using System.Web.UI.WebControls;
using System.Web.UI;
using System.ComponentModel;

namespace LookUpSearch
{
    /// <summary>
    /// Table Cell template control
    /// </summary>
    [NonVisualControl]
    [ToolboxItem(false)]
    public class LuTemplate : WebControl
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LuTemplate"/> class.
        /// </summary>
        public LuTemplate()
        { }

        /// <summary>
        /// Gets or sets the template.
        /// </summary>
        /// <value>The template.</value>
        [Browsable(false)]
        [DefaultValue((string)null)]
        [PersistenceMode(PersistenceMode.InnerProperty)]
        [TemplateContainer(typeof(IDataItemContainer))]
        public ITemplate Template
        {
            get;
            set;
        }

        [DefaultValue((string)null)]
        [PersistenceMode(PersistenceMode.InnerProperty)]
        public string HeaderText { get; set; }



    }
}
