﻿// Copyright (c) 2011 Josue Medrano Cruz
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.

// register 'LookUpSearch' as a namespace
Type.registerNamespace('LookUpSearch');

//Define helpers prototypes - Extensions
if (window.Node && Node.prototype && !Node.prototype.contains) {
    Node.prototype.contains = function (arg) {
        return !!(this.compareDocumentPosition(arg) & 16);
    };
}

if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function (obj, fromIndex) {
        if (fromIndex == null) { fromIndex = 0; }
        else if (fromIndex < 0) {
            fromIndex = Math.max(0, this.length + fromIndex);
        }
        for (var i = fromIndex, j = this.length; i < j; i++) {
            if (this[i] === obj) return i;
        } return -1;
    };
}

if (!String.prototype.replaceAll) {
    String.prototype.replaceAll = function (find, replace) {
        var str = this;
        return str.replace(new RegExp(find.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), 'g'), replace);
    };
}
//Control definition
LookUpSearch.LookUpControl = function (element) {

    LookUpSearch.LookUpControl.initializeBase(this, [element]);

    this._enabled = null;
    this._pageSize = null;
    this._PositionBaseOn = null;
    this._DialogueCentred = null;
    this._posX = null;
    this._posY = null;
    this._textBoxId = null;
    this._wWidth = null;
    this._wHeight = null;
    this._pnlContainer = null;
    this._iFrameUrl = null;
    this._table = null;
    this._tableChild = null;
    this._tableBtnControl = null;
    this._rowHighlightCSSClass = 'LU_TableRowMouseHover';
    this._dragHeadereRowId = null;
    this._dialogueImgClose = null;
    this._iFrameId = null;
    this._uniqueId = null;
    this._clientId = null;
    this._multiSelection = null;
    this._titlePopUp = null;
    this._spriteImg = null;
    this._progressImageUrl = null;
    this._popupHeaderUrl = null;
    this._popupHeaderTableUrl = null;
    this._columnHeaders = null;
    this._pnlInput = null;
    this._maxRecordsToShow = null;
    this._ignoreRequiredAttributes = null;
    this._fadeDelay = null;
    this._HtmTemplate = null;
    this._HtmContainer = null;
    this._SelectParameters = null;
    this._ResulttotalRecords = null;
    this._lubtn_glass_img = null;
    this._lubtn_glass_img_hover = null;
    this._multiCbId = null;

    this.textBox = null;
    this.ctrl = null;
    this.iframeCtrl = null;
    this.containerCtrl = null;
    this.table = null;
    this.tableChild = null;
    this.tableBtnControl = null;
    this.mouseOutCSSClass = null;
    this.dialogueIsCreated = null;

    //Handlers
    this._searchFormCallback = null;
    this._onContainerBlurHandler = null;
    this._btnClear_DialogueHandler = null;
    this._btnSearch_DialogueHandler = null;
    this._closeSearch_DialogueHandler = null;
    this._onMouseOverRowHandler = null;
    this._onMouseOutRowHandler = null;
    this._onkeydownHandler = null;
    this._btnSearchOK_DialogueHandler = null;
    this._dragging_onmousedown_Handler = null;
    this._dragging_onmouseup_Handler = null;


    //Dialogue ID Controls
    this._btnSearch_Dialogue = null;
    this._btnClear_Dialogue = null;
    this._tHeadSpan_Dialogue = null;
    this._btnSearchOK_Dialogue = null;
    this._btnSearchCancel_Dialogue = null;
    this._Message_Dialogue = null;

    //Dialogue Controls
    this.btnSearch_Dialogue = null;
    this.btnClear_Dialogue = null;
    this.btnSearchOK_Dialogue = null;
    this.btnSearchCancel_Dialogue = null;
    this.Message_Dialogue = null;
    this._multiCbDialogue = null;

};

LookUpSearch.LookUpControl.prototype =
{
    // called when the object is created
    initialize: function () {

        // call initialize on the base class - a standard piece of OO code
        LookUpSearch.LookUpControl.callBaseMethod(this, 'initialize');

        if (!this._enabled)
            return;

        this.ctrl = $get(this.get_id());
        if (this.ctrl == undefined)
            return;

        this.textBox = $get(this._textBoxId);
        this.dialogueIsCreated = false;

        // wire up the onclick event
        this._onClickHandler = Function.createDelegate(this, this._onClick);
        if (this._enabled) {
            $addHandler(this.get_element(), 'click', this._onClickHandler);
        }

        this._searchFormCallback = Function.createDelegate(this, this.receiverServerData);
        this._onContainerBlurHandler = Function.createDelegate(this, this.onContainerBlur);
        this._btnClear_DialogueHandler = Function.createDelegate(this, this.clearDialogueValues);
        this._btnSearch_DialogueHandler = Function.createDelegate(this, this.handleButtonSearchClick);
        this._closeSearch_DialogueHandler = Function.createDelegate(this, this._onDialogueClose);
        this._btnSearchOK_DialogueHandler = Function.createDelegate(this, this._onDialogueOk);
        this._onMouseOverRowHandler = Function.createDelegate(this, this._onMouseOverRow);
        this._onMouseOutRowHandler = Function.createDelegate(this, this._onMouseOutRow);
        this._onkeydownHandler = Function.createDelegate(this, this._onkeydown);
        this._dragging_onmousedown_Handler = Function.createDelegate(this, this._dragging_onmousedown);
        this._dragging_onmouseup_Handler = Function.createDelegate(this, this._dragging_onmouseup);
        this._multiCheckAll_Handler = Function.createDelegate(this, this._multiCheckAll);


    },
    // called when the object is removed
    dispose: function () {
        // unwire the event handlers
        $clearHandlers(this.get_element());
        // call dispose on the base class - a standard piece of OO code
        LookUpSearch.LookUpControl.callBaseMethod(this, 'dispose');
    },

    // ----------------------------------------------   
    // properties
    // ----------------------------------------------
    get_multiSelection: function () { return this._multiSelection; },
    set_multiSelection: function (value) { this._multiSelection = value; },

    get_titlePopUp: function () { return this._titlePopUp; },
    set_titlePopUp: function (value) { this._titlePopUp = value; },

    get_textBoxId: function () { return this._textBoxId; },
    set_textBoxId: function (value) { this._textBoxId = value; },

    get_wWidth: function () { return this._wWidth; },
    set_wWidth: function (value) { this._wWidth = value; },

    get_wHeight: function () { return this._wHeight; },
    set_wHeight: function (value) { this._wHeight = value; },

    get_uniqueId: function () { return this._uniqueId; },
    set_uniqueId: function (value) { this._uniqueId = value; },

    get_containerCtrl: function () { return this._containerCtrl; },
    set_containerCtrl: function (value) { this._containerCtrl = value; },

    get_iFrameUrl: function () { return this._iFrameUrl; },
    set_iFrameUrl: function (value) { this._iFrameUrl = value; },

    get_dialogueImgClose: function () { return this._dialogueImgClose; },
    set_dialogueImgClose: function (value) { this._dialogueImgClose = value; },

    get_spriteImg: function () { return this._spriteImg; },
    set_spriteImg: function (value) { this._spriteImg = value; },

    get_progressImageUrl: function () { return this._progressImageUrl; },
    set_progressImageUrl: function (value) { this._progressImageUrl = value; },

    get_popupHeaderUrl: function () { return this._popupHeaderUrl; },
    set_popupHeaderUrl: function (value) { this._popupHeaderUrl = value; },

    get_popupHeaderTableUrl: function () { return this._popupHeaderTableUrl; },
    set_popupHeaderTableUrl: function (value) { this._popupHeaderTableUrl = value; },

    get_dialogueIsCreated: function () { return this._dialogueIsCreated; },
    set_dialogueIsCreated: function (value) { this._dialogueIsCreated = value; },

    get_pageSize: function () { return this._pageSize; },
    set_pageSize: function (value) { this._pageSize = value; },

    get_posX: function () { return this._posX; },
    set_posX: function (value) { this._posX = value; },

    get_posY: function () { return this._posY; },
    set_posY: function (value) { this._posY = value; },

    get_PositionBaseOn: function () { return this._PositionBaseOn; },
    set_PositionBaseOn: function (value) { this._PositionBaseOn = value; },

    get_DialogueCentred: function () { return this._DialogueCentred; },
    set_DialogueCentred: function (value) { this._DialogueCentred = value; },

    get_enabled: function () { return this._enabled; },
    set_enabled: function (value) { this._enabled = value; },

    get_clientId: function () { return this._clientId; },
    set_clientId: function (value) { this._clientId = value; },

    get_columnHeaders: function () { return this._columnHeaders; },
    set_columnHeaders: function (value) { this._columnHeaders = value; },

    get_HtmTemplate: function () { return this._HtmTemplate; },
    set_HtmTemplate: function (value) { this._HtmTemplate = value; },

    get_HtmContainer: function () { return this._HtmContainer; },
    set_HtmContainer: function (value) { this._HtmContainer = value; },

    get_maxRecordsToShow: function () { return this._maxRecordsToShow; },
    set_maxRecordsToShow: function (value) { this._maxRecordsToShow = value; },

    get_SelectParameters: function () { return this._SelectParameters; },
    set_SelectParameters: function (value) { this._SelectParameters = value.split(";"); },

    get_ignoreRequiredAttributes: function () { return this._ignoreRequiredAttributes; },
    set_ignoreRequiredAttributes: function (value) { this._ignoreRequiredAttributes = value; },

    get_fadeDelay: function () { return this._fadeDelay; },
    set_fadeDelay: function (value) { this._fadeDelay = value * 1000; },

    get_lubtn_glass_img: function () { return this._lubtn_glass_img; },
    set_lubtn_glass_img: function (value) { this._lubtn_glass_img = value; },

    get_lubtn_glass_img_hover: function () { return this._lubtn_glass_img_hover; },
    set_lubtn_glass_img_hover: function (value) { this._lubtn_glass_img_hover = value; },

    // ----------------------------------------------------------------    
    // methods
    // ----------------------------------------------------------------
    _onClick: function (e) {

        if (this.ctrl.disabled == true)
            return;

        if (this.dialogueIsCreated == true)
            return;

        this.createDialogueOuterHTML();

        $addHandler(document, 'click', this._onContainerBlurHandler);
        $addHandler(this.btnClear_Dialogue, "click", this._btnClear_DialogueHandler);
        $addHandler(this.btnSearch_Dialogue, "click", this._btnSearch_DialogueHandler);
        $addHandler(this.btnClose_Dialogue, "click", this._closeSearch_DialogueHandler);
        $addHandler(this.btnSearchCancel_Dialogue, "click", this._closeSearch_DialogueHandler);

        if (this._multiSelection == true) {
            $addHandler(this.btnSearchOK_Dialogue, "click", this._btnSearchOK_DialogueHandler);
        }

        var draggedObj = $get(this._dragHeadereRowId);
        $clearHandlers(draggedObj);
        $addHandler(draggedObj, "mousedown", this._dragging_onmousedown_Handler);
        $addHandler(draggedObj, "mouseup", this._dragging_onmouseup_Handler);

        this.showContainer();
        this._SetFocus();
        e.stopPropagation();
    },

    _dragging_onmousedown: function (e) {
        this.startMoving(e, this.containerCtrl);
        e.stopPropagation();
    },

    _dragging_onmouseup: function (e) {
        document.onmousemove = function () { };
        document.onselectstart = null;
        this._SetFocus();
        e.stopPropagation();
    },

    
    _multiCheckAll: function (e) {
        if (this._multiSelection) // Activate click in row
        {
            this.tableChild = $get(this._tableChild);
            var checkboxesAll = this.tableChild.getElementsByTagName('input');
            for (var i = 0; i < checkboxesAll.length; i++) {
                if (!checkboxesAll[i].getAttribute('ismultiCb'))
                    continue;
                checkboxesAll[i].checked = e.target.checked;
            }
        }
    },
    _SetFocus: function () {
        var bFound = false;
        for (var i = 0; i < this._pnlInput.length; i++) {
            var inpCtrl = this._pnlInput[i];
            if (!(inpCtrl.type == "hidden") || (inpCtrl.disabled == true)) {
                inpCtrl.focus();
                bFound = true;
            }
            if (bFound)
                break;
        }
    },

    _onDialogueClose: function () {
        // unwire the event handlers
        $clearHandlers(this.containerCtrl);
        $clearHandlers(this.btnClear_Dialogue);
        $clearHandlers(this.btnSearch_Dialogue);
        $clearHandlers(this.btnClose_Dialogue);
        $clearHandlers(this.btnSearchOK_Dialogue);
        $clearHandlers(this.btnSearchCancel_Dialogue);
        $removeHandler(document, 'click', this._onContainerBlurHandler);
        if (this._multiSelection == true) {
            $clearHandlers(this._multiCbDialogue);
        }
        this.fadeOut(this, this.get_fadeDelay());
    },

    fadeOut: function (thisObj, time) {
        var elem = thisObj.containerCtrl;
        var startOpacity = elem.style.opacity || 1;
        elem.style.opacity = startOpacity;
        (function go() {
            elem.style.opacity -= startOpacity / (time / 100);
            elem.style.filter = 'alpha(opacity=' + elem.style.opacity * 100 + ')';

            if (elem.style.opacity > 0)
                setTimeout(go, 2);
            else {
                elem.style.display = 'none';
                document.getElementsByTagName('body')[0].removeChild(elem);
                if (this.iframeCtrl != null)
                    document.getElementsByTagName('body')[0].removeChild(elem);
                thisObj.dialogueIsCreated = false;

            }
        })();
    },

    fadeIn: function (thisObj, time) {
        var elem = thisObj.containerCtrl;
        var startOpacity = 0;
        elem.style.opacity = startOpacity;
        elem.style.filter = 'alpha(opacity=' + elem.style.opacity * 100 + ')';
        elem.style.display = '';
        (function go() {
            elem.style.opacity = (elem.style.opacity * 1) + (1 / (time / 100));
            // for IE
            elem.style.filter = 'alpha(opacity=' + elem.style.opacity * 100 + ')';
            if (elem.style.opacity < 1)
                setTimeout(go, 10);
            else {
                elem.style.display = '';
            }
        })();
    },

    _onDialogueOk: function () {

        this.tableChild = $get(this._tableChild);
        var checkboxesAll = this.tableChild.getElementsByTagName('input');
        var checkedArray = new Array(0);

        for (i = 0; i < checkboxesAll.length; i++) {

            if (!checkboxesAll[i].getAttribute('ismultiCb'))
                continue;

            if (checkboxesAll[i].checked) {
                checkedArray.push(checkboxesAll[i].value);
            }
        }
        var returnArrayValue = checkedArray.join('°°');
        //Perform postback
        __doPostBack(this._uniqueId, returnArrayValue);
        this._onDialogueClose();
    },

    clearDialogueValues: function (e) {
        for (var i = 0; i < this._pnlInput.length; i++) {
            var inpCtrl = this._pnlInput[i];
            if (inpCtrl.type == 'select-one')
                inpCtrl.selectedIndex = 0;
            else if (inpCtrl.type == 'radio') {
                inpCtrl = this.GetOneRadioFromGroup(inpCtrl);
                inpCtrl.checked = false;
            } if (inpCtrl.type == 'checkbox') {
                inpCtrl.checked = false;
            } else
                inpCtrl.value = '';
        }

        var Message_Dialogue = $get(this._Message_Dialogue);
        Message_Dialogue.innerHTML = "";

        this.clearTablesResult();
        this._SetFocus();
        e.stopPropagation();

    },

    _onkeydown: function (event) {
        if (event.which || event.keyCode) {
            if ((event.which == 27) || (event.keyCode == 27)) {
                this._onDialogueClose();
                return false;
            }
            if ((event.which == 13) || (event.keyCode == 13)) {
                this.handleButtonSearchClick();
                return false;
            }


            return true;
        }
        else
            return true;
    },

    handleButtonSearchClick: function (ev) {
        //var keyCode = ev.charCode || ev.keyCode
        this.clearTablesResult();
        this.performCallBack();
    },

    onContainerBlur: function (e) {
        if (this.dialogueIsCreated == false)
            return;
        if (this.containerCtrl.contains(e.target))
            return;
        this._onDialogueClose();

    },

    isContainerVisible: function () {
        return (this.containerCtrl.style.display == '') ? true : false;
    },
    showContainer: function () {

        this.controlBtnbehavior();
        this.resizeIFrameToTable();
        if (this._DialogueCentred)
            this.dialogueCentered();

        this.fadeIn(this, this.get_fadeDelay());

        $addHandler(this.containerCtrl, "keydown", this._onkeydownHandler);

    },

    parseJSON: function parseJSON(data) {
        return window.JSON && window.JSON.parse ? window.JSON.parse(data) : (new Function("return " + data))();
    },

    receiverServerData: function (jsonResult) {

        var arrObj = this.parseJSON(jsonResult);
        var data = arrObj.HtmlData;
        this._ResulttotalRecords = arrObj.ResultTotalRecords;
        if (this._ResulttotalRecords < 1) {
            this.resultHeaderStatus(0);
            this.onUpdated();
            return;
        }
        this.table = $get(this._table);


        this.tableChild = $get(this._tableChild);
        this.tableChild.outerHTML = this.genChildTable(data);
        this.tableChild = $get(this._tableChild);
        var sbTableClass = new Sys.StringBuilder();
        sbTableClass.append(' container-' + this._pnlContainer + '.' + this._iFrameId);
        this.tableChild.className = 'sortable no-arrow paginate-' + this._pageSize + ' max-pages-8 ' + sbTableClass.toString();
        tablePaginater.init(this._tableChild);
        var dataRows = 0;
        for (var i = 0; i != this.tableChild.rows.length; i++) {
            var row = this.tableChild.rows[i];

            if (row.getAttribute('rowtype') == 'data') {

                $clearHandlers(row);
                $addHandler(row, "mouseover", this._onMouseOverRowHandler);
                $addHandler(row, "mouseout", this._onMouseOutRowHandler);

                if (!this._multiSelection) // Activate click in row
                {
                    row.setAttribute("onmouseover", "this.style.cursor='pointer';");
                    $addHandler(row, "click", this._closeSearch_DialogueHandler);

                }
                if (i % 2 != 0)
                    row.className = "LU_TableOddRow";
                else
                    row.className = "LU_TableEvenRow";

                dataRows++;
            }
        }

        this.resultHeaderStatus(dataRows);
        this.controlBtnbehavior();
        this.resizeIFrameToTable();
        this.onUpdated();
    },

    resultHeaderStatus: function (rows) {
        var messageResult = "";
        if (this._ResulttotalRecords > this.get_maxRecordsToShow())
            messageResult = "Search Result: Selected first " + this.get_maxRecordsToShow() + " of " + this._ResulttotalRecords + " records.";
        else if (rows > 0)
            messageResult = "Search Result: " + rows + " record(s) found.";
        else
            messageResult = "Search Result: No records found.";

        var headResultLabel = $get(this._tHeadSpan_Dialogue);
        headResultLabel.innerHTML = messageResult;
    },

    controlBtnbehavior: function () {
        this.tableBtnControl = $get(this._tableBtnControl);
        this.tableChild = $get(this._tableChild);
        if (this.tableChild.rows.length <= 1 || !this._multiSelection)
            this.tableBtnControl.style.display = 'none';
        else
            this.tableBtnControl.style.display = 'block';
        if (this._multiSelection == true) {
            this._multiCbDialogue = $get(this._multiCbId);
            $addHandler(this._multiCbDialogue, "click", this._multiCheckAll_Handler);
        }
    },

    performCallBack: function () {
        var strJson = '';
        var radioArray = new Array();
        var required = false;
        var requiredParamValues = '';
        for (var i = 0; i < this._pnlInput.length; i++) {

            var inpCtrl = this._pnlInput[i];
            if (inpCtrl.type == 'radio') {
                if (radioArray.indexOf(inpCtrl.name) == -1) {
                    Array.add(radioArray, inpCtrl.name);
                    inpCtrl = this.GetOneRadioFromGroup(inpCtrl);
                } else continue;
            }

            if (strJson.length > 0)
                strJson += ',';

            var paramName = null;
            var paramValue = null;

            if (inpCtrl.type == 'radio') {
                paramName = inpCtrl.name;
                if (inpCtrl.checked)
                    paramValue = inpCtrl.value.replace(/\"/g, '\\"');
                else
                    paramValue = '';
            } else if (inpCtrl.type == 'checkbox') {
                paramName = inpCtrl.id;
                paramValue = inpCtrl.checked;
            }
            else {
                paramName = inpCtrl.id;
                paramValue = inpCtrl.value.replace(/\"/g, '\\"');

            }

            if (!this.get_ignoreRequiredAttributes()) {
                if (inpCtrl.getAttribute('isrequired') == 'true') {
                    required = true;
                    requiredParamValues = requiredParamValues + paramValue;
                }
            }
            strJson += '{"ParamName": "' + paramName + '", "Value":"' + paramValue + '"}';
        }

        if (required && requiredParamValues.length < 1) {
            $get(this._Message_Dialogue).innerHTML = "Too many search results. Please limit your filter criteria and try again.";
            $get(this._tHeadSpan_Dialogue).innerHTML = "";

            this.onUpdated();
            return;
        }

        strJson = '[' + strJson + ']';
        var context = '';
        var eventTarget = this._uniqueId;

        this.onUpdating();
        WebForm_DoCallback(eventTarget, strJson, this._searchFormCallback, context, null, false);

    },

    GetOneRadioFromGroup: function (inpCtrl) {
        var pnl = $get(this._pnlContainer);
        var inputs = document.getElementsByName(inpCtrl.name);
        for (var i = 0; i < inputs.length; i++) {
            if (inputs[i].checked) {
                return inputs[i];
            }
        }
        return inpCtrl;
    },

    resizeIFrameToTable: function () {
        if (this.table == null || this.iframeCtrl == null || this.containerCtrl == null)
            return;

        var pnlTemp = $get(this._pnlContainer);
        this.iframeCtrl.style.left = pnlTemp.style.left;
        this.iframeCtrl.style.top = pnlTemp.style.top;
        this.iframeCtrl.style.width = pnlTemp.offsetWidth; //pnlTemp.style.width;
        this.iframeCtrl.style.height = pnlTemp.offsetHeight;

    },

    getSearchObjects: function () {

        var pnl = $get(this._pnlContainer);
        this._pnlInput = new Array();
        radioArray = new Array();
        var inpObjs = pnl.getElementsByTagName('input');
        var selObjs = pnl.getElementsByTagName('select');
        for (var i = 0; i < inpObjs.length; i++) {

            if (inpObjs[i].type == 'text') {

                if (this._SelectParameters.indexOf(inpObjs[i].id) != -1) {
                    Array.add(this._pnlInput, inpObjs[i]);
                }
                continue;
            }
            if (inpObjs[i].type == 'checkbox') {
                if (this._SelectParameters.indexOf(inpObjs[i].id) != -1) {
                    Array.add(this._pnlInput, inpObjs[i]);
                }
                continue;
            }
            if (inpObjs[i].type == 'radio') {
                if (this._SelectParameters.indexOf(inpObjs[i].name) != -1) {

                    if (radioArray.indexOf(inpObjs[i].name) == -1) {
                        Array.add(radioArray, inpObjs[i].name);
                        Array.add(this._pnlInput, inpObjs[i]);
                    } else continue;
                }
            }
        }
        for (var j = 0; j < selObjs.length; j++) {
            if (this._SelectParameters.indexOf(selObjs[j].id) != -1) {
                Array.add(this._pnlInput, selObjs[j]);
            }

        }
    },

    iniciateDialogueFieldsInstance: function () {
        this.getSearchObjects();
        this.btnSearch_Dialogue = $get(this._btnSearch_Dialogue);
        this.btnClear_Dialogue = $get(this._btnClear_Dialogue);
        this.btnClose_Dialogue = $get(this._btnClose_Dialogue);
        this.btnSearchOK_Dialogue = $get(this._btnSearchOK_Dialogue);
        this.btnSearchCancel_Dialogue = $get(this._btnSearchCancel_Dialogue);
        this.Message_Dialogue = $get(this._Message_Dialogue);
        for (var i = 0; i < this._pnlInput.length; i++) {
            var inpCtrl = this._pnlInput[i];
            if (inpCtrl != null) {
                $clearHandlers(inpCtrl);
                $addHandler(inpCtrl, "keydown", this._onkeydownHandler);
            }
        }


    },

    clearTablesResult: function () {
        var tblChild = $get(this._tableChild);
        var tblParent = $get(this._table);
        $get(this._Message_Dialogue).innerHTML = "";
        for (var z = tblChild.tBodies.length - 1; z > -1; z--) {
            for (var i = tblChild.tBodies[z].rows.length; i > 0; i--) {
                tblChild.tBodies[z].deleteRow(i - 1);
            }
        }
        tablePaginater.init(this._tableChild);
        var headResultLabel = $get(this._tHeadSpan_Dialogue);
        headResultLabel.innerHTML = "";
        this.controlBtnbehavior();
        this.resizeIFrameToTable();

    },

    _onMouseOverRow: function (e) {
        var tgt = this.getParentByTagName(e.target, "TR");
        if (tgt != null) {
            this.mouseOutCSSClass = tgt.className;
            tgt.className = this._rowHighlightCSSClass;
        }
        e.stopPropagation();
    },

    _onMouseOutRow: function (e) {
        var tgt = this.getParentByTagName(e.target, "TR");
        if (tgt != null) {
            tgt.className = this.mouseOutCSSClass;
        }
        e.stopPropagation();
    },

    getParentByTagName: function (element, tagName) {
        var parent = element.parentNode;
        var upperTagName = tagName.toUpperCase();

        while (parent && (parent.tagName.toUpperCase() != upperTagName)) {
            parent = parent.parentNode ? parent.parentNode : parent.parentElement;
        }
        return parent;
    },

    dialogueCentered: function () {

        var newpos = window.center({ width: this.containerCtrl.clientWidth, height: this.containerCtrl.clientHeight });
        var p_x = newpos.y + this._posY;
        if (p_x < 0) p_x = 0;

        this.containerCtrl.style.top = p_x;
        this.containerCtrl.style.left = newpos.x + this._posX;
        this.resizeIFrameToTable();
    },


    createDialogueOuterHTML: function () {

        this.iframeCtrl = null;
        this._pnlContainer = "containerCtrl_" + this._uniqueId;
        this._iFrameId = "iFrameCtrl_" + this._uniqueId;

        var pos, posX, posY;
        if (this._PositionBaseOn == 1) {
            pos = Sys.UI.DomElement.getLocation(this.ctrl);
            posX = pos.x + 2;
            posY = pos.y + (this.ctrl.offsetHeight) + 4;
        }
        else {
            pos = Sys.UI.DomElement.getLocation(this.textBox);
            posX = pos.x + 2;
            posY = pos.y + (this.textBox.offsetHeight) + 4;
        }

        if (this._posX != -1)
            posX = this._posX;

        if (this._posY != -1)
            posY = this._posY;

        if (this._DialogueCentred) {
            var newpos = window.center({ width: this._wWidth, height: 300 });
            posY = newpos.y + this._posY;
            posX = newpos.x + this._posX;
        }

        this.containerCtrl = document.createElement('div');
        this.containerCtrl.setAttribute("id", this._pnlContainer);

        this.containerCtrl.style.zIndex = '10001';
        this.containerCtrl.style.position = 'absolute';
        this.containerCtrl.style.left = posX + 'px';
        this.containerCtrl.style.top = posY + 'px';
        this.containerCtrl.style.display = 'none';
        this.containerCtrl.style.width = this._wWidth + 'px';
        this.containerCtrl.className = "LU_DivContainer";

        this._btnSearch_Dialogue = 'btnSearch_' + this._uniqueId;
        this._btnClear_Dialogue = 'btnClear_' + this._uniqueId;
        this._btnClose_Dialogue = 'btnClose_' + this._uniqueId;
        this._btnSearchOK_Dialogue = 'btnSearchOK_' + this._uniqueId;
        this._btnSearchCancel_Dialogue = 'btnSearchCancel_' + this._uniqueId;
        this._Message_Dialogue = 'Message_Dialogue_' + this._uniqueId;

        this._tHeadSpan_Dialogue = 'tHeadSpan_' + this._clientId;
        this._table = 'SelectOuResult_Parent_' + this._clientId;
        this._tableChild = 'SelectOuResult_Child_' + this._clientId;
        this._tableBtnControl = 'BtnControl_' + this._clientId;
        this._dragHeadereRowId = 'dragHeadereRowId_' + this._clientId;
        this._multiCbId = 'multiCbAll_' + this._clientId;

        var spriteImgUrl = "url('" + this._spriteImg + "')";
        var progressImageUrl = "url('" + this._progressImageUrl + "')";
        var popupHeaderUrl = "url('" + this._popupHeaderUrl + "')";

        var htmContainer = this._HtmContainer.replaceAll('@this._pnlContainer@', this._pnlContainer);
        htmContainer = htmContainer.replaceAll('@spriteImgUrl@', spriteImgUrl);
        htmContainer = htmContainer.replaceAll('@progressImageUrl@', progressImageUrl);

        htmContainer = htmContainer.replaceAll('@popupHeaderUrl@', popupHeaderUrl);
        htmContainer = htmContainer.replaceAll('@this._iFrameId@', this._iFrameId);
        htmContainer = htmContainer.replaceAll('@this._titlePopUp@', this._titlePopUp);
        htmContainer = htmContainer.replaceAll('@this._btnClose_Dialogue@', this._btnClose_Dialogue);
        htmContainer = htmContainer.replaceAll('@this._dialogueImgClose@', this._dialogueImgClose);
        htmContainer = htmContainer.replaceAll('@this._HtmTemplate@', this._HtmTemplate);
        htmContainer = htmContainer.replaceAll('@this._btnSearch_Dialogue@', this._btnSearch_Dialogue);
        htmContainer = htmContainer.replaceAll('@this._btnClear_Dialogue@', this._btnClear_Dialogue);
        htmContainer = htmContainer.replaceAll('@this._tHeadSpan_Dialogue@', this._tHeadSpan_Dialogue);
        htmContainer = htmContainer.replaceAll('@this._table@', this._table);
        htmContainer = htmContainer.replaceAll('@this.genChildTable@', this.genChildTable(' '));
        htmContainer = htmContainer.replaceAll('@this._tableBtnControl@', this._tableBtnControl);
        htmContainer = htmContainer.replaceAll('@this._btnSearchOK_Dialogue@', this._btnSearchOK_Dialogue);
        htmContainer = htmContainer.replaceAll('@this._btnSearchCancel_Dialogue@', this._btnSearchCancel_Dialogue);
        htmContainer = htmContainer.replaceAll('@this._Message_Dialogue@', this._Message_Dialogue);
        htmContainer = htmContainer.replaceAll('@this._dragHeadereRowId@', this._dragHeadereRowId);

        var sb = new Sys.StringBuilder();
        sb.append(htmContainer);
        this.containerCtrl.innerHTML = sb.toString();
        var body = document.getElementsByTagName("body")[0];
        body.appendChild(this.containerCtrl);
        this.table = $get(this._table);
        this.createIframe();
        this.iniciateDialogueFieldsInstance();
        this.dialogueIsCreated = true;
    },

    genChildTable: function (childData) {
        var headerArray = new Array(0);
        headerArray = this._columnHeaders.split("°°");
        var sb = new Sys.StringBuilder();
        sb.append('<table id="' + this._tableChild + '" width="100%" CellSpacing="0" CellPadding="0">');
        sb.append('<thead>');
        sb.append('<tr class="LU_ColumnHeader" rowtype="rowHeader" style=" @HeaderTableStyle@ " >');
        var ncol = 1;
        if ((this._multiSelection)) {
            sb.append('<th class="LU_CellLeft" style="width:10px"><input id="' + this._multiCbId + '" type="checkbox"/></th>');
        }
        for (var j = 0; j < headerArray.length; j++) {
            var columnClass = 'LU_CellLeft';
            if (ncol >= 1 && ncol == headerArray.length)
                columnClass = 'LU_CellBox';

            sb.append('<th class="' + columnClass + '">' + headerArray[j] + '</th>');
            ncol++;
        }
        sb.append('</tr>');
        sb.append('</thead>');
        sb.append('<tbody>');
        sb.append(childData);
        sb.append('</tbody>');
        sb.append('</table>');
        var mstyle = "background-image: url('" + this._popupHeaderTableUrl + "');background-repeat: repeat-x;background-position-x: center;background-position-y: bottom;background-size: auto;background-origin: padding-box;background-clip: border-box;background-color: rgb(199, 223, 255);";
        var sbstring = sb.toString();
        sbstring = sbstring.replaceAll('@HeaderTableStyle@', mstyle);
        return sbstring;
    },

    onUpdating: function () {

        var pnlPopup = $get('progressPopupPanel_' + this._pnlContainer);

        //  get the pnlContainer element
        var pnlContainer = $get(this._pnlContainer);

        // make it visible
        pnlPopup.style.display = '';

        // get the bounds of both the pnlContainer and the progress div
        var pnlContainerBounds = Sys.UI.DomElement.getBounds(pnlContainer);
        var pnlPopupBounds = Sys.UI.DomElement.getBounds(pnlPopup);

        //  center of pnlContainer
        var x = Math.round(pnlContainerBounds.width / 2) - Math.round(pnlPopupBounds.width / 2);
        var y = Math.round(pnlContainerBounds.height / 2) - Math.round(pnlPopupBounds.height / 2);

        //	set the progress element to this position
        Sys.UI.DomElement.setLocation(pnlPopup, x, y);

    },

    onUpdated: function () {
        // get the update progress div
        var pnlPopup = $get('progressPopupPanel_' + this._pnlContainer);
        // make it invisible
        pnlPopup.style.display = 'none';
    },

    startMoving: function (evt, el) {

        var $el = el;

        evt = evt || window.event;
        var posX = evt.clientX,
            posY = evt.clientY,
            divTop = $el.style.top,
            divLeft = $el.style.left;

        if (isNaN(divTop) || divTop == '')
            divTop = $el.offsetTop + 'px';
        if (isNaN(divLeft) || divLeft == '')
            divLeft = $el.offsetLeft + 'px';

        divTop = divTop.replace('px', '');
        divLeft = divLeft.replace('px', '');
        var diffX = posX - divLeft,
            diffY = posY - divTop;

        document.body.focus();
        document.onselectstart = function () { return false; };

        document.onmousemove = function (evt) {
            evt = evt || window.event;
            var posX = evt.clientX;
            var posY = evt.clientY;
            var aX = posX - diffX;
            var aY = posY - diffY;

            $el.style.left = aX + 'px';
            $el.style.top = aY + 'px';
        };
    },


    createIframe: function () {
        var body = document.getElementsByTagName("body")[0];
        if (navigator.appName == 'Microsoft Internet Explorer') {
            if (navigator.appVersion.indexOf('MSIE 6.') != -1 && this._iFrameUrl != null && this.iframeCtrl == null) {

                this.iframeCtrl = document.createElement("iframe");
                this.iframeCtrl.id = this._iFrameId;
                this.iframeCtrl.frameBorder = 0;
                this.iframeCtrl.src = "javascript:false;";
                this.iframeCtrl.style.display = "none";
                this.iframeCtrl.style.position = "absolute";
                this.iframeCtrl.style.filter = "progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0)";
                this.iframeCtrl.style.zIndex = this.containerCtrl.style.zIndex - 1;
                body.appendChild(this.iframeCtrl);

            }
        }
    }
};

window.size = function () {
    var w = 0;
    var h = 0;
    //IE
    if (!window.innerWidth) {
        //strict mode
        if (!(document.documentElement.clientWidth == 0)) {
            w = document.documentElement.clientWidth;
            h = document.documentElement.clientHeight;
        }
        //quirks mode
        else {
            w = document.body.clientWidth;
            h = document.body.clientHeight;
        }
    }
    //w3c
    else {
        w = window.innerWidth;
        h = window.innerHeight;
    }
    return { width: w, height: h };
};

window.center = function () {
    var hWnd = (arguments[0] != null) ? arguments[0] : { width: 0, height: 0 };
    var _x = 0;
    var _y = 0;
    var offsetX = 0;
    var offsetY = 0;
    //IE
    if (!window.pageYOffset) {
        //strict mode
        if (!(document.documentElement.scrollTop == 0)) {
            offsetY = document.documentElement.scrollTop;
            offsetX = document.documentElement.scrollLeft;
        }
        //quirks mode
        else {
            offsetY = document.body.scrollTop;
            offsetX = document.body.scrollLeft;
        }
    }
    //w3c
    else {
        offsetX = window.pageXOffset;
        offsetY = window.pageYOffset;
    }
    _x = ((this.size().width - hWnd.width) / 2) + offsetX;
    _y = ((this.size().height - hWnd.height) / 2) + offsetY;
    return { x: _x, y: _y };
};

LookUpSearch.LookUpControl.registerClass('LookUpSearch.LookUpControl', Sys.UI.Control);
