﻿// Copyright (c) 2011 Josue Medrano Cruz
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.


// register 'JmComboBox' as a namespace
Type.registerNamespace('JmComboBox');

//Define helpers prototypes - Extensions
if (window.Node && Node.prototype && !Node.prototype.contains) {
    Node.prototype.contains = function (arg) {
        return !!(this.compareDocumentPosition(arg) & 16);
    };
}

if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function (obj, fromIndex) {
        if (fromIndex == null) { fromIndex = 0; }
        else if (fromIndex < 0) {
            fromIndex = Math.max(0, this.length + fromIndex);
        }
        for (var i = fromIndex, j = this.length; i < j; i++) {
            if (this[i] === obj) return i;
        } return -1;
    };
}

if (!String.prototype.replaceAll) {
    String.prototype.replaceAll = function (find, replace) {
        var str = this;
        return str.replace(new RegExp(find.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), 'g'), replace);
    };
}

//Control definition
JmComboBox.MultiComboBoxControl = function (element) {

    JmComboBox.MultiComboBoxControl.initializeBase(this, [element]);

    this._TargetInputName = null;
    this._TargetInputHiddenName = null;
    this._enabled = null;

    this._PositionBaseOn = null;
    this._DialogueCentred = null;
    this._posX = null;
    this._posY = null;
    this._wWidth = null;
    this._wHeight = null;
    this._pnlContainer = null;
    this._table = null;
    this._tableChild = null;
    this._mainDivChildId = null;
    this._tableBtnControl = null;
    this._rowHighlightCSSClass = 'CB_TableRowMouseHover';
    this._dragHeadereRowId = null;
    this._iFrameId = null;
    this._uniqueId = null;
    this._clientId = null;
    this._multiSelection = null;
    this.callActive = null;
    this.previousText = null;
    this._busyImageUrl = null;
    this._minLengthSearch = null;
    this._searchDelay = null;
    this._wWidth = null;
    this._wHeight = null;

    this._popupHeaderTableUrl = null;
    this._columnHeaders = null;
    this._pnlInput = null;
    this._maxRecordsToShow = null;
    this._fadeDelay = null;
    this._lubtn_glass_img = null;
    this._lubtn_glass_img_hover = null;
    this._multiCbId = null;
    this._tableChildData = null;
    this._tableChildHeader = null;
    this._tableBindingResultsName = null;
    this._divHeader = null;
    this._divDetail = null;
    this._btnSearchOK_Dialogue = null;
    this._btnSearchCancel_Dialogue = null;
    this.dialogueIsCreated = null;
    this.Direction = { UP: { value: -1 }, DOWN: { value: 1 } };

    //this.textBox = null;
    this.ctrl = null;
    this.iframeCtrl = null;
    this.containerCtrl = null;
    this.table = null;
    this.tableChild = null;
    this.tableBtnControl = null;
    this.mouseOutCSSClass = null;
    this.busyImage = null;

    //Handlers
    this._onContainerBlurHandler = null;
    this._closeSearch_DialogueHandler = null;
    this._onMouseOverRowHandler = null;
    this._onMouseOutRowHandler = null;
    this._containerCtrlKeydownHandler = null;
    this._btnSearchOK_DialogueHandler = null;
    this._dragging_onmousedown_Handler = null;
    this._dragging_onmouseup_Handler = null;

    //Dialogue ID Controls
    this._tHeadSpan_Dialogue = null;
    this._Message_Dialogue = null;

    //Dialogue Controls
    this.btnSearchOK_Dialogue = null;
    this.btnSearchCancel_Dialogue = null;
    this.Message_Dialogue = null;
    this._multiCbDialogue = null;

};

JmComboBox.MultiComboBoxControl.prototype =
{
    // called when the object is created
    initialize: function () {

        // call initialize on the base class - a standard piece of OO code
        JmComboBox.MultiComboBoxControl.callBaseMethod(this, 'initialize');

        if (!this._enabled)
            return;

        this.ctrl = $get(this.get_id());
        if (this.ctrl == undefined)
            return;

        if (this._busyImageUrl != null && this._busyImageUrl != "") {
            this.busyImage = document.createElement('img');
            this.busyImage.src = this._busyImageUrl;
            this.busyImage.style.display = 'none';
            this.busyImage.style.position = 'absolute';
            this.busyImage.style.zIndex = 100;
            this.getParentElement(this.get_TargetInputNameObj()).appendChild(this.busyImage);
        }

        this.dialogueIsCreated = false;

        // wire up the onclick event
        this._onClickHandler = Function.createDelegate(this, this._onClick);
        this._onContainerBlurHandler = Function.createDelegate(this, this.onContainerBlur);
        this._closeSearch_DialogueHandler = Function.createDelegate(this, this._onDialogueClose);
        this._btnSearchOK_DialogueHandler = Function.createDelegate(this, this._onDialogueOk);
        this._onMouseOverRowHandler = Function.createDelegate(this, this._onMouseOverRow);
        this._onMouseOutRowHandler = Function.createDelegate(this, this._onMouseOutRow);
        this._containerCtrlKeydownHandler = Function.createDelegate(this, this._containerCtrlKeydown);
        this._dragging_onmousedown_Handler = Function.createDelegate(this, this._dragging_onmousedown);
        this._dragging_onmouseup_Handler = Function.createDelegate(this, this._dragging_onmouseup);
        this._multiCheckAll_Handler = Function.createDelegate(this, this._multiCheckAll);
        this._window_onresize_Handler = Function.createDelegate(this, this.window_onresize);


        if (this._enabled) {
            $addHandler(this.get_element(), 'click', this._onClickHandler);
            $addHandler(this.get_TargetInputNameObj(), 'click', this._onClickHandler);

            $addHandler(this.get_TargetInputNameObj(), 'keydown', Function.createDelegate(this, this._textBoxKeyDown));
            $addHandler(this.get_TargetInputNameObj(), 'keyup', Function.createDelegate(this, this._textBoxKeyUp));

            if (window.attachEvent) {
                window.attachEvent('onresize', this._window_onresize_Handler);
            }
            else if (window.addEventListener) {
                window.addEventListener('resize', this._window_onresize_Handler, true);
            }
        }

    },

    // called when the object is removed
    dispose: function () {

        // unwire the event handlers
        $clearHandlers(this.get_element());
        $clearHandlers(this.get_TargetInputNameObj());

        // call dispose on the base class - a standard piece of OO code
        JmComboBox.MultiComboBoxControl.callBaseMethod(this, 'dispose');
    },

    // ----------------------------------------------   
    // properties
    // ----------------------------------------------

    get_TargetInputName: function () { return this._TargetInputName; },
    set_TargetInputName: function (value) { this._TargetInputName = value; },

    get_TargetInputHiddenName: function () { return this._TargetInputHiddenName; },
    set_TargetInputHiddenName: function (value) { this._TargetInputHiddenName = value; },

    get_multiSelection: function () { return this._multiSelection; },
    set_multiSelection: function (value) { this._multiSelection = value; },

    get_wWidth: function () { return this._wWidth; },
    set_wWidth: function (value) { this._wWidth = value; },

    get_wHeight: function () { return this._wHeight; },
    set_wHeight: function (value) { this._wHeight = value; },

    get_uniqueId: function () { return this._uniqueId; },
    set_uniqueId: function (value) { this._uniqueId = value; },

    get_containerCtrl: function () { return this._containerCtrl; },
    set_containerCtrl: function (value) { this._containerCtrl = value; },

    get_busyImageUrl: function () { return this._busyImageUrl; },
    set_busyImageUrl: function (value) { this._busyImageUrl = value; },

    get_popupHeaderTableUrl: function () { return this._popupHeaderTableUrl; },
    set_popupHeaderTableUrl: function (value) { this._popupHeaderTableUrl = value; },

    get_dialogueIsCreated: function () { return this._dialogueIsCreated; },
    set_dialogueIsCreated: function (value) { this._dialogueIsCreated = value; },

    get_posX: function () { return this._posX; },
    set_posX: function (value) { this._posX = value; },

    get_posY: function () { return this._posY; },
    set_posY: function (value) { this._posY = value; },

    get_PositionBaseOn: function () { return this._PositionBaseOn; },
    set_PositionBaseOn: function (value) { this._PositionBaseOn = value; },

    get_DialogueCentred: function () { return this._DialogueCentred; },
    set_DialogueCentred: function (value) { this._DialogueCentred = value; },

    get_enabled: function () { return this._enabled; },
    set_enabled: function (value) { this._enabled = value; },

    get_clientId: function () { return this._clientId; },
    set_clientId: function (value) { this._clientId = value; },

    get_columnHeaders: function () { return this._columnHeaders; },
    set_columnHeaders: function (value) { this._columnHeaders = value; },

    get_maxRecordsToShow: function () { return this._maxRecordsToShow; },
    set_maxRecordsToShow: function (value) { this._maxRecordsToShow = value; },

    get_fadeDelay: function () { return this._fadeDelay; },
    set_fadeDelay: function (value) { this._fadeDelay = value * 1000; },

    get_lubtn_glass_img: function () { return this._lubtn_glass_img; },
    set_lubtn_glass_img: function (value) { this._lubtn_glass_img = value; },

    get_lubtn_glass_img_hover: function () { return this._lubtn_glass_img_hover; },
    set_lubtn_glass_img_hover: function (value) { this._lubtn_glass_img_hover = value; },

    get_TargetInputNameObj: function () { return $get(this.get_TargetInputName()); },

    get_tableBindingResultsName: function () { return this._tableBindingResultsName; },
    set_tableBindingResultsName: function (value) { this._tableBindingResultsName = value; },

    get_minLengthSearch: function () { return this._minLengthSearch; },
    set_minLengthSearch: function (value) { this._minLengthSearch = value; },

    get_searchDelay: function () { return this._searchDelay; },
    set_searchDelay: function (value) { this._searchDelay = value; },


    // ----------------------------------------------------------------    
    // methods
    // ----------------------------------------------------------------
    _onClick: function (e) {

        if (this.ctrl.disabled == true)
            return;

        if (this.dialogueIsCreated == true)
            return;

        this._ShowDialogue();

        e.stopPropagation();
    },
    getParentElement: function (element) {
        if (document.all) // IE
            return element.parentElement;
        else
            return element.parentNode;
    },
    _ShowDialogue: function () {

        if (this.ctrl.disabled == true)
            return;

        if (this.dialogueIsCreated == true)
            return;

        this.createDialogueOuterHTML();

        $addHandler(document, 'click', this._onContainerBlurHandler);

        var draggedObj = $get(this._divHeader);
        $clearHandlers(draggedObj);
        $addHandler(draggedObj, "mousedown", this._dragging_onmousedown_Handler);
        $addHandler(draggedObj, "mouseup", this._dragging_onmouseup_Handler);

        this.showContainer();

    },

    _dragging_onmousedown: function (e) {
        this.startMoving(e, this.containerCtrl);
        e.stopPropagation();
    },

    _dragging_onmouseup: function (e) {
        document.onmousemove = function () {
        };
        document.onselectstart = null;
        this.get_TargetInputNameObj().focus();
        e.stopPropagation();
    },

    _multiCheckAll: function (e) {
        if (this._multiSelection) // Activate click in row
        {
            this.tableChild = $get(this._tableChildData);
            var checkboxesAll = this.tableChild.getElementsByTagName('input');
            for (var i = 0; i < checkboxesAll.length; i++) {
                if (!checkboxesAll[i].getAttribute('ismultiCb'))
                    continue;
                checkboxesAll[i].checked = e.target.checked;
            }
        }
    },

    _onDialogueClose: function (obj) {

        // unwire the event handlers
        $removeHandler(document, 'click', this._onContainerBlurHandler);
        $clearHandlers(this.containerCtrl);

        if (window.detachEvent) {
            window.detachEvent('onresize', this._window_onresize_Handler);
        }
        else if (window.removeEventListener) {
            window.removeEventListener('resize', this._window_onresize_Handler);
        }

        if (this._multiSelection == true) {
            $clearHandlers(this._multiCbDialogue);
        }

        this.strongTypedValueText();
        this.fadeOut(this, this.get_fadeDelay());

    },

    fadeOut: function (thisObj, time) {
        var elem = thisObj.containerCtrl;
        var startOpacity = elem.style.opacity || 1;
        elem.style.opacity = startOpacity;
        (function go() {
            elem.style.opacity -= startOpacity / (time / 100);
            elem.style.filter = 'alpha(opacity=' + elem.style.opacity * 100 + ')';

            if (elem.style.opacity > 0.1)
                setTimeout(go, 2);
            else {
                elem.style.display = 'none';
                document.getElementsByTagName('body')[0].removeChild(elem);
                if (this.iframeCtrl != null)
                    document.getElementsByTagName('body')[0].removeChild(elem);
                thisObj.dialogueIsCreated = false;

            }
        })();
    },

    fadeIn: function (thisObj, time) {
        var elem = thisObj.containerCtrl;
        var startOpacity = 0;
        elem.style.opacity = startOpacity;
        elem.style.filter = 'alpha(opacity=' + elem.style.opacity * 100 + ')';
        elem.style.display = '';
        (function go() {
            elem.style.opacity = (elem.style.opacity * 1) + (1 / (time / 100));
            // for IE
            elem.style.filter = 'alpha(opacity=' + elem.style.opacity * 100 + ')';
            if (elem.style.opacity < 1)
                setTimeout(go, 10);
            else {
                elem.style.display = '';
            }
        })();
    },

    _onDialogueOk: function () {

        $get(this.get_TargetInputHiddenName()).value = '';
        $get(this.get_TargetInputName()).value = '';

        this.tableChild = $get(this._tableChildData);
        var checkboxesAll = this.tableChild.getElementsByTagName('input');
        var checkedArray = new Array(0);

        for (i = 0; i < checkboxesAll.length; i++) {
            if (!checkboxesAll[i].getAttribute('ismultiCb'))
                continue;

            if (checkboxesAll[i].checked) {
                checkedArray.push(checkboxesAll[i].value);
            }
        }
        var returnArrayValue = checkedArray.join('°°');

        __doPostBack(this._uniqueId, returnArrayValue);

        this._onDialogueClose();
    },

    _containerCtrlKeydown: function (event) {
        if (event.which || event.keyCode) {
            if ((event.which == 27) || (event.keyCode == 27)) {
                this._onDialogueClose();
                return false;
            }
            if ((event.which == 13) || (event.keyCode == 13)) {
                //this.handleButtonSearchClick();
                return false;
            }
            return true;
        } else
            return true;
    },

    _textBoxKeyDown: function (ev) {

        var keyCode = ev.charCode || ev.keyCode;
        var ret = false;

        if (this.dialogueIsCreated) {
            if (keyCode == 13 || keyCode == 9) // ENTER or TAB
            {
                __doPostBack(this._uniqueId, this.getSelectedRowValue());
                this._onDialogueClose();
                return false;

            } else if (keyCode == 27) // ESC
            {
                __doPostBack(this._uniqueId, this.getSelectedRowValue());
                this._onDialogueClose();

            } else {
                ret = true;
            }
        } else {
            ret = true;
        }

        return ret;
    },


    _textBoxKeyUp: function (ev) {

        var keyCode = ev.charCode || ev.keyCode;

        if (keyCode == 127 || keyCode == 8) {  // if delete or backspace and text is empty remove preselected key.
            if ($get(this.get_TargetInputName()).value.length == 0)
                $get(this.get_TargetInputHiddenName()).value = '';
        }

        if (keyCode == 38) // up
        {
            if (!this.dialogueIsCreated)
                return;
            this.moveActiveSelection(this.Direction.UP);
        }
        else if (keyCode == 40) // down
        {
            if (this.dialogueIsCreated == false) {
                this._ShowDialogue();
                return;
            }
            this.moveActiveSelection(this.Direction.DOWN);
        }
        else if ((keyCode < 37 || keyCode > 40) && keyCode != 13 && keyCode != 27 && keyCode != 9) // no arrow keys,no enter,no ESC, no TAB
        {

            if (this.get_TargetInputNameObj().value != this.previousText) // check if text has changed -> prevent unnecessary lookups
            {
                if (this.callActive != null) {
                    window.clearTimeout(this.callActive);
                    this.callActive = null;
                }

                if (this.get_TargetInputNameObj().value.length >= this._minLengthSearch) {
                    this.callActive = window.setTimeout(Function.createDelegate(this, this.setAutoCompleteTable), this._searchDelay);
                    this.showBusyImage(true);
                }
                else {
                    this.showBusyImage(false);
                }

                this.previousText = this.get_TargetInputNameObj().value;
            }
        }
    },

    strongTypedValueText: function () {
        
        $get(this.get_TargetInputName()).value = '';
        var table = $get(this._tableChildData);
        
        if (!this._multiSelection) {

            for (var ax = 0; ax != table.rows.length; ax++) {
                var xrow = table.rows[ax];
                if (xrow.getAttribute('KeyValue') == $get(this.get_TargetInputHiddenName()).value) {
                    $get(this.get_TargetInputName()).value = xrow.getAttribute('TextValue');
                }
            }
        } else {

         
            
            var keyValueArray = new Array(0);
            var textValueArray = new Array(0);
            
            for (var ax = 0; ax != table.rows.length; ax++) {
                var xrow = table.rows[ax];
                
                var checkboxesAll = xrow.getElementsByTagName('input');
                for (var i = 0; i < checkboxesAll.length; i++) {
                    if (checkboxesAll[i].getAttribute('ismultiCb')) {

                        if (checkboxesAll[i].checked) {
                            keyValueArray.push(xrow.getAttribute('KeyValue'));
                            textValueArray.push(xrow.getAttribute('TextValue'));
                        }
                        break;
                    }
                }
   
            }
            $get(this.get_TargetInputHiddenName()).value = keyValueArray.join(";");
            $get(this.get_TargetInputName()).value = textValueArray.join(";");

        }

    },

    getSelectedRowValue: function () {

        var rowValues = '';
        var table = $get(this._tableChildData);
        for (var ax = 0; ax != table.rows.length; ax++) {
            var xrow = table.rows[ax];
            if (xrow.getAttribute('KeyValue') == $get(this.get_TargetInputHiddenName()).value) {
                rowValues = xrow.getAttribute('valueInKeys');
            }
        }
        return rowValues;
    },

    moveActiveSelection: function (dir) {

        var table = $get(this._tableChildData);
        var rowsVisibleArray = [];
        var ii = 0;
        for (var ax = 0; ax != table.rows.length; ax++) {
            var xrow = table.rows[ax];
            if (xrow.style.display == 'none')
                continue;
            rowsVisibleArray.push(xrow);
            ii++;
        }

        var selectedRowId = -1;
        for (var y = 0; y != rowsVisibleArray.length; y++) {
            if (rowsVisibleArray[y].getAttribute('KeyValue') == $get(this.get_TargetInputHiddenName()).value) {
                selectedRowId = y;
                break;
            }
        }

        selectedRowId = selectedRowId + dir.value;
        if (selectedRowId >= 0 && rowsVisibleArray.length > selectedRowId) {
            $get(this.get_TargetInputHiddenName()).value = rowsVisibleArray[selectedRowId].getAttribute('KeyValue');
            $get(this.get_TargetInputName()).value = rowsVisibleArray[selectedRowId].getAttribute('TextValue');
        }

        this.stylingSelectedRow();

    },

    stylingSelectedRow: function () {

        var table = $get(this._tableChildData);
        var selectedValues = $get(this.get_TargetInputHiddenName()).value.split(";");

        ii = 0;
        for (var ax = 0; ax != table.rows.length; ax++) {
            var xrow = table.rows[ax];

            if (xrow.style.display == 'none')
                continue;

            if (xrow.getAttribute('rowtype') == 'data') {
                if (ii % 2 != 0)
                    xrow.className = "CB_TableOddRow";
                else
                    xrow.className = "CB_TableEvenRow";


                if (!this._multiSelection) {
                    if (xrow.getAttribute('KeyValue') == $get(this.get_TargetInputHiddenName()).value) {
                        xrow.className = "CB_TableRowSelected";

                        var divDet = $get(this._divDetail);
                        var mpos = xrow.offsetTop;
                        var divscrollTop = divDet.scrollTop;
                        if ((mpos - divscrollTop) < 0 || (mpos - divscrollTop) + 20 >= divDet.offsetHeight) {

                            divDet.scrollTop = mpos - divDet.offsetHeight / 2;

                            if ((mpos - divscrollTop) < 0) {
                                divDet.scrollTop = divDet.scrollTop - divDet.offsetHeight / 2;
                            }
                        }
                    }
                }
                else {
                    if (selectedValues.indexOf(xrow.getAttribute('KeyValue')) >= 0) {
                        var checkboxesAll = xrow.getElementsByTagName('input');
                        for (var i = 0; i < checkboxesAll.length; i++) {
                            if (!checkboxesAll[i].getAttribute('ismultiCb'))
                                continue;
                            checkboxesAll[i].checked = true;
                        }
                    }
                }
            }
            ii++;
        }


        var divDetailHeight = (this._wHeight - 4);

        var divDet = $get(this._divDetail);
        if (table.clientHeight < divDet.clientHeight)
            divDet.style.height = (table.clientHeight + 4) + 'px';
        else
            divDet.style.height = divDetailHeight + 'px';

    },

    setAutoCompleteTable: function () {

        if (this.callActive == null) {
            return;
        }
        if (this.dialogueIsCreated == false)
            this._ShowDialogue();

        this.filterTable(this.get_TargetInputNameObj(), $get(this._tableChildData));
        this.alingLayoutTable();
        window.clearTimeout(this.callActive);
        this.callActive = null;

        this.showBusyImage(false);
    },


    receiverServerData: function () {

        var source = $get(this._tableBindingResultsName);;
        var destination = $get(this._tableChildData);
        var copy = source.cloneNode(true);
        copy.setAttribute('id', this._tableChildData);
        destination.parentNode.replaceChild(copy, destination);

        var tableChildData = $get(this._tableChildData);
        var dataRows = 0;

        for (var i = 0; i != tableChildData.rows.length; i++) {

            var row = tableChildData.rows[i];

            if (row.getAttribute('rowtype') == 'data') {

                $clearHandlers(row);
                $addHandler(row, "mouseover", this._onMouseOverRowHandler);
                $addHandler(row, "mouseout", this._onMouseOutRowHandler);

                if (!this._multiSelection) // Activate click in row
                {
                    row.setAttribute("onmouseover", "this.style.cursor='pointer';");
                    $addHandler(row, "click", this._closeSearch_DialogueHandler);

                }

                dataRows++;
            }
        }
    },


    filterTable: function filterTable(term, table) {
        this.dehighlight(table);
        var terms = term.value.toLowerCase().split(" ");

        for (var r = 0; r < table.rows.length; r++) {

            if (table.rows[r].getAttribute('rowtype') == 'header')
                continue;

            var display = '';
            for (var i = 0; i < terms.length; i++) {
                if (table.rows[r].innerHTML.replace(/<[^>]+>/g, "").toLowerCase().indexOf(terms[i]) < 0) {
                    display = 'none';
                } else {
                    if (terms[i].length)
                        this.highlight(terms[i], table.rows[r]);
                }
                table.rows[r].style.display = display;
            }
        }
    },

    dehighlight: function (container) {
        for (var i = 0; i < container.childNodes.length; i++) {
            var node = container.childNodes[i];

            if (node.attributes && node.attributes['class'] && node.attributes['class'].value == 'highlighted') {
                node.parentNode.parentNode.replaceChild(document.createTextNode(node.parentNode.innerHTML.replace(/<[^>]+>/g, "")), node.parentNode);
                // Stop here and process next parent
                return;
            } else if (node.nodeType != 3) {
                // Keep going onto other elements
                this.dehighlight(node);
            }
        }
    },

    highlight: function highlight(term, container) {

        for (var i = 0; i < container.childNodes.length; i++) {
            var node = container.childNodes[i];

            if (node.nodeType == 3) {
                // Text node
                var data = node.data;
                var data_low = data.toLowerCase();
                if (data_low.indexOf(term) >= 0) {
                    //term found!
                    var new_node = document.createElement('span');

                    node.parentNode.replaceChild(new_node, node);

                    var result;
                    while ((result = data_low.indexOf(term)) != -1) {
                        new_node.appendChild(document.createTextNode(data.substr(0, result)));

                        var chl = document.createTextNode(data.substr(result, term.length));

                        var nodeIn = document.createElement('span');
                        nodeIn.setAttribute('class', 'highlighted');
                        nodeIn.attributes['class'].value = 'highlighted';
                        nodeIn.appendChild(chl);

                        new_node.appendChild(nodeIn);
                        data = data.substr(result + term.length);
                        data_low = data_low.substr(result + term.length);
                    }
                    new_node.appendChild(document.createTextNode(data));
                }
            } else {
                // Keep going onto other elements
                highlight(term, node);
            }
        }
    },

    showBusyImage: function (show) {

        if (this.busyImage != null) {
            if (show == true) {
                this.busyImage.style.display = '';

                var pos = Sys.UI.DomElement.getLocation(this.get_TargetInputNameObj());
                if (navigator.appVersion.indexOf('MSIE 8.') != -1) {
                    pos.x += 2;
                    pos.y += 2;
                }

                var posX = pos.x + (this.get_TargetInputNameObj().offsetWidth) - (this.busyImage.offsetWidth) - 2;
                var posY = pos.y + (this.get_TargetInputNameObj().offsetHeight / 2) - (this.busyImage.offsetHeight / 2);

                this.busyImage.style.left = posX + 'px';
                this.busyImage.style.top = posY + 'px';
            }
            else {
                this.busyImage.style.display = 'none';
            }
        }
    },


    onContainerBlur: function (e) {

        if (this.dialogueIsCreated == false)
            return;
        if (this.containerCtrl.contains(e.target))
            return;
        this._onDialogueClose();

    },

    isContainerVisible: function () {
        return (this.containerCtrl.style.display == '') ? true : false;
    },

    showContainer: function () {

        if (this._DialogueCentred)
            this.dialogueCentered();

        this.fadeIn(this, this.get_fadeDelay());

        $addHandler(this.containerCtrl, "keydown", this._containerCtrlKeydownHandler);

        this.alingLayoutTable();

    },

    alingLayoutTable: function () {

        this.stylingSelectedRow();

        var _tableChildData = $get(this._tableChildData);
        if (_tableChildData.rows.length > 0) {
            var tableChildHeader = $get(this._tableChildHeader);
            for (var x = 0; x != _tableChildData.rows.length; x++) {
                var row = _tableChildData.rows[x];
                if (row.getAttribute('rowtype') == 'header') {
                    for (var i = 0; i != row.cells.length; i++) {
                        tableChildHeader.rows[0].cells[i].style.width = row.cells[i].style.width;
                    }
                    break;
                }
            }

            var a1 = $get(this._divDetail);
            var a2 = $get(this._divHeader);
            if (a1.clientHeight < a1.scrollHeight)
                a2.style.paddingRight = "17px";
            else
                a2.style.paddingRight = "0px";
        }

    },

    iniciateDialogueFieldsInstance: function () {

        this.Message_Dialogue = $get(this._Message_Dialogue);
        this.btnSearchOK_Dialogue = $get(this._btnSearchOK_Dialogue);
        this.btnSearchCancel_Dialogue = $get(this._btnSearchCancel_Dialogue);

    },

    clearTablesResult: function () {
        var tblChild = $get(this._tableChild);
        $get(this._Message_Dialogue).innerHTML = "";

        for (var z = tblChild.tBodies.length - 1; z > -1; z--) {
            for (var i = tblChild.tBodies[z].rows.length; i > 0; i--) {
                tblChild.tBodies[z].deleteRow(i - 1);
            }
        }

        var headResultLabel = $get(this._tHeadSpan_Dialogue);
        headResultLabel.innerHTML = "";
        this.controlBtnbehavior();


    },

    _onMouseOverRow: function (e) {
        var tgt = this.getParentByTagNameOfParent(e.target, "TR", this._tableChildData);
        if (tgt != null) {
            this.mouseOutCSSClass = tgt.className;
            tgt.className = this._rowHighlightCSSClass;
        }
        e.stopPropagation();
    },

    _onMouseOutRow: function (e) {
        var tgt = this.getParentByTagNameOfParent(e.target, "TR", this._tableChildData);
        if (tgt != null) {
            tgt.className = this.mouseOutCSSClass;
        }
        e.stopPropagation();
    },

    getParentByTagNameOfParent: function (element, tagName, ofParent) {

        var elem = element;
        var upperTagName = tagName.toUpperCase();
        var parent1 = null;
        var parent2 = null;

        while (elem) {

            parent1 = elem.parentNode ? elem.parentNode : elem.parentElement;
            parent2 = parent1.parentNode ? parent1.parentNode : parent1.parentElement;

            if (elem.tagName.toUpperCase() == upperTagName && (parent1.id == ofParent))
                break;

            if (parent2) {
                if (elem.tagName.toUpperCase() == upperTagName && (parent2.id == ofParent))
                    break;
            }

            elem = parent1;

        }
        return elem;
    },


    getParentByTagName: function (element, tagName) {
        var parent = element.parentNode;
        var upperTagName = tagName.toUpperCase();

        while (parent && (parent.tagName.toUpperCase() != upperTagName)) {
            parent = parent.parentNode ? parent.parentNode : parent.parentElement;
        }
        return parent;
    },

    dialogueCentered: function () {

        var newpos = window.center({ width: this.containerCtrl.clientWidth, height: this.containerCtrl.clientHeight });
        var p_x = newpos.y + this._posY;
        if (p_x < 0) p_x = 0;

        this.containerCtrl.style.top = p_x;
        this.containerCtrl.style.left = newpos.x + this._posX;

    },

    window_onresize: function () {

        if (this.dialogueIsCreated) {
            var pos, posX, posY;
            if (this._PositionBaseOn == 1) {
                pos = Sys.UI.DomElement.getLocation(this.ctrl);
                posX = pos.x;
                posY = pos.y + (this.ctrl.offsetHeight);
            }
            else {
                var elem = this.get_TargetInputNameObj();
                pos = Sys.UI.DomElement.getLocation(elem);
                posX = pos.x - 1;
                posY = pos.y + (elem.offsetHeight) + 2;
            }

            if (this._posX != -1)
                posX = this._posX;

            if (this._posY != -1)
                posY = this._posY;

            if (this._DialogueCentred) {
                var newpos = window.center({ width: this._wWidth, height: 300 });
                posY = newpos.y + this._posY;
                posX = newpos.x + this._posX;
            }

            this.containerCtrl.style.left = posX + 'px';
            this.containerCtrl.style.top = posY + 'px';

        }

    },


    createDialogueOuterHTML: function () {

        this.iframeCtrl = null;
        this._pnlContainer = "containerCtrl_" + this._uniqueId;
        this._iFrameId = "iFrameCtrl_" + this._uniqueId;

        var pos, posX, posY;
        if (this._PositionBaseOn == 1) {
            pos = Sys.UI.DomElement.getLocation(this.ctrl);
            posX = pos.x;
            posY = pos.y + (this.ctrl.offsetHeight);
        }
        else {

            var elem = this.get_TargetInputNameObj();
            pos = Sys.UI.DomElement.getLocation(elem);
            posX = pos.x - 1;
            posY = pos.y + (elem.offsetHeight) + 2;
        }

        if (this._posX != -1)
            posX = this._posX;

        if (this._posY != -1)
            posY = this._posY;

        if (this._DialogueCentred) {
            var newpos = window.center({ width: this._wWidth, height: 300 });
            posY = newpos.y + this._posY;
            posX = newpos.x + this._posX;
        }

        this.containerCtrl = document.createElement('div');
        this.containerCtrl.setAttribute("id", this._pnlContainer);

        this.containerCtrl.style.zIndex = '10001';
        this.containerCtrl.style.position = 'absolute';
        this.containerCtrl.style.left = posX + 'px';
        this.containerCtrl.style.top = posY + 'px';
        this.containerCtrl.style.display = 'none';
        this.containerCtrl.style.width = this._wWidth + 'px';
        //this.containerCtrl.style.overflow = 'hidden';
        this.containerCtrl.className = "CB_DivContainer";

        this._Message_Dialogue = 'Message_Dialogue_' + this._uniqueId;

        this._tHeadSpan_Dialogue = 'tHeadSpan_' + this._clientId;
        this._table = 'SelectOuResult_Parent_' + this._clientId;
        this._tableChild = 'SelectOuResult_Child_' + this._clientId;
        this._tableBtnControl = 'BtnControl_' + this._clientId;
        this._dragHeadereRowId = 'dragHeadereRowId_' + this._clientId;
        this._multiCbId = 'multiCbAll_' + this._clientId;
        this._mainDivChildId = 'mainDivChildId' + this._clientId;
        this._tableChildData = 'tableChildData' + this._clientId;
        this._tableChildHeader = 'tableChildHeader' + this._clientId;
        this._btnSearchOK_Dialogue = 'btnSearchOK_' + this._uniqueId;
        this._btnSearchCancel_Dialogue = 'btnSearchCancel_' + this._uniqueId;

        var sb = new Sys.StringBuilder();
        sb.append('<table id="' + this._table + '"  cellpadding="0" cellspacing="0" style="margin-top: 0px;" width="100%" cellspacing="0" cellpadding="0">');
        sb.append('<thead>');
        sb.append('</thead>');
        sb.append('<tbody>');
        sb.append('<tr>');
        sb.append('    <td>');
        sb.append('<div id="' + this._mainDivChildId + '" >');
        sb.append(this.genChildTable());
        sb.append('</div>');
        sb.append('    </td>');
        sb.append('</tr>');
        sb.append('<tr>');
        sb.append('<td style="padding: 2px;">');
        sb.append('    <table  style="border-collapse: collapse; Width:100%">');
        sb.append('        <tr style="text-align: right">');
        sb.append('            <td style="Width: 110px">');
        if (this._multiSelection)
            sb.append('                <input type="submit" class="lubButton_Glass" value="Select" id="' + this._btnSearchOK_Dialogue + '"  style="width: 100px; height: 22px;"/> ');
        sb.append('                &nbsp;');
        sb.append('            </td>');
        sb.append('            <td style="Width: 110px; padding-left: 4px;">');
        if (this._multiSelection)
            sb.append('                <input type="submit" class="lubButton_Glass" value="Cancel" id="' + this._btnSearchCancel_Dialogue + '" style="width: 100px; height: 22px;"/>');
        sb.append('                &nbsp;');
        sb.append('            </td>');
        sb.append('            <td>');
        sb.append('            </td>');
        sb.append('        </tr>');
        sb.append('    </table>');
        sb.append('</td>');
        sb.append('</tr>');
        sb.append('</body>');
        sb.append('</table>');

        this.containerCtrl.innerHTML = sb.toString();
        var body = document.getElementsByTagName("body")[0];
        body.appendChild(this.containerCtrl);
        this.table = $get(this._table);
        this.containerCtrl = $get(this._pnlContainer);
        this.dialogueIsCreated = true;

        this.receiverServerData();

        this.iniciateDialogueFieldsInstance();

        if (this._multiSelection == true) {

            this._multiCbDialogue = $get(this._multiCbId);
            $addHandler(this._multiCbDialogue, "click", this._multiCheckAll_Handler);
            $addHandler(this.btnSearchOK_Dialogue, "click", this._btnSearchOK_DialogueHandler);
            $addHandler(this.btnSearchCancel_Dialogue, "click", this._closeSearch_DialogueHandler);
        }
    },


    genChildTable: function () {

        this._divHeader = "divHeader" + this._clientId;
        this._divDetail = "divDetail" + this._clientId;

        var divDetailHeight = this._wHeight - 4;

        var headerArray = new Array(0);
        var headerArray = this._columnHeaders.split("°°");
        var sb = new Sys.StringBuilder();

        sb.append('<table id="' + this._tableChild + '" width="100%" CellSpacing="0" CellPadding="0">');
        sb.append('<table width="100%" CellSpacing="0" CellPadding="0">');
        sb.append('<tr>');
        sb.append('<td>');
        sb.append('<div id="' + this._divHeader + '" style="overflow:auto;cursor: move; overflow-x:hidden; border-right: solid 0px #bed6f6;border-bottom: solid 1px #bed6f6;  @HeaderTableStyle@ ">');  //*********************Header Table -begin
        sb.append('<table id="' + this._tableChildHeader + '" style="width:100%; table-layout:fixed" CellSpacing="0" CellPadding="0">');
        sb.append('<tr class="CB_ColumnHeader" rowtype="rowHeader" >');
        var ncol = 1;

        if ((this._multiSelection)) {
            sb.append('<td style="width:20px; overflow:hidden; cursor: pointer;" class="CB_HCellLeft"><input id="' + this._multiCbId + '" type="checkbox"/></td>');
        }
        for (var j = 0; j < headerArray.length; j++) {
            var columnClass = 'CB_HCellLeft';
            if (ncol >= 1 && ncol == headerArray.length)
                columnClass = 'CB_HCellLeft';

            sb.append('<td style="overflow:hidden" class="' + columnClass + '">' + headerArray[j] + '</td>');
            ncol++;
        }

        sb.append('</tr>');
        sb.append('</table>');
        sb.append('</div>'); //*********************Header Table End
        sb.append('<div id="' + this._divDetail + '" style="height:' + divDetailHeight + 'px; overflow:auto; overflow-x:hidden; border-bottom: solid 1px #bed6f6; ">');  //*********************Table Data -begin
        sb.append('<table   id="' + this._tableChildData + '"  style="width:0px; table-layout:fixed"   CellSpacing="0" CellPadding="0">');
        sb.append('</table>');
        sb.append('</div>'); //*********************Table Data End
        sb.append('</td>');
        sb.append('</tr>');
        sb.append('</table>');
        var mstyle = "background-image: url('" + this._popupHeaderTableUrl + "'); background-repeat: repeat-x;background-position-x: center;background-position-y: bottom;background-size: auto;background-origin: padding-box;background-clip: border-box;background-color: rgb(199, 223, 255);";
        var sbstring = sb.toString();
        sbstring = sbstring.replaceAll('@HeaderTableStyle@', mstyle);
        return sbstring;

    },

    startMoving: function (evt, el) {
        var $el = el;
        evt = evt || window.event;
        var posX = evt.clientX,
            posY = evt.clientY,
            divTop = $el.style.top,
            divLeft = $el.style.left;

        if (isNaN(divTop) || divTop == '')
            divTop = $el.offsetTop + 'px';
        if (isNaN(divLeft) || divLeft == '')
            divLeft = $el.offsetLeft + 'px';

        divTop = divTop.replace('px', '');
        divLeft = divLeft.replace('px', '');
        var diffX = posX - divLeft,
            diffY = posY - divTop;

        document.body.focus();
        document.onselectstart = function () { return false; };

        document.onmousemove = function (evt) {
            evt = evt || window.event;
            var posX = evt.clientX;
            var posY = evt.clientY;
            var aX = posX - diffX;
            var aY = posY - diffY;

            $el.style.left = aX + 'px';
            $el.style.top = aY + 'px';
        };
    },


    createIframe: function () {
        var body = document.getElementsByTagName("body")[0];
        if (navigator.appName == 'Microsoft Internet Explorer') {
            if (navigator.appVersion.indexOf('MSIE 6.') != -1 && this._iFrameUrl != null && this.iframeCtrl == null) {

                this.iframeCtrl = document.createElement("iframe");
                this.iframeCtrl.id = this._iFrameId;
                this.iframeCtrl.frameBorder = 0;
                this.iframeCtrl.src = "javascript:false;";
                this.iframeCtrl.style.display = "none";
                this.iframeCtrl.style.position = "absolute";
                this.iframeCtrl.style.filter = "progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0)";
                this.iframeCtrl.style.zIndex = this.containerCtrl.style.zIndex - 1;
                body.appendChild(this.iframeCtrl);

            }
        }
    }
};

window.size = function () {
    var w = 0;
    var h = 0;
    //IE
    if (!window.innerWidth) {
        //strict mode
        if (!(document.documentElement.clientWidth == 0)) {
            w = document.documentElement.clientWidth;
            h = document.documentElement.clientHeight;
        }
            //quirks mode
        else {
            w = document.body.clientWidth;
            h = document.body.clientHeight;
        }
    }
        //w3c
    else {
        w = window.innerWidth;
        h = window.innerHeight;
    }
    return { width: w, height: h };
};

window.center = function () {
    var hWnd = (arguments[0] != null) ? arguments[0] : { width: 0, height: 0 };
    var _x = 0;
    var _y = 0;
    var offsetX = 0;
    var offsetY = 0;
    //IE
    if (!window.pageYOffset) {
        //strict mode
        if (!(document.documentElement.scrollTop == 0)) {
            offsetY = document.documentElement.scrollTop;
            offsetX = document.documentElement.scrollLeft;
        }
            //quirks mode
        else {
            offsetY = document.body.scrollTop;
            offsetX = document.body.scrollLeft;
        }
    }
        //w3c
    else {
        offsetX = window.pageXOffset;
        offsetY = window.pageYOffset;
    }
    _x = ((this.size().width - hWnd.width) / 2) + offsetX;
    _y = ((this.size().height - hWnd.height) / 2) + offsetY;
    return { x: _x, y: _y };
};

JmComboBox.MultiComboBoxControl.registerClass('JmComboBox.MultiComboBoxControl', Sys.UI.Control);
