﻿#region License

// Copyright (c) 2011 Josue Medrano Cruz
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.

#endregion


using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Design;
using System.Text.RegularExpressions;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Data;
using Newtonsoft.Json;
using BorderStyle = System.Web.UI.WebControls.BorderStyle;
using CheckBox = System.Web.UI.WebControls.CheckBox;
using Control = System.Web.UI.Control;
using HorizontalAlign = System.Web.UI.WebControls.HorizontalAlign;
using TextBox = System.Web.UI.WebControls.TextBox;


[assembly: TagPrefix("MultiComboBox", "JmComboBox")]
[assembly: WebResource("JmComboBox.Common.activity.gif", "image/gif")]
[assembly: WebResource("JmComboBox.Common.dropDownArrow.png", "img/png")]
[assembly: WebResource("JmComboBox.Common.dropDownArrowDissabled.png", "img/png")]
[assembly: WebResource("JmComboBox.Common.JmComboBox.css", "text/css")]
[assembly: WebResource("JmComboBox.Common.lubtn_glass_img.gif", "image/gif")]
[assembly: WebResource("JmComboBox.Common.lubtn_glass_img_hover.gif", "image/gif")]
[assembly: WebResource("JmComboBox.Common.Popup_header_table.gif", "img/png")]
[assembly: WebResource("JmComboBox.MultiComboBox.MultiComboBox.js", "text/js")]

internal class MultiComboBoxEmbeddedResource
{

}


namespace JmComboBox
{
    [ToolboxData("<{0}:MultiComboBox runat=\"server\"></{0}:MultiComboBox>"),
    ToolboxBitmap(typeof(MultiComboBoxEmbeddedResource), "JmComboBox.Common.dropDownArrow.png"),
    DefaultEvent("SelectedIndexChanged")
    ]
    public class MultiComboBox : DataBoundControl, IScriptControl, ICallbackEventHandler, IPostBackEventHandler
    {


        #region private fields



        private List<ColumnField> _cellTemplates;
        private ScriptManager _sm;
        private TextBox _textBoxSelectedText;
        private TextBox _textBoxSelectedIndex;
        private string _tableNameBindedResultsInner;
        private DataTable _bindedDataTable;
        private bool _requiresTextBinding;


        #endregion

        public override void DataBind()
        {
            base.DataBind();
            _tableNameBindedResultsInner = RenderGridList();
        }

        public enum PositionOn
        {
            Control = 1, TargetControl = 2
        }

        

        public event EventHandler<RowData> SelectedIndexChanged;

        #region Design Properties


        /// <summary>
        /// Gets or sets the formatting string used to control how data bound to the list control is displayed.
        [DefaultValue("")]
        [Description("ListControl_DataTextField")]
        [Themeable(false)]
        public virtual string DataTextField
        {
            get
            {
                return (string)this.ViewState["DataTextField"] ?? string.Empty;
            }
            set
            {
                this.ViewState["DataTextField"] = (object)value;
                //if (!this.Initialized)
                //    return;
                //this.RequiresDataBinding = true;
            }
        }

        /// <summary>
        /// Gets or sets the field of the data source that provides the value of each list item.
        [Themeable(false)]
        [DefaultValue("")]
        [Description("ListControl_DataValueField")]
        public virtual string DataValueField
        {
            get
            {
                return (string)this.ViewState["DataValueField"] ?? string.Empty;
            }
            set
            {
                this.ViewState["DataValueField"] = (object)value;
                //if (!this.Initialized)
                //    return;
                //this.RequiresDataBinding = true;
            }
        }


        [DefaultValue("")]
        [Themeable(false)]
        [Bindable(true, BindingDirection.TwoWay)]
        [Category("Behavior")]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        [Browsable(false)]
        public virtual string SelectedValue
        {
            get
            {
                EnsureChildControls();
                return _textBoxSelectedIndex.Text;
            }
            set
            {
                EnsureChildControls();
                _textBoxSelectedIndex.Text = value;
                if (!this.Initialized)
                    return;
                this._requiresTextBinding = true;
            }
        }

        [Description("DataControls_Columns")]
        [PersistenceMode(PersistenceMode.InnerProperty)]
        [Category("Default")]
        [MergableProperty(false)]
        [DefaultValue(null)]
        public virtual List<ColumnField> Columns
        {
            get
            {
                if (this._cellTemplates == null)
                {
                    this._cellTemplates = new List<ColumnField>();
                    if (this.IsTrackingViewState)
                        this.TrackViewState();
                }
                return this._cellTemplates;
            }
        }



        [Category("misc")]
        [Description("")]
        private string TargetInputName
        {
            get
            {
                return (string.Format("{0}_InputName", ClientID));
            }
        }

        [Category("misc")]
        [Description("")]
        private string TargetInputHiddenName
        {
            get
            {
                return (string.Format("{0}_InputHiddenName", ClientID));
            }
        }


        [Category("misc")]
        [Description("")]
        private string TableBindingResultsName
        {
            get
            {
                return (string.Format("TableBindingResultsName_{0}", this.ClientID));
            }
        }

        /// <summary>
        /// Gets or sets the delay between last key action and the lookup
        /// </summary>
        [Category("Behavior"), DefaultValue(500), Description("Specifies the delay in ms after the last key press before a search is triggered.")]
        public int SearchDelay
        {
            get
            {
                object o = ViewState["SearchDelay"];
                return (o == null) ? 500 : (int)o;
            }
            set
            {
                if (value < 0)
                    throw new ArgumentOutOfRangeException("The value of 'SearchDelay' must be at least 0");
                ViewState["SearchDelay"] = value;
            }
        }

        [Category("Behavior"), DefaultValue(0), Description("Minimun length in text box to search in dropdown.")]
        public int MinLengthSearch
        {
            get
            {
                var o = ViewState["_MinLengthSearch"];
                return (o == null ? 0 : (int)o);
            }
            set
            {

                ViewState["_MinLengthSearch"] = value;
            }
        }


        [DefaultValue("")]
        [Localizable(true)]
        [PersistenceMode(PersistenceMode.EncodedInnerDefaultProperty)]
        public string Text
        {
            get
            {
                if (!string.IsNullOrEmpty(_textBoxSelectedText.Text))
                    return _textBoxSelectedText.Text;
                if (!string.IsNullOrEmpty(_textBoxSelectedIndex.Text))
                    return _textBoxSelectedIndex.Text;
                else
                    return string.Empty;
            }
            set
            {
                _textBoxSelectedText.Text = value;
            }
        }
        /// <summary>
        /// Gets or sets the image URL.
        /// </summary>
        /// <value>The image URL.</value>
        [Category("Appearance"), DefaultValue("")]
        [Description("The URL of the image to be displayed for the button. The Text property will become the alt text tag for the image button.")]
        [Browsable(true), Editor(typeof(System.Web.UI.Design.UrlEditor), typeof(UITypeEditor))]
        public string ImageUrl
        {
            get
            {
                EnsureChildControls();
                var o = ViewState["_ImageUrlOn"];
                return (o == null ? string.Empty : (string)o);
            }

            set
            {
                EnsureChildControls();
                ViewState["_ImageUrlOn"] = ResolveUrl(value);

            }
        }



        [Category("Appearance"), DefaultValue("")]
        [Description("The URL of the image to be displayed for the button. The Text property will become the alt text tag for the image button.")]
        [Browsable(true), Editor(typeof(System.Web.UI.Design.UrlEditor), typeof(UITypeEditor))]
        public string ImageUrlOff
        {
            get
            {
                EnsureChildControls();
                var o = ViewState["_ImageUrlOff"];
                return (o == null ? string.Empty : (string)o);
            }

            set
            {
                EnsureChildControls();
                ViewState["_ImageUrlOff"] = ResolveUrl(value);

            }
        }


        [TypeConverterAttribute(typeof(StringArrayConverter)),
        Category("Data"), Description("Fields for which the values will be available when user complete the selection")]
        public string[] DataKeyNames { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether [dialogue centred].
        /// </summary>
        /// <value><c>true</c> if [dialogue centred]; otherwise, <c>false</c>.</value>
        [Category("Appearance"), DefaultValue(false), Description("Set the dialogue on the center of the window")]
        public bool DialogueCentred
        {
            get
            {
                var o = ViewState["_DialogueCentred"];
                return (o != null && (bool)o);
            }
            set
            {
                ViewState["_DialogueCentred"] = value;
            }
        }



        [Category("Appearance"), DefaultValue(2), Description("Fade delay (seconds)")]
        public int FadeDelay
        {
            get
            {
                var o = ViewState["_FadeDelay"];
                return (o == null ? 2 : (int)o);
            }
            set
            {
                ViewState["_FadeDelay"] = value;
            }
        }


        /// <summary>
        /// Gets or sets the width.
        /// </summary>
        /// <value>The width.</value>
        [Category("Appearance"), DefaultValue(PositionOn.TargetControl), Description("The default for position based on control or Target Control, where the control will appear first where the user invoques the control to pops up")]
        public PositionOn PositionBaseOn
        {
            get
            {
                var o = ViewState["_PositionBaseOn"];
                return (o == null) ? PositionOn.TargetControl : (PositionOn)o;
            }
            set
            {
                ViewState["_PositionBaseOn"] = value;
            }
        }

        /// <summary>
        /// Gets or sets the width.
        /// </summary>
        /// <value>The width.</value>
        [Category("Appearance"), DefaultValue(-1), Description("The default for top position of the windows information")]
        public int PosX
        {
            get
            {
                var o = ViewState["_PosX"];
                return (o == null ? -1 : (int)o);
            }
            set
            {
                ViewState["_PosX"] = value;
            }
        }

        /// <summary>
        /// Gets or sets the width.
        /// </summary>
        /// <value>The width.</value>
        [Category("Appearance"), DefaultValue(-1), Description("The default for bottom position of the windows information")]
        public int PosY
        {
            get
            {
                var o = ViewState["_PosY"];
                return (o == null ? -1 : (int)o);
            }
            set
            {
                ViewState["_PosY"] = value;
            }
        }

        /// <summary>
        /// Gets or sets the width.
        /// </summary>
        /// <value>The width.</value>
        [Category("Layout"), DefaultValue(400), Description("ComboBox Height")]
        public int LayoutHeight
        {
            get
            {
                var o = ViewState["_wHeight"];
                return (o == null ? 400 : (int)o);
            }
            set
            {
                ViewState["_wHeight"] = value;
            }
        }

        /// <summary>
        /// Gets or sets the width.
        /// </summary>
        /// <value>The width.</value>
        [Category("Layout"), DefaultValue(700), Description("ComboBox Width")]
        public int LayoutWidth
        {
            get
            {
                var o = ViewState["_wWidth"];
                return (o == null ? 700 : (int)o);
            }
            set
            {
                ViewState["_wWidth"] = value;
            }
        }



        [Category("Behavior"), DefaultValue(false), Description("Indicates wheher the target control is readonly")]
        public bool TargetControlReadOnly
        {
            get
            {
                EnsureChildControls();
                var o = ViewState["_TargetControlReadOnly"];
                return (o != null && (bool)o);
            }

            set
            {
                EnsureChildControls();
                ViewState["_TargetControlReadOnly"] = value;
            }
        }


        [Category("Behavior"), DefaultValue(true), Description("Automatically postback after the user has selected a value from result.")]
        public bool AutoPostBack
        {
            get
            {
                var o = ViewState["_AutoPostBack"];
                return (o == null || (bool)o);
            }

            set
            {
                ViewState["_AutoPostBack"] = value;
            }
        }

        [Category("Behavior"), DefaultValue("{0}"), Description("Format how the fields are retrieved based on the DataKeyNames fields, sample: {0} {1} {2}. This is only when no SelectedIndexChanged event is handled.")]
        public string TextFormatString
        {
            get
            {
                var o = ViewState["_TextFormatString"];
                return (o == null) ? "{0}" : ((string)o);
            }

            set
            {
                ViewState["_TextFormatString"] = value;
            }
        }

        [Category("Behavior")]
        [DefaultValue(200)]
        [Description("Defines the maximum entries displayed in the table.")]
        public int MaximumEntries
        {
            get
            {
                var o = ViewState["MaximumEntries"];
                return (o == null) ? 200 : (int)o;
            }

            set
            {
                ViewState["MaximumEntries"] = value;
            }
        }


        [Category("Behavior")]
        [DefaultValue(true), Bindable(false), Description("Control to assign value.")]
        public bool ExtenderEnabled
        {
            get
            {
                var o = ViewState["_ExtenderEnabled"];
                return (o == null || (bool)o);
            }

            set
            {
                ViewState["_ExtenderEnabled"] = value;
            }
        }


        [Category("Behavior")]
        [DefaultValue(false), Bindable(false), Description("Indicates whether user can select multible rows from the records result.")]
        public bool MultiSelection
        {
            get
            {
                var o = ViewState["_MultiSelection"];
                return (o != null && (bool)o);
            }
            set
            {
                ViewState["_MultiSelection"] = value;
            }
        }

        #region private properties or not visible for designer


        private string ColumnHeader
        {
            get
            {
                EnsureChildControls();

                var lcolumTitle = new List<string>();

                foreach (var column in Columns)
                {
                    lcolumTitle.Add(column.HeaderText);
                }

                string columTitle = string.Join("°°", lcolumTitle.ToArray());
                return columTitle;
            }

        }

        private List<string> DataKeyNamesFieldValue
        {
            get
            {
                List<string> list = new List<string>();
                list.Add(DataValueField); //Important!  Fisrt column contains key row
                list.Add(string.IsNullOrEmpty(DataTextField) ? DataValueField : DataTextField);
                if (DataKeyNames != null)
                {
                    foreach (var keys in DataKeyNames)
                    {
                        list.Add(keys);
                    }
                }
                return list;
            }
        }

        [Browsable(false)]
        public override bool EnableTheming
        {
            get;
            set;
        }

        [Browsable(false)]
        public override Color BackColor
        {
            get;
            set;
        }
        [Browsable(false)]
        public override Color BorderColor
        {
            get;
            set;
        }
        [Browsable(false)]
        public override BorderStyle BorderStyle
        {
            get;
            set;
        }
        [Browsable(false)]
        public override Unit BorderWidth
        {
            get;
            set;
        }
        [Browsable(false)]
        public override string CssClass
        {
            get;
            set;
        }
        [Browsable(false)]
        public override FontInfo Font
        {
            get
            {
                return base.Font;
            }
        }
        [Browsable(false)]
        public override Color ForeColor
        {
            get;
            set;
        }

        #endregion

        #endregion

        #region Implementation of IScriptControl


        /// <summary>
        /// Gets a collection of <see cref="T:System.Web.UI.ScriptReference"/> objects that define script resources that the control requires.
        /// </summary>
        /// <returns>
        /// An <see cref="T:System.Collections.IEnumerable"/> collection of <see cref="T:System.Web.UI.ScriptReference"/> objects.
        /// </returns>
        public IEnumerable<ScriptReference> GetScriptReferences()
        {

            var refScript1 = new ScriptReference("JmComboBox.MultiComboBox.MultiComboBox.js", GetType().Assembly.FullName);
            return new[] { refScript1 };

        }

        /// <summary>
        /// Gets a collection of script descriptors that represent ECMAScript (JavaScript) client components.
        /// </summary>
        /// <returns>
        /// An <see cref="T:System.Collections.IEnumerable"/> collection of <see cref="T:System.Web.UI.ScriptDescriptor"/> objects.
        /// </returns>
        public IEnumerable<ScriptDescriptor> GetScriptDescriptors()
        {

            Page.ClientScript.GetCallbackEventReference(this, "data", string.Format("{0}_ReceiveData", UniqueID), "context");

            var scDesc = new ScriptControlDescriptor("JmComboBox.MultiComboBoxControl", ClientID);

            if (!DesignMode)
            {

                scDesc.AddProperty("TargetInputName", _textBoxSelectedText.ClientID);
                scDesc.AddProperty("TargetInputHiddenName", _textBoxSelectedIndex.ClientID);
                scDesc.AddProperty("uniqueId", UniqueID);
                scDesc.AddProperty("clientId", ClientID);
                scDesc.AddProperty("wWidth", LayoutWidth);
                scDesc.AddProperty("wHeight", LayoutHeight);
                scDesc.AddProperty("posX", PosX);
                scDesc.AddProperty("posY", PosY);
                scDesc.AddProperty("enabled", (Enabled));
                scDesc.AddProperty("PositionBaseOn", PositionBaseOn);
                scDesc.AddProperty("DialogueCentred", DialogueCentred);
                scDesc.AddProperty("multiSelection", MultiSelection);
                scDesc.AddProperty("columnHeaders", ColumnHeader);
                scDesc.AddProperty("busyImageUrl", Page.ClientScript.GetWebResourceUrl(GetType(), "JmComboBox.Common.activity.gif"));
                scDesc.AddProperty("popupHeaderTableUrl", Page.ClientScript.GetWebResourceUrl(GetType(), "JmComboBox.Common.Popup_header_table.gif"));
                scDesc.AddProperty("maxRecordsToShow", MaximumEntries);
                scDesc.AddProperty("fadeDelay", FadeDelay);
                scDesc.AddProperty("lubtn_glass_img", Page.ClientScript.GetWebResourceUrl(GetType(), "JmComboBox.Common.lubtn_glass_img.gif"));
                scDesc.AddProperty("lubtn_glass_img_hover", Page.ClientScript.GetWebResourceUrl(GetType(), "JmComboBox.Common.lubtn_glass_img_hover.gif"));
                scDesc.AddProperty("tableBindingResultsName", TableBindingResultsName);
                scDesc.AddProperty("minLengthSearch", MinLengthSearch);
                scDesc.AddProperty("searchDelay", SearchDelay);


            }
            return new[] { scDesc };
        }


        #endregion

        /// <summary>
        /// Raises the <see cref="E:System.Web.UI.Control.PreRender"/> event.
        /// </summary>
        /// <param name="e">An <see cref="T:System.EventArgs"/> object that contains the event data.</param>
        protected override void OnPreRender(EventArgs e)
        {

            if (this.RequiresDataBinding)
                this.DataBind();

            if (this._requiresTextBinding)
                TextBinding();


            if (!DesignMode)
            {
                // Test for ScriptManager and register if it exists

                _sm = ScriptManager.GetCurrent(Page);
                if (_sm == null)
                    throw new HttpException("A ScriptManager control must exist on the current page.");

                if (string.IsNullOrEmpty(DataValueField))
                    throw new HttpException("DataValueField is not indicated.");


                _sm.RegisterScriptControl(this);

                if (TargetControlReadOnly)
                {
                    _textBoxSelectedText.ReadOnly = false;
                    _textBoxSelectedText.Attributes.Add("readonly", "readonly");
                }

                if (!Page.Items.Contains("JmComboBox_css"))
                {
                    HtmlGenericControl csslink = new HtmlGenericControl("link");
                    csslink.Attributes.Add("href", Page.ClientScript.GetWebResourceUrl(GetType(), "JmComboBox.Common.JmComboBox.css"));
                    csslink.Attributes.Add("type", "text/css");
                    csslink.Attributes.Add("rel", "stylesheet");
                    Page.Header.Controls.Add(csslink);


                    LiteralControl ltr = new LiteralControl();
                    var cssclass = @"<style type=""text/css"" rel=""stylesheet"">
                            .lubButton_Glass {{
                                color: #000000;
                                line-height: normal;
                                padding: 1px;
                                font-family: Tahoma, Geneva, sans-serif;
                                font-size: 12px;
                                font-style: normal;
                                font-variant: normal;
                                font-weight: normal;
                                vertical-align: middle;
                                border-color: #b2bcbe;
                                border-width: 1px;
                                border-style: solid;
                                cursor: pointer;
                                font-size-adjust: none;
                                font-stretch: normal;
                                background-attachment: scroll;
                                background-repeat: repeat-x;
                                background-position-x: center;
                                background-position-y: top;
                                background-size: auto;
                                background-origin: padding-box;
                                background-clip: border-box;
                                background-color: rgb(218, 223, 224);
                                background-image: url(""{0}"");
                            }}

                                .lubButton_Glass:hover {{
                                    border-color: #71acb4;
                                    border-width: 1px;
                                    border-style: solid;
                                    background-repeat: repeat-x;
                                    background-position-x: center;
                                    background-position-y: top;
                                    background-size: auto;
                                    background-origin: padding-box;
                                    background-clip: border-box;
                                    background-color: rgb(181, 215, 219);
                                    background-image: url(""{1}"");
                                }}

                                .lubButton_Glass div.lubox {{
                                    padding-top: 3px;
                                    padding-right: 13px;
                                    padding-bottom: 4px;
                                    padding-left: 13px;
                                    border-top-width: 0px;
                                    border-right-width: 0px;
                                    border-bottom-width: 0px;
                                    border-left-width: 0px;
                                }}

                    </style>";

                    ltr.Text = string.Format(cssclass,
                        Page.ClientScript.GetWebResourceUrl(GetType(), "JmComboBox.Common.lubtn_glass_img.gif"), Page.ClientScript.GetWebResourceUrl(GetType(), "JmComboBox.Common.lubtn_glass_img_hover.gif"));
                    this.Page.Header.Controls.Add(ltr);
                    

                    Page.Items.Add("JmComboBox_css", "JmComboBox_css");



                }

            }

            base.OnPreRender(e);

        }

        /// <summary>
        /// Renders the control to the specified HTML writer.
        /// </summary>
        /// <param name="writer">The <see cref="T:System.Web.UI.HtmlTextWriter"/> object that receives the control content.</param>




        protected override void Render(HtmlTextWriter writer)
        {


            if (!DesignMode)
                _sm.RegisterScriptDescriptors(this);


            writer.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "0", false);
            writer.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "0", false);
            writer.AddAttribute(HtmlTextWriterAttribute.Width, Width.ToString());
            writer.AddAttribute(HtmlTextWriterAttribute.Height, Height.ToString());
            if (DesignMode)
                writer.AddAttribute(HtmlTextWriterAttribute.Style, "border: 1px solid #7eacb1; padding: 0px; margin: 0px; display: table-cell; height: 10px;");
            else
                writer.AddAttribute(HtmlTextWriterAttribute.Class, Enabled ? "CB_InputBoxCell" : "CB_InputBoxCellDissabled");

            writer.RenderBeginTag(HtmlTextWriterTag.Table);
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);

            EnsureChildControls();
            this.RenderChildren(writer);
            writer.AddAttribute(HtmlTextWriterAttribute.Valign, "button", false);
            writer.AddAttribute(HtmlTextWriterAttribute.Style, "height: 10px;");
            writer.RenderBeginTag(HtmlTextWriterTag.Td);
            writer.WriteBeginTag("img");
            writer.WriteAttribute("Id", ClientID);
            writer.WriteAttribute("alt", ToolTip);
            writer.WriteAttribute("title", ToolTip);
            writer.WriteAttribute("style", "padding: 1px; vertical-align: text-bottom;");
            writer.WriteAttribute("src", getImageUrl());
            writer.Write(HtmlTextWriter.TagRightChar);
            writer.WriteEndTag("img");


            if (!DesignMode)
            {
                writer.RenderBeginTag(HtmlTextWriterTag.Tr);
                writer.AddAttribute(HtmlTextWriterAttribute.Style, "display: none; vertical-align: top;");
                writer.AddAttribute(HtmlTextWriterAttribute.Colspan, "3");
                writer.RenderBeginTag(HtmlTextWriterTag.Td);

                Control table = new LiteralControl(_tableNameBindedResultsInner);
                table.RenderControl(writer);

                writer.RenderEndTag();
                writer.RenderEndTag();
            }


            writer.RenderEndTag();
            writer.RenderEndTag();
            writer.RenderEndTag();

        }



        protected override void CreateChildControls()
        {

            _textBoxSelectedIndex = new TextBox { ID = TargetInputHiddenName, EnableViewState = true };
            _textBoxSelectedText = new TextBox { ID = TargetInputName, Width = Unit.Percentage(100), EnableViewState = true };

            this.Controls.Add(new LiteralControl(string.Format("<td style=\"vertical-align: top; height: 10px; width:100%; \">")));
            _textBoxSelectedText.Attributes.Add("onkeydown", "return (event.keyCode!=13);");
            _textBoxSelectedText.Attributes.Add("style", "border: 0px;");
            this.Controls.Add(_textBoxSelectedText);
            this.Controls.Add(new LiteralControl("</td>"));

            this.Controls.Add(new LiteralControl("<td style=\"display: none;vertical-align: top; height: 10px;\">"));
            if (!DesignMode)
                this.Controls.Add(_textBoxSelectedIndex);
            else
                this.Controls.Add(new LiteralControl("&nbsp;"));

            this.Controls.Add(new LiteralControl("</td>"));


            base.CreateChildControls();
        }

        protected override void OnInit(EventArgs e)
        {

            base.OnInit(e);

        }

        protected override object SaveViewState()
        {

            ViewState["_SelectedText"] = _textBoxSelectedIndex.Text;
            ViewState["_tableNameBindedResultsInner"] = _tableNameBindedResultsInner;
            ViewState["_bindedDataTable"] = _bindedDataTable;

            return base.SaveViewState();

        }
        protected override void LoadViewState(object savedState)
        {
            EnsureChildControls();
            base.LoadViewState(savedState);

            if (ViewState["_SelectedText"] != null)
            {
                _textBoxSelectedIndex.Text = (string)ViewState["_SelectedText"];
            }

            if (ViewState["_tableNameBindedResultsInner"] != null)
            {
                _tableNameBindedResultsInner = (string)ViewState["_tableNameBindedResultsInner"];
            }

            if (ViewState["_bindedDataTable"] != null)
            {
                _bindedDataTable = (DataTable)ViewState["_bindedDataTable"];
            }


        }



        private string getImageUrl()
        {
            string imageUrl;

            var pImageUrl = ImageUrl;
            var pImageUrlOff = ImageUrlOff;


            if (string.IsNullOrEmpty(pImageUrl))
                pImageUrl = Page.ClientScript.GetWebResourceUrl(GetType(), "JmComboBox.Common.dropDownArrow.png");

            if (string.IsNullOrEmpty(pImageUrlOff))
                pImageUrlOff = Page.ClientScript.GetWebResourceUrl(GetType(), "JmComboBox.Common.dropDownArrowDissabled.png");

            if (!DesignMode)
                imageUrl = Enabled ? pImageUrl : pImageUrlOff;
            else
                imageUrl = pImageUrl;

            if (DesignMode)
                imageUrl = imageUrl.Replace("~/", "");

            return imageUrl;

        }



        #region Implementation of ICallbackEventHandler

        /// <summary>
        /// Processes a callback event that targets a control.
        /// </summary>
        /// <param name="eventArgument">A string that represents an event argument to pass to the event handler.</param>
        public void RaiseCallbackEvent(string eventArgument)
        {

            /*ObjObjectDataSource.SelectParameters.Clear();
            var jarray = JsonConvert.DeserializeObject<List<SelectParameter>>(eventArgument);
            foreach (var selectParameter in jarray)
            {ObjObjectDataSource.SelectParameters.Add(selectParameter.ParamName, selectParameter.Value); }     */

        }

        /// <summary>
        /// Returns the results of a callback event that targets a control.
        /// </summary>
        /// <returns>The result of the callback.</returns>
        public string GetCallbackResult()
        {
            return RenderGridList();
        }

        #region RenderGridList

        protected virtual string RenderGridList()
        {

            var sb = new StringBuilder(1024);
            DataSourceView dsv = GetData();

            var table = new Table();
            table.Attributes.Add("id", TableBindingResultsName);
            table.CellSpacing = 0;
            table.CellPadding = 0;
            table.Style.Add("table-layout", "fixed");
            table.Style.Add("width", "100%");



            AddTableHeader(table);

            _bindedDataTable = new DataTable();
            foreach (string column in DataKeyNamesFieldValue)
            {
                if (!_bindedDataTable.Columns.Contains(column))
                    _bindedDataTable.Columns.Add(column, typeof(string));
            }

            try
            {
                dsv.Select(new DataSourceSelectArguments(), delegate(IEnumerable data)
                {
                    if (data == null)
                    {
                        var infoRow = CreateInfoRow("No records avaible");
                        infoRow.Style.Add("background-color", "#FFCECE");
                        table.Rows.Add(infoRow);
                        using (var sw = new StringWriter(sb))
                        {
                            using (var writer = new HtmlTextWriter(sw))
                            {
                                table.RenderControl(writer);
                            }
                        }
                    }
                    else
                    {
                        var rowId = 0;
                        foreach (object dataRow in data)
                        {

                            var row = new TableRow();
                            var newRow = _bindedDataTable.NewRow();

                            var avacols = new List<AvailableFields>();
                            foreach (var item in DataKeyNamesFieldValue)
                            {
                                var valueInKey = DataBinder.Eval(dataRow, item);
                                avacols.Add(new AvailableFields { FieldName = item, Value = valueInKey.ToString() });
                                newRow[item] = valueInKey.ToString();
                            }
                            _bindedDataTable.Rows.Add(newRow);


                            var textValue = GetSelectText(newRow);
                            var keyValue = (DataBinder.Eval(dataRow, DataValueField)).ToString();
                            row.Attributes.Add("KeyValue", keyValue);
                            row.Attributes.Add("TextValue", textValue);


                            if (keyValue == SelectedValue)
                                _textBoxSelectedText.Text = textValue;


                            string valueInKeys = JsonConvert.SerializeObject(avacols);

                            row.Attributes.Add("valueInKeys", valueInKeys);


                            if (MultiSelection)
                            {
                                var tc = new TableCell();
                                tc.CssClass = "CB_CellLeft";
                                var ctrl = new CheckBox { ID = String.Format("RId{0}_{1}", rowId, ClientID) };
                                ctrl.InputAttributes.Add("value", valueInKeys);
                                ctrl.InputAttributes.Add("ismultiCb", "true");
                                tc.Controls.Add(ctrl);
                                row.Cells.Add(tc);
                            }

                            BindRow(dataRow, ref row);

                            if (!MultiSelection)
                                row.Attributes.Add("onclick", Page.ClientScript.GetPostBackEventReference(this, string.Format("{0}", valueInKeys)));

                            table.Rows.Add(row);

                            rowId++;

                            if (rowId == MaximumEntries)
                                break;

                        }

                        //var newList = (from e in data.Cast<object>() select e).ToList();
                        //_resultTotalRecords = newList.Count();
                        using (var sw = new StringWriter(sb))
                        {
                            using (var writer = new HtmlTextWriter(sw))
                            {
                                table.RenderControl(writer);
                            }
                        }

                    }

                });
            }
            catch (Exception ex)
            {
                var infoRow = CreateInfoRow(ex.Message);
                infoRow.Style.Add("background-color", "#FFCECE");
                table.Rows.Add(infoRow);

                using (var sw = new StringWriter(sb))
                {
                    using (var writer = new HtmlTextWriter(sw))
                    {
                        table.RenderControl(writer);
                    }
                }

            }
            var result = sb.ToString();
            return result;
        }

        private void AddTableHeader(Table table)
        {
            TableHeaderRow hRow = new TableHeaderRow();
            hRow.Attributes["rowType"] = "header";

            if (MultiSelection)
                hRow.Cells.Add(CreateHeaderCell(Unit.Pixel(20)));

            foreach (var template in this._cellTemplates)
            {
                hRow.Cells.Add(CreateHeaderCell(template.Width));
            }

            table.Rows.AddAt(0, hRow);
        }

        private TableHeaderCell CreateHeaderCell(Unit widthValue)
        {
            TableHeaderCell th = new TableHeaderCell();
            th.Width = widthValue == 0 ? 100 : widthValue;
            th.Style.Add("overflow", "hidden");
            th.CssClass = "CB_HCellLeft";
            return th;
        }

        private void BindRow(object data, ref TableRow row)
        {

            row.Attributes["rowType"] = "data";
            if (_cellTemplates != null && _cellTemplates.Count != 0)
            {
                int columnIndex = -1;
                foreach (var template in this._cellTemplates)
                {
                    columnIndex++;
                    template.DataBind();
                    var item = new TableCellItem(data, 0);
                    template.FieldTemplate.InstantiateIn(item);
                    item.DataBind();
                    item.CssClass = template.CssClass;
                    //item.Width = template.Width == 0 ? 100 : template.Width;
                    //item.Style.Add("overflow", "hidden");
                    row.Cells.Add(item);
                }
            }

        }

        private TableRow CreateInfoRow(string msg)
        {
            var row = new TableRow();
            var cell = new TableCell();

            row.Attributes["rowType"] = "info"; // info row 


            if (_cellTemplates == null)
            {
                _cellTemplates = new List<ColumnField>();
                var msgrow = new ColumnField();
                _cellTemplates.Add(msgrow);

            }

            cell.ColumnSpan = this._cellTemplates.Count + (MultiSelection ? 1 : 0);
            row.Cells.Add(cell);


            cell.Text = msg;
            cell.HorizontalAlign = HorizontalAlign.Left;

            return row;
        }



        private void TextBinding()
        {

            if (this._requiresTextBinding)
            {
                DataView view = _bindedDataTable.DefaultView;
                view.RowFilter = string.Format(" {0} = '{1}'", _bindedDataTable.Columns[0].ColumnName, _textBoxSelectedIndex.Text);
                if (view.Count > 0)
                {
                    _textBoxSelectedText.Text = GetSelectText(view[0].Row);
                }
                this._requiresTextBinding = false;
            }

        }

        private string GetSelectText(DataRow dr)
        {
            string txt = string.Empty;
            try
            {
                string[] resultArray = dr.ItemArray.Select(dc => dc.ToString()).ToArray();
                txt = string.Format(TextFormatString, resultArray);
            }
            catch
            {
            }
            return txt;
        }


        #endregion

        #endregion

        #region Implementation of IPostBackEventHandler

        /// <summary>
        /// Enables a server control to process an event raised when a form is posted to the server.
        /// </summary>
        /// <param name="eventArgument">A <see cref="T:System.String"/> that represents an optional event argument to be passed to the event handler.</param>
        public void RaisePostBackEvent(string eventArgument)
        {
            var dataRow = new RowData(eventArgument, MultiSelection, DataKeyNamesFieldValue);

            try
            {
                if (dataRow.DataTable.Rows.Count > 0)
                {
                    if (!MultiSelection)
                    {
                        DataRow dr = dataRow.DataTable.Rows[0];
                        _textBoxSelectedText.Text = GetSelectText(dataRow.DataTable.Rows[0]);
                        SelectedValue = dr[DataValueField].ToString();
                    }
                    else
                    {
                        List<string> keys = new List<string>();
                        List<string> text = new List<string>();

                        foreach (DataRow dr in dataRow.DataTable.Rows)
                        {
                            keys.Add(dr[DataValueField].ToString());
                            text.Add(dr[DataTextField].ToString());
                        }

                        _textBoxSelectedText.Text = string.Join(";", text.ToArray());
                        SelectedValue = string.Join(";", keys.ToArray());

                    }
                }
            }
            catch { }

            if (SelectedIndexChanged != null)
            {
                // var dataResult = new RowEventArgs(DataRow);
                SelectedIndexChanged(this, dataRow);
            }

        }


        #endregion

        # region complement class and interfaces

        private class AvailableFields
        {
            public string FieldName { get; set; }
            public string Value { get; set; }
        }

        /// <summary>
        /// Row data returned
        /// </summary>
        public class RowData : EventArgs
        {
            public readonly DataTable DataTable = new DataTable();

            public RowData(string eventArgument, bool multiselection, List<string> DataKeyNamesFieldValue)
            {
                foreach (string column in DataKeyNamesFieldValue)
                {
                    if (!DataTable.Columns.Contains(column))
                        DataTable.Columns.Add(column, typeof(string));
                }
                if (string.IsNullOrEmpty(eventArgument))
                    return;
                string[] rows = Regex.Split(eventArgument, @"\s*°°\s*");
                foreach (var row in rows)
                {
                    var cols = JsonConvert.DeserializeObject<List<AvailableFields>>(row);
                    DataRow newRow = DataTable.NewRow();
                    foreach (AvailableFields col in cols)
                    {
                        newRow[col.FieldName] = col.Value;
                    }
                    DataTable.Rows.Add(newRow);
                }
            }
        }

        #endregion

    }

}
