using System.Web.UI.WebControls;
using System.Web.UI;
using System.ComponentModel;

namespace JmComboBox
{
    /// <summary>
    /// Table Cell template control
    /// </summary>
    [NonVisualControl]
    [ToolboxItem(false)]
    public class ColumnField : WebControl
    {

        private ITemplate itemTemplate;

        [Browsable(false)]
        [PersistenceMode(PersistenceMode.InnerProperty)]
        [TemplateContainer(typeof(IDataItemContainer), BindingDirection.TwoWay)]
        [DefaultValue(null)]
        public virtual ITemplate FieldTemplate
        {
            get
            {
                return this.itemTemplate;
            }
            set
            {
                this.itemTemplate = value;
            }
        }

        [DefaultValue((string)null)]
        [PersistenceMode(PersistenceMode.InnerProperty)]
        public string HeaderText { get; set; }


        internal void SetDirty()
        {
            TrackViewState();
        }

    }
}
