﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace DataServices
{

    public class DepartmentService
    {

        public List<Department> Get_OuSearch1(string search1, string search2, string search3, bool OnlyActive)
        {
            List<Department> list = GenData();
            return list.Select(s => new Department
            {
                OuCode = s.OuCode,
                OuDescription = s.OuDescription,
                LM = s.LM,
                LMName = s.LMName,
                LastChange = s.LastChange,
                Active = s.Active
            }).OrderBy(o => o.OuCode).ToList<Department>();
        }

        public int CountGet_OuSearch1(string search1, string search2, string search3, bool OnlyActive)
        {
            var list = Get_OuSearch1(search1, search2, search3, OnlyActive);
            return list.Count();

        }


        public List<Department> Get_OuSearch2(string search1, string search2, string search3, string Select1, string MType)
        {
            List<Department> list = GenData();
            return list.Select(s => new Department
            {
                OuCode = s.OuCode,
                OuDescription = s.OuDescription,
                LM = s.LM,
                LMName = s.LMName,
                LastChange = s.LastChange,
                Active = s.Active
            }).OrderBy(o => o.OuCode).ToList<Department>();
        }

        public int CountGet_OuSearch2(string search1, string search2, string search3, string Select1, string MType)
        {
            var list = Get_OuSearch2(search1, search2, search3, Select1, MType);
            return list.Count();

        }





        public List<Department> GetAll(string search1, string search2, string Select1, string MType)
        {
            List<Department> list = GenData();
            return list.Select(s => new Department { OuCode = s.OuCode, OuDescription = s.OuDescription, LM = s.LM, LMName = s.LMName }).OrderBy(o => o.OuCode).ToList<Department>();
        }

        public int GetCount(string search1, string search2, string Select1, string MType)
        {
            var list = GetAll(search1, search2, Select1, MType);
            return list.Count();
        }


        public List<Department> GetAll2(string search1, string search2, bool OnlyActive)
        {
            List<Department> list = GenData();
            return list.Select(s => new Department { OuCode = s.OuCode, OuDescription = s.OuDescription, LM = s.LM, LMName = s.LMName, LastChange = s.LastChange }).OrderBy(o => o.OuCode).ToList<Department>();
        }

        public int GetCount2(string search1, string search2, bool OnlyActive)
        {
            var list = GetAll2(search1, search2, OnlyActive);
            return list.Count();

        }








        private List<Department> GenData()
        {
            List<Department> list = new List<Department>();

            list.Add(new Department { OuCode = "A001", OuDescription = "Human Resourses", LM = "00000001", LMName = "LM name 1", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A002", OuDescription = "Accounting", LM = "00000001", LMName = "LM name 1", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A003", OuDescription = "Information Technology", LM = "00000001", LMName = "LM name 1", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A004", OuDescription = "Department Description 4", LM = "00000001", LMName = "LM name 1", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A005", OuDescription = "Department Description 5", LM = "00000002", LMName = "LM name 2", Active = false, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A006", OuDescription = "Department Description 6", LM = "00000002", LMName = "LM name 2", Active = false, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A007", OuDescription = "Department Description 7", LM = "00000002", LMName = "LM name 2", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A008", OuDescription = "Department Description 8", LM = "00000002", LMName = "LM name 2", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A009", OuDescription = "Department Description 9", LM = "00000001", LMName = "LM name 1", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A010", OuDescription = "Department Description 10", LM = "00000002", LMName = "LM name 2", Active = false, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A011", OuDescription = "Department Description 11", LM = "00000002", LMName = "LM name 2", Active = false, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A012", OuDescription = "Department Description 12", LM = "00000002", LMName = "LM name 2", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A013", OuDescription = "Department Description 13", LM = "00000002", LMName = "LM name 2", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A014", OuDescription = "Department Description 14", LM = "00000001", LMName = "LM name 1", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A015", OuDescription = "Department Description 15", LM = "00000002", LMName = "LM name 2", Active = false, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A016", OuDescription = "Department Description 16", LM = "00000002", LMName = "LM name 2", Active = false, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A017", OuDescription = "Department Description 17", LM = "00000002", LMName = "LM name 2", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A018", OuDescription = "Department Description 18", LM = "00000002", LMName = "LM name 2", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A019", OuDescription = "Department Description 19", LM = "00000001", LMName = "LM name 1", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A020", OuDescription = "Department Description 20", LM = "00000002", LMName = "LM name 2", Active = false, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A021", OuDescription = "Department Description 21", LM = "00000002", LMName = "LM name 2", Active = false, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A022", OuDescription = "Department Description 22", LM = "00000002", LMName = "LM name 2", Active = true, LastChange = DateTime.Today.Date });
            list.Add(new Department { OuCode = "A023", OuDescription = "Department Description 23", LM = "00000002", LMName = "LM name 2", Active = true, LastChange = DateTime.Today.Date });

            return list;
        }



        public class Department
        {

            public string OuCode { get; set; }
            public string OuDescription { get; set; }
            public string LM { get; set; }
            public string LMName { get; set; }
            public bool Active { get; set; }
            public DateTime LastChange { get; set; }


        }
    }
}