﻿using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;

namespace DataServices
{
    public class ContactService
    {

        [DataObjectMethod(DataObjectMethodType.Select)]
        public List<Contact> GetAll()
        {
            List<Contact> list = new List<Contact>();

            list.Add(new Contact { Id = "1", ContactName = "Alejandra Camino", CompanyName = "Romero y tomillo", Country = "Spain", Phone = "(91) 745 6200", Ou = "A001" });
            list.Add(new Contact { Id = "2", ContactName = "Alexander Feuer", CompanyName = "Morgenstern Gesundkost", Country = "Germany", Phone = "0342-023176", Ou = "A001" });
            list.Add(new Contact { Id = "3", ContactName = "Ana Trujillo", CompanyName = "Ana Trujillo Emparedados y helados", Country = "Mexico", Phone = "(5) 555-4729", Ou = "A001" });
            list.Add(new Contact { Id = "4", ContactName = "Anabela Domingues", CompanyName = "Tradição Hipermercados", Country = "Brazil", Phone = "(11) 555-2167", Ou = "A002" });
            list.Add(new Contact { Id = "5", ContactName = "André Fonseca", CompanyName = "Gourmet Lanchonetes", Country = "Brazil", Phone = "(11) 555-9482", Ou = "A002" });
            list.Add(new Contact { Id = "6", ContactName = "Ann Devon", CompanyName = "Eastern Connection", Country = "UK", Phone = "(171) 555-0297", Ou = "A002" });
            list.Add(new Contact { Id = "7", ContactName = "Annette Roulet", CompanyName = "La maison d'Asie", Country = "France", Phone = "61.77.61.10", Ou = "A002" });
            list.Add(new Contact { Id = "8", ContactName = "Antonio Moreno", CompanyName = "Antonio Moreno Taquería", Country = "Mexico", Phone = "(5) 555-3932", Ou = "A002" });
            list.Add(new Contact { Id = "9", ContactName = "Aria Cruz", CompanyName = "Familia Arquibaldo", Country = "Brazil", Phone = "(11) 555-9857", Ou = "A003" });
            list.Add(new Contact { Id = "10", ContactName = "Art Braunschweiger", CompanyName = "Split Rail Beer & Ale", Country = "USA", Phone = "(307) 555-4680", Ou = "A003" });
            list.Add(new Contact { Id = "11", ContactName = "Bernardo Batista", CompanyName = "Que Delícia", Country = "Brazil", Phone = "(21) 555-4252", Ou = "A003" });
            list.Add(new Contact { Id = "12", ContactName = "Carine Schmitt", CompanyName = "France restauration", Country = "France", Phone = "40.32.21.21", Ou = "A003" });
            list.Add(new Contact { Id = "13", ContactName = "Carlos González", CompanyName = "LILA-Supermercado", Country = "Venezuela", Phone = "(9) 331-6954", Ou = "A003" });
            list.Add(new Contact { Id = "14", ContactName = "Carlos Hernández", CompanyName = "HILARIÓN-Abastos", Country = "Venezuela", Phone = "(5) 555-1340", Ou = "A003" });
            list.Add(new Contact { Id = "15", ContactName = "Catherine Dewey", CompanyName = "Maison Dewey", Country = "Belgium", Phone = "(02) 201 24 67", Ou = "A003" });
            list.Add(new Contact { Id = "16", ContactName = "Christina Berglund", CompanyName = "Berglunds snabbköp", Country = "Sweden", Phone = "0921-12 34 65", Ou = "A003" });
            list.Add(new Contact { Id = "17", ContactName = "Daniel Tonini", CompanyName = "La corne d'abondance", Country = "France", Phone = "30.59.84.10", Ou = "A003" });
            list.Add(new Contact { Id = "18", ContactName = "Diego Roel", CompanyName = "FISSA Fabrica Inter. Salchichas S.A.", Country = "Spain", Phone = "(91) 555 94 44", Ou = "A003" });
            list.Add(new Contact { Id = "19", ContactName = "Dominique Perrier", CompanyName = "Spécialités du monde", Country = "France", Phone = "(1) 47.55.60.10", Ou = "A003" });
            list.Add(new Contact { Id = "20", ContactName = "Eduardo Saavedra", CompanyName = "Galería del gastrónomo", Country = "Spain", Phone = "(93) 203 4560", Ou = "A003" });
            list.Add(new Contact { Id = "21", ContactName = "Elizabeth Brown", CompanyName = "Consolidated Holdings", Country = "UK", Phone = "(171) 555-2282", Ou = "A003" });
            list.Add(new Contact { Id = "22", ContactName = "Elizabeth Lincoln", CompanyName = "Bottom-Dollar Markets", Country = "Canada", Phone = "(604) 555-4729", Ou = "A003" });
            list.Add(new Contact { Id = "23", ContactName = "Felipe Izquierdo", CompanyName = "LINO-Delicateses", Country = "Venezuela", Phone = "(8) 34-56-12", Ou = "A003" });
            list.Add(new Contact { Id = "24", ContactName = "Fran Wilson", CompanyName = "Lonesome Pine Restaurant", Country = "USA", Phone = "(503) 555-9573", Ou = "A004" });
            list.Add(new Contact { Id = "25", ContactName = "Francisco Chang", CompanyName = "Centro comercial Moctezuma", Country = "Mexico", Phone = "(5) 555-3392", Ou = "A004" });
            list.Add(new Contact { Id = "26", ContactName = "Frédérique Citeaux", CompanyName = "Blondel père et fils", Country = "France", Phone = "88.60.15.31", Ou = "A004" });
            list.Add(new Contact { Id = "27", ContactName = "Georg Pipps", CompanyName = "Piccolo und mehr", Country = "Austria", Phone = "6562-9722", Ou = "A004" });
            list.Add(new Contact { Id = "28", ContactName = "Giovanni Rovelli", CompanyName = "Magazzini Alimentari Riuniti", Country = "Italy", Phone = "035-640230", Ou = "A004" });
            list.Add(new Contact { Id = "29", ContactName = "Guillermo Fernández", CompanyName = "Pericles Comidas clásicas", Country = "Mexico", Phone = "(5) 552-3745", Ou = "A004" });
            list.Add(new Contact { Id = "30", ContactName = "Hanna Moos", CompanyName = "Blauer See Delikatessen", Country = "Germany", Phone = "0621-08460", Ou = "A004" });
            list.Add(new Contact { Id = "31", ContactName = "Hari Kumar", CompanyName = "Seven Seas Imports", Country = "UK", Phone = "(171) 555-1717", Ou = "A004" });
            list.Add(new Contact { Id = "32", ContactName = "Helen Bennett", CompanyName = "Island Trading", Country = "UK", Phone = "(198) 555-8888", Ou = "A004" });
            list.Add(new Contact { Id = "33", ContactName = "Helvetius Nagy", CompanyName = "Trail's Head Gourmet Provisioners", Country = "USA", Phone = "(206) 555-8257", Ou = "A004" });
            list.Add(new Contact { Id = "34", ContactName = "Henriette Pfalzheim", CompanyName = "Ottilies Käseladen", Country = "Germany", Phone = "0221-0644327", Ou = "A004" });
            list.Add(new Contact { Id = "35", ContactName = "Horst Kloss", CompanyName = "QUICK-Stop", Country = "Germany", Phone = "0372-035188", Ou = "A004" });
            list.Add(new Contact { Id = "36", ContactName = "Howard Snyder", CompanyName = "Great Lakes Food Market", Country = "USA", Phone = "(503) 555-7555", Ou = "A004" });
            list.Add(new Contact { Id = "37", ContactName = "Isabel de Castro", CompanyName = "Princesa Isabel Vinhos", Country = "Portugal", Phone = "(1) 356-5634", Ou = "A005" });
            list.Add(new Contact { Id = "38", ContactName = "Jaime Yorres", CompanyName = "Let's Stop N Shop", Country = "USA", Phone = "(415) 555-5938", Ou = "A005" });
            list.Add(new Contact { Id = "39", ContactName = "Janete Limeira", CompanyName = "Ricardo Adocicados", Country = "Brazil", Phone = "(21) 555-3412", Ou = "A005" });
            list.Add(new Contact { Id = "40", ContactName = "Janine Labrune", CompanyName = "Du monde entier", Country = "France", Phone = "40.67.88.88", Ou = "A005" });
            list.Add(new Contact { Id = "41", ContactName = "Jean Fresnière", CompanyName = "Mère Paillarde", Country = "Canada", Phone = "(514) 555-8054", Ou = "A005" });
            list.Add(new Contact { Id = "42", ContactName = "John Steel", CompanyName = "Lazy K Kountry Store", Country = "USA", Phone = "(509) 555-7969", Ou = "A005" });
            list.Add(new Contact { Id = "43", ContactName = "Jonas Bergulfsen", CompanyName = "Santé Gourmet", Country = "Norway", Phone = "07-98 92 35", Ou = "A005" });
            list.Add(new Contact { Id = "44", ContactName = "Jose Pavarotti", CompanyName = "Save-a-lot Markets", Country = "USA", Phone = "(208) 555-8097", Ou = "A005" });
            list.Add(new Contact { Id = "45", ContactName = "José Pedro Freyre", CompanyName = "Godos Cocina Típica", Country = "Spain", Phone = "(95) 555 82 82", Ou = "A005" });
            list.Add(new Contact { Id = "46", ContactName = "Jytte Petersen", CompanyName = "Simons bistro", Country = "Denmark", Phone = "31 12 34 56", Ou = "A005" });
            list.Add(new Contact { Id = "47", ContactName = "Karin Josephs", CompanyName = "Toms Spezialitäten", Country = "Germany", Phone = "0251-031259", Ou = "A005" });
            list.Add(new Contact { Id = "48", ContactName = "Karl Jablonski", CompanyName = "White Clover Markets", Country = "USA", Phone = "(206) 555-4112", Ou = "A005" });
            list.Add(new Contact { Id = "49", ContactName = "Laurence Lebihan", CompanyName = "Bon app'", Country = "France", Phone = "91.24.45.40", Ou = "A005" });
            list.Add(new Contact { Id = "50", ContactName = "Lino Rodriguez ", CompanyName = "Furia Bacalhau e Frutos do Mar", Country = "Portugal", Phone = "(1) 354-2534", Ou = "A005" });
            list.Add(new Contact { Id = "51", ContactName = "Liu Wong", CompanyName = "The Cracker Box", Country = "USA", Phone = "(406) 555-5834", Ou = "A005" });
            list.Add(new Contact { Id = "52", ContactName = "Liz Nixon", CompanyName = "The Big Cheese", Country = "USA", Phone = "(503) 555-3612", Ou = "A005" });
            list.Add(new Contact { Id = "53", ContactName = "Lúcia Carvalho", CompanyName = "Queen Cozinha", Country = "Brazil", Phone = "(11) 555-1189" });
            list.Add(new Contact { Id = "54", ContactName = "Manuel Pereira", CompanyName = "GROSELLA-Restaurante", Country = "Venezuela", Phone = "(2) 283-2951", Ou = "A005" });
            list.Add(new Contact { Id = "55", ContactName = "Maria Anders", CompanyName = "Alfreds Futterkiste", Country = "Germany", Phone = "030-0074321" });
            list.Add(new Contact { Id = "56", ContactName = "Maria Larsson", CompanyName = "Folk och fä HB", Country = "Sweden", Phone = "0695-34 67 21" });
            list.Add(new Contact { Id = "57", ContactName = "Marie Bertrand", CompanyName = "Paris spécialités", Country = "France", Phone = "(1) 42.34.22.66" });
            list.Add(new Contact { Id = "58", ContactName = "Mario Pontes", CompanyName = "Hanari Carnes", Country = "Brazil", Phone = "(21) 555-0091" });
            list.Add(new Contact { Id = "59", ContactName = "Martín Sommer", CompanyName = "Bólido Comidas preparadas", Country = "Spain", Phone = "(91) 555 22 82" });
            list.Add(new Contact { Id = "60", ContactName = "Martine Rancé", CompanyName = "Folies gourmandes", Country = "France", Phone = "20.16.10.16" });
            list.Add(new Contact { Id = "61", ContactName = "Mary Saveley", CompanyName = "Victuailles en stock", Country = "France", Phone = "78.32.54.86" });
            list.Add(new Contact { Id = "62", ContactName = "Matti Karttunen", CompanyName = "Wilman Kala", Country = "Finland", Phone = "90-224 8858" });
            list.Add(new Contact { Id = "63", ContactName = "Maurizio Moroni", CompanyName = "Reggiani Caseifici", Country = "Italy", Phone = "0522-556721" });
            list.Add(new Contact { Id = "64", ContactName = "Michael Holz", CompanyName = "Richter Supermarkt", Country = "Switzerland", Phone = "0897-034214" });
            list.Add(new Contact { Id = "65", ContactName = "Miguel Angel Paolino", CompanyName = "Tortuga Restaurante", Country = "Mexico", Phone = "(5) 555-2933" });
            list.Add(new Contact { Id = "66", ContactName = "Palle Ibsen", CompanyName = "Vaffeljernet", Country = "Denmark", Phone = "86 21 32 43" });
            list.Add(new Contact { Id = "67", ContactName = "Paolo Accorti", CompanyName = "Franchi S.p.A.", Country = "Italy", Phone = "011-4988260" });
            list.Add(new Contact { Id = "68", ContactName = "Pascale Cartrain", CompanyName = "Suprêmes délices", Country = "Belgium", Phone = "(071) 23 67 22 20" });
            list.Add(new Contact { Id = "69", ContactName = "Patricia McKenna", CompanyName = "Hungry Owl All-Night Grocers", Country = "Ireland", Phone = "2967 542" });
            list.Add(new Contact { Id = "70", ContactName = "Patricio Simpson", CompanyName = "Cactus Comidas para llevar", Country = "Argentina", Phone = "(1) 135-5555" });
            list.Add(new Contact { Id = "71", ContactName = "Paul Henriot", CompanyName = "Vins et alcools Chevalier", Country = "France", Phone = "26.47.15.10" });
            list.Add(new Contact { Id = "72", ContactName = "Paula Parente", CompanyName = "Wellington Importadora", Country = "Brazil", Phone = "(14) 555-8122" });
            list.Add(new Contact { Id = "73", ContactName = "Paula Wilson", CompanyName = "Rattlesnake Canyon Grocery", Country = "USA", Phone = "(505) 555-5939" });
            list.Add(new Contact { Id = "74", ContactName = "Pedro Afonso", CompanyName = "Comércio Mineiro", Country = "Brazil", Phone = "(11) 555-7647" });
            list.Add(new Contact { Id = "75", ContactName = "Peter Franken", CompanyName = "Frankenversand", Country = "Germany", Phone = "089-0877310" });
            list.Add(new Contact { Id = "76", ContactName = "Philip Cramer", CompanyName = "Königlich Essen", Country = "Germany", Phone = "0555-09876" });
            list.Add(new Contact { Id = "77", ContactName = "Pirkko Koskitalo", CompanyName = "Wartian Herkku", Country = "Finland", Phone = "981-443655" });
            list.Add(new Contact { Id = "78", ContactName = "Renate Messner", CompanyName = "Lehmanns Marktstand", Country = "Germany", Phone = "069-0245984" });
            list.Add(new Contact { Id = "79", ContactName = "Rene Phillips", CompanyName = "Old World Delicatessen", Country = "USA", Phone = "(907) 555-7584" });
            list.Add(new Contact { Id = "80", ContactName = "Rita Müller", CompanyName = "Die Wandernde Kuh", Country = "Germany", Phone = "0711-020361" });
            list.Add(new Contact { Id = "81", ContactName = "Roland Mendel", CompanyName = "Ernst Handel", Country = "Austria", Phone = "7675-3425" });
            list.Add(new Contact { Id = "82", ContactName = "Sergio Gutiérrez", CompanyName = "Rancho grande", Country = "Argentina", Phone = "(1) 123-5555" });
            list.Add(new Contact { Id = "83", ContactName = "Simon Crowther", CompanyName = "North/South", Country = "UK", Phone = "(171) 555-7733" });
            list.Add(new Contact { Id = "84", ContactName = "Sven Ottlieb", CompanyName = "Drachenblut Delikatessen", Country = "Germany", Phone = "0241-039123" });
            list.Add(new Contact { Id = "85", ContactName = "Thomas Hardy", CompanyName = "Around the Horn", Country = "UK", Phone = "(171) 555-7788" });
            list.Add(new Contact { Id = "86", ContactName = "Victoria Ashworth", CompanyName = "B's Beverages", Country = "UK", Phone = "(171) 555-1212" });
            list.Add(new Contact { Id = "87", ContactName = "Yang Wang", CompanyName = "Chop-suey Chinese", Country = "Switzerland", Phone = "0452-076545" });
            list.Add(new Contact { Id = "88", ContactName = "Yoshi Latimer", CompanyName = "Hungry Coyote Import Store", Country = "USA", Phone = "(503) 555-6874" });
            list.Add(new Contact { Id = "89", ContactName = "Yoshi Tannamuri", CompanyName = "Laughing Bacchus Wine Cellars", Country = "Canada", Phone = "(604) 555-3392" });
            list.Add(new Contact { Id = "90", ContactName = "Yvonne Moncada", CompanyName = "Océano Atlántico Ltda.", Country = "Argentina", Phone = "(1) 135-5333" });
            list.Add(new Contact { Id = "91", ContactName = "Zbyszek Piestrzeniewicz", CompanyName = "Wolski  Zajazd", Country = "Poland", Phone = "(26) 642-7012" });

            return list;
        }

        public int GetCountAll()
        {
            return GetAll().Count;
        }

        public void Update(Contact contact)
        {

        }


        [DataObjectMethod(DataObjectMethodType.Select)]
        public List<Contact> Get_OuSearch2(string search1, string search2, string search3)
        {

            List<Contact> list = GetAll();
            return list.Select(s => new Contact
            {
                Id = s.Id,
                ContactName = s.ContactName,
                CompanyName = s.CompanyName,
                Country = s.Country,
                Phone = s.Phone,
                Ou = s.Ou
            }).Where(r => ((search1 == null || r.ContactName.StartsWith(search1)) && (search2 == null || r.CompanyName.StartsWith(search2)))).OrderBy(o => o.ContactName).ToList<Contact>();
        }



    }

    public class Contact
    {
        public string Id { get; set; }
        public string ContactName { get; set; }
        public string CompanyName { get; set; }
        public string Country { get; set; }
        public string Phone { get; set; }
        public string Ou { get; set; }

        public string Key_ContactName
        {
            get { return Id + ":" + ContactName; }
            
        }
    }
}