﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;

namespace AuthorizationControlTest.ControlAdapter
{
   
    public class ControlAuthorizationAdapter : System.Web.UI.WebControls.Adapters.WebControlAdapter
    {
        private void ManageWebControls(WebControl webControls)
        {
            string permissionFlags = webControls.Attributes["Permissions"];
            if (string.IsNullOrEmpty(permissionFlags)) return;

            bool result = AuthorizationUtility.IsAuthorized<Permissions>(permissionFlags);
            Type type = webControls.GetType();

            string property = webControls.Attributes["Property"];
            if (type.Equals(typeof(Button)) || type.Equals(typeof(TextBox)) || type.Equals(typeof(HyperLink)))
            {
                if (string.IsNullOrEmpty(property) || property.Equals("Enabled"))
                    webControls.Enabled = result;
                else if (property.Equals("Visible"))
                    webControls.Visible = result;
            }

        }

        [Obsolete("This is not supported, but I am researching on Adapter method for UserControls.")]
        private void ManageUserControl(System.Web.UI.Control tb)
        {
            System.Web.UI.UserControl uc = tb as System.Web.UI.UserControl;
            string permissionFlags = uc.Attributes["Permissions"];
            if (string.IsNullOrEmpty(permissionFlags)) return;

            bool result = AuthorizationUtility.IsAuthorized<Permissions>(permissionFlags);
            Type type = uc.GetType();

            //string property = uc.Attributes["Property"];
            if (type.Equals(typeof(InsuranceHomePage)))
            {
                uc.Visible = result;
            }

        }
        
        protected override void OnLoad(EventArgs e)
        {
            if (this.Page is ISecurable)
            {
                if (this.Control is WebControl)
                    this.ManageWebControls(this.Control as WebControl);
                else if (this.Control is System.Web.UI.UserControl) //This will not work as current framework is not allowing for UserControl
                    this.ManageUserControl(this.Control);
                
            }
            base.OnLoad(e);
        }
    }
}
