﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AuthorizationControlTest
{
    [Flags]
    public enum Roles
    {
        Guest = 0,
        BeginerPack = 1,
        JumboPack = 2,
        MegaPack = 4,
    }
   
    [Flags]
    public enum Permissions
    {
        Auto = 1,
        Property = 2, //3       Auto, Property
        Health = 4,   //5,6,7   Auto, Health; Property, Health; Auto, Property, Health
        Medical = 8
    }
    public static class AuthorizationUtility
    {

        static AuthorizationRole[] authRoles;
            
        static AuthorizationUtility()
            {
                 List<AuthorizationPermission> permissions = new List<AuthorizationPermission>();
                    permissions.Add(new AuthorizationPermission{ Name = Permissions.Auto.ToString(),
                                                                Type = "Permissions", Value = "true"});
                    permissions.Add(new AuthorizationPermission{ Name = Permissions.Property.ToString(),
                                                Type = "Permissions", Value = "false"});

                    permissions.Add(new AuthorizationPermission
                    {
                        Name = Permissions.Health.ToString(),
                        Type = "Permissions",
                        Value = "true"
                    });

                    authRoles = new AuthorizationRole[1];

                    authRoles[0] = new AuthorizationRole { RoleName = "JumboPack", AuthorizationPermissions = permissions };
            }
        

        public static bool IsAuthorized<T>(T flag)
        where T : struct
        {
            return IsAuthorized<T>(flag.ToString());
        }

        public static bool IsAuthorized<T>(string flags)
        where T : struct
        {
            Type type = typeof(T);

            // only works with enums
            if (!type.IsEnum)
                throw new ArgumentException("The type parameter T must be an enum type.");


            if (type.Equals(typeof(Permissions)))
            {

                var equialidPermissions = (from role in authRoles
                                           from permission in role.AuthorizationPermissions
                                           where flags.ToString().Contains(permission.Name) && permission.Value.Equals("true")
                                           select permission);

                if (equialidPermissions.Count() > 0)
                    return true;
                else
                    return false;
                //Check list of permissions available or not and check its value is True or not
                //If found with true value then return true, else return false.
            }
            else if (type.Equals(typeof(Roles)))
            {
                var equialidRoles = (from role in authRoles
                                     where flags.ToString().Contains(role.RoleName)
                                     select role).Count();

                if (equialidRoles > 0)
                    return true;
                else
                    return false;
                //Check if passed roles is available in role list or not, if yes then return true else return false
            }

            return false;
        }
    }
}