#!/bin/sh
#Setting environment
. /etc/sargraph.conf
#Command check
if [ $# -eq 0 ]
then
echo "USAGE: updatesar <servername>"
exit -1;
fi
Server=$1

##Identify SSH
SSH=`which ssh` 
if [ "x${SSH}" = "x" ] 
then
    if [ "x$silent" = "x" ]
then
     echo "SSH  not found! exiting.." 
fi
exit -1
fi

##SSH PORT SET##

if [ "x${SSH_PORT}" = "x" ]
then
SSH_PORT=22
fi


##GET OS type##
OS=`grep -i $Server $SERVERSCONF|awk -F : '{print $3}'|awk '{print $1}'` 
##GET Date## 
date=`$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server date "+%F"`


if [ "x$silent" = "x" ]
then
     echo "$Server is $OS"
fi

##GET Sar reports##
case "`$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server uname`" in
Linux)
##CPU##
$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server "LC_TIME="POSIX" sar -u " > $WORKDIR/$Server.cpu 
cat $WORKDIR/$Server.cpu|awk '{print $1","$3","$5","$6","$7}'|egrep -v 'Linux|$Server|user|Average|RESTART' > $WORKDIR/daily/$Server$date.cpu

##MEM## 
totmem=`$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server free|grep Mem|awk '{print $2}'` 
$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server "LC_TIME="POSIX" sar -r|egrep -v 'Linux|kbmemfree|$Server|Time|Average|RESTART'" > $WORKDIR/$Server.mem 
cat $WORKDIR/$Server.mem|awk '{print $1","$2+$6","$8}' > $WORKDIR/daily/$Server$date.mem
if [ "$OS" != "Red" ] 
then 
$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server "LC_TIME="POSIX" sar -S" > $WORKDIR/sar.swp
cat $WORKDIR/sar.swp|awk '{print $1","$3","$4}'|egrep -v 'Linux|$Server|user|Average|RESTART' > $WORKDIR/daily/$Server$date.swp
fi

##Run-queue##
$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server "LC_TIME="POSIX" sar -q |egrep -v 'Linux|$Server|runq-sz|RESTART|Average'" > $WORKDIR/$Server.rq 
cat $WORKDIR/$Server.rq|awk '{print $1","$2}' > $WORKDIR/daily/$Server$date.rq 
chmod 755 $WORKDIR/daily/$Server$date.* 
;;
SunOS)
##CPU##
$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server "LC_TIME="POSIX" sar -u" > $WORKDIR/sarlog
cat $WORKDIR/sarlog|awk '{print $1","$2","$3","$4","$5}'|egrep -v 'SunOS|usr'>$WORKDIR/$Server.log
$EGREP -v '^$' $WORKDIR/$Server.log > $WORKDIR/daily/$Server$date.cpu

##MEM##
$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server "LC_TIME="POSIX" sar -r|egrep -v 'SunOS|Time|freemem'">$WORKDIR/$Server.mem
cat $WORKDIR/$Server.mem|awk '{print $1","$2*8","$3*512}'>$WORKDIR/$Server.mem.tmp1
$EGREP -v '^$' $WORKDIR/$Server.mem.tmp1 >$WORKDIR/daily/$Server$date.mem
pform=`$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server "uname -m"`
totmem=`$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server /usr/platform/$pform/sbin/prtdiag -v|egrep -i "Memory size"|awk '{print $3}'`
totmem=`echo $totmem*1024|bc`

##Run-queue##
$SSH -i $KEY -p $SSH_PORT $SARUSER@$Server "LC_TIME="POSIX" sar -q|egrep -v 'SunOS|$Server|runq-sz|Average'" > $WORKDIR/$Server.rq
cat $WORKDIR/$Server.rq|awk '{print $1","$2}' > $WORKDIR/daily/$Server$date.rq
chmod 755 $WORKDIR/daily/$Server$date.*
;;
esac
