<?php

/*-------------------------------------------
  MAIAN MAIL v3.2
  Written by David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: www.maianscriptworld.co.uk
  This File: Main Parsing File
---------------------------------------------*/

// Set error reporting..
// Comment out for debugging..
error_reporting (0);

// Define constants..
define('PATH', dirname(__FILE__).'/');
define('PARENT',1);

// Load include files..
include(PATH.'control/config.inc.php');
include(PATH.'control/functions.php');
include(PATH.'lang/'.(file_exists(PATH.'lang/'.LANGFILE) ? LANGFILE : 'english.php'));
include(PATH.'classes/class_mail.inc.php');
include(PATH.'classes/class_boxtrapper.inc.php');
include(PATH.'control/Savant2.php');

// Create instance of mail class and pass default vars..
// If attachments are live, enable mailer as default..
$MAIL             = new mailClass();
$MAIL->smtp       = (ATTACHMENTS>0 && BOXTRAPPER==0 ? 1 : SMTP);
$MAIL->smtp_host  = SMTP_HOST;
$MAIL->smtp_user  = SMTP_USER;
$MAIL->smtp_pass  = SMTP_PASS;
$MAIL->smtp_port  = SMTP_PORT;
$MAIL->html       = HTML_EMAILS;
$MAIL->addTag('{HOMEPAGE}', WEBSITE_NAME);
$MAIL->addTag('{HOMELINK}', HOMEPAGE_URL);
$MAIL->addTag('{PATH}', FORM_PATH);
$MAIL->addTag('{IP}', getRealIPAddr());
$MAIL->addTag('{DATE}', DATE_FORMAT);

// Create instance of box trapper class and pass default vars..
$BOXTRAPPER             = new boxTrapper();
$BOXTRAPPER->whitelist  = WHITELIST_FILE;
$BOXTRAPPER->duration   = DURATION;
$BOXTRAPPER->folder     = BOXTRAPPER_FOLDER;

// Run auto cron for box trapper..
// Only run if enabled..
if (BOXTRAPPER) {
  if (!is_dir(PATH.BOXTRAPPER_FOLDER) || !is_writeable(PATH.BOXTRAPPER_FOLDER)) {
    echo str_replace('{folder}',BOXTRAPPER_FOLDER,$bt_error);
    exit;
  }
  $BOXTRAPPER->autoCronBoxTrapper();
}

// Default vars..
$cmd          = isset($_GET['p']) ? strip_tags($_GET['p']) : 'home';
$count        = 0;
$attachments  = array();
$aErrorArray  = array();

// Is box trapper verification in process..
if (isset($_GET['code'])) {
  $cmd = 'bt';
}

// Parse data..
switch ($cmd) {
  case 'home':
  if (isset($_POST['process'])) {
    // Clean post data array..
    $_POST = array_map('cleanEvilTags',$_POST);
    // Now lets do error checking if enabled..
    if (NAME_CHECK && $_POST['name']=='') {
      $N_ERROR = true; $count++;
    }
    if (EMAIL_CHECK && !preg_match("/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/i", $_POST['ctct'])) {
      $E_ERROR = true; $count++;
    }
    if (SUBJECT_CHECK && $_POST['subject']=='') {
      $S_ERROR = true; $count++;
    }
    if (COMMENTS_CHECK && $_POST['comments']=='') {
      $C_ERROR = true; $count++;
    }
    if (ATTACHMENTS>0) {
      for ($i=0; $i<count($_FILES['attachment']['tmp_name']); $i++) {
        $name  = filterUploadName($_FILES['attachment']['name'][$i]);
        $temp  = $_FILES['attachment']['tmp_name'][$i];
        $size  = $_FILES['attachment']['size'][$i];
        if ($name && $temp && $size>0) {
          $isSingleFile        = true;
          $attachments[$i][0]  = $temp;
          $attachments[$i][1]  = $name;
          // Error check file size and extensions..
          if (!in_array(strrchr(strtolower($name), '.'),validFileExtensions())) {
            $aErrorArray[] = showFormErrorMsg($field_attach_error); $count++;
          }
          if ($size>MAX_FILE_SIZE && MAX_FILE_SIZE>0) {
            $aErrorArray[] = showFormErrorMsg($field_attach_error2); $count++;
          }
        }
      }
    }
    if (ATTACHMENTS>0 && ATTACH_ERROR_CHECK && !isset($isSingleFile)) {
      $aErrorArray[] = showFormErrorMsg($field_attach_error3); $count++;
    }
    if (ENABLE_CAPTCHA) {
      include(PATH.'captcha/securimage.php');
      $img    = new Securimage();
      $valid  = $img->check($_POST['code']);
      if($valid == false) {
        $CA_ERROR = true;
        $count++;
      }
    }
    // If count is 0, there are no errors, so send mail..
    // If there are errors, show form with error messages..
    if ($count==0) {
      foreach ($_POST AS $key => $value) {
        $MAIL->addTag('{'.strtoupper($key).'}', $value);
      }
      // Is the box trapper enabled and attachments disabled..
      if (BOXTRAPPER && ATTACHMENTS==0) {
        // Assign unique code string
        // Pass to mail class
        $c_string          = $BOXTRAPPER->randomCodeGenerator(10);
        $BOXTRAPPER->code  = $c_string;
        $MAIL->addTag('{CODE}', $c_string);
        // If this address is in the whitelist, send mail..
        if ($BOXTRAPPER->checkEmailAddress()) {
          // Send mail to webmaster..
          $MAIL->sendMail(WEBSITE_NAME,
                          EMAIL_ADDRESS,
                          $_POST['name'],
                          $_POST['ctct'],
                          $_POST['subject'],
                          $MAIL->template(PATH.'templates/email/webmaster.txt')
                          );

          // Send auto responder if enabled..
          if (AUTO_RESPONDER && $_POST['ctct']) {
            $MAIL->sendMail($_POST['name'],
                            $_POST['ctct'],
                            WEBSITE_NAME,
                            EMAIL_ADDRESS,
                            str_replace('{website}',WEBSITE_NAME,$auto),
                            $MAIL->template(PATH.'templates/email/auto_responder.txt')
                            );
          }
          $dStyle = 'thanks';
          $dMsg   = $thanks;
          foreach ($_POST AS $key => $value) {
            $_POST[$key] = '';
          }
        } else {
          // Log message to box trapper folder and send mail for verification..
          $BOXTRAPPER->writeToDataFile();
          $MAIL->sendMail($_POST['name'],
                          $_POST['ctct'],
                          WEBSITE_NAME,
                          EMAIL_ADDRESS,
                          str_replace('{website}',WEBSITE_NAME,$auto2),
                          $MAIL->template(PATH.'templates/email/box_trapper.txt')
                          );
          include(PATH.'control/header.php');
          $tpl = new Savant2();
          $tpl->assign('MESSAGE', str_replace(array('{name}','{email}','{days}'),array(cleanData($_POST['name']),$_POST['ctct'],DURATION),$thanks2));
          $tpl->display('templates/boxtrapper.tpl.php');
          include(PATH.'control/footer.php');
          exit;
        }
      } else {
        // Are attachments present..
        if (!empty($attachments) && ATTACHMENTS>0) {
          $MAIL->attachments = $attachments;
        }
        // Send mail to webmaster..
        $MAIL->sendMail(WEBSITE_NAME,
                        EMAIL_ADDRESS,
                        $_POST['name'],
                        $_POST['ctct'],
                        $_POST['subject'],
                        $MAIL->template(PATH.'templates/email/webmaster.txt')
                        );
        // Don`t send attachments in auto responder..
        if (!empty($attachments) && ATTACHMENTS>0) {
          $MAIL->attachments = array();
        }                
        // Send auto responder if enabled..
        if (AUTO_RESPONDER && $_POST['ctct']) {
          $MAIL->sendMail($_POST['name'],
                          $_POST['ctct'],
                          WEBSITE_NAME,
                          EMAIL_ADDRESS,
                          str_replace('{website}',WEBSITE_NAME,$auto),
                          $MAIL->template(PATH.'templates/email/auto_responder.txt')
                          );
        }
      }
      $dStyle = 'thanks';
      $dMsg   = $thanks;
      foreach ($_POST AS $key => $value) {
        $_POST[$key] = '';
      }
    } else {
      // Clear temp files if another error is present..
      if (!empty($aErrorArray)) {
        for ($i=0; $i<count($_FILES['attachment']['tmp_name']); $i++) {
          if (file_exists($_FILES['attachment']['tmp_name'][$i])) {
            @unlink($_FILES['attachment']['tmp_name'][$i]);
          }
        }
        $attachments = array();
      }
      $dStyle = 'errorMsg';
      $dMsg   = str_replace('{count}',$count,$field_error_msg);
    }
  }

  // Load captcha html if enabled..
  if (ENABLE_CAPTCHA) {
    $c_code = str_replace(array('{text}','{enter_txt}','{captcha_error}','{symbol}'),
                          array($field_sec_code,$field_code,(isset($CA_ERROR) ? showFormErrorMsg($field_code_error) : ''),ECHECK_SYMBOL),
                          file_get_contents(PATH.'templates/html/captcha.htm')
              );
  }
  // Load attachments html if enabled..
  if (ATTACHMENTS && BOXTRAPPER==0) {
    $a_data = '';
    $boxes  = '';
    for ($i=0; $i<ATTACHMENTS; $i++) {
      $boxes .= str_replace('{error_checking}',(!$i && ATTACH_ERROR_CHECK ? ECHECK_SYMBOL : ''),
                file_get_contents(PATH.'templates/html/attachment.htm')
                );
    }
    $a_data .= str_replace(array('{fields}','{restrictions}','{errors}'),
                           array($boxes,str_replace(array('{files}','{size}'),
                                                    array(ALLOWED_EXTENSIONS,fileSizeConversion(MAX_FILE_SIZE)),$field_attachments),
                                                    (!empty($aErrorArray) ? implode(defineNewline(),$aErrorArray) : '')
                                        ),
                           file_get_contents(PATH.'templates/html/attachments-wrapper.htm')
              );
  }

  include(PATH.'control/header.php');
  $tpl = new Savant2();
  $tpl->assign('DISPLAY_MESSAGE', (isset($dMsg) ? displayMessage($dStyle,$dMsg) : displayMessage('onload',str_replace('{symbol}',ECHECK_SYMBOL,$field_start_message))));
  $tpl->assign('NAME', $field_name);
  $tpl->assign('EMAIL', $field_email);
  $tpl->assign('SUBJECT', $field_subject);
  $tpl->assign('COMMENTS', $field_comments);
  $tpl->assign('SEND', $field_send);
  $tpl->assign('IS_ATTACHMENT', (ATTACHMENTS ? true : false));
  $tpl->assign('ATTACHMENTS', (isset($a_data) ? $a_data : ''));
  $tpl->assign('NAME_VALUE', (isset($_POST['name']) ? htmlspecialchars(cleanData($_POST['name'])) : ''));
  $tpl->assign('EMAIL_VALUE', (isset($_POST['ctct']) ? htmlspecialchars(cleanData($_POST['ctct'])) : ''));
  $tpl->assign('SUBJECT_VALUE', (isset($_POST['subject']) ? htmlspecialchars(cleanData($_POST['subject'])) : ''));
  $tpl->assign('COMMENTS_VALUE', (isset($_POST['comments']) ? htmlspecialchars(cleanData($_POST['comments'])) : ''));
  $tpl->assign('NAME_ERROR_CHECKING', (NAME_CHECK ? ECHECK_SYMBOL : ''));
  $tpl->assign('EMAIL_ERROR_CHECKING', (EMAIL_CHECK ? ECHECK_SYMBOL : ''));
  $tpl->assign('SUBJECT_ERROR_CHECKING', (SUBJECT_CHECK ? ECHECK_SYMBOL : ''));
  $tpl->assign('COMMENTS_ERROR_CHECKING', (COMMENTS_CHECK ? ECHECK_SYMBOL : ''));
  $tpl->assign('NAME_ERRORS', (isset($N_ERROR) ? showFormErrorMsg($field_name_error) : ''));
  $tpl->assign('EMAIL_ERRORS', (isset($E_ERROR) ? showFormErrorMsg($field_email_error) : ''));
  $tpl->assign('SUBJECT_ERRORS', (isset($S_ERROR) ? showFormErrorMsg($field_subject_error) : ''));
  $tpl->assign('COMMENTS_ERRORS', (isset($C_ERROR) ? showFormErrorMsg($field_comments_error) : ''));
  $tpl->assign('CAPTCHA', (isset($c_code) ? $c_code : ''));
  $tpl->display('templates/index.tpl.php');
  include(PATH.'control/footer.php');
  break;

  // For box trapper verification..
  case 'bt':

  $code = isset($_GET['code']) ? strip_tags($_GET['code']) : '';

  // Lets check the code var and make sure its alphanumeric..
  if ($code=='' || !ctype_alnum($code)) {
    exit;
  }

  // Check box trapper code to make sure file exists..
  if (!$BOXTRAPPER->getBoxTrapperData($code)) {
    include(PATH.'control/header.php');
    $tpl = new Savant2();
    $tpl->assign('MESSAGE', $error);
    $tpl->display('templates/boxtrapper.tpl.php');
    include(PATH.'control/footer.php');
  } else {
    // Assign array data to variable..
    // $data[0] = Name
    // $data[1] = Email
    // $data[2] = Subject
    // $data[3] = Comments
    $data = explode($BOXTRAPPER->addSeperator,$BOXTRAPPER->getBoxTrapperData($code,true,false));
    // Pass data to mail class
    $MAIL->addTag('{NAME}', $data[0]);
    $MAIL->addTag('{CTCT}', $data[1]);
    $MAIL->addTag('{SUBJECT}', $data[2]);
    $MAIL->addTag('{COMMENTS}', $data[3]);
    // Send message to webmaster..
    $MAIL->sendMail(WEBSITE_NAME,
                    EMAIL_ADDRESS,
                    $data[0],
                    $data[1],
                    $data[2],
                    $MAIL->template(PATH.'templates/email/webmaster.txt')
                    );
    // Send auto responder if enabled..
    if (AUTO_RESPONDER) {
      $MAIL->sendMail($data[0],
                      $data[1],
                      WEBSITE_NAME,
                      EMAIL_ADDRESS,
                      str_replace('{website}',WEBSITE_NAME,$auto),
                      $MAIL->template(PATH.'templates/email/auto_responder.txt')
                      );
    }
    // Add e-mail to whitelist..
    $BOXTRAPPER->writeToWhiteList($data[1]);
    // Delete box trapper message..
    $BOXTRAPPER->deleteBoxTrapperData($BOXTRAPPER->getBoxTrapperData($code,true,true));
    // Show message..
    include(PATH.'control/header.php');
    $tpl = new Savant2();
    $tpl->assign('MESSAGE', str_replace(array('{name}','{email}','{days}'),array(cleanData($data[0]),$data[1],DURATION),$thanks));
    $tpl->display('templates/boxtrapper.tpl.php');
    include(PATH.'control/footer.php');
  }

  break;

  case 'captcha':
  include (PATH.'captcha/securimage.php');
  $img = new securimage();
  $img->show();
  break;
}

?>
