<?php

/*---------------------------------------------
  MAIAN MAIL v3.2
  Written by David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: www.maianscriptworld.co.uk
  This File: Program Functions
----------------------------------------------*/

// Display error message under form fields..
function showFormErrorMsg($txt) {
  return str_replace('{text}',$txt,file_get_contents(PATH.'templates/html/error.htm'));
}

// Display message box..
function displayMessage($type,$text) {
  return str_replace(array('{type}','{text}'),array($type,$text),file_get_contents(PATH.'templates/html/message.htm'));
}

// Get extensions..
function validFileExtensions() {
  $ext   = array();
  $split = explode(',',ALLOWED_EXTENSIONS);
  for ($i=0; $i<count($split); $i++) {
    $ext[] = '.'.strtolower($split[$i]);
  }
  return $ext;
}

// New line char..
function defineNewline() {
  $nl = "\r\n";
  if (strstr(strtolower($_SERVER["HTTP_USER_AGENT"]), 'win')) {
    $nl = "\r\n";
  } else if (strstr(strtolower($_SERVER["HTTP_USER_AGENT"]), 'mac')) {
    $nl = "\r";
  } else {
    $nl = "\n";
  }
  return $nl;
}

// Filter file upload name..
function filterUploadName($file) {
  // Convert to lower case chars..
  $file = strtolower($file);
  // Next, get original file extension
  $ext  = strrchr($file, '.');
  // Now remove the extension..
  $file = str_replace($ext,'',$file);
  // Remove problem chars and clean file name..
  $file = preg_replace('`[^\w_-]`', '', $file);
  // Finally, return filtered name with original extension and timestamp..
  return trim($file).$ext;
}

// File size conversion..
function fileSizeConversion($size=0,$base='1048576') {
  if ($size>0) {
    if ($size>1023987) {
      return number_format($size/$base,1)."MB";
    } else if ($size<1024) {
      return $size." Bytes";
    } else {
      return number_format($size/1024,0)."KB";
    }
  } else {
    return '0KB';
  }
}

// Clean evil tags in form data..
function cleanEvilTags($data) {
  $data = preg_replace("/javascript/i", "j&#097;v&#097;script",$data);
  $data = preg_replace("/alert/i", "&#097;lert",$data);
  $data = preg_replace("/about:/i", "&#097;bout:",$data);
  $data = preg_replace("/onmouseover/i", "&#111;nmouseover",$data);
  $data = preg_replace("/onclick/i", "&#111;nclick",$data);
  $data = preg_replace("/onload/i", "&#111;nload",$data);
  $data = preg_replace("/onsubmit/i", "&#111;nsubmit",$data);
  $data = preg_replace("/<body/i", "&lt;body",$data);
  $data = preg_replace("/<html/i", "&lt;html",$data);
  $data = preg_replace("/document\./i", "&#100;ocument.",$data);
  $data = cleanData($data);
  
  return strip_tags(trim($data));
}

// Clean form output..
function cleanData($data) {
  return (get_magic_quotes_gpc() ? stripslashes($data) : $data);
}

// Gets visitor IP address..
function getRealIPAddr() {
  $ip = array();
  if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
    $ip[] = $_SERVER['HTTP_CLIENT_IP'];
	} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'],',')) {
      $split = explode(',',$_SERVER['HTTP_X_FORWARDED_FOR']);
      foreach ($split AS $value) {
        $ip[] = $value;
      }
    } else {
      $ip[] = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
  } else {
    $ip[] = $_SERVER['REMOTE_ADDR'];
  }
  return (!empty($ip) ? implode(',',$ip) : '');
}

?>
