<?php

/*-------------------------------------------
  MAIAN MAIL v3.2
  Written by David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: www.maianscriptworld.co.uk
  This File: Configuration File
---------------------------------------------*/

/****************************************************************************************************************
*  IMPORTANT - READ FIRST                                                                                       *
*  Listed below are the configuration options for your website. Edit them carefully, ensuring that you do NOT   *
*  remove any semi colons OR anything that is displayed in CAPITAL letters. These are important to the program. *
*****************************************************************************************************************/

/*=====================================================================================
  1. DEFINE WEBSITE SETTINGS
     Specify your contact form preferences.
=======================================================================================*/


// Website Name
// Escape apostrophes. ie: \'
define('WEBSITE_NAME', 'Your Website');

// Homepage URL
define('HOMEPAGE_URL', 'http://www.yoursite.com');

// Path to where contact form is installed. NO trailing slash
// This is only important if the box trapper is enabled
define('FORM_PATH', 'http://www.yoursite.com/mail');

// E-Mail Address
define('EMAIL_ADDRESS', 'you@youremail.com');

// Form title. Appears in the title address bar..
define('FORM_TITLE', 'My Contact Form');

// Send Auto Respond e-mail to visitor? 
// 1 = yes, 0 = no
define('AUTO_RESPONDER', 1);

// Language file
define('LANGFILE', 'english.php');

// Date format as it appears in e-mails..
define('DATE_FORMAT', date("j F Y"));

// Symbol which denotes required field..
define('ECHECK_SYMBOL', '*');

// Activate HTML formatted e-mails..
// If you enable this you can use html in the e-mail templates..
define('HTML_EMAILS', 0);

// Enable captcha
// 0 = Off, 1 = On
// Settings for the captcha are in the following file:
// classes/secureimage.php
define('ENABLE_CAPTCHA', 1);



/*===========================================================================
  2. DEFINE ERROR CHECKING
     For which fields do you want error checking to be enabled?
     0 = Off, 1 = On
=============================================================================*/


// Name Field
define('NAME_CHECK', 1);

// Subject Field
define('SUBJECT_CHECK', 1);

// E-Mail Field
define('EMAIL_CHECK', 1);

// Comments Field
define('COMMENTS_CHECK', 1);


/*=======================================================
  3. ATTACHMENTS
     Would you like visitors to include attachments
     with their message? If this is enabled, the PHP
     mailer system handles the processing and SMTP becomes
     live. Note that you may also need to specify SMTP 
     authentication details for this to work.
     
     Note: Attachments do not work with the box trapper
     function. If this is enabled, box trapper is auto
     disabled
=========================================================*/


// How many attachment fields do you require? ie: 3
// 0 disables the attachments
define('ATTACHMENTS', 0);

// Allowable attachment file types..
// This is not case sensitive. PDF and pdf are the same
// Seperate with comma..
define('ALLOWED_EXTENSIONS', 'pdf,doc,rtf');

// Maximum file size for attachments. In Bytes.
// Examples: 
// 1024 x 1024 = 1048576Bytes (or 1MB)
// 1024 x 200  = 204800Bytes (or 200KB)
// Set to 0 for no limit..
define('MAX_FILE_SIZE', '204800');

// Error checking. Is at least 1 attachment required?
// 0 = No, 1 = Yes
define('ATTACH_ERROR_CHECK', 1);


/*=======================================================
  4. SMTP SETTINGS
     If enabled overwrites PHP mail function
     Note some servers require authentication for this
     to work.
=========================================================*/


// Enable SMTP
// 0 = No, 1 = Yes
define('SMTP', 0);

// SMTP Host
define('SMTP_HOST', 'localhost');

// SMTP Username
define('SMTP_USER', '');

// SMTP Password
define('SMTP_PASS', '');

// SMTP Port
define('SMTP_PORT', 25);


/*==================================================================
  5. BOX TRAPPER SETTINGS
     If enabled, messages are stored on the server and require
     e-mail verification before being sent. Unsent messages are
     deleted after x amount of days.
     
     Note: This will NOT work with attachments. If you have
     enabled attachments, enabling the box trapper will have no
     effect.
===================================================================*/


// Enable Box trapper
// 0 = No, 1 = Yes
define('BOXTRAPPER', 0);

// Box trapper folder name..This must exist and be writeable..
define('BOXTRAPPER_FOLDER', 'boxtrapper');

// Specify text file name for whitelist (ie, approved e-mail addresses)
// This is auto generated the first time the system runs and should
// ideally be named something unique. You can manually add e-mail
// addresses to this file if you want to. Note that the system stores
// e-mails in this format:
//
// support[at]maianscriptworld[dot]co[dot]uk
//
// If adding manually, you can use actual address. Data is changed to
// prevent any bots from grabbing the addresses, but will still work.
// You should prevent search bots from accessing your 'boxtrapper'
// folder by using robots.txt, or .htaccess.
define('WHITELIST_FILE', 'whitelist.txt');

// Amount of time (in days) messages remain before being deleted.
// An auto cron runs in the background everytime someone accesses
// the form. If old messages are found, they are deleted.
define('DURATION', 3);


/*==================================================================
  6. POWERED BY HEADER LINK
     This activates the powered by text in the title bar. Its not
     required you enable this, but please leave the copyright in
     the footer unless you wish to pay for copyright removal
===================================================================*/


// 0 = No, 1 = Yes
define('DISABLE_POWERED_BY', 1);

?>
