<?php

/*---------------------------------------------
  MAIAN MAIL v3.2
  Written by David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: www.maianscriptworld.co.uk
  This File: Box Trapper Class
  Added in v3.1
----------------------------------------------*/

class boxTrapper {
  
var $whitelist;
var $duration;
var $code;
var $addSeperator = '###';
var $folder;

// Check e-mail address against whitelist..
function checkEmailAddress() {
  if (file_exists(PATH.$this->folder.'/'.$this->whitelist)) {
    $file = array_map('trim',file(PATH.$this->folder.'/'.$this->whitelist));
    if (!empty($file)) {
      for($i=0; $i<count($file); $i++) {
        if ($_POST['ctct']===$this->convertEmailAddress($file[$i],true)) {
          return true;
        }
      }
      return false;
    } else {
      return false;
    }
  } else {
    return false;
  }
}

// Log attachments to server..
// For future development..
function logAttachmentsToServer() {
}

//Parse e-mail address and convert @ and period symbols..
function convertEmailAddress($email,$back=false) {
  $find     = array((!$back ? "@" : "[at]"),(!$back ? "." : "[dot]"));
  $replace  = array((!$back ? "[at]" : "@"),(!$back ? "[dot]" : "."));
  return str_replace($find,$replace,$email);
}

// Auto run when someone accesses form..
function autoCronBoxTrapper() {
  $date = date("Y-m-d", strtotime("-".$this->duration." days"));
  $dir  = opendir(PATH.$this->folder.'/');
  while (false !== ($read = readdir($dir))) {
    if (!in_array($read,array('index.html','.','..')) && $read!=$this->whitelist) {
      $name = explode("_", $read);
      if ($name[0]<$date) {
        @unlink(PATH.$this->folder.'/'.$read);
      }
    }
  }
  closedir($dir);
}

// Add e-mail to whitelist..
function writeToWhiteList($email) {
  if (file_exists(PATH.$this->folder.'/'.$this->whitelist)) {
    $data = file_get_contents(PATH.$this->folder.'/'.$this->whitelist);
  }
  if (isset($data)) {
    @unlink(PATH.$this->folder.'/'.$this->whitelist);
  }  
  $fp = fopen(PATH.$this->folder.'/'.$this->whitelist, 'ab');
  if ($fp) {
    fwrite($fp,(isset($data) ? trim($data).defineNewline() : '').$this->convertEmailAddress($email));
    fclose($fp);
  }
}

// Get data from box trapper directory..
function getBoxTrapperData($code,$data=false,$name=false) {
  $dir = opendir(PATH.$this->folder.'/');
  while (false !== ($read = readdir($dir))) {
    if (!in_array($read,array('index.html','.','..')) && $read!=$this->whitelist) {
      $info = explode("_", $read);
      if (substr($info[1],0,10)==$code) {
        $match = $read;
      }
    }
  }
  closedir($dir);
  if (isset($match)) {
    return ($data ? ($name ? $match : file_get_contents(PATH.$this->folder.'/'.$match)) : true);
  } else {
    return false;
  }
}

// Deletes box trapper data..
function deleteBoxTrapperData($file) {
  if (file_exists(PATH.$this->folder.'/'.$file)) {
    @unlink(PATH.$this->folder.'/'.$file);
  }
}

// Write data to data file..
function writeToDataFile() {
  $file    = date("Y-m-d").'_'.$this->code.'.txt';
  $string  = $_POST['name'].$this->addSeperator.$_POST['ctct'].$this->addSeperator.$_POST['subject'].$this->addSeperator.$_POST['comments'];
  $fp = fopen(PATH.$this->folder.'/'.$file, 'ab');
  if ($fp) {
    fwrite($fp,trim($string));
    fclose($fp);
  }
}

// Generates random string..
function randomCodeGenerator($num) {
  return substr(md5(uniqid(rand(),1)),3,$num);
}

}

?>
