﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SessionInjQuery.aspx.cs" Inherits="JQueryExample.SessionInjQuery" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <script src="jquery/js/jquery-1.8.3.js" type="text/javascript"></script>   
    
    <script type="text/javascript">

    var sess_pollInterval = 60000;
    var sess_expirationMinutes = 20;
    var sess_warningMinutes = 5;
    var sess_intervalID;
    var sess_lastActivity;

    function initSession()
    {    
        sess_lastActivity = new Date();
        sessSetInterval();
        $(document).bind('keypress.session', function (ed, e)
        {
            sessKeyPressed(ed, e);
        });
    }

    function sessSetInterval() 
    {
        sess_intervalID = setInterval('sessInterval()', sess_pollInterval);
    }

    function sessClearInterval() 
    {
        clearInterval(sess_intervalID);
    }

    function sessKeyPressed(ed, e) 
    {
        sess_lastActivity = new Date();
    }

    function sessLogOut() 
    {
        window.location.href = 'Logout.aspx';
    }

    function sessInterval()
    {
        var now = new Date();
        //get milliseconds of differneces 
        var diff = now - sess_lastActivity;
        //get minutes between differences
        var diffMins = (diff / 1000 / 60);

        if (diffMins >= sess_warningMinutes)
        {
            //wran before expiring
            //stop the timer
            sessClearInterval();
            //promt for attention
            var active = confirm('Your session will expire in ' + (sess_expirationMinutes - sess_warningMinutes) +
                ' minutes (as of ' + now.toTimeString() + '), press OK to remain logged in ' +
                'or press Cancel to log off. \nIf you are logged off any changes will be lost.');
            if (active == true)
            {
                now = new Date();
                diff = now - sess_lastActivity;
                diffMins = (diff / 1000 / 60);

                if (diffMins > sess_expirationMinutes)
                {
                    sessLogOut();
                }
                else
                {
                    initSession();
                    sessSetInterval();
                    sess_lastActivity = new Date();
                }
            }
            else
            {
                sessLogOut();
            }
        }
    }
</script>
 
</head>
<body onload="initSession()">
    <form id="form1" runat="server">
    <div>
     <h1>Your Most Welcome!</h1>
    </div>
    </form>
</body>
</html>
