<?php
	// Set the current page and include necessary files.
	$current_page = 'spell.php';
	require("include/config.php");
	require("include/language.php");
	require("include/functions.internal.php");
	require("include/functions.html.php");
	require("include/functions.format.php");
	require("include/functions.sessions.php");
	require("include/connect.php");
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<HTML>

<?
	if (!$ispell_text)	{
?>

<HEAD>
	<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<? echo HTML_CHARSET ?>">
	<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
	<? if (HTML_STYLESHEET) { ?><LINK REL="stylesheet" HREF="<? echo HTML_STYLESHEET ?>"><? } ?>

	<TITLE>
		<? echo HTML_TITLE ?>

	</TITLE>
</HEAD>

<BODY <? echo html_body() ?> ONLOAD="initiateSpeller()">
	<TABLE WIDTH="100%" BORDER="0" CELLPADDING="2">
		<TR>
			<TD ALIGN="CENTER"><B>Spellcheck initiating...</B></TD>
		</TR>
		<TR>
			<TD><HR></TD>
		</TR>
		<TR>
			<TD>&nbsp;</TD>
		</TR>
		<TR>
			<TD>
				<SCRIPT TYPE="text/javascript">
				 <!--

				  // fetch the subject and body from the compose window and submit it to the
				  // ispell.
				  function initiateSpeller(){
				   textToSpell = opener.document.forms[0].Message.value;
				   if (!textToSpell) textToSpell = "\n";
				   document.forms[0].ispell_text.value = textToSpell;
				   document.forms[0].submit();
				  }
				 //-->
				 </SCRIPT>
				<P ALIGN="CENTER">Please wait, communicating with the server...</P>
				<FORM METHOD="POST"><INPUT TYPE="HIDDEN" name="ispell_text"></FORM>
			</TD>
		</TR>
		<TR>
			<TD>&nbsp;</TD>
		</TR>
		<TR>
			<TD><HR></TD>
		</TR>
	</TABLE>
<?
	}	else {
	// so, the form has been submitted.
?>
<HEAD>
	<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<? echo HTML_CHARSET ?>">
	<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
	<? if (HTML_STYLESHEET) { ?><LINK REL="stylesheet" HREF="<? echo HTML_STYLESHEET ?>"><? } ?>

	<TITLE>
		<? echo HTML_TITLE ?>

	</TITLE>
<?
 
	if (get_magic_quotes_gpc()) {
		$ispell_text = stripslashes($ispell_text);
	}		
 
	$ispell_raw_lines = explode("\n", $ispell_text);
	for ($i=0; $i<sizeof($ispell_raw_lines); $i++){
		$ispell_raw_lines[$i] = ereg_replace("^", " ", $ispell_raw_lines[$i]);
	}
	$ispell_text=implode("\n", $ispell_raw_lines);
 
	$floc = tempnam(ISPELL_TMPDIR,"ISPELL");
	$fp=fopen($floc, "w");
	fwrite($fp, $ispell_text);
	fclose($fp);
	exec("cat $floc | ".ISPELL_COMMAND, $ispell_output);
	unlink($floc);
 
	$current_line=0;
	$missed_words=Array();
	$misses = Array();
	$locations = Array();
	$errors=0;

	for ($i=0; $i<sizeof($ispell_output); $i++){
		switch (substr($ispell_output[$i], 0, 1)){
			case "":
				$current_line++;
				break;

			case "&":
				// This means there's a misspelled word and a few suggestions.
				list($left, $right) = explode(": ", $ispell_output[$i]);
				$tmparray = explode(" ", $left);
				$ispell_word=$tmparray[1];
				$ispell_symb=intval($tmparray[3])-1;
				if (!$misses[$ispell_word]) {
					$misses[$ispell_word] = $right;
					$missed_words[$errors] = $ispell_word;
					$errors++;
				}
				if ($locations[$ispell_word]) $locations[$ispell_word] .= ", ";
					$locations[$ispell_word] .= "$current_line:$ispell_symb";
					break;

			case "#":
				// This means a misspelled word and no suggestions.
				$tmparray = explode(" ", $ispell_output[$i]);
				$ispell_word=$tmparray[1];
				$ispell_symb=intval($tmparray[2])-1;
				if (!$misses[$ispell_word]) {
					$misses[$ispell_word] = "_NONE";
					$missed_words[$errors] = $ispell_word;
					$errors++;
				}
				if ($locations[$ispell_word]) $locations[$ispell_word] .= ", ";
					$locations[$ispell_word] .= "$current_line:$ispell_symb";
					break;
				}
		}

		if ($errors){ 
			// So, there are errors
?>
	<SCRIPT TYPE="text/javascript">
     // Load the spelling errors into JavaScript arrays
     <!--
     <?php
   
     $ispell_lines = explode("\n", $ispell_text);
     echo "var ispell_lines = new Array();\n";
     for ($i=0; $i<sizeof($ispell_lines); $i++){
       echo "ispell_lines[$i] = \"" . trim(addslashes($ispell_lines[$i])) . "\";\n";
     }

     echo "\n\n";
     echo "// Misses are all misspelled words\n";
     echo "var misses = new Array();\n";
     for ($i=0; $i<sizeof($missed_words); $i++){
       echo "misses[$i] = \"" . $missed_words[$i] . "\";\n";
     }

     echo "\n\n";
     echo "// Suggestions are (guess what!) suggestions for misspellings\n";
     echo "var suggestions = new Array();\n";

     $i=0;
     while (list($word, $value) = each($misses)){
       if ($value=="_NONE") $value="";
       echo "suggestions[\"$i\"] = \"$value\";\n";
       $i++;
     }

     echo "\n\n";
     echo "// Locations are where those misspellings are located, line:symbol\n";
     echo "var locations = new Array();\n";
     $i=0;
     while (list($word, $value) = each($locations)){
       echo "locations[\"$i\"] = \"$value\";\n";
       $i++;
     }
     ?>

     var CurrentError=0;
     var CurrentLocation=0;

     var CurrentLine;
     var CurrentSymbol;
     var ChangesMade=false;

     function populateIspellForm(){
       // this function loads error data into the form.
       CurrentWord=Word=misses[CurrentError];
       WordLocations = locations[CurrentError].split(", ");
       CurrentLoc = WordLocations[CurrentLocation];
       if(CurrentLocation==WordLocations.length-1) {
	 CurrentLocation=0;
       } else {
	 CurrentLocation++;
       }
       
       tmp = CurrentLoc.split(":");
       CurrentLine=parseInt(tmp[0]);
       CurrentSymbol=parseInt(tmp[1]);
       document.forms[0].ispell_error.value=Word;
       LineValue=ispell_lines[CurrentLine];
       StartWith=0;
       NewLineValue="";
       if (CurrentSymbol > 40){
         StartWith=CurrentSymbol-40;
	 NewLineValue = "...";
       }
       EndWith=LineValue.length;
       EndLine="";
       if (EndWith > CurrentSymbol + 40){
         EndWith=CurrentSymbol+40;
	 EndLine="...";
       }
       NewLineValue+=LineValue.substring(StartWith, CurrentSymbol) + "*" + Word + "*" + LineValue.substring(CurrentSymbol + Word.length, EndWith) + EndLine;
       document.forms[0].ispell_line_area.value=NewLineValue;
       
       if (suggestions[CurrentError]){
         WordSuggestions = suggestions[CurrentError].split(", ");
         for (i=0; i<WordSuggestions.length; i++){
           document.forms[0].ispell_suggestion.options[i] = new Option(WordSuggestions[i], WordSuggestions[i]);
         }
       } else {
         document.forms[0].ispell_suggestion.options[0] = new Option("No Suggestions", "_NONE");
         document.forms[0].ispell_oruse.value=Word;
         document.forms[0].ispell_oruse.focus();
         document.forms[0].ispell_oruse.select();
       }
       
       document.forms[0].ispell_suggestion.selectedIndex=0;
       if (!document.forms[0].ispell_oruse.value)
         document.forms[0].ispell_oruse.value=document.forms[0].ispell_suggestion.options[document.forms[0].ispell_suggestion.selectedIndex].value;
       occursTimes = WordLocations.length;
       if (CurrentLocation) occursTimes += CurrentLocation-1;
       document.forms[0].ispell_likethis.value=occursTimes;
     }

     function updateLine(lLine, lSymbol, lWord, lNewWord){
       // This function updates the line with new word value
       ispell_lines[lLine] = ispell_lines[lLine].substring(0, lSymbol) + lNewWord + ispell_lines[lLine].substring(lSymbol+lWord.length, ispell_lines[lLine].length);
       if (lWord.length != lNewWord.length)
	 updateSymbol(lLine, lSymbol, lNewWord.length-lWord.length);
       if (!ChangesMade) ChangesMade=true;
     }

     function ispellChange(){
       // Called when pressed the "Change" button
       CurrentWord = misses[CurrentError];
       NewWord=document.forms[0].ispell_oruse.value;
       updateLine(CurrentLine, CurrentSymbol, CurrentWord, NewWord);
       proceed();
     }

     function ispellChangeAll(){
       // Called when pressed the "Change All" button
       allLoc = locations[CurrentError].split(", ");
       if (allLoc.length==1) {
         // There's no need to "change all", only one occurance.
	 ispellChange();
	 return;
       }
       
       NewWord=document.forms[0].ispell_oruse.value;
       CurrentWord = misses[CurrentError];
       for (z=CurrentLocation-1; z<allLoc.length; z++){
	 tmp = allLoc[z].split(":");
	 lLine = parseInt(tmp[0]);  lSymbol = parseInt(tmp[1]);
	 updateLine(lLine, lSymbol, CurrentWord, NewWord);
	 // Load it again to reflect the changes in symbol data
	 allLoc = locations[CurrentError].split(", ");
       }
       
       CurrentLocation=0;
       proceed();
     }

     function ispellIgnore(){
       // Only here for consistency. Called when pressed the "Ignore" button
       proceed();
     }

     function ispellIgnoreAll(){
       // Called when pressed the "Ignore All" button
       CurrentLocation=0;
       proceed();
     }

     function clearIspellForm(){
       // Clears the options in selectbox "ispell_suggestions"
       for (i=0; i<document.forms[0].ispell_suggestion.length; i++){
         document.forms[0].ispell_suggestion.options[i]=null;
       }
       // Now, I've been instructed by the Netscape Developer docs to call
       // history.go(0) to refresh the page after I've changed the options.
       // However, that brings so many pains with it that I just decided not
       // to do it. It works like it is in Netscape 4.x. If there are problems
       // in earlier versions of Netscape, then oh well. I'm not THAT anxious
       // to have it working on all browsers... ;)

       document.forms[0].ispell_oruse.value="";
     }

     function proceed(){
       // Goes on to the next error if any, or finishes.
       if (!CurrentLocation) CurrentError++;
       if (misses[CurrentError]){
         clearIspellForm();
         populateIspellForm();
       } else {
         if (ChangesMade){
           if (confirm("SpellCheck complete. Commit Changes?")) 
	     ispellCommitChanges();
	 } else {
	   confirm ("No changes were made.");
	 }
	 self.close();
       }
     }

     function updateSymbol(lLine, lSymbol, difference){
       // Now, I will admit that this is not the best way to do stuff,
       // However that's the solution I've come up with.
       // This function updates the symbol locations after there have been
       // word length changes in the lines. Otherwise SquirrelSpell barfs all
       // over your message... ;)
       
       for (i=0; i<misses.length; i++){
         if(locations[i].indexOf(lLine + ":") >= 0){
           allLoc = locations[i].split(", ");
           for (j=0; j<allLoc.length; j++){
	     if (allLoc[j].indexOf(lLine+":")==0){
	       tmp = allLoc[j].split(":");
	       tmp[0] = parseInt(tmp[0]); tmp[1] = parseInt(tmp[1]);
	       if (tmp[1] > lSymbol){
	         tmp[1] = tmp[1] + difference;
	         allLoc[j] = tmp.join(":");
	       }
	     }
           }
           locations[i] = allLoc.join(", ");
         }
       }
     }

     function ispellCommitChanges(){
       // Write the changes back into the compose form
         newBody = "";
         for (i=0; i<ispell_lines.length; i++){
           if (i!=0) newBody+="\n";
           newBody += ispell_lines[i];
         }

       opener.document.forms[0].Message.value=newBody;
       self.close();
     }

     //-->
	 </SCRIPT>
</HEAD>

<BODY <? echo html_body() ?> ONLOAD="populateIspellForm()">
	<FORM ONSUBMIT="return false">
	<TABLE WIDTH="100%" BORDER="0" CELLPADDING="2">
		<TR>
			<TD COLSPAN="4" ALIGN="CENTER"><B>Found <?php echo $errors ?> errors</B></TD>
		</TR>
		<TR>
			<TD COLSPAN="4"><HR></TD>
		</TR>
		<TR>
			<TD COLSPAN="4">
				<TABLE BORDER="0" WIDTH="100%">
					<TR ALIGN="CENTER">
						<TD COLSPAN="4">
							Line with an error:<BR>
							<TEXTAREA NAME="ispell_line_area" COLS="40" ROWS="3" WRAP="hard" ONFOCUS="this.blur()"></TEXTAREA>
						</TD>
					</TR>
					<TR VALIGN="MIDDLE">
						<TD ALIGN="RIGHT" WIDTH="25%">
							Error: 
						</TD>
						<TD ALIGN="LEFT" WIDTH="25%">
							<INPUT NAME="ispell_error" SIZE="10" VALUE="" ONFOCUS="this.blur()">
						</TD>
						<TD ALIGN="RIGHT" WIDTH="25%">
							Suggestions:
						</TD>
						<TD ALIGN="LEFT" WIDTH="25%">
							<SELECT NAME="ispell_suggestion" ONCHANGE="if (this.options[this.selectedIndex].value != '_NONE') document.forms[0].ispell_oruse.value=this.options[this.selectedIndex].value">
							<OPTION>Suggestions</OPTION>
							</SELECT>
						</TD>
					</TR>
					<TR>
						<TD ALIGN="right">
							Change to: 
						</TD>
						<TD ALIGN="left">
							<INPUT NAME="ispell_oruse" SIZE="15" VALUE="" ONFOCUS="if(!this.value) this.value=document.forms[0].ispell_error.value">
						</TD>
						<TD ALIGN="right">
							Occurs times:
						</TD>
						<TD ALIGN="left">
							<INPUT NAME="ispell_likethis" SIZE=3 VALUE="" ONFOCUS="this.blur()">
						</TD>
					</TR>
				</TABLE>
			</TD>
		</TR>
		<TR>
			<TD COLSPAN="4"><HR></TD>
		</TR>
		<TR ALIGN="center">
			<TD>
				<INPUT TYPE="button" VALUE="Change" ONCLICK="ispellChange()">
			</TD>
			<TD>
				<INPUT TYPE="button" VALUE="Change all" ONCLICK="ispellChangeAll()">
			</TD>
			<TD>
				<INPUT TYPE="button" VALUE="Ignore" ONCLICK="ispellIgnore()">
			</TD>
			<TD>
				<INPUT TYPE="button" VALUE="Ignore all" ONCLICK="ispellIgnoreAll()">
			</TD>
		</TR>
		<TR>
			<TD COLSPAN="4"><HR></TD>
		</TR>
		<TR>
			<TD COLSPAN="4" ALIGN="center">
				<INPUT TYPE="submit" VALUE="Close and Commit" ONCLICK="if (confirm('The spellcheck is not finished. Really close and commit changes?')) ispellCommitChanges()"> 
				<INPUT TYPE="submit" VALUE="Close and Cancel" ONCLICK="if (confirm('The spellcheck is not finished. Really close and discard changes?')) self.close()">
			</TD>
		</TR>
	</TABLE>
	</FORM>

<?
	} else {
   // AREN'T YOU SUCH A KNOW-IT-ALL!
?>
</HEAD>

<BODY <? echo html_body() ?> ONLOAD="populateIspellForm()">

	<FORM>
	<TABLE WIDTH="100%"	BORDER="0" CELLPADDING="2">
	<TR><TD	ALIGN="CENTER"><B>No spelling errors found.</B></TD></TR>
	<TR><TD><HR></TD></TR>
	<TR><TD	ALIGN="center">
		<P>
			<INPUT TYPE="submit" VALUE="Close" ONCLICK="self.close()">
		</P>
		</TD>
	</TR>
	<TR><TD><HR></TD></TR>
    </TABLE>
    </FORM>
 <?
 }
}
?>
</BODY>
</HTML>

<? mysql_close($conn); ?>