<?
define("PEAR_SESSION_TABLE", SQL_TABLEPREFIX.'sessions');
require_once('DB.php');

function pear_session_open($save_path, $name)
{
  global $pear_session_db;
  $pear_session_db = DB::connect("mysql://".SQL_USER.":".SQL_PASSWORD."@".SQL_HOST."/".SQL_DATABASE);
  if (DB::isError($pear_session_db)) {
      user_error("pear_session: can't open database: "
        . $pear_session_db->getMessage(), E_USER_ERROR);
      die ($pear_session_db->getMessage());
  }
  return !(DB::isError($pear_session_db));
}

function pear_session_close()
{
  return true;
}    

function pear_session_read($sesskey)
{
  global $pear_session_db;
  $sql = "SELECT value FROM " . PEAR_SESSION_TABLE . " WHERE sesskey = '"
       . addslashes($sesskey) . "'";
  $rs = $pear_session_db->query($sql);
  if (DB::isError($rs))
  {
    user_error("pear_session: error reading session $sesskey: "
      . $rs->getMessage(), E_USER_ERROR);
    return false;
  }
  $data = ($row = $rs->fetchRow()) ? $row[0] : "";
  return $data;
}

function pear_session_write($sesskey, $data)
{
  global $pear_session_db;
  $expiry = time() + get_cfg_var("session.gc_maxlifetime");
  $sql = "INSERT INTO " . PEAR_SESSION_TABLE . "(sesskey, expiry, value) "
       . "VALUES('" . addslashes($sesskey) . "', $expiry, '" . addslashes($data)
       . "')";
  $rs = $pear_session_db->query($sql);
  if (DB::isError($rs)) // probably a duplicate error: update existing value
  {
    $sql = "UPDATE " . PEAR_SESSION_TABLE . " SET expiry = $expiry, value = '"
         . addslashes($data) . "' WHERE sesskey = '" . addslashes($sesskey)
         . "'";
    $rs = $pear_session_db->query($sql);
  }
  return !(DB::isError($result));
}

function pear_session_destroy($sesskey)
{
  global $pear_session_db;
  $sql = "DELETE FROM " . PEAR_SESSION_TABLE . " WHERE sesskey = '"
       . addslashes($sesskey) . "'";
  $rs = $pear_session_db->query($sql);
  return !(DB::isError($rs));
}

function pear_session_gc($gc_maxlifetime)
{
  global $pear_session_db;
  $sql = "DELETE FROM " . PEAR_SESSION_TABLE . " WHERE expiry < "
  . time();
  $rs = $pear_session_db->query($sql);
  return !(DB::isError($result));
}

session_set_save_handler(
    "pear_session_open",
    "pear_session_close",
    "pear_session_read",
    "pear_session_write",
    "pear_session_destroy",
    "pear_session_gc");
?>