<?
	/***********************************************************************/
	/* http://wordlog.sourceforge.net        tlupfer@users.sourceforge.net */
	/***********************************************************************/

	/* is_user_admin --> returns if a user is an administrator */
	function is_user_admin() {
		$is_admin = 0;
		$admin = explode("\n",ADMINISTRATORS);
		foreach ($admin as $line) {
			if ($_SESSION[LOGGED_IN] == $line) {
				$is_admin++;
			}
		}
		return $is_admin;
	}

	/* get_directories --> get a relative, recursive directory listing */
	function get_directories($startDir,&$matchArray) {
		$startDir = preg_replace("/[\/]+$/",'',$startDir);
		$handle = opendir($startDir);
		$recurse = array();

		while (false !== ($file = readdir($handle))) {
			if (is_dir($startDir."/".$file) && !preg_match("/^([.]|[.][.])$/",$file)) {
				array_push($matchArray,$startDir."/".$file);
				array_push($recurse,$startDir."/".$file);
			}
		}
		closedir($handle);

		for ($i = 0; $i < count($recurse); $i++) get_directories($recurse[$i],$matchArray);
	}

	/* get_valid_image_directories --> parses a list of directories for valid image containing dirs */
	function get_valid_image_directories($inputArray) {
		$outputArray = array();
		$usedAlready = array();
		$replaceString = preg_replace("/\//",'[\/]',IMAGES_PATH);

		$sql_query = "SELECT * FROM ".SQL_TABLEPREFIX."image_image";
		$sql_result = mysql_query($sql_query);
		while ($sql_entry = mysql_fetch_row($sql_result)) {
			$sql_entry[1] = preg_replace("/[\/]+$/",'',$sql_entry[1]);
			array_push($usedAlready,$sql_entry[1]);
		}

		for ($i = 0; $i < count($inputArray); $i++) {
			$images = 0;
			$handle = openDir($inputArray[$i]);
			while (false !== ($file = readdir($handle))) {
				if (preg_match("/[.](jp(e)?g|png|gif)$/i",$file)) $images++;
			}
			closedir($handle);
			if ($images) {
				$pushValue = preg_replace("/^$replaceString/",'',$inputArray[$i]);
				$pushValue = preg_replace("/[\/]+$/",'',$pushValue);
				$exists = 0;
				for ($k = 0; $k < count($usedAlready); $k++) if ($usedAlready[$k] == $pushValue) $exists++;
				if (!$exists) array_push($outputArray,$pushValue);
			}
		}
		return $outputArray;
	}

	/* how_many_replies --> finds # of replies for id and page */
	function how_many_replies($pid,$current_page) {
		mysql_query("SELECT * FROM ".SQL_TABLEPREFIX."replies WHERE (pid = $pid) AND sourcet = '$current_page'");
		return mysql_affected_rows();
	}

	/* convert_date --> makes a date human readable */
	function convert_date($timestamp) {
		return date(DATE_FORMAT, mktime(substr($timestamp,8,2), substr($timestamp,10,2), substr($timestamp,12,2), substr($timestamp,4,2), substr($timestamp,6,2), substr($timestamp,0,4)));
	}
	
	function convert_short_date($timestamp) {
		return date(DATE_SHORT, mktime(substr($timestamp,8,2), substr($timestamp,10,2), substr($timestamp,12,2), substr($timestamp,4,2), substr($timestamp,6,2), substr($timestamp,0,4)));
	}

	/* delete_replies --> deletes replies */
	function delete_replies($id,$pid,$cid,$sourcet) {
		$sql_result	= mysql_query("SELECT * FROM ".SQL_TABLEPREFIX."replies WHERE (pid = $pid) AND (cid = $cid) AND sourcet = '$sourcet' ORDER BY id ASC");
		mysql_query("DELETE FROM ".SQL_TABLEPREFIX."replies WHERE sourcet = '$sourcet' AND id = $id");
		while ($sql_entry = mysql_fetch_row($sql_result)) delete_replies($sql_entry[0],$sql_entry[1],$sql_entry[0],$sql_entry[3]); 
		return TRUE;
	}

	/* next_reply --> recursive function for printing out replies */
	function next_reply($pid,$cid,$sourcet,$indent) {
		$sql_result	= mysql_query("SELECT * FROM ".SQL_TABLEPREFIX."replies WHERE (pid = $pid) AND (cid = $cid) AND sourcet = '$sourcet' ORDER BY id ASC");
		$found = mysql_affected_rows();

		while ($sql_entry = mysql_fetch_row($sql_result)) {
			$id = $sql_entry[0];
			$pid = $sql_entry[1];
			$cid = $sql_entry[2];
			$sourcet = $sql_entry[3];
			$from_user = $sql_entry[4];
			$host = $sql_entry[5];
			$date = convert_date($sql_entry[6]);

			$message = $sql_entry[7];
			if (FORMAT_WIDTH - $indent < 20) $indent -= 3;

			echo format_wrap("$date (".GENERIC_POSTEDBY." ".'[LINK="users.php?SELECT_USER='.$from_user.'"]'.$from_user.'[/LINK]'.")",$indent),format_blank();
			echo format_wrap($message,$indent);

			if ($_SESSION[LOGGED_IN] && !is_user_admin()) 
				echo format_wrap("[LINK=\"addreply.php?pid=$pid&amp;cid=$id&amp;sourcet=$sourcet\"]".REPLY_TOTHIS."[/LINK]",$indent);
			elseif (is_user_admin())
				echo format_wrap("[LINK=\"addreply.php?pid=$pid&amp;cid=$id&amp;sourcet=$sourcet\"]".REPLY_TOTHIS."[/LINK]"." [[LINK=\"replies.php?delete=$id&amp;pid=$pid&amp;sourcet=$sourcet&amp;DO_IT=1\"]-[/LINK]]",$indent);
			echo format_line();
			next_reply($pid,$id,$sourcet,($indent+3));
		}
		return $found;
	}

	/* ignorecase_sort --> case insensitive sorting */
	function ignorecase_sort(&$xArray,$lower=0,$upper=0)	{
		$xLow=$lower;
		if ($upper==0) $upper=count($xArray)-1;
		$xHigh=$upper;
		if	($upper	<= $lower) return;
		$midPoint = floor(($lower + $upper)/2); 
		$strTemp =	strtolower($xArray[$midPoint]);
		while ($xLow<=$xHigh) {
			while	(strtolower($xArray[$xLow])<$strTemp) {
				$xLow++;
				if ($xLow==$upper) {break;}
			}
			while ($strTemp<strtolower($xArray[$xHigh]))	{
				$xHigh--;
				if	($xHigh==$lower) {break;}
			}
			if ($xLow<=$xHigh) {	
				$strBuffer=$xArray[$xLow];
				$xArray[$xLow]=$xArray[$xHigh];
				$xArray[$xHigh]=$strBuffer;
				$xLow++;
				$xHigh--;
			}
		}
		if	($lower<$xHigh)	ignorecase_sort($xArray,$lower,$xHigh);
		if	($xLow<$upper) ignorecase_sort($xArray,$xLow,$upper);
	}

	/* unhtmlspecialchars --> translates special html characters into text */
	function unhtmlspecialchars($string) {
		$string = strtr($string, array_flip(get_html_translation_table(HTML_ENTITIES)));
		$string = preg_replace("/&#([0-9]+);/me", "chr('\\1')", $string);
		return $string;
	}

?>