<?
	/***********************************************************************/
	/* http://wordlog.sourceforge.net        tlupfer@users.sourceforge.net */
	/***********************************************************************/

	/* format_line --> draw a line */
	function format_line() {
		return "+".str_repeat("-",FORMAT_WIDTH - 2)."+\n";
	}

	/* format_blank --> a blank line */
	function format_blank() {
		return "|".str_repeat(" ",FORMAT_WIDTH - 2)."|\n";
	}

	/* format_wrap --> wordwrap function */
	function format_wrap($text,$indent) {
		$textwrap = array(
			"raw"=>preg_replace("/\015\012?|\012/","\n",strip_tags($text)),
			"width"=>FORMAT_WIDTH - (4 + $indent),
			"html_tags"=>array());
		$textwrap[lines] = explode("\n",$textwrap[raw]);
		
		foreach ($textwrap[lines] as $line) {
			$sub_string = '';

			/* CONVERT SPACES IN LINKS */
			$line = preg_replace("/\[LINK=[^]]*\]/me","stripslashes(str_replace(' ','%20','\\0'))",$line);

			/* SPLIT LINE INTO INDIVIDUAL WORDS */
			$line = preg_replace("/[ ]([^ ])/"," \n$1",$line);
			$line = preg_replace("/([^ ])[ ]/","$1\n ",$line);
			$line = preg_replace("/\[[^]]*\]/","\n\\0\n",$line);
			$words = explode("\n",$line);

			/* SLICE UP EXTRA LONG WORDS */
			if (preg_grep("/.{".$textwrap[width].",}/",$words)) {
				for ($i=0;$i<count($words);$i++) {
					if (html_length($words[$i]) > $textwrap[width]) {
						$words[$i] = unhtmlspecialchars($words[$i]);
						$text = substr($words[$i],0,$textwrap[width]);
						$extra = substr($words[$i],$textwrap[width]);
						$words[$i] = htmlentities($text);
						array_splice($words, $i+1, 0, $extra);
					}
				}
			}
			
			foreach ($words as $word) {

				/* WRAP IF THE LINE IS FULL */
				if (html_length($word.$sub_string) > $textwrap[width]) {

					/* ADD ENDING TAGS */
					foreach (array_reverse($textwrap[html_tags]) as $tag) {
						preg_match("/".WRAP_VALIDTAGS."/",$tag,$endtags);
						if ($endtags[1]) { $sub_string .= '[/'.$endtags[1].']'; }
					}

					$return .= "| ".str_repeat(' ',$indent).$sub_string.str_repeat(' ',$textwrap[width] - html_length($sub_string))." |\n";

					/* RESET THE SUBSTRING AND BEGIN ANY OVERLAPPING TAGS */
					$sub_string = '';
					foreach ($textwrap[html_tags] as $tag) { 
						if ($tag) { $sub_string .= "[".$tag."]"; }
					}
					if (!str_replace(" ",'',$word)) { continue; }
				}
				$sub_string .= $word;

				/* CATCH ANY OPENING TAGS */
				if (preg_match_all(WRAP_STARTTAG,$word,$addtags)) {
					for ($k=0;$k<count($addtags[1]);$k++) {
						array_push($textwrap[html_tags],$addtags[1][$k].$addtags[2][$k]);
					}
				}

				/* CATCH ANY CLOSING TAGS */
				if (preg_match_all("/\[\/".WRAP_VALIDTAGS."\]/",$word,$closetag,PREG_PATTERN_ORDER)) {
					for ($k=(count($closetag[1])-1); $k>=0; $k--) {
						for ($m=(count($textwrap[html_tags])-1);$m>=0;$m--) {
							if (preg_match("/".$closetag[1][$k]."/",$textwrap[html_tags][$m])) {
								$textwrap[html_tags][$m] = '';
								continue(2);
							}
						}
					}
				}

			}
			/* CATCH ANY TAGS THAT WERE NOT CLOSED PROPERLY */
			foreach ($textwrap[html_tags] as $tag) {
				if ($tag) { $sub_string .= "[/".$tag."]"; }
			}

			$return .= "| ".str_repeat(' ',$indent).$sub_string.str_repeat(' ',$textwrap[width] - html_length($sub_string))." |\n";
		}

		/* SUB IN HTML */
		$return = str_replace("[BOLD]","<B>",$return);
		$return = str_replace("[/BOLD]","</B>",$return);
		$return = preg_replace("/[[]LINK=([^\/][^]]+)[]]/","<A HREF=$1>",$return);
		$return = str_replace("[/LINK]","</A>",$return);
		$return = preg_replace("/[[]IMAGEWIN=([^\/][^]]+)[]]/","<A HREF=".html_openwin("$1",525,550).">",$return);
		$return = str_replace("[/IMAGEWIN]","</A>",$return);
		return $return;
	}

	/* format_split --> prints text1 on the left and text2 on the right */
	function format_split($text1,$text2) {
		return format_wrap($text1.str_repeat(' ',(FORMAT_WIDTH - (4 + html_length($text1.$text2)))).$text2,0);
	}

	/* format_trisplit --> left, center, and right */
	function format_trisplit($text1,$text2,$text3) {
		$buffer = array();
		$buffer[total] = FORMAT_WIDTH - 4;
		$buffer[onleft] = sprintf("%d",($buffer[total] - html_length($text2)) / 2);
		$buffer[onright] = $buffer[total] - (html_length($text2)+$buffer[onleft]);

		return format_wrap(
			$text1.str_repeat(' ',$buffer[onleft] - html_length($text1)).
			$text2.
			str_repeat(' ',$buffer[onright] - html_length($text3)).$text3,0);
	}

	/* format_right --> print text all the way to the right */
	function format_right($text) {
		return format_wrap(str_repeat(' ',(FORMAT_WIDTH - (4 + html_length($text)))).$text,0);
	}

	/* format_url --> replaces spaces in urls */
	function format_url($string) {
		return str_replace(" ",'%20',$string);
	}
	
	/* format_repeat --> returns a string repeated x times */
	function format_repeat($string,$times) {
		return str_repeat($string,$times);
	}
?>