﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace WebApplication4.Models
{
    public class DPlatypusRepository : IDPlatypusRepository
    {
        private List<DPlatypus> platypi = new List<DPlatypus>();
        private int _nextId = 1;

        public DPlatypusRepository()
        {
            Add(new DPlatypus { Name = "Donald" });
            Add(new DPlatypus { Name = "GoGo" });
            Add(new DPlatypus { Name = "Patty" });
            Add(new DPlatypus { Name = "Platypup" });
            Add(new DPlatypus { Name = "Platypop" });
            Add(new DPlatypus { Name = "Platymop" });
            Add(new DPlatypus { Name = "Platydude" });
            Add(new DPlatypus { Name = "Platydudette" });
        }

        public IEnumerable<DPlatypus> GetAll()
        {
            return platypi;
        }

        public String Get(int id)
        {
            var item = platypi.Find(p => p.Id == id);
            return item == null ? string.Empty : item.Name;
        }

        public DPlatypus Add(DPlatypus platypus)
        {
            if (platypus == null)
            {
                throw new ArgumentNullException("platypus");
            }
            platypus.Id = _nextId++;
            platypi.Add(platypus);
            return platypus;
        }
    }
}