﻿using System;
using System.Web.UI;
using RedCell.Web;

namespace HttpResponseFilter
{
    /// <summary>
    /// Example page to demonstrate HttpResponseFilter
    /// </summary>
    /// <author>Yvan Rodrigues</author>
    /// <copyright>© 2011 <a href="http://two-red-cells.com">Red Cell Innovation Inc.</a></copyright>
    /// <license>Provided under the terms of the <a href="http://www.codeproject.com/info/cpol10.aspx">Code Project Open License</a>.</license>
    public partial class Default : Page
    {
        /// <summary>
        /// Handles the Load event of the Page control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="EventArgs"/> instance containing the event data.</param>
        protected void Page_Load(object sender, EventArgs e)
        {
            // Add some content from a resource.
            Content.Text = Properties.Resources.Great_Expectations__by_Charles_Dickens;

            if(IsPostBack)
            {
                // Implement a highlighter with one line of code:
                Response.Filter = new HighlightFilter(Response, Needle.Text)
                                      {
                                          IsHtml5 = false, 
                                          MatchCase = MatchCase.Checked, 
                                          MatchWholeWords = MatchWholeWords.Checked, 
                                          UseRegex = UseRegularExpressions.Checked
                                      };

                // Don't try to highlight the search box.
                Needle.Text = string.Empty;
            }
        }
    }
}