<?php
/*
** @access    public
** 
** @param     string    $email    (required)
**            ** E-mail address
** 
** @param     string    $visibleChars    (optional)
**            ** Defines how many or what percentage of
**            ** characters within $user and $domain
**            ** that are displayed. The rest will
**            ** return as $replace
** 
** @param     string    $replace    (optional)
**            ** Defines the symbol(s) to use to mask
**            ** the existing characters from view
** 
** @return    string
*/

function obfuscateEmail($email, $visibleChars = 3, $replace = "*") {
 list($user, $domain) = explode("@", $email);
 $userLen = strlen($user);

 $lastDot = strrpos($domain, ".");
 $prefix = substr($domain, 0, $lastDot);
 $extension = substr($domain, $lastDot);
 $prefixLen = strlen($prefix);

 if (!empty($visibleChars) && substr($visibleChars, strlen($visibleChars) - 1) == "%") {
  $visibleChars = (float) substr($visibleChars, 0, strlen($visibleChars) - 1);
  $visibleChars = $visibleChars * 0.01;
  $userLength = round($visibleChars * $userLen);
  $domainLength = round($visibleChars * $prefixLen);
 } else {
  $userLength = $visibleChars;
  $domainLength = $visibleChars;
 }

 $prefix = substr($prefix, 0, $domainLength);
 $user = substr($user, 0, $userLength);

 $emailAddress = str_pad($user, $userLen, $replace) . "@" . str_pad($prefix, $prefixLen, $replace) . $extension;

 return $emailAddress;
}
?>