﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Text;
using System.IO;
using System.Xml.Serialization;
using System.Web.Optimization;
using System.Configuration;
using System.Web.UI;

/// <summary>
/// Class to handle all the application level settings.
/// </summary>
public class ApplicationSettingsHelper
{
    /// <summary>
    /// This function will add the bundling and minification for the JS and CSS files. 
    /// File names and collection will will in the settings file on server.
    /// </summary>
    public void AddBundling()
    {
        string filePath = String.Empty;
        string bundleName = String.Empty;
        try
        {
            StreamReader reader = new StreamReader(HttpContext.Current.Server.MapPath("~/Settings/FileBundling.xml"));
            XmlSerializer serializer = new XmlSerializer(typeof(Bundling));

            Bundling bundlingInfo = (Bundling)serializer.Deserialize(reader);
            reader.Close();
            reader.Dispose();

            #region Bundling of the css files.
            Bundle cssBundle;

            foreach (Css css in bundlingInfo.Css)
            {
                cssBundle = new Bundle(css.Name);
                foreach (string cssFile in css.Path)
                {
                    cssBundle.Include(cssFile);
                }

                BundleTable.Bundles.Add(cssBundle);
            }

            #endregion

            #region Bundling of the java script files.

            Bundle jsBundle;
            foreach (Js js in bundlingInfo.Js)
            {
                bundleName = js.Name;
                jsBundle = new Bundle(js.Name);
                foreach (string jsFile in js.Path)
                {
                    filePath = jsFile;
                    jsBundle.Include(jsFile);
                }

                BundleTable.Bundles.Add(jsBundle);
            }

            #endregion
        }
        catch (Exception ex)
        {
            throw new Exception("There is a problem while creating Bundle", ex);
        }
    }

    /// <summary>
    /// Enable/Disable js bundling as per debug mode.
    /// </summary>
    /// <param name="bundleName"></param>
    /// <returns></returns>
    public static string AddScriptFromBundle(string bundleName)
    {
        StringBuilder strScript = new StringBuilder();
        if (HttpContext.Current.IsDebuggingEnabled)
        {
            StreamReader reader = new StreamReader(HttpContext.Current.Server.MapPath("~/Settings/FileBundling.xml"));
            XmlSerializer serializer = new XmlSerializer(typeof(Bundling));

            Bundling bundlingInfo = (Bundling)serializer.Deserialize(reader);
            
            reader.Close();
            reader.Dispose();

            foreach (Js js in bundlingInfo.Js)
            {
                if (js.Name.Trim('~') == bundleName)
                {
                    foreach (string jsFile in js.Path)
                    {
                        strScript.Append(String.Format("<script src=\"{0}\" type=\"text/javascript\"></script>", jsFile.Trim('~')));

                    }
                    break;
                }
            }
        }
        else
        {
            strScript.Append(String.Format("<script src=\"{0}\" type=\"text/javascript\"></script>", bundleName));
        }
        return strScript.ToString();
    }

    /// <summary>
    /// Method to register script to the page at bottom of the page.
    /// </summary>
    /// <param name="bundleName"></param>
    /// <param name="varThis"></param>
    /// <param name="scriptKey"></param>
    public static void AddScriptFromBundle(string bundleName, Page varThis, string scriptKey)
    {
        StringBuilder strScript = new StringBuilder();
        if (HttpContext.Current.IsDebuggingEnabled)
        {
            StreamReader reader = new StreamReader(HttpContext.Current.Server.MapPath("~/Settings/FileBundling.xml"));
            XmlSerializer serializer = new XmlSerializer(typeof(Bundling));

            Bundling bundlingInfo = (Bundling)serializer.Deserialize(reader);

            reader.Close();
            reader.Dispose();

            foreach (Js js in bundlingInfo.Js)
            {
                if (js.Name.Trim('~') == bundleName)
                {
                    foreach (string jsFile in js.Path)
                    {
                        strScript.Append(String.Format("<script src=\"{0}?v=" + ConfigurationManager.AppSettings["ScriptVersion"] + "\" type=\"text/javascript\"></script>", jsFile.Trim('~')));

                    }
                    break;
                }
            }
        }
        else
        {
            strScript.Append(String.Format("<script src=\"{0}?v=" + ConfigurationManager.AppSettings["ScriptVersion"] + "\" type=\"text/javascript\"></script>", bundleName));
        }

        varThis.ClientScript.RegisterStartupScript(varThis.GetType(), scriptKey, strScript.ToString());
    }
}