﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using LoginScreenDemo.ViewModel;
using LoginScreenDemo.Business;
using System.Web.Routing;
using System.Web.Security;

namespace LoginScreenDemo.Controllers
{
    public class HomeController : Controller
    {
        LoginManager loginManeger;

        public HomeController()
        {
            loginManeger = new LoginManager();
        }

        public ActionResult Index()
        {

            return View();
        }

        public ActionResult Login()
        {
            return View();
        }


        [HttpPost]
        public ActionResult Login(LoginVM loginVM)
        {
            try
            {
                string redirectUrl = string.Empty;

                if (!ModelState.IsValid)
                    return PartialView("Login", loginVM);

                bool result = loginManeger.ValidateLogin(loginVM);

                if (result)
                {
                    FormsAuthentication.SetAuthCookie(loginVM.LoginName, false);
                    Session["LoginName"] = loginVM.LoginName;
                    Session["Role"] = loginManeger.RollName;
                    return Content("1");
                }
                else
                {
                    redirectUrl = @Url.Action("Index", "Home");
                    ModelState.AddModelError("", "Invalid user name and password!");
                    return PartialView("Login", loginVM);
                }
            }
            catch (Exception ex)
            {
                return Content(ex.Message.ToString());
            }
        }

        [Authorize]
        public ActionResult Logout()
        {
            FormsAuthentication.SignOut();
            Session["LoginName"] = null;
            Session["Role"] = null;
            return RedirectToAction("Index");
        }

        [Authorize]
        public ActionResult SiteMap()
        {
            return View();
        }

    }
}
