﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Web;

namespace StudentManagement.Models
{
    /// <summary>
    /// View Model Class for Course
    /// </summary>
    public class Course
    {
        private int _branchId;
        [Key]
        [DatabaseGeneratedAttribute(DatabaseGeneratedOption.Identity)]
        public int CourseId { get; set; }
        [Required]
        [Display(Name = "Branch")]
        public int BranchId { get { return _branchId; } set { _branchId = value; if( value > 0) GetBranchName(); } }
        /// <summary>
        /// Don't add to database table
        /// </summary>
        [NotMapped]
        [Display(Name = "Branch")]
        public string BranchName { get; set; }
        [Required]
        public string Name { get; set; }
        [Required]
        [RegularExpression("^[A-Z]{2,5}$", ErrorMessage = "Short Name should contains only alpha upper case letters and length should be in 2 to 5 letters")]
        [Display(Name = "Short Name")]
        public string ShortName { get; set; }
        [DataType(DataType.MultilineText)]
        public string Description { get; set; }

        private void GetBranchName()
        {
            var context = new AdminContext();
            var branch = context.Branches.Find(_branchId);
            if (branch != null)
                BranchName = branch.Name;
            context.Dispose();
        }
        
    }

   
}