﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using StudentManagement.Models;

namespace StudentManagement.Controllers
{

    /// <summary>
    /// Controller for Student Information Management
    /// </summary>
    public class StudentController : Controller
    {
        private AdminContext db = new AdminContext();

        //
        // GET: /Student/
        /// <summary>
        /// Action for Student list view
        /// </summary>
        /// <returns></returns>
        public ActionResult Index()
        {
            return View(db.Students.ToList());
        }

        //
        // GET: /Student/Details/5
        /// <summary>
        /// Action for student information page
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public ActionResult Details(int id = 0)
        {
            Student student = db.Students.Find(id);
            if (student == null)
            {
                return HttpNotFound();
            }
            return View(student);
        }

        //
        // GET: /Student/Create
        /// <summary>
        /// Action for student creation
        /// </summary>
        /// <returns></returns>
        public ActionResult Create()
        {
            LoadDropDownList();
            return View();
        }

        //
        // POST: /Student/Create

        [HttpPost]
        public ActionResult Create(Student student)
        {
            if (ModelState.IsValid)
            {
                db.Students.Add(student);
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            LoadDropDownList();
            return View(student);
        }

        //
        // GET: /Student/Edit/5
        /// <summary>
        /// Action for Student information updation
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public ActionResult Edit(int id = 0)
        {
            Student student = db.Students.Find(id);
            if (student == null)
            {
                return HttpNotFound();
            }
            LoadDropDownList(student.BranchId,student.CourseId);
            return View(student);
        }

        //
        // POST: /Student/Edit/5
        /// <summary>
        /// Action for student information updation
        /// </summary>
        /// <param name="student"></param>
        /// <returns></returns>
        [HttpPost]
        public ActionResult Edit(Student student)
        {
            if (ModelState.IsValid)
            {
                db.Entry(student).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            LoadDropDownList();
            return View(student);
        }

        //
        // GET: /Student/Delete/5
        /// <summary>
        /// Action for remove the student information from the database
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public ActionResult Delete(int id = 0)
        {
            Student student = db.Students.Find(id);
            if (student == null)
            {
                return HttpNotFound();
            }
            return View(student);
        }

        //
        // POST: /Student/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {
            Student student = db.Students.Find(id);
            db.Students.Remove(student);
            db.SaveChanges();
            return RedirectToAction("Index");
        }
        public ActionResult GetCourses(int id=0)
        {
            var courses = db.Courses.ToList<Course>().Where(x=> x.BranchId == id).Select(x => new SelectListItem { Text = x.Name, Value = x.CourseId.ToString() });
            return Json(courses.ToList<SelectListItem>(), JsonRequestBehavior.AllowGet);
        }

        /// <summary>
        /// Load the drop down list for Branches and Courses
        /// </summary>
        private void LoadDropDownList()
        {
            ViewBag.Branches = db.Branches.ToList<Branch>().Select(x => new SelectListItem { Text = x.Name, Value = x.BranchId.ToString() });
            ViewBag.Courses = new[] { new SelectListItem() };//db.Courses.ToList<Course>().Select(x => new SelectListItem { Text = x.Name, Value = x.CourseId.ToString() });
        }
        /// <summary>
        /// Load the drop down list for Branches and Courses
        /// </summary>
        private void LoadDropDownList(int branchId,int courseId)
        {
            ViewBag.Branches = db.Branches.ToList<Branch>().Select(x => new SelectListItem { Text = x.Name, Value = x.BranchId.ToString() });
            var courses = db.Courses.ToList<Course>().Where(x => x.BranchId == branchId).Select(x => new SelectListItem {Selected=(x.CourseId == courseId),Text = x.Name, Value = x.CourseId.ToString() });
            ViewBag.Courses = courses;//db.Courses.ToList<Course>().Select(x => new SelectListItem { Text = x.Name, Value = x.CourseId.ToString() });
        }
        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
       
        
    }
}