﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using StudentManagement.Models;

namespace StudentManagement.Controllers
{
    /// <summary>
    /// Controller for Course configuration
    /// </summary>
    public class CourseController : Controller
    {
        private AdminContext db = new AdminContext();

        //
        // GET: /Course/
        /// <summary>
        /// Action for course list view
        /// </summary>
        /// <returns></returns>
        public ActionResult Index()
        {
            //LoadBranches();
            return View(db.Courses.ToList());
        }

        //
        // GET: /Course/Details/5
        /// <summary>
        /// Action for course details view.
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public ActionResult Details(int id = 0)
        {
            Course course = db.Courses.Find(id);
            if (course == null)
            {
                return HttpNotFound();
            }
            LoadBranches();
            return View(course);
        }

        //
        // GET: /Course/Create
        /// <summary>
        /// Action for course creation
        /// </summary>
        /// <returns></returns>
        public ActionResult Create()
        {
            LoadBranches();
            return View();
        }

        //
        // POST: /Course/Create
        /// <summary>
        /// Action for course creation
        /// </summary>
        /// <param name="course"></param>
        /// <returns></returns>
        [HttpPost]
        public ActionResult Create(Course course)
        {
            if (ModelState.IsValid)
            {
                db.Courses.Add(course);
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            LoadBranches();
            return View(course);
        }

        //
        // GET: /Course/Edit/5
        /// <summary>
        /// Action for course information updation
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public ActionResult Edit(int id = 0)
        {
            Course course = db.Courses.Find(id);
            if (course == null)
            {
                return HttpNotFound();
            }
            LoadBranches();
            return View(course);
        }

        //
        // POST: /Course/Edit/5
        /// <summary>
        /// Action for course information updation
        /// </summary>
        /// <param name="course"></param>
        /// <returns></returns>
        [HttpPost]
        public ActionResult Edit(Course course)
        {
            if (ModelState.IsValid)
            {
                db.Entry(course).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            LoadBranches();
            return View(course);
        }

        /// <summary>
        /// Load all available branches
        /// </summary>
        private void LoadBranches()
        {
            ViewBag.Branches = db.Branches.ToList<Branch>().Select(x => new SelectListItem { Text = x.Name, Value = x.BranchId.ToString() });
        }

        //
        // GET: /Course/Delete/5
        /// <summary>
        /// Remove the course information from the database
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public ActionResult Delete(int id = 0)
        {
            Course course = db.Courses.Find(id);
            if (course == null)
            {
                return HttpNotFound();
            }
            return View(course);
        }

        //
        // POST: /Course/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {
            Course course = db.Courses.Find(id);
            db.Courses.Remove(course);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }

       
    }
}