<?php 

# index.php
#######################################
# Whois Lookup  2010 Scott Connell
# Created: 2010/12/26 (year/month/day) 
# Updated: 2012/10/05
# License: Free for personal and commercial use.
# Terms: Redistribution/republishing strictly forbidden.
# Source: http://www.scottconnell.com
#######################################

# SET VARIABLES #################################
# Set the full path to this directory with trailing slash /.

$full_path = "c:/scott/source/whois_lookup/";

# END SETTING VARIABLES ###################

$header_path = $full_path . "header.php";
$footer_path = $full_path . "footer.php";

$definitions = array();
$servers = @file($full_path . "/whois-lookup-list.txt");

foreach($servers as $server)
{
list($dot,$whois) = explode(" = ", trim($server));
$definitions[$dot] = array(explode(", ", $whois));
}

function printForm()
{
global $keyword,$ext,$definitions;

$action = htmlspecialchars($_SERVER["PHP_SELF"]);

print <<<ENDHTM
<form method="post" action="$action">
<p>Keyword <input type="text" name="keyword" value="$keyword" /> . <select name="ext">
ENDHTM;

foreach($definitions as $key => $value)
{
	if($key == $ext)
	{
	print "<option value=\"$key\" selected=\"selected\">$key</option>\n";
	}
	else
	{
	print "<option value=\"$key\">$key</option>\n";
	}
}

print <<<ENDHTM
</select> <input type="submit" value="Submit" /></p>
</form>
ENDHTM;
}

if(isset($_POST['keyword']) && strlen($_POST['keyword']) > 0)
{
$keyword = $_POST['keyword'];
$ext = $_POST['ext'];

	if(strlen($keyword) < 2)
	{
	$title = "Error: The keyword \"$keyword\" is too short.";
	include_once($header_path);
	printForm();
	exit(include_once($footer_path));
	}
	if(strlen($keyword) > 63)
	{
	$title = "Error: The keyword is too long. Max 63 characters. You have ". strlen($keyword) ." characters.";
	include_once($header_path);
	printForm();
	exit(include_once($footer_path));
	}
	if(!preg_match("/^[a-zA-Z0-9\-]+$/", $keyword))
	{
	$title = "Error: Keyword cannot contain special characters.";
	include_once($header_path);
	printForm();
	exit(include_once($footer_path));
	}
	if(preg_match("/^-|-$/", $keyword))
	{
	$title = "Error: Keywords cannot begin, or end with a hyphen.";
	include_once($header_path);
	printForm();
	exit(include_once($footer_path));
	}

$server = $definitions[$ext][0][0];

	if(!$server_conn = @fsockopen($server, 43))
	{
		if(isset($definitions[$ext][0][1]))
		{
		$server = $definitions[$ext][0][1];
		
			if(!$server_conn = @fsockopen($server, 43))
			{
			$title = "Error: Could not connect to either whois server at: ". $definitions[$ext][0][0] ."/". $definitions[$ext][0][1];
			include_once($header_path);
			printForm();
			exit(include_once($footer_path));
			}
		}
		else
		{
		$title = "Error: Could not connect to whois server at: ". $definitions[$ext][0][0];
		include_once($header_path);
		printForm();
		exit(include_once($footer_path));
		}
	}

	if($ext=="com" || $ext=="net")
	{
	fputs($server_conn, "$keyword.$ext\n");

		while(!feof($server_conn))
		{
		$temp = fgets($server_conn,128);

			if(preg_match("/Whois Server:/", $temp))
			{
			$server = str_replace("Whois Server: ", "", $temp);
			$server = trim($server);
			}
		}

	fclose($server_conn);

		if(!$server_conn = @fsockopen($server, 43))
		{
		$title = "Error: Could not connect to whois server at: ". $server;
		include_once($header_path);
		printForm();
		exit(include_once($footer_path));
		}
	}

$title = "Whois Lookup";
include_once($header_path);
printForm();

$response = "";

fputs($server_conn, "$keyword.$ext\r\n");

	while(!feof($server_conn))
	{
	$response .= fgets($server_conn, 128);
	}

fclose($server_conn);

print "<p class=\"pre\"><b>Whois</b> query information for $keyword.$ext</p>\n";

print "<p>\n";

$response = explode("\n", $response);

	foreach($response as $line)
	{
	print "$line<br />\n";
	}

print "</p>";
}
else
{
$title = "Whois Lookup";
include_once($header_path);
printForm();
}

include_once($footer_path);

?>
