<?php 

# index.php
#######################################
# HTTP Viewer  2010 Scott Connell
# Created: 2010/12/26 (year/month/day)
# Updated: 2012/10/05
# License: Free for personal and commercial use.
# Terms: Redistribution/republishing strictly forbidden.
# Source: http://www.scottconnell.com
#######################################

# SET VARIABLES ##########################
# Set the full path to this directory with trailing slash /.

$full_path = "c:/scott/source/http_viewer/";

# END SETTING VARIABLES ###################

$header_path = $full_path . "header.php";
$footer_path = $full_path . "footer.php";

function printForm()
{
global $domain,$options;

	if(!isset($domain))
	{
	$domain = "http://";
	}

$action = htmlspecialchars($_SERVER["PHP_SELF"]);

print <<<ENDHTM
<form method="post" action="$action">
<p>URL <input type="text" name="www" size="30" value="$domain" /></p>
<p>Method <select name="methods">
ENDHTM;

	foreach($options as $o)
	{
	print "<option value=\"$o\">$o</option>\n";
	}

print <<<ENDHTM
</select></p>
<p><input type="submit" value="Submit" /></p>
</form>

ENDHTM;
}

function fetchURL($o)
{
global $domain;

$xHost = parse_url($domain, PHP_URL_HOST);

	if(!$xPath = @parse_url($domain, PHP_URL_PATH))
	{
	$xPath = "/";
	}

	if(!$xQuery = @parse_url($domain, PHP_URL_QUERY))
	{
	$xPage = $xPath;
	}
	else
	{
	$xPage = $xPath . "?" . $xQuery;
	}

	$open_socket = @fsockopen($xHost, "80", $errno, $errstr, 30);

	if($open_socket)
	{
	$message = $o ." ". $xPage . " HTTP/1.1\r\n";
	$message .= "Host: $xHost\r\n";
	$message .= "User-Agent: " . $_SERVER["HTTP_USER_AGENT"] . "\r\n";
	$message .= "Connection: close\r\n\r\n";

	fputs($open_socket, "$message\n");

  	$response = "";

 		while ($read_text = fgets($open_socket, 4096)) 
		{
		$response .= htmlspecialchars($read_text, ENT_QUOTES);
		}

	return $response;
	}
}

$options = array('GET','HEAD','POST','OPTIONS','TRACE','BASELINE_CONTROL','CHECKIN',
'CHECKOUT','CONNECT','COPY','DELETE','INVALID','LABEL','LOCK','MERGE','MKACTIVITY','MKCOL',
'MKWORKSPACE','MOVE','PATCH','PROPFIND','PROPPATCH','PUT','REPORT','UNCHECKOUT','UNLOCK',
'UPDATE','VERSION_CONTROL');

if(isset($_REQUEST['www']))
{
$domain = $_REQUEST['www'];

	if(!$xHost = parse_url($domain, PHP_URL_HOST))
	{
	$title = "Error: Could not parse URL";
	include_once($header_path);
	printForm();
	exit(include_once($footer_path));
	}

	if(!$fp = @fsockopen($xHost, 80, $errno, $errstr, 30))
	{
	$title = "Error: Could not connect to $xHost";
	include_once($header_path);
	printForm();
	exit(include_once($footer_path));
	}
	else
	{
	$title = "HTTP Viewer";
	include_once($header_path);
	printForm();

	$result = fetchURL($_REQUEST['methods']);	
	print "<h2>". $_REQUEST['methods'] ." Request</h2>\n";
	print "<pre>$result</pre>\n\n";
	}
}
else
{
$title = "HTTP Viewer";
include_once($header_path);
printForm();
}

include_once($footer_path);

?>
