var assert = require('assert'),
    math = require('../../../index')();

describe('map', function() {

  it('should apply map to all elements of the matrix', function() {
    var m = math.matrix([[1,2,3], [4,5,6]]);
    var m2 = math.map(m, function (value) { return value * 2; });
    assert.deepEqual(m2.valueOf(), [[2,4,6],[8,10,12]]);
    assert.ok(m2 instanceof math.type.Matrix);
  });

  it('should apply deep-map to all elements in the array', function() {
    var arr = [[1,2,3], [4,5,6]];
    var arr2 = math.map(arr, function (value) { return value * 2; });
    assert.deepEqual(arr2, [[2,4,6],[8,10,12]]);
    assert.ok(Array.isArray(arr2));
  });

  it('should invoke callback with parameters value, index, obj', function() {
    var arr = [[1,2,3], [4,5,6]];

    assert.deepEqual(math.map(arr, function (value, index, obj) {
      return math.clone([value, index, obj === arr]);
    }).valueOf(), [
      [
        [1, [0, 0], true ],
        [2, [0, 1], true ],
        [3, [0, 2], true ]
      ],
      [
        [4, [1, 0], true ],
        [5, [1, 1], true ],
        [6, [1, 2], true ]
      ]
    ]);

  });

  it('should throw an error if called with unsupported type', function() {
    assert.throws(function() { math.map(1, function() {}) });
    assert.throws(function() { math.map('arr', function() {}) });
  });

  it('should throw an error if called with invalid number of arguments', function() {
    assert.throws(function() { math.map([1, 2, 3]) });
  });

});