/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 0.17.1
 * @date    2013-12-19
 *
 * @license
 * Copyright (C) 2013 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(e){"object"==typeof exports?module.exports=e():"function"==typeof define&&define.amd?define(e):"undefined"!=typeof window?window.mathjs=e():"undefined"!=typeof global?global.mathjs=e():"undefined"!=typeof self&&(self.mathjs=e())}(function(){var e;return function n(e,t,r){function i(a,s){if(!t[a]){if(!e[a]){var u="function"==typeof require&&require;if(!s&&u)return u(a,!0);if(o)return o(a,!0);throw new Error("Cannot find module '"+a+"'")}var c=t[a]={exports:{}};e[a][0].call(c.exports,function(n){var t=e[a][1][n];return i(t?t:n)},c,c.exports,n,e,t,r)}return t[a].exports}for(var o="function"==typeof require&&require,a=0;a<r.length;a++)i(r[a]);return i}({1:[function(e,n){n.exports=e("./lib/math.js")},{"./lib/math.js":202}],2:[function(e,n){n.exports=function(n){function t(e){if(!(this instanceof t))throw new SyntaxError("Selector constructor must be called with the new operator");this.value=e instanceof t?e.value:e}function r(e,n){var r=Array.prototype.slice;t.prototype[e]="function"==typeof n?function(){var e=[this.value].concat(r.call(arguments,0));return new t(n.apply(this,e))}:new t(n)}var i=e("../util/string");t.prototype.done=function(){return this.value},t.prototype.valueOf=function(){return this.value},t.prototype.toString=function(){return i.format(this.value)},t.createProxy=r;for(var o in n)n.hasOwnProperty(o)&&o&&r(o,n[o]);return t}},{"../util/string":216}],3:[function(e,n){n.exports=function(n){var t=e("./type/Complex");n.pi=Math.PI,n.e=Math.E,n.tau=2*Math.PI,n.i=new t(0,1),n.Infinity=1/0,n.NaN=0/0,n["true"]=!0,n["false"]=!1,n.E=Math.E,n.LN2=Math.LN2,n.LN10=Math.LN10,n.LOG2E=Math.LOG2E,n.LOG10E=Math.LOG10E,n.PI=Math.PI,n.SQRT1_2=Math.SQRT1_2,n.SQRT2=Math.SQRT2}},{"./type/Complex":203}],4:[function(e,n){function t(e){if(!(this instanceof t))throw new SyntaxError("Parser constructor must be called with the new operator");this.math=e,this.scope=new r(e)}var r=e("./Scope");t.prototype.parse=function(e){return this.math.parse(e,this.scope)},t.prototype.eval=function(e){var n=this.math.parse(e,this.scope);return n.eval()},t.prototype.get=function(e){return this.scope.get(e)},t.prototype.set=function(e,n){return this.scope.set(e,n)},t.prototype.remove=function(e){this.scope.remove(e)},t.prototype.clear=function(){this.scope.clear()},n.exports=t},{"./Scope":5}],5:[function(e,n){function t(e,n,r){this.math=e,this.parentScope=null,this.subScopes=null,this.symbols={},this.cache={},n&&(n instanceof t?this.parentScope=n:n instanceof Object&&(this.symbols=n)),r&&r instanceof Object&&(this.symbols=r)}var r=e("../type/Unit");t.prototype={createSubScope:function(){var e=new t(this.math,this);return this.subScopes||(this.subScopes=[]),this.subScopes.push(e),e},get:function(e){var n;if(n=this.symbols[e],void 0!==n)return n;var t=this.cache[e];if(t)return t[e];for(var i=this.parentScope;i;){if(n=i.symbols[e],void 0!==n)return this.cache[e]=i.symbols,n;i=i.parentScope}return n=this.math[e],void 0!==n?(this.cache[e]=this.math,n):r.isPlainUnit(e)?(n=new r(null,e),this.cache[e]={},this.cache[e][e]=n,n):void 0},has:function(e){return void 0!==this.symbols[e]},set:function(e,n){return this.symbols[e]=n},remove:function(e){delete this.symbols[e]},clear:function(){var e=this.symbols;for(var n in e)e.hasOwnProperty(n)&&delete e[n];if(this.subScopes)for(var t=this.subScopes,r=0,i=t.length;i>r;r++)t[r].clear();this.clearCache()},clearCache:function(){this.cache={}}},t.context=[],n.exports=t},{"../type/Unit":208}],6:[function(e,n){n.exports={name:"Infinity",category:"Constants",syntax:["Infinity"],description:"Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",examples:["Infinity","1 / 0"],seealso:[]}},{}],7:[function(e,n){n.exports={name:"LN10",category:"Constants",syntax:["LN10"],description:"Returns the natural logarithm of 10, approximately equal to 2.302",examples:["LN10","log(10)"],seealso:[]}},{}],8:[function(e,n){n.exports={name:"LN2",category:"Constants",syntax:["LN2"],description:"Returns the natural logarithm of 2, approximately equal to 0.693",examples:["LN2","log(2)"],seealso:[]}},{}],9:[function(e,n){n.exports={name:"LOG10E",category:"Constants",syntax:["LOG10E"],description:"Returns the base-10 logarithm of E, approximately equal to 0.434",examples:["LOG10E","log(e, 10)"],seealso:[]}},{}],10:[function(e,n){n.exports={name:"LOG2E",category:"Constants",syntax:["LOG2E"],description:"Returns the base-2 logarithm of E, approximately equal to 1.442",examples:["LOG2E","log(e, 2)"],seealso:[]}},{}],11:[function(e,n){n.exports={name:"NaN",category:"Constants",syntax:["NaN"],description:"Not a number",examples:["NaN","0 / 0"],seealso:[]}},{}],12:[function(e,n){n.exports={name:"SQRT1_2",category:"Constants",syntax:["SQRT1_2"],description:"Returns the square root of 1/2, approximately equal to 0.707",examples:["SQRT1_2","sqrt(1/2)"],seealso:[]}},{}],13:[function(e,n){n.exports={name:"SQRT2",category:"Constants",syntax:["SQRT2"],description:"Returns the square root of 2, approximately equal to 1.414",examples:["SQRT2","sqrt(2)"],seealso:[]}},{}],14:[function(e,n){n.exports={name:"e",category:"Constants",syntax:["e"],description:"Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",examples:["e","e ^ 2","exp(2)","log(e)"],seealso:["exp"]}},{}],15:[function(e,n){n.exports={name:"false",category:"Constants",syntax:["false"],description:"Boolean value false",examples:["false"],seealso:["true"]}},{}],16:[function(e,n){n.exports={name:"i",category:"Constants",syntax:["i"],description:"Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",examples:["i","i * i","sqrt(-1)"],seealso:[]}},{}],17:[function(e,n){n.exports={name:"pi",category:"Constants",syntax:["pi"],description:"The number pi is a mathematical constant that is the ratio of a circle's circumference to its diameter, and is approximately equal to 3.14159",examples:["pi","sin(pi/2)"],seealso:["tau"]}},{}],18:[function(e,n){n.exports={name:"tau",category:"Constants",syntax:["pi"],description:"Tau is the ratio constant of a circle's circumference to radius, equal to 2 * pi, approximately 6.2832.",examples:["tau","2 * pi"],seealso:["pi"]}},{}],19:[function(e,n){n.exports={name:"true",category:"Constants",syntax:["true"],description:"Boolean value true",examples:["true"],seealso:["false"]}},{}],20:[function(e,n){n.exports={name:"abs",category:"Arithmetic",syntax:["abs(x)"],description:"Compute the absolute value.",examples:["abs(3.5)","abs(-4.2)"],seealso:["sign"]}},{}],21:[function(e,n){n.exports={name:"add",category:"Operators",syntax:["x + y","add(x, y)"],description:"Add two values.",examples:["2.1 + 3.6","ans - 3.6","3 + 2i",'"hello" + " world"',"3 cm + 2 inch"],seealso:["subtract"]}},{}],22:[function(e,n){n.exports={name:"ceil",category:"Arithmetic",syntax:["ceil(x)"],description:"Round a value towards plus infinity.If x is complex, both real and imaginary part are rounded towards plus infinity.",examples:["ceil(3.2)","ceil(3.8)","ceil(-4.2)"],seealso:["floor","fix","round"]}},{}],23:[function(e,n){n.exports={name:"cube",category:"Arithmetic",syntax:["cube(x)"],description:"Compute the cube of a value. The cube of x is x * x * x.",examples:["cube(2)","2^3","2 * 2 * 2"],seealso:["multiply","square","pow"]}},{}],24:[function(e,n){n.exports={name:"divide",category:"Operators",syntax:["x / y","divide(x, y)"],description:"Divide two values.",examples:["2 / 3","ans * 3","4.5 / 2","3 + 4 / 2","(3 + 4) / 2","18 km / 4.5"],seealso:["multiply"]}},{}],25:[function(e,n){n.exports={name:"edivide",category:"Operators",syntax:["x ./ y","edivide(x, y)"],description:"divide two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a ./ b"],seealso:["multiply","emultiply","divide"]}},{}],26:[function(e,n){n.exports={name:"emultiply",category:"Operators",syntax:["x .* y","emultiply(x, y)"],description:"multiply two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a .* b"],seealso:["multiply","divide","edivide"]}},{}],27:[function(e,n){n.exports={name:"epow",category:"Operators",syntax:["x .^ y","epow(x, y)"],description:"Calculates the power of x to y element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","a .^ 2"],seealso:["pow"]}},{}],28:[function(e,n){n.exports={name:"equal",category:"Operators",syntax:["x == y","equal(x, y)"],description:"Check equality of two values. Returns 1 if the values are equal, and 0 if not.",examples:["2+2 == 3","2+2 == 4","a = 3.2","b = 6-2.8","a == b","50cm == 0.5m"],seealso:["unequal","smaller","larger","smallereq","largereq"]}},{}],29:[function(e,n){n.exports={name:"exp",category:"Arithmetic",syntax:["exp(x)"],description:"Calculate the exponent of a value.",examples:["exp(1.3)","e ^ 1.3","log(exp(1.3))","x = 2.4","(exp(i*x) == cos(x) + i*sin(x))   # Euler's formula"],seealso:["square","multiply","log"]}},{}],30:[function(e,n){n.exports={name:"fix",category:"Arithmetic",syntax:["fix(x)"],description:"Round a value towards zero.If x is complex, both real and imaginary part are rounded towards zero.",examples:["fix(3.2)","fix(3.8)","fix(-4.2)","fix(-4.8)"],seealso:["ceil","floor","round"]}},{}],31:[function(e,n){n.exports={name:"floor",category:"Arithmetic",syntax:["floor(x)"],description:"Round a value towards minus infinity.If x is complex, both real and imaginary part are rounded towards minus infinity.",examples:["floor(3.2)","floor(3.8)","floor(-4.2)"],seealso:["ceil","fix","round"]}},{}],32:[function(e,n){n.exports={name:"gcd",category:"Arithmetic",syntax:["gcd(a, b)","gcd(a, b, c, ...)"],description:"Compute the greatest common divisor.",examples:["gcd(8, 12)","gcd(-4, 6)","gcd(25, 15, -10)"],seealso:["lcm","xgcd"]}},{}],33:[function(e,n){n.exports={name:"larger",category:"Operators",syntax:["x > y","larger(x, y)"],description:"Check if value x is larger than y. Returns 1 if x is larger than y, and 0 if not.",examples:["2 > 3","5 > 2*2","a = 3.3","b = 6-2.8","(a > b)","(b < a)","5 cm > 2 inch"],seealso:["equal","unequal","smaller","smallereq","largereq"]}},{}],34:[function(e,n){n.exports={name:"largereq",category:"Operators",syntax:["x >= y","largereq(x, y)"],description:"Check if value x is larger or equal to y. Returns 1 if x is larger or equal to y, and 0 if not.",examples:["2 > 1+1","2 >= 1+1","a = 3.2","b = 6-2.8","(a > b)"],seealso:["equal","unequal","smallereq","smaller","largereq"]}},{}],35:[function(e,n){n.exports={name:"lcm",category:"Arithmetic",syntax:["lcm(x, y)"],description:"Compute the least common multiple.",examples:["lcm(4, 6)","lcm(6, 21)","lcm(6, 21, 5)"],seealso:["gcd"]}},{}],36:[function(e,n){n.exports={name:"log",category:"Arithmetic",syntax:["log(x)","log(x, base)"],description:"Compute the logarithm of a value. If no base is provided, the natural logarithm of x is calculated. If base if provided, the logarithm is calculated for the specified base. log(x, base) is defined as log(x) / log(base).",examples:["log(3.5)","a = log(2.4)","exp(a)","10 ^ 3","log(1000, 10)","log(1000) / log(10)","b = logb(1024, 2)","2 ^ b"],seealso:["exp","log10"]}},{}],37:[function(e,n){n.exports={name:"log10",category:"Arithmetic",syntax:["log10(x)"],description:"Compute the 10-base logarithm of a value.",examples:["log10(1000)","10 ^ 3","log10(0.01)","log(1000) / log(10)","log(1000, 10)"],seealso:["exp","log"]}},{}],38:[function(e,n){n.exports={name:"mod",category:"Operators",syntax:["x % y","x mod y","mod(x, y)"],description:"Calculates the modulus, the remainder of an integer division.",examples:["7 % 3","11 % 2","10 mod 4","function isOdd(x) = x % 2","isOdd(2)","isOdd(3)"],seealso:[]}},{}],39:[function(e,n){n.exports={name:"multiply",category:"Operators",syntax:["x * y","multiply(x, y)"],description:"multiply two values.",examples:["2.1 * 3.6","ans / 3.6","2 * 3 + 4","2 * (3 + 4)","3 * 2.1 km"],seealso:["divide"]}},{}],40:[function(e,n){n.exports={name:"pow",category:"Operators",syntax:["x ^ y","pow(x, y)"],description:"Calculates the power of x to y, x^y.",examples:["2^3 = 8","2*2*2","1 + e ^ (pi * i)"],seealso:["unequal","smaller","larger","smallereq","largereq"]}},{}],41:[function(e,n){n.exports={name:"round",category:"Arithmetic",syntax:["round(x)","round(x, n)"],description:"round a value towards the nearest integer.If x is complex, both real and imaginary part are rounded towards the nearest integer. When n is specified, the value is rounded to n decimals.",examples:["round(3.2)","round(3.8)","round(-4.2)","round(-4.8)","round(pi, 3)","round(123.45678, 2)"],seealso:["ceil","floor","fix"]}},{}],42:[function(e,n){n.exports={name:"sign",category:"Arithmetic",syntax:["sign(x)"],description:"Compute the sign of a value. The sign of a value x is 1 when x>1, -1 when x<0, and 0 when x=0.",examples:["sign(3.5)","sign(-4.2)","sign(0)"],seealso:["abs"]}},{}],43:[function(e,n){n.exports={name:"smaller",category:"Operators",syntax:["x < y","smaller(x, y)"],description:"Check if value x is smaller than value y. Returns 1 if x is smaller than y, and 0 if not.",examples:["2 < 3","5 < 2*2","a = 3.3","b = 6-2.8","(a < b)","5 cm < 2 inch"],seealso:["equal","unequal","larger","smallereq","largereq"]}},{}],44:[function(e,n){n.exports={name:"smallereq",category:"Operators",syntax:["x <= y","smallereq(x, y)"],description:"Check if value x is smaller or equal to value y. Returns 1 if x is smaller than y, and 0 if not.",examples:["2 < 1+1","2 <= 1+1","a = 3.2","b = 6-2.8","(a < b)"],seealso:["equal","unequal","larger","smaller","largereq"]}},{}],45:[function(e,n){n.exports={name:"sqrt",category:"Arithmetic",syntax:["sqrt(x)"],description:"Compute the square root value. If x = y * y, then y is the square root of x.",examples:["sqrt(25)","5 * 5","sqrt(-1)"],seealso:["square","multiply"]}},{}],46:[function(e,n){n.exports={name:"square",category:"Arithmetic",syntax:["square(x)"],description:"Compute the square of a value. The square of x is x * x.",examples:["square(3)","sqrt(9)","3^2","3 * 3"],seealso:["multiply","pow","sqrt","cube"]}},{}],47:[function(e,n){n.exports={name:"subtract",category:"Operators",syntax:["x - y","subtract(x, y)"],description:"subtract two values.",examples:["5.3 - 2","ans + 2","2/3 - 1/6","2 * 3 - 3","2.1 km - 500m"],seealso:["add"]}},{}],48:[function(e,n){n.exports={name:"unary",category:"Operators",syntax:["-x","unary(x)"],description:"Inverse the sign of a value.",examples:["-4.5","-(-5.6)"],seealso:["add","subtract"]}},{}],49:[function(e,n){n.exports={name:"unequal",category:"Operators",syntax:["x != y","unequal(x, y)"],description:"Check unequality of two values. Returns 1 if the values are unequal, and 0 if they are equal.",examples:["2+2 != 3","2+2 != 4","a = 3.2","b = 6-2.8","a != b","50cm != 0.5m","5 cm != 2 inch"],seealso:["equal","smaller","larger","smallereq","largereq"]}},{}],50:[function(e,n){n.exports={name:"xgcd",category:"Arithmetic",syntax:["xgcd(a, b)"],description:"Calculate the extended greatest common divisor for two values",examples:["xgcd(8, 12)","gcd(8, 12)","xgcd(36163, 21199)"],seealso:["gcd","lcm"]}},{}],51:[function(e,n){n.exports={name:"arg",category:"Complex",syntax:["arg(x)"],description:"Compute the argument of a complex value. If x = a+bi, the argument is computed as atan2(b, a).",examples:["arg(2 + 2i)","atan2(3, 2)","arg(2 - 3i)"],seealso:["re","im","conj","abs"]}},{}],52:[function(e,n){n.exports={name:"conj",category:"Complex",syntax:["conj(x)"],description:"Compute the complex conjugate of a complex value. If x = a+bi, the complex conjugate is a-bi.",examples:["conj(2 + 3i)","conj(2 - 3i)","conj(-5.2i)"],seealso:["re","im","abs","arg"]}},{}],53:[function(e,n){n.exports={name:"im",category:"Complex",syntax:["im(x)"],description:"Get the imaginary part of a complex number.",examples:["im(2 + 3i)","re(2 + 3i)","im(-5.2i)","im(2.4)"],seealso:["re","conj","abs","arg"]}},{}],54:[function(e,n){n.exports={name:"re",category:"Complex",syntax:["re(x)"],description:"Get the real part of a complex number.",examples:["re(2 + 3i)","im(2 + 3i)","re(-5.2i)","re(2.4)"],seealso:["im","conj","abs","arg"]}},{}],55:[function(e,n){n.exports={name:"bignumber",category:"Type",syntax:["bignumber(x)"],description:"Create a big number from a number or string.",examples:["0.1 + 0.2","bignumber(0.1) + bignumber(0.2)",'bignumber("7.2")','bignumber("7.2e500")',"bignumber([0.1, 0.2, 0.3])"],seealso:["boolean","complex","index","matrix","string","unit"]}},{}],56:[function(e,n){n.exports={name:"boolean",category:"Type",syntax:["x","boolean(x)"],description:"Convert a string or number into a boolean.",examples:["boolean(0)","boolean(1)","boolean(3)",'boolean("true")','boolean("false")',"boolean([1, 0, 1, 1])"],seealso:["bignumber","complex","index","matrix","number","string","unit"]}},{}],57:[function(e,n){n.exports={name:"complex",category:"Type",syntax:["complex()","complex(re, im)","complex(string)"],description:"Create a complex number.",examples:["complex()","complex(2, 3)",'complex("7 - 2i")'],seealso:["bignumber","boolean","index","matrix","number","string","unit"]}},{}],58:[function(e,n){n.exports={name:"index",category:"Type",syntax:["[start]","[start:end]","[start:step:end]","[start1, start 2, ...]","[start1:end1, start2:end2, ...]","[start1:step1:end1, start2:step2:end2, ...]"],description:"Create an index to get or replace a subset of a matrix",examples:["[]","[1, 2, 3]","A = [1, 2, 3; 4, 5, 6]","A[1, :]","A[1, 2] = 50","A[0:2, 0:2] = ones(2, 2)"],seealso:["bignumber","boolean","complex","matrix,","number","range","string","unit"]}},{}],59:[function(e,n){n.exports={name:"matrix",category:"Type",syntax:["[]","[a1, b1, ...; a2, b2, ...]","matrix()","matrix([...])"],description:"Create a matrix.",examples:["[]","[1, 2, 3]","[1, 2, 3; 4, 5, 6]","matrix()","matrix([3, 4])"],seealso:["bignumber","boolean","complex","index","number","string","unit"]}},{}],60:[function(e,n){n.exports={name:"number",category:"Type",syntax:["x","number(x)"],description:"Create a number or convert a string or boolean into a number.",examples:["2","2e3","4.05","number(2)",'number("7.2")',"number(true)","number([true, false, true, true])"],seealso:["bignumber","boolean","complex","index","matrix","string","unit"]}},{}],61:[function(e,n){n.exports={name:"string",category:"Type",syntax:['"text"',"string(x)"],description:"Create a string or convert a value to a string",examples:['"Hello World!"',"string(4.2)","string(3 + 2i)"],seealso:["bignumber","boolean","complex","index","matrix","number","unit"]}},{}],62:[function(e,n){n.exports={name:"unit",category:"Type",syntax:["value unit","unit(value, unit)","unit(string)"],description:"Create a unit.",examples:["5.5 mm","3 inch",'unit(7.1, "kilogram")','unit("23 deg")'],seealso:["bignumber","boolean","complex","index","matrix","number","string"]}},{}],63:[function(e,n){n.exports={name:"eval",category:"Expression",syntax:["eval(expression)","eval([expr1, expr2, expr3, ...])"],description:"Evaluate an expression or an array with expressions.",examples:['eval("2 + 3")','eval("sqrt(" + 4 + ")")'],seealso:[]}},{}],64:[function(e,n){n.exports={name:"help",category:"Expression",syntax:["help(object)","help(string)"],description:"Display documentation on a function or data type.",examples:["help(sqrt)",'help("complex")'],seealso:[]}},{}],65:[function(e,n){n.exports={name:"concat",category:"Matrix",syntax:["concat(a, b, c, ...)","concat(a, b, c, ..., dim)"],description:"Concatenate matrices. By default, the matrices are concatenated by the first dimension. The dimension on which to concatenate can be provided as last argument.",examples:["a = [1, 2; 5, 6]","b = [3, 4; 7, 8]","concat(a, b)","[a, b]","concat(a, b, 2)","[a; b]"],seealso:["det","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},{}],66:[function(e,n){n.exports={name:"det",category:"Matrix",syntax:["det(x)"],description:"Calculate the determinant of a matrix",examples:["det([1, 2; 3, 4])","det([-2, 2, 3; -1, 1, 3; 2, 0, -1])"],seealso:["concat","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},{}],67:[function(e,n){n.exports={name:"diag",category:"Matrix",syntax:["diag(x)","diag(x, k)"],description:"Create a diagonal matrix or retrieve the diagonal of a matrix. When x is a vector, a matrix with the vector values on the diagonal will be returned. When x is a matrix, a vector with the diagonal values of the matrix is returned.When k is provided, the k-th diagonal will be filled in or retrieved, if k is positive, the values are placed on the super diagonal. When k is negative, the values are placed on the sub diagonal.",examples:["diag(1:3)","diag(1:3, 1)","a = [1, 2, 3; 4, 5, 6; 7, 8, 9]","diag(a)"],seealso:["concat","det","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},{}],68:[function(e,n){n.exports={name:"eye",category:"Matrix",syntax:["eye(n)","eye(m, n)","eye([m, n])","eye"],description:"Returns the identity matrix with size m-by-n. The matrix has ones on the diagonal and zeros elsewhere.",examples:["eye(3)","eye(3, 5)","a = [1, 2, 3; 4, 5, 6]","eye(size(a))"],seealso:["concat","det","diag","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},{}],69:[function(e,n){n.exports={name:"inv",category:"Matrix",syntax:["inv(x)"],description:"Calculate the inverse of a matrix",examples:["inv([1, 2; 3, 4])","inv(4)","1 / 4"],seealso:["concat","det","diag","eye","ones","range","size","squeeze","subset","transpose","zeros"]}},{}],70:[function(e,n){n.exports={name:"ones",category:"Matrix",syntax:["ones(m)","ones(m, n)","ones(m, n, p, ...)","ones([m])","ones([m, n])","ones([m, n, p, ...])","ones"],description:"Create a matrix containing ones.",examples:["ones(3)","ones(3, 5)","ones([2,3]) * 4.5","a = [1, 2, 3; 4, 5, 6]","ones(size(a))"],seealso:["concat","det","diag","eye","inv","range","size","squeeze","subset","transpose","zeros"]}},{}],71:[function(e,n){n.exports={name:"range",category:"Type",syntax:["start:end","start:step:end","range(start, end)","range(start, end, step)","range(string)"],description:"Create a range. Lower bound of the range is included, upper bound is excluded.",examples:["1:5","3:-1:-3","range(3, 7)","range(0, 12, 2)",'range("4:10")',"a = [1, 2, 3, 4; 5, 6, 7, 8]","a(1:2, 1:2)"],seealso:["concat","det","diag","eye","inv","ones","size","squeeze","subset","transpose","zeros"]}},{}],72:[function(e,n){n.exports={name:"resize",category:"Matrix",syntax:["resize(x, size)","resize(x, size, defaultValue)"],description:"Resize a matrix.",examples:["resize([1,2,3,4,5], [3])","resize([1,2,3], [5], 0)","resize(2, [2, 3], 0)",'resize("hello", [8], "!")'],seealso:["size","subset","squeeze"]}},{}],73:[function(e,n){n.exports={name:"size",category:"Matrix",syntax:["size(x)"],description:"Calculate the size of a matrix.",examples:["size(2.3)",'size("hello world")',"a = [1, 2; 3, 4; 5, 6]","size(a)","size(1:6)"],seealso:["concat","det","diag","eye","inv","ones","range","squeeze","subset","transpose","zeros"]}},{}],74:[function(e,n){n.exports={name:"squeeze",category:"Matrix",syntax:["squeeze(x)"],description:"Remove singleton dimensions from a matrix.",examples:["a = zeros(1,3,2)","size(squeeze(a))","b = zeros(3,1,1)","size(squeeze(b))"],seealso:["concat","det","diag","eye","inv","ones","range","size","subset","transpose","zeros"]}},{}],75:[function(e,n){n.exports={name:"subset",category:"Matrix",syntax:["value(index)","value(index) = replacement","subset(value, [index])","subset(value, [index], replacement)"],description:"Get or set a subset of a matrix or string. Indexes are one-based. Both the ranges lower-bound and upper-bound are included.",examples:["d = [1, 2; 3, 4]","e = []","e(1, 1:2) = [5, 6]","e(2, :) = [7, 8]","f = d * e","f(2, 1)","f(:, 1)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","transpose","zeros"]}},{}],76:[function(e,n){n.exports={name:"transpose",category:"Matrix",syntax:["x'","transpose(x)"],description:"Transpose a matrix",examples:["a = [1, 2, 3; 4, 5, 6]","a'","transpose(a)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","zeros"]}},{}],77:[function(e,n){n.exports={name:"zeros",category:"Matrix",syntax:["zeros(m)","zeros(m, n)","zeros(m, n, p, ...)","zeros([m])","zeros([m, n])","zeros([m, n, p, ...])","zeros"],description:"Create a matrix containing zeros.",examples:["zeros(3)","zeros(3, 5)","a = [1, 2, 3; 4, 5, 6]","zeros(size(a))"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","transpose"]}},{}],78:[function(e,n){n.exports={name:"distribution",category:"Probability",syntax:["distribution(name)","distribution(name, arg1, arg2, ...)"],description:'Create a distribution object of a specific type. A distribution object contains functions `random([size,] [min,] [max])`, `randomInt([size,] [min,] [max])`, and `pickRandom(array)`. Available types of distributions: "uniform", "normal". Note that the function distribution is currently not available via the expression parser.',examples:[],seealso:["random","randomInt"]}},{}],79:[function(e,n){n.exports={name:"factorial",category:"Probability",syntax:["x!","factorial(x)"],description:"Compute the factorial of a value",examples:["5!","5*4*3*2*1","3!"],seealso:[]}},{}],80:[function(e,n){n.exports={name:"pickRandom",category:"Probability",syntax:["pickRandom(array)"],description:"Pick a random entry from a given array.",examples:["pickRandom(0:10)","pickRandom([1, 3, 1, 6])"],seealso:["distribution","random","randomInt"]}},{}],81:[function(e,n){n.exports={name:"random",category:"Probability",syntax:["random()","random(max)","random(min, max)","random(size)","random(size, max)","random(size, min, max)"],description:"Return a random number.",examples:["random()","random(10, 20)","random([2, 3])"],seealso:["distribution","pickRandom","randomInt"]}},{}],82:[function(e,n){n.exports={name:"randInt",category:"Probability",syntax:["randInt()","randInt(max)","randInt(min, max)","randInt(size)","randInt(size, max)","randInt(size, min, max)"],description:"Return a random integer number",examples:["randInt()","randInt(10, 20)","randInt([2, 3], 10)"],seealso:["distribution","pickRandom","random"]}},{}],83:[function(e,n){n.exports={name:"max",category:"Statistics",syntax:["max(a, b, c, ...)","max(A)","max(A, dim)"],description:"Compute the maximum value of a list of values.",examples:["max(2, 3, 4, 1)","max([2, 3, 4, 1])","max([2, 5; 4, 3], 0)","max([2, 5; 4, 3], 1)","max(2.7, 7.1, -4.5, 2.0, 4.1)","min(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["mean","min"]}},{}],84:[function(e,n){n.exports={name:"mean",category:"Statistics",syntax:["mean(a, b, c, ...)","mean(A)","mean(A, dim)"],description:"Compute the arithmetic mean of a list of values.",examples:["mean(2, 3, 4, 1)","mean([2, 3, 4, 1])","mean([2, 5; 4, 3], 0)","mean([2, 5; 4, 3], 1)","mean([1.0, 2.7, 3.2, 4.0])"],seealso:["max","min"]}},{}],85:[function(e,n){n.exports={name:"min",category:"Statistics",syntax:["min(a, b, c, ...)","min(A)","min(A, dim)"],description:"Compute the minimum value of a list of values.",examples:["min(2, 3, 4, 1)","min([2, 3, 4, 1])","min([2, 5; 4, 3], 0)","min([2, 5; 4, 3], 1)","min(2.7, 7.1, -4.5, 2.0, 4.1)","max(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["max","mean","min"]}},{}],86:[function(e,n){n.exports={name:"acos",category:"Trigonometry",syntax:["acos(x)"],description:"Compute the inverse cosine of a value in radians.",examples:["acos(0.5)","acos(cos(2.3))"],seealso:["cos","acos","asin"]}},{}],87:[function(e,n){n.exports={name:"asin",category:"Trigonometry",syntax:["asin(x)"],description:"Compute the inverse sine of a value in radians.",examples:["asin(0.5)","asin(sin(2.3))"],seealso:["sin","acos","asin"]}},{}],88:[function(e,n){n.exports={name:"atan",category:"Trigonometry",syntax:["atan(x)"],description:"Compute the inverse tangent of a value in radians.",examples:["atan(0.5)","atan(tan(2.3))"],seealso:["tan","acos","asin"]}},{}],89:[function(e,n){n.exports={name:"atan2",category:"Trigonometry",syntax:["atan2(y, x)"],description:"Computes the principal value of the arc tangent of y/x in radians.",examples:["atan2(2, 2) / pi","angle = 60 deg in rad","x = cos(angle)","y = sin(angle)","atan2(y, x)"],seealso:["sin","cos","tan"]}},{}],90:[function(e,n){n.exports={name:"cos",category:"Trigonometry",syntax:["cos(x)"],description:"Compute the cosine of x in radians.",examples:["cos(2)","cos(pi / 4) ^ 2","cos(180 deg)","cos(60 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["acos","sin","tan"]}},{}],91:[function(e,n){n.exports={name:"cot",category:"Trigonometry",syntax:["cot(x)"],description:"Compute the cotangent of x in radians. Defined as 1/tan(x)",examples:["cot(2)","1 / tan(2)"],seealso:["sec","csc","tan"]}},{}],92:[function(e,n){n.exports={name:"csc",category:"Trigonometry",syntax:["csc(x)"],description:"Compute the cosecant of x in radians. Defined as 1/sin(x)",examples:["csc(2)","1 / sin(2)"],seealso:["sec","cot","sin"]}},{}],93:[function(e,n){n.exports={name:"sec",category:"Trigonometry",syntax:["sec(x)"],description:"Compute the secant of x in radians. Defined as 1/cos(x)",examples:["sec(2)","1 / cos(2)"],seealso:["cot","csc","cos"]}},{}],94:[function(e,n){n.exports={name:"sin",category:"Trigonometry",syntax:["sin(x)"],description:"Compute the sine of x in radians.",examples:["sin(2)","sin(pi / 4) ^ 2","sin(90 deg)","sin(30 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["asin","cos","tan"]}},{}],95:[function(e,n){n.exports={name:"tan",category:"Trigonometry",syntax:["tan(x)"],description:"Compute the tangent of x in radians.",examples:["tan(0.5)","sin(0.5) / cos(0.5)","tan(pi / 4)","tan(45 deg)"],seealso:["atan","sin","cos"]}},{}],96:[function(e,n){n.exports={name:"in",category:"Units",syntax:["x in unit","in(x, unit)"],description:"Change the unit of a value.",examples:["5 inch in cm","3.2kg in g","16 bytes in bits"],seealso:[]}},{}],97:[function(e,n){n.exports={name:"clone",category:"Utils",syntax:["clone(x)"],description:"Clone a variable. Creates a copy of primitive variables,and a deep copy of matrices",examples:["clone(3.5)","clone(2 - 4i)","clone(45 deg)","clone([1, 2; 3, 4])",'clone("hello world")'],seealso:[]}},{}],98:[function(e,n){n.exports={name:"forEach",category:"Utils",syntax:["forEach(x, callback)"],description:"Iterates over all elements of a matrix/array, and executes the given callback.",examples:["forEach([1, 2, 3], function(val) { console.log(val) })"],seealso:[]}},{}],99:[function(e,n){n.exports={name:"format",category:"Utils",syntax:["format(value)","format(value, precision)"],description:"Format a value of any type as string.",examples:["format(2.3)","format(3 - 4i)","format([])","format(pi, 3)"],seealso:["print"]}},{}],100:[function(e,n){n.exports={name:"import",category:"Utils",syntax:["import(string)"],description:"Import functions from a file.",examples:['import("numbers")','import("./mylib.js")'],seealso:[]}},{}],101:[function(e,n){n.exports={name:"map",category:"Utils",syntax:["map(x, callback)"],description:"Create a new matrix or array with the results of the callback function executed on each entry of the matrix/array.",examples:["map([1, 2, 3], function(val) { return math.max(val, 1.5) })"],seealso:[]}},{}],102:[function(e,n){n.exports={name:"typeof",category:"Utils",syntax:["typeof(x)"],description:"Get the type of a variable.",examples:["typeof(3.5)","typeof(2 - 4i)","typeof(45 deg)",'typeof("hello world")'],seealso:[]}},{}],103:[function(e,n,t){t.e=e("./constants/e"),t.E=e("./constants/e"),t["false"]=e("./constants/false"),t.i=e("./constants/i"),t.Infinity=e("./constants/Infinity"),t.LN2=e("./constants/LN2"),t.LN10=e("./constants/LN10"),t.LOG2E=e("./constants/LOG2E"),t.LOG10E=e("./constants/LOG10E"),t.NaN=e("./constants/NaN"),t.pi=e("./constants/pi"),t.PI=e("./constants/pi"),t.SQRT1_2=e("./constants/SQRT1_2"),t.SQRT2=e("./constants/SQRT2"),t.tau=e("./constants/tau"),t["true"]=e("./constants/true"),t.abs=e("./function/arithmetic/abs"),t.add=e("./function/arithmetic/add"),t.ceil=e("./function/arithmetic/ceil"),t.cube=e("./function/arithmetic/cube"),t.divide=e("./function/arithmetic/divide"),t.edivide=e("./function/arithmetic/edivide"),t.emultiply=e("./function/arithmetic/emultiply"),t.epow=e("./function/arithmetic/epow"),t.equal=e("./function/arithmetic/equal"),t.exp=e("./function/arithmetic/exp"),t.fix=e("./function/arithmetic/fix"),t.floor=e("./function/arithmetic/floor"),t.gcd=e("./function/arithmetic/gcd"),t.larger=e("./function/arithmetic/larger"),t.largereq=e("./function/arithmetic/largereq"),t.lcm=e("./function/arithmetic/lcm"),t.log=e("./function/arithmetic/log"),t.log10=e("./function/arithmetic/log10"),t.mod=e("./function/arithmetic/mod"),t.multiply=e("./function/arithmetic/multiply"),t.pow=e("./function/arithmetic/pow"),t.round=e("./function/arithmetic/round"),t.sign=e("./function/arithmetic/sign"),t.smaller=e("./function/arithmetic/smaller"),t.smallereq=e("./function/arithmetic/smallereq"),t.sqrt=e("./function/arithmetic/sqrt"),t.square=e("./function/arithmetic/square"),t.subtract=e("./function/arithmetic/subtract"),t.unary=e("./function/arithmetic/unary"),t.unequal=e("./function/arithmetic/unequal"),t.xgcd=e("./function/arithmetic/xgcd"),t.arg=e("./function/complex/arg"),t.conj=e("./function/complex/conj"),t.re=e("./function/complex/re"),t.im=e("./function/complex/im"),t.bignumber=e("./function/construction/bignumber"),t["boolean"]=e("./function/construction/boolean"),t.complex=e("./function/construction/complex"),t.index=e("./function/construction/index"),t.matrix=e("./function/construction/matrix"),t.number=e("./function/construction/number"),t.string=e("./function/construction/string"),t.unit=e("./function/construction/unit"),t.eval=e("./function/expression/eval"),t.help=e("./function/expression/help"),t.concat=e("./function/matrix/concat"),t.det=e("./function/matrix/det"),t.diag=e("./function/matrix/diag"),t.eye=e("./function/matrix/eye"),t.inv=e("./function/matrix/inv"),t.ones=e("./function/matrix/ones"),t.range=e("./function/matrix/range"),t.resize=e("./function/matrix/resize"),t.size=e("./function/matrix/size"),t.squeeze=e("./function/matrix/squeeze"),t.subset=e("./function/matrix/subset"),t.transpose=e("./function/matrix/transpose"),t.zeros=e("./function/matrix/zeros"),t.factorial=e("./function/probability/factorial"),t.distribution=e("./function/probability/distribution"),t.pickRandom=e("./function/probability/pickRandom"),t.random=e("./function/probability/random"),t.randomInt=e("./function/probability/randomInt"),t.min=e("./function/statistics/min"),t.mean=e("./function/statistics/mean"),t.max=e("./function/statistics/max"),t.acos=e("./function/trigonometry/acos"),t.asin=e("./function/trigonometry/asin"),t.atan=e("./function/trigonometry/atan"),t.atan2=e("./function/trigonometry/atan2"),t.cos=e("./function/trigonometry/cos"),t.cot=e("./function/trigonometry/cot"),t.csc=e("./function/trigonometry/csc"),t.sec=e("./function/trigonometry/sec"),t.sin=e("./function/trigonometry/sin"),t.tan=e("./function/trigonometry/tan"),t["in"]=e("./function/units/in"),t.clone=e("./function/utils/clone"),t.map=e("./function/utils/map"),t.forEach=e("./function/utils/forEach"),t.format=e("./function/utils/format"),t["import"]=e("./function/utils/import"),t["typeof"]=e("./function/utils/typeof")
},{"./constants/Infinity":6,"./constants/LN10":7,"./constants/LN2":8,"./constants/LOG10E":9,"./constants/LOG2E":10,"./constants/NaN":11,"./constants/SQRT1_2":12,"./constants/SQRT2":13,"./constants/e":14,"./constants/false":15,"./constants/i":16,"./constants/pi":17,"./constants/tau":18,"./constants/true":19,"./function/arithmetic/abs":20,"./function/arithmetic/add":21,"./function/arithmetic/ceil":22,"./function/arithmetic/cube":23,"./function/arithmetic/divide":24,"./function/arithmetic/edivide":25,"./function/arithmetic/emultiply":26,"./function/arithmetic/epow":27,"./function/arithmetic/equal":28,"./function/arithmetic/exp":29,"./function/arithmetic/fix":30,"./function/arithmetic/floor":31,"./function/arithmetic/gcd":32,"./function/arithmetic/larger":33,"./function/arithmetic/largereq":34,"./function/arithmetic/lcm":35,"./function/arithmetic/log":36,"./function/arithmetic/log10":37,"./function/arithmetic/mod":38,"./function/arithmetic/multiply":39,"./function/arithmetic/pow":40,"./function/arithmetic/round":41,"./function/arithmetic/sign":42,"./function/arithmetic/smaller":43,"./function/arithmetic/smallereq":44,"./function/arithmetic/sqrt":45,"./function/arithmetic/square":46,"./function/arithmetic/subtract":47,"./function/arithmetic/unary":48,"./function/arithmetic/unequal":49,"./function/arithmetic/xgcd":50,"./function/complex/arg":51,"./function/complex/conj":52,"./function/complex/im":53,"./function/complex/re":54,"./function/construction/bignumber":55,"./function/construction/boolean":56,"./function/construction/complex":57,"./function/construction/index":58,"./function/construction/matrix":59,"./function/construction/number":60,"./function/construction/string":61,"./function/construction/unit":62,"./function/expression/eval":63,"./function/expression/help":64,"./function/matrix/concat":65,"./function/matrix/det":66,"./function/matrix/diag":67,"./function/matrix/eye":68,"./function/matrix/inv":69,"./function/matrix/ones":70,"./function/matrix/range":71,"./function/matrix/resize":72,"./function/matrix/size":73,"./function/matrix/squeeze":74,"./function/matrix/subset":75,"./function/matrix/transpose":76,"./function/matrix/zeros":77,"./function/probability/distribution":78,"./function/probability/factorial":79,"./function/probability/pickRandom":80,"./function/probability/random":81,"./function/probability/randomInt":82,"./function/statistics/max":83,"./function/statistics/mean":84,"./function/statistics/min":85,"./function/trigonometry/acos":86,"./function/trigonometry/asin":87,"./function/trigonometry/atan":88,"./function/trigonometry/atan2":89,"./function/trigonometry/cos":90,"./function/trigonometry/cot":91,"./function/trigonometry/csc":92,"./function/trigonometry/sec":93,"./function/trigonometry/sin":94,"./function/trigonometry/tan":95,"./function/units/in":96,"./function/utils/clone":97,"./function/utils/forEach":98,"./function/utils/format":99,"./function/utils/import":100,"./function/utils/map":101,"./function/utils/typeof":102}],104:[function(e,n){function t(e,n){this.settings=e,this.nodes=n||[]}var r=e("./Node"),i=(e("../../util/object"),e("../../util/string")),o=(e("../../type/collection"),e("../../type/Matrix"));t.prototype=new r,t.prototype.eval=function(){for(var e=this.nodes,n=[],t=0,r=e.length;r>t;t++){var i=e[t],a=i.eval();n[t]=a instanceof o?a.valueOf():a}return"array"===this.settings.matrix?n:new o(n)},t.prototype.find=function(e){var n=[];this.match(e)&&n.push(this);for(var t=this.nodes,r=0,i=t.length;i>r;r++)for(var o=t[r],a=0,s=o.length;s>a;a++)n=n.concat(o[a].find(e));return n},t.prototype.toString=function(){return i.format(this.nodes)},n.exports=t},{"../../type/Matrix":206,"../../type/collection":209,"../../util/object":215,"../../util/string":216,"./Node":109}],105:[function(e,n){function t(e,n,t){this.name=e,this.expr=n,this.scope=t}var r=e("./Node");t.prototype=new r,t.prototype.eval=function(){if(void 0===this.expr)throw new Error("Undefined symbol "+this.name);var e=this.expr.eval();return this.scope.set(this.name,e),e},t.prototype.find=function(e){var n=[];return this.match(e)&&n.push(this),this.expr&&(n=n.concat(this.expr.find(e))),n},t.prototype.toString=function(){return this.name+" = "+this.expr.toString()},n.exports=t},{"./Node":109}],106:[function(e,n){function t(){this.params=[],this.visible=[]}var r=e("./Node");t.prototype=new r,t.prototype.add=function(e,n){var t=this.params.length;this.params[t]=e,this.visible[t]=void 0!=n?n:!0},t.prototype.eval=function(){for(var e=[],n=0,t=this.params.length;t>n;n++){var r=this.params[n].eval();this.visible[n]&&e.push(r)}return e},t.prototype.find=function(e){var n=[];this.match(e)&&n.push(this);var t=this.params;if(t)for(var r=0,i=t.length;i>r;r++)n=n.concat(t[r].find(e));return n},t.prototype.toString=function(){for(var e=[],n=0,t=this.params.length;t>n;n++)this.visible[n]&&e.push("\n  "+this.params[n].toString());return"["+e.join(",")+"\n]"},n.exports=t},{"./Node":109}],107:[function(e,n){function t(e){this.value=e}var r=e("./Node"),i=e("../../util/string");t.prototype=new r,t.prototype.eval=function(){return this.value},t.prototype.toString=function(){return i.format(this.value)},n.exports=t},{"../../util/string":216,"./Node":109}],108:[function(e,n){function t(e,n,t,r,i){this.name=e,this.variables=n,this.expr=t,this.scope=i,this.fn=function(){var i=n?n.length:0;if(arguments.length!=i)throw new SyntaxError("Wrong number of arguments in function "+e+" ("+arguments.length+" provided, "+i+" expected)");for(var o=0;i>o;o++)r.set(n[o],arguments[o]);return t.eval()},this.fn.syntax=e+"("+n.join(", ")+")"}var r=e("./Node");t.prototype=new r,t.prototype.eval=function(){return this.scope.set(this.name,this.fn),this.fn},t.prototype.find=function(e){var n=[];return this.match(e)&&n.push(this),this.expr&&(n=n.concat(this.expr.find(e))),n},t.prototype.toString=function(){return this.fn.description},n.exports=t},{"./Node":109}],109:[function(e,n){function t(){}t.prototype.eval=function(){throw new Error("Cannot evaluate a Node interface")},t.prototype.find=function(e){return this.match(e)?[this]:[]},t.prototype.match=function(e){var n=!0;if(e&&(!e.type||this instanceof e.type||(n=!1),n&&e.properties))for(var t in e.properties)if(e.properties.hasOwnProperty(t)&&this[t]!=e.properties[t]){n=!1;break}return n},t.prototype.toString=function(){return""},n.exports=t},{}],110:[function(e,n){function t(e,n,t){this.name=e,this.fn=n,this.params=t}var r=e("./Node");t.prototype=new r,t.prototype.eval=function(){return this.fn.apply(this,this.params.map(function(e){return e.eval()}))},t.prototype.find=function(e){var n=[];this.match(e)&&n.push(this);var t=this.params;if(t)for(var r=0,i=t.length;i>r;r++)n=n.concat(t[r].find(e));return n},t.prototype.toString=function(){var e=this.params;switch(e.length){case 1:return"-"==this.name?"-"+e[0].toString():e[0].toString()+this.name;case 2:var n=e[0].toString();e[0]instanceof t&&(n="("+n+")");var r=e[1].toString();return e[1]instanceof t&&(r="("+r+")"),n+" "+this.name+" "+r;default:return this.name+"("+this.params.join(", ")+")"}},n.exports=t},{"./Node":109}],111:[function(e,n){function t(e,n,t,r){if(this.math=e,this.object=n,this.params=t,this.paramScopes=r,this.hasContextParams=!1,t)for(var i={type:a,properties:{name:"end"}},o=0,s=t.length;s>o;o++)if(t[o].find(i).length>0){this.hasContextParams=!0;break}}var r=e("../../util/number"),i=e("./Node"),o=e("./RangeNode"),a=e("./SymbolNode"),s=e("bignumber.js"),u=e("../../type/Index"),c=e("../../type/Range"),f=r.isNumber,l=r.toNumber;t.prototype=new i,t.prototype.eval=function(){var e,n,t,r,i=this.object;if(void 0==i)throw new Error("Node undefined");var a=i.eval();if(this.hasContextParams&&"function"!=typeof a){var m=this.paramScopes,p=this.math.size(a).valueOf();if(m&&p)for(e=0,n=this.params.length;n>e;e++){var h=m[e];h&&h.set("end",p[e])}}if("function"==typeof a){for(t=this.params,r=[],e=0,n=this.params.length;n>e;e++)r[e]=t[e].eval();return a.apply(this,r)}for(t=this.params,r=[],e=0,n=this.params.length;n>e;e++){var g,x=t[e];if(g=x instanceof o?x.toRange():x.eval(),g instanceof s&&(g=l(g)),g instanceof c)g.start--,g.end--;else{if(!f(g))throw new TypeError("Number or Range expected");g--}r[e]=g}var d=u.create(r);return this.math.subset(a,d)},t.prototype.find=function(e){var n=[];this.match(e)&&n.push(this),this.object&&(n=n.concat(this.object.find(e)));var t=this.params;if(t)for(var r=0,i=t.length;i>r;r++)n=n.concat(t[r].find(e));return n},t.prototype.toString=function(){var e=this.object?this.object.toString():"";return this.params&&(e+="("+this.params.join(", ")+")"),e},n.exports=t},{"../../type/Index":205,"../../type/Range":207,"../../util/number":214,"./Node":109,"./RangeNode":112,"./SymbolNode":113,"bignumber.js":218}],112:[function(e,n){function t(e,n,t){if(this.math=e,this.settings=n,this.start=null,this.end=null,this.step=null,2==t.length)this.start=t[0],this.end=t[1];else{if(3!=t.length)throw new SyntaxError("Wrong number of arguments");this.start=t[0],this.step=t[1],this.end=t[2]}}var r=e("../../util/number"),i=e("./Node"),o=e("bignumber.js"),a=e("../../type/Range"),s=e("../../type/Matrix"),u=r.toNumber;t.prototype=new i,t.prototype.eval=function(){var e=this._evalParams(),n=e.start,t=e.step,r=e.end,i=[],o=n;if(t>0)for(;r>=o;)i.push(o),o+=t;else if(0>t)for(;o>=r;)i.push(o),o+=t;return"array"===this.settings.matrix?i:new s(i)},t.prototype.toRange=function(){var e=this._evalParams(),n=e.start,t=e.step,r=e.end;return r=this.math.add(r,t>0?1:-1),new a(n,r,t)},t.prototype._evalParams=function(){var e=this.start.eval(),n=this.end.eval(),t=this.step?this.step.eval():1;if(e instanceof o&&(e=u(e)),n instanceof o&&(n=u(n)),t instanceof o&&(t=u(t)),!r.isNumber(e))throw new TypeError("Parameter start must be a number");if(!r.isNumber(n))throw new TypeError("Parameter end must be a number");if(!r.isNumber(t))throw new TypeError("Parameter step must be a number");return{start:e,end:n,step:t}},t.prototype.find=function(e){var n=[];return this.match(e)&&n.push(this),this.start&&(n=n.concat(this.start.find(e))),this.step&&(n=n.concat(this.step.find(e))),this.end&&(n=n.concat(this.end.find(e))),n},t.prototype.toString=function(){var e=this.start.toString();return this.step&&(e+=":"+this.step.toString()),e+=":"+this.end.toString()},n.exports=t},{"../../type/Matrix":206,"../../type/Range":207,"../../util/number":214,"./Node":109,"bignumber.js":218}],113:[function(e,n){function t(e,n){this.name=e,this.scope=n}var r=e("./Node");t.prototype=new r,t.prototype.eval=function(){var e=this.scope.get(this.name);if(void 0===e)throw new Error("Undefined symbol "+this.name);return e},t.prototype.toString=function(){return this.name},n.exports=t},{"./Node":109}],114:[function(e,n){function t(e,n){this.value=e,this.unit=n}var r=e("./Node"),i=e("bignumber.js"),o=(e("../../type/Complex"),e("../../type/Unit")),a=e("../../util/number"),s=a.toNumber;t.prototype=new r,t.prototype.eval=function(){var e=this.value.eval();if(e=e instanceof i?s(e):e,o.isPlainUnit(this.unit))return new o(e,this.unit);throw new TypeError('Unknown unit "'+this.unit+'"')},t.prototype.find=function(e){var n=[];return this.match(e)&&n.push(this),n=n.concat(this.value.find(e))},t.prototype.toString=function(){return this.value+" "+this.unit},n.exports=t},{"../../type/Complex":203,"../../type/Unit":208,"../../util/number":214,"./Node":109,"bignumber.js":218}],115:[function(e,n){function t(e,n,t,r,i,o){this.math=e,this.name=n,this.params=t,this.paramScopes=r,this.expr=i,this.scope=o,this.hasContextParams=!1;for(var s={type:a,properties:{name:"end"}},u=0,c=t.length;c>u;u++)if(t[u].find(s).length>0){this.hasContextParams=!0;break}}var r=e("../../util/number"),i=e("./Node"),o=e("./RangeNode"),a=e("./SymbolNode"),s=e("bignumber.js"),u=e("../../type/Index"),c=e("../../type/Range"),f=r.isNumber,l=r.toNumber;t.prototype=new i,t.prototype.eval=function(){if(void 0===this.expr)throw new Error("Undefined symbol "+this.name);var e,n=this.scope.get(this.name);if(void 0==n)throw new Error("Undefined symbol "+this.name);if(this.hasContextParams&&"function"!=typeof n){var t=this.paramScopes,r=this.math.size(n).valueOf();if(t&&r)for(var i=0,a=this.params.length;a>i;i++){var m=t[i];m&&m.set("end",r[i])}}var p=[];this.params.forEach(function(e){var n;if(n=e instanceof o?e.toRange():e.eval(),n instanceof s&&(n=l(n)),n instanceof c)n.start--,n.end--;else{if(!f(n))throw new TypeError("Number or Range expected");n--}p.push(n)});var h=this.expr.eval(),g=u.create(p);return e=this.math.subset(n,g,h),this.scope.set(this.name,e),e},t.prototype.find=function(e){var n=[];this.match(e)&&n.push(this);var t=this.params;if(t)for(var r=0,i=t.length;i>r;r++)n=n.concat(t[r].find(e));return this.expr&&(n=n.concat(this.expr.find(e))),n},t.prototype.toString=function(){var e="";return e+=this.name,this.params&&this.params.length&&(e+="("+this.params.join(", ")+")"),e+=" = ",e+=this.expr.toString()},n.exports=t},{"../../type/Index":205,"../../type/Range":207,"../../util/number":214,"./Node":109,"./RangeNode":112,"./SymbolNode":113,"bignumber.js":218}],116:[function(){},{}],117:[function(e,n,t){t.AssignmentNode=e("./AssignmentNode"),t.BlockNode=e("./BlockNode"),t.ConstantNode=e("./ConstantNode"),t.UnitNode=e("./UnitNode"),t.FunctionNode=e("./FunctionNode"),t.ArrayNode=e("./ArrayNode"),t.Node=e("./Node"),t.OperatorNode=e("./OperatorNode"),t.ParamsNode=e("./ParamsNode"),t.RangeNode=e("./RangeNode"),t.SymbolNode=e("./SymbolNode"),t.UpdateNode=e("./UpdateNode"),t.handlers=e("./handlers")},{"./ArrayNode":104,"./AssignmentNode":105,"./BlockNode":106,"./ConstantNode":107,"./FunctionNode":108,"./Node":109,"./OperatorNode":110,"./ParamsNode":111,"./RangeNode":112,"./SymbolNode":113,"./UnitNode":114,"./UpdateNode":115,"./handlers":116}],118:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=(e("../../type/Matrix"),e("../../type/collection")),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.abs=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("abs",arguments.length,1);if(a(e))return Math.abs(e);if(u(e))return Math.sqrt(e.re*e.re+e.im*e.im);if(e instanceof r)return e.abs();if(c(e))return o.deepMap(e,f);if(s(e))return Math.abs(e);throw new n.error.UnsupportedTypeError("abs",e)}}},{"../../type/Complex":203,"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],119:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=(e("../../type/Matrix"),e("../../type/Unit")),a=e("../../type/collection"),s=t["boolean"].isBoolean,u=t.number.isNumber,c=t.number.toNumber,f=t.number.toBigNumber,l=t.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;n.add=function g(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("add",arguments.length,2);if(u(e)){if(u(t))return e+t;if(m(t))return new i(e+t.re,t.im)}if(m(e)){if(m(t))return new i(e.re+t.re,e.im+t.im);if(u(t))return new i(e.re+t,e.im)}if(p(e)&&p(t)){if(!e.equalBase(t))throw new Error("Units do not match");if(null==e.value)throw new Error("Unit on left hand side of operator + has an undefined value");if(null==t.value)throw new Error("Unit on right hand side of operator + has an undefined value");var o=e.clone();return o.value+=t.value,o.fixPrefix=!1,o}if(e instanceof r)return u(t)?t=f(t):s(t)&&(t=new r(t?1:0)),t instanceof r?e.plus(t):g(c(e),t);if(t instanceof r)return u(e)?e=f(e):s(e)&&(e=new r(e?1:0)),e instanceof r?e.plus(t):g(e,c(t));if(l(e)||l(t))return e+t;if(h(e)||h(t))return a.deepMap2(e,t,g);if(s(e))return g(+e,t);if(s(t))return g(e,+t);throw new n.error.UnsupportedTypeError("add",e,t)}}},{"../../type/Complex":203,"../../type/Matrix":206,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],120:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=o.isCollection,c=i.isComplex;n.ceil=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("ceil",arguments.length,1);if(a(e))return Math.ceil(e);if(c(e))return new i(Math.ceil(e.re),Math.ceil(e.im));if(e instanceof r)return e.ceil();if(u(e))return o.deepMap(e,f);if(s(e))return Math.ceil(e);throw new n.error.UnsupportedTypeError("ceil",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],121:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.cube=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("cube",arguments.length,1);if(a(e))return e*e*e;if(u(e))return n.multiply(n.multiply(e,e),e);if(e instanceof r)return e.times(e).times(e);if(c(e))return o.deepMap(e,f);if(s(e))return f(+e);throw new n.error.UnsupportedTypeError("cube",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],122:[function(e,n){n.exports=function(n){function t(e,n){var t=n.re*n.re+n.im*n.im;return 0!=t?new o((e.re*n.re+e.im*n.im)/t,(e.im*n.re-e.re*n.im)/t):new o(0!=e.re?e.re/0:0,0!=e.im?e.im/0:0)}var r=e("../../util/index"),i=e("bignumber.js"),o=e("../../type/Complex"),a=(e("../../type/Matrix"),e("../../type/Unit")),s=e("../../type/collection"),u=r.number.isNumber,c=r.number.toNumber,f=r.number.toBigNumber,l=r["boolean"].isBoolean,m=o.isComplex,p=a.isUnit,h=s.isCollection;n.divide=function g(e,r){if(2!=arguments.length)throw new n.error.ArgumentsError("divide",arguments.length,2);if(u(e)){if(u(r))return e/r;if(m(r))return t(new o(e,0),r)}if(m(e)){if(m(r))return t(e,r);if(u(r))return t(e,new o(r,0))}if(e instanceof i)return u(r)?r=f(r):l(r)&&(r=new i(r?1:0)),r instanceof i?e.div(r):g(c(e),r);if(r instanceof i)return u(e)?e=f(e):l(e)&&(e=new i(e?1:0)),e instanceof i?e.div(r):g(e,c(r));if(p(e)&&u(r)){var a=e.clone();return a.value/=r,a}if(h(e))return h(r)?n.multiply(e,n.inv(r)):s.deepMap2(e,r,g);if(h(r))return n.multiply(e,n.inv(r));if(l(e))return g(+e,r);if(l(r))return g(e,+r);throw new n.error.UnsupportedTypeError("divide",e,r)}}},{"../../type/Complex":203,"../../type/Matrix":206,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],123:[function(e,n){n.exports=function(n){var t=e("../../type/collection");n.edivide=function(e,r){if(2!=arguments.length)throw new n.error.ArgumentsError("edivide",arguments.length,2);return t.deepMap2(e,r,n.divide)}}},{"../../type/collection":209}],124:[function(e,n){n.exports=function(n){var t=e("../../type/collection");n.emultiply=function(e,r){if(2!=arguments.length)throw new n.error.ArgumentsError("emultiply",arguments.length,2);return t.deepMap2(e,r,n.multiply)}}},{"../../type/collection":209}],125:[function(e,n){n.exports=function(n){var t=e("../../type/collection");n.epow=function(e,r){if(2!=arguments.length)throw new n.error.ArgumentsError("epow",arguments.length,2);return t.deepMap2(e,r,n.pow)}}},{"../../type/collection":209}],126:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t.number.toNumber,c=t.number.toBigNumber,f=t["boolean"].isBoolean,l=t.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;n.equal=function g(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("equal",arguments.length,2);if(s(e)){if(s(t))return e==t;if(m(t))return e==t.re&&0==t.im}if(m(e)){if(s(t))return e.re==t&&0==e.im;if(m(t))return e.re==t.re&&e.im==t.im}if(e instanceof r)return s(t)?t=c(t):f(t)&&(t=new r(t?1:0)),t instanceof r?e.eq(t):g(u(e),t);if(t instanceof r)return s(e)?e=c(e):f(e)&&(e=new r(e?1:0)),e instanceof r?e.eq(t):g(e,u(t));if(p(e)&&p(t)){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return e.value==t.value}if(l(e)||l(t))return e==t;if(h(e)||h(t))return a.deepMap2(e,t,g);if(f(e))return g(+e,t);if(f(t))return g(e,+t);throw new n.error.UnsupportedTypeError("equal",e,t)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],127:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=(e("../../type/Matrix"),e("../../type/collection")),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.exp=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("exp",arguments.length,1);if(a(e))return Math.exp(e);if(u(e)){var l=Math.exp(e.re);return new i(l*Math.cos(e.im),l*Math.sin(e.im))}if(e instanceof r)return f(t.number.toNumber(e));if(c(e))return o.deepMap(e,f);if(s(e))return Math.exp(e);throw new n.error.UnsupportedTypeError("exp",e)}}},{"../../type/Complex":203,"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],128:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.fix=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("fix",arguments.length,1);if(a(e))return e>0?Math.floor(e):Math.ceil(e);if(u(e))return new i(e.re>0?Math.floor(e.re):Math.ceil(e.re),e.im>0?Math.floor(e.im):Math.ceil(e.im));if(e instanceof r)return e.isNegative()?e.ceil():e.floor();if(c(e))return o.deepMap(e,f);if(s(e))return f(+e);throw new n.error.UnsupportedTypeError("fix",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],129:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.floor=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("floor",arguments.length,1);if(a(e))return Math.floor(e);if(u(e))return new i(Math.floor(e.re),Math.floor(e.im));if(e instanceof r)return e.floor();if(c(e))return o.deepMap(e,f);if(s(e))return f(+e);throw new n.error.UnsupportedTypeError("floor",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],130:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/collection"),o=t.number.isNumber,a=t.number.toNumber,s=t["boolean"].isBoolean,u=t.number.isInteger,c=i.isCollection;n.gcd=function f(){var e,t=arguments[0],l=arguments[1];if(2==arguments.length){if(o(t)&&o(l)){if(!u(t)||!u(l))throw new Error("Parameters in function gcd must be integer numbers");for(;0!=l;)e=t%l,t=l,l=e;return 0>t?-t:t}if(c(t)||c(l))return i.deepMap2(t,l,f);if(t instanceof r)return f(a(t),l);if(l instanceof r)return f(t,a(l));if(s(t))return f(+t,l);if(s(l))return f(t,+l);throw new n.error.UnsupportedTypeError("gcd",t,l)}if(arguments.length>2){for(var m=1;m<arguments.length;m++)t=f(t,arguments[m]);return t}throw new SyntaxError("Function gcd expects two or more arguments")}}},{"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],131:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t.number.toNumber,c=t.number.toBigNumber,f=t["boolean"].isBoolean,l=t.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;n.larger=function g(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("larger",arguments.length,2);if(s(e)&&s(t))return e>t;if(e instanceof r)return s(t)?t=c(t):f(t)&&(t=new r(t?1:0)),t instanceof r?e.gt(t):g(u(e),t);if(t instanceof r)return s(e)?e=c(e):f(e)&&(e=new r(e?1:0)),e instanceof r?e.gt(t):g(e,u(t));if(p(e)&&p(t)){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return e.value>t.value}if(l(e)||l(t))return e>t;if(h(e)||h(t))return a.deepMap2(e,t,g);if(f(e))return g(+e,t);if(f(t))return g(e,+t);if(m(e)||m(t))throw new TypeError("No ordering relation is defined for complex numbers");throw new n.error.UnsupportedTypeError("larger",e,t)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],132:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t.number.toNumber,c=t.number.toBigNumber,f=t["boolean"].isBoolean,l=t.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;n.largereq=function g(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("largereq",arguments.length,2);if(s(e)&&s(t))return e>=t;if(e instanceof r)return s(t)?t=c(t):f(t)&&(t=new r(t?1:0)),t instanceof r?e.gte(t):g(u(e),t);if(t instanceof r)return s(e)?e=c(e):f(e)&&(e=new r(e?1:0)),e instanceof r?e.gte(t):g(e,u(t));if(p(e)&&p(t)){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return e.value>=t.value}if(l(e)||l(t))return e>=t;if(h(e)||h(t))return a.deepMap2(e,t,g);if(f(e))return g(+e,t);if(f(t))return g(e,+t);if(m(e)||m(t))throw new TypeError("No ordering relation is defined for complex numbers");throw new n.error.UnsupportedTypeError("largereq",e,t)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],133:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/collection"),o=t.number.isNumber,a=t.number.toNumber,s=t["boolean"].isBoolean,u=t.number.isInteger,c=i.isCollection;n.lcm=function f(){var e,t=arguments[0],l=arguments[1];if(2==arguments.length){if(o(t)&&o(l)){if(!u(t)||!u(l))throw new Error("Parameters in function lcm must be integer numbers");if(0==t||0==l)return 0;for(var m=t*l;0!=l;)e=l,l=t%e,t=e;return Math.abs(m/t)}if(c(t)||c(l))return i.deepMap2(t,l,f);if(s(t))return f(+t,l);if(s(l))return f(t,+l);if(t instanceof r)return f(a(t),l);if(l instanceof r)return f(t,a(l));throw new n.error.UnsupportedTypeError("lcm",t,l)}if(arguments.length>2){for(var p=1;p<arguments.length;p++)t=f(t,arguments[p]);return t}throw new SyntaxError("Function lcm expects two or more arguments")}}},{"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],134:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.log=function f(e,l){if(1==arguments.length){if(a(e))return e>=0?Math.log(e):f(new i(e,0));if(u(e))return new i(Math.log(Math.sqrt(e.re*e.re+e.im*e.im)),Math.atan2(e.im,e.re));if(e instanceof r)return f(t.number.toNumber(e));if(c(e))return o.deepMap(e,f);if(s(e))return f(+e);throw new n.error.UnsupportedTypeError("log",e)}if(2==arguments.length)return n.divide(f(e),f(l));throw new n.error.ArgumentsError("log",arguments.length,1,2)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],135:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.log10=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("log10",arguments.length,1);if(a(e))return e>=0?Math.log(e)/Math.LN10:f(new i(e,0));if(e instanceof r)return f(t.number.toNumber(e));if(u(e))return new i(Math.log(Math.sqrt(e.re*e.re+e.im*e.im))/Math.LN10,Math.atan2(e.im,e.re)/Math.LN10);if(c(e))return o.deepMap(e,f);if(s(e))return f(+e);throw new n.error.UnsupportedTypeError("log10",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],136:[function(e,n){n.exports=function(n){function t(e,n){if(n>0)return e>0?e%n:0==e?0:e-n*Math.floor(e/n);if(0==n)return e;throw new Error("Cannot calculate mod for a negative divisor")}var r=e("../../util/index"),i=e("bignumber.js"),o=e("../../type/collection"),a=r.number.isNumber,s=r.number.toNumber,u=r.number.toBigNumber,c=r["boolean"].isBoolean,f=o.isCollection;n.mod=function l(e,r){if(2!=arguments.length)throw new n.error.ArgumentsError("mod",arguments.length,2);if(a(e)&&a(r))return t(e,r);if(e instanceof i)return a(r)?r=u(r):c(r)&&(r=new i(r?1:0)),r instanceof i?e.mod(r):l(s(e),r);if(r instanceof i)return a(e)?e=u(e):c(e)&&(e=new i(e?1:0)),e instanceof i?e.mod(r):l(e,s(r));if(f(e)||f(r))return o.deepMap2(e,r,l);if(c(e))return l(+e,r);if(c(r))return l(e,+r);throw new n.error.UnsupportedTypeError("mod",e,r)}}},{"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],137:[function(e,n){n.exports=function(n){function t(e,t){for(var r=[],i=e.length,o=t[0].length,a=e[0].length,s=0;i>s;s++){r[s]=[];for(var u=0;o>u;u++){for(var c=null,f=0;a>f;f++){var l=n.multiply(e[s][f],t[f][u]);c=null===c?l:n.add(c,l)}r[s][u]=c}}return r}function r(e,t){for(var r=[],i=t.length,o=t[0].length,a=0;o>a;a++){for(var s=null,u=0;i>u;u++){var c=n.multiply(e[u],t[u][a]);s=0===u?c:n.add(s,c)}r[a]=s}return r}function i(e,t){for(var r=[],i=e.length,o=e[0].length,a=0;i>a;a++){for(var s=null,u=0;o>u;u++){var c=n.multiply(e[a][u],t[u]);s=0===u?c:n.add(s,c)}r[a]=s}return r}function o(e,t){var r=e.length,i=null;if(r){i=0;for(var o=0,a=e.length;a>o;o++)i=n.add(i,n.multiply(e[o],t[o]))}return i}function a(e,n){return 0==e.im?0==n.im?new c(e.re*n.re,0):0==n.re?new c(0,e.re*n.im):new c(e.re*n.re,e.re*n.im):0==e.re?0==n.im?new c(0,e.im*n.re):0==n.re?new c(-e.im*n.im,0):new c(-e.im*n.im,e.im*n.re):0==n.im?new c(e.re*n.re,e.im*n.re):0==n.re?new c(-e.im*n.im,e.re*n.im):new c(e.re*n.re-e.im*n.im,e.re*n.im+e.im*n.re)}var s=e("../../util/index"),u=e("bignumber.js"),c=e("../../type/Complex"),f=e("../../type/Matrix"),l=e("../../type/Unit"),m=e("../../type/collection"),p=s.array,h=s.number.isNumber,g=s.number.toNumber,x=s.number.toBigNumber,d=s["boolean"].isBoolean,y=c.isComplex,b=Array.isArray,v=l.isUnit;n.multiply=function w(e,s){if(2!=arguments.length)throw new n.error.ArgumentsError("multiply",arguments.length,2);if(h(e)){if(h(s))return e*s;if(y(s))return a(new c(e,0),s);if(v(s))return res=s.clone(),res.value*=e,res}if(y(e)){if(h(s))return a(e,new c(s,0));if(y(s))return a(e,s)}if(e instanceof u)return h(s)?s=x(s):d(s)&&(s=new u(s?1:0)),s instanceof u?e.times(s):w(g(e),s);if(s instanceof u)return h(e)?e=x(e):d(e)&&(e=new u(e?1:0)),e instanceof u?e.times(s):w(e,g(s));if(v(e)&&h(s))return res=e.clone(),res.value*=s,res;if(b(e)){if(b(s)){var l=p.size(e),E=p.size(s);if(1==l.length){if(1==E.length){if(l[0]!=E[0])throw new RangeError("Dimensions mismatch in multiplication. Length of A must match length of B (A is "+l[0]+", B is "+E[0]+l[0]+" != "+E[0]+")");return o(e,s)}if(2==E.length){if(l[0]!=E[0])throw new RangeError("Dimensions mismatch in multiplication. Length of A must match rows of B (A is "+l[0]+", B is "+E[0]+"x"+E[1]+", "+l[0]+" != "+E[0]+")");return r(e,s)}throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has "+E.length+" dimensions)")}if(2==l.length){if(1==E.length){if(l[1]!=E[0])throw new RangeError("Dimensions mismatch in multiplication. Columns of A must match length of B (A is "+l[0]+"x"+l[0]+", B is "+E[0]+", "+l[1]+" != "+E[0]+")");return i(e,s)}if(2==E.length){if(l[1]!=E[0])throw new RangeError("Dimensions mismatch in multiplication. Columns of A must match rows of B (A is "+l[0]+"x"+l[1]+", B is "+E[0]+"x"+E[1]+", "+l[1]+" != "+E[0]+")");return t(e,s)}throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has "+E.length+" dimensions)")}throw new Error("Can only multiply a 1 or 2 dimensional matrix (A has "+l.length+" dimensions)")}return s instanceof f?new f(w(e,s.valueOf())):m.deepMap2(e,s,w)}if(e instanceof f)return s instanceof f?new f(w(e.valueOf(),s.valueOf())):new f(w(e.valueOf(),s));
if(b(s))return m.deepMap2(e,s,w);if(s instanceof f)return new f(m.deepMap2(e,s.valueOf(),w));if(d(e))return w(+e,s);if(d(s))return w(e,+s);throw new n.error.UnsupportedTypeError("multiply",e,s)}}},{"../../type/Complex":203,"../../type/Matrix":206,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],138:[function(e,n){n.exports=function(n){function t(e,t){var r=n.log(e),i=n.multiply(r,t);return n.exp(i)}var r=e("../../util/index"),i=e("bignumber.js"),o=e("../../type/Complex"),a=e("../../type/Matrix"),s=(e("../../type/collection"),r.array),u=r.number.isNumber,c=r.number.toNumber,f=r.number.toBigNumber,l=r["boolean"].isBoolean,m=Array.isArray,p=r.number.isInteger,h=o.isComplex;n.pow=function g(e,r){if(2!=arguments.length)throw new n.error.ArgumentsError("pow",arguments.length,2);if(u(e)){if(u(r))return p(r)||e>=0?Math.pow(e,r):t(new o(e,0),new o(r,0));if(h(r))return t(new o(e,0),r)}if(h(e)){if(u(r))return t(e,new o(r,0));if(h(r))return t(e,r)}if(e instanceof i)return u(r)?r=f(r):l(r)&&(r=new i(r?1:0)),r instanceof i?e.pow(r):g(c(e),r);if(r instanceof i)return u(e)?e=f(e):l(e)&&(e=new i(e?1:0)),e instanceof i?e.pow(r):g(e,c(r));if(m(e)){if(!u(r)||!p(r)||0>r)throw new TypeError("For A^b, b must be a positive integer (value is "+r+")");var x=s.size(e);if(2!=x.length)throw new Error("For A^b, A must be 2 dimensional (A has "+x.length+" dimensions)");if(x[0]!=x[1])throw new Error("For A^b, A must be square (size is "+x[0]+"x"+x[1]+")");if(0==r)return n.eye(x[0]);for(var d=e,y=1;r>y;y++)d=n.multiply(e,d);return d}if(e instanceof a)return new a(g(e.valueOf(),r));if(l(e))return g(+e,r);if(l(r))return g(e,+r);throw new n.error.UnsupportedTypeError("pow",e,r)}}},{"../../type/Complex":203,"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],139:[function(e,n){n.exports=function(n){function t(e,n){if(n){var t=Math.pow(10,n);return Math.round(e*t)/t}return Math.round(e)}var r=e("../../util/index"),i=e("bignumber.js"),o=e("../../type/Complex"),a=e("../../type/collection"),s=r.number.isNumber,u=r.number.isInteger,c=r["boolean"].isBoolean,f=o.isComplex,l=a.isCollection;n.round=function m(e,r){if(1!=arguments.length&&2!=arguments.length)throw new n.error.ArgumentsError("round",arguments.length,1,2);if(void 0==r){if(s(e))return Math.round(e);if(f(e))return new o(Math.round(e.re),Math.round(e.im));if(e instanceof i)return e.round();if(l(e))return a.deepMap(e,m);if(c(e))return Math.round(e);throw new n.error.UnsupportedTypeError("round",e)}if(r instanceof i&&(r=parseFloat(r.valueOf())),!s(r)||!u(r))throw new TypeError("Number of decimals in function round must be an integer");if(0>r||r>9)throw new Error("Number of decimals in function round must be in te range of 0-9");if(s(e))return t(e,r);if(f(e))return new o(t(e.re,r),t(e.im,r));if(e instanceof i&&s(r))return e.round(r);if(l(e)||l(r))return a.deepMap2(e,r,m);if(c(e))return m(+e,r);if(c(r))return m(e,+r);throw new n.error.UnsupportedTypeError("round",e,r)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],140:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number,s=t.number.isNumber,u=t["boolean"].isBoolean,c=i.isComplex,f=o.isCollection;n.sign=function l(e){if(1!=arguments.length)throw new n.error.ArgumentsError("sign",arguments.length,1);if(s(e))return a.sign(e);if(c(e)){var t=Math.sqrt(e.re*e.re+e.im*e.im);return new i(e.re/t,e.im/t)}if(e instanceof r)return new r(e.cmp(0));if(f(e))return o.deepMap(e,l);if(u(e))return a.sign(e);throw new n.error.UnsupportedTypeError("sign",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],141:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t.number.toNumber,c=t.number.toBigNumber,f=t["boolean"].isBoolean,l=t.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;n.smaller=function g(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("smaller",arguments.length,2);if(s(e)&&s(t))return t>e;if(e instanceof r)return s(t)?t=c(t):f(t)&&(t=new r(t?1:0)),t instanceof r?e.lt(t):g(u(e),t);if(t instanceof r)return s(e)?e=c(e):f(e)&&(e=new r(e?1:0)),e instanceof r?e.lt(t):g(e,u(t));if(p(e)&&p(t)){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return e.value<t.value}if(l(e)||l(t))return t>e;if(h(e)||h(t))return a.deepMap2(e,t,g);if(f(e))return g(+e,t);if(f(t))return g(e,+t);if(m(e)||m(t))throw new TypeError("No ordering relation is defined for complex numbers");throw new n.error.UnsupportedTypeError("smaller",e,t)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],142:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t.number.toNumber,c=t.number.toBigNumber,f=t["boolean"].isBoolean,l=t.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;n.smallereq=function g(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("smallereq",arguments.length,2);if(s(e)&&s(t))return t>=e;if(e instanceof r)return s(t)?t=c(t):f(t)&&(t=new r(t?1:0)),t instanceof r?e.lte(t):g(u(e),t);if(t instanceof r)return s(e)?e=c(e):f(e)&&(e=new r(e?1:0)),e instanceof r?e.lte(t):g(e,u(t));if(p(e)&&p(t)){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return e.value<=t.value}if(l(e)||l(t))return t>=e;if(h(e)||h(t))return a.deepMap2(e,t,g);if(f(e))return g(+e,t);if(f(t))return g(e,+t);if(m(e)||m(t))throw new TypeError("No ordering relation is defined for complex numbers");throw new n.error.UnsupportedTypeError("smallereq",e,t)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],143:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.sqrt=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("sqrt",arguments.length,1);if(a(e))return e>=0?Math.sqrt(e):f(new i(e,0));if(u(e)){var t=Math.sqrt(e.re*e.re+e.im*e.im);return e.im>=0?new i(.5*Math.sqrt(2*(t+e.re)),.5*Math.sqrt(2*(t-e.re))):new i(.5*Math.sqrt(2*(t+e.re)),-.5*Math.sqrt(2*(t-e.re)))}if(e instanceof r)return e.sqrt();if(c(e))return o.deepMap(e,f);if(s(e))return f(+e);throw new n.error.UnsupportedTypeError("sqrt",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],144:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.square=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("square",arguments.length,1);if(a(e))return e*e;if(u(e))return n.multiply(e,e);if(e instanceof r)return e.times(e);if(c(e))return o.deepMap(e,f);if(s(e))return e*e;throw new n.error.UnsupportedTypeError("square",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],145:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=(e("../../type/Matrix"),e("../../type/Unit")),a=e("../../type/collection"),s=t.number.toNumber,u=t.number.toBigNumber,c=t["boolean"].isBoolean,f=t.number.isNumber,l=i.isComplex,m=o.isUnit,p=a.isCollection;n.subtract=function h(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("subtract",arguments.length,2);if(f(e)){if(f(t))return e-t;if(l(t))return new i(e-t.re,-t.im)}else if(l(e)){if(f(t))return new i(e.re-t,e.im);if(l(t))return new i(e.re-t.re,e.im-t.im)}if(e instanceof r)return f(t)?t=u(t):c(t)&&(t=new r(t?1:0)),t instanceof r?e.minus(t):h(s(e),t);if(t instanceof r)return f(e)?e=u(e):c(e)&&(e=new r(e?1:0)),e instanceof r?e.minus(t):h(e,s(t));if(m(e)&&m(t)){if(!e.equalBase(t))throw new Error("Units do not match");if(null==e.value)throw new Error("Unit on left hand side of operator - has an undefined value");if(null==t.value)throw new Error("Unit on right hand side of operator - has an undefined value");var o=e.clone();return o.value-=t.value,o.fixPrefix=!1,o}if(p(e)||p(t))return a.deepMap2(e,t,h);if(c(e))return h(+e,t);if(c(t))return h(e,+t);throw new n.error.UnsupportedTypeError("subtract",e,t)}}},{"../../type/Complex":203,"../../type/Matrix":206,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],146:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;n.unary=function m(e){if(1!=arguments.length)throw new n.error.ArgumentsError("unary",arguments.length,1);if(s(e))return-e;if(c(e))return new i(-e.re,-e.im);if(e instanceof r)return e.neg();if(f(e)){var t=e.clone();return t.value=-e.value,t}if(l(e))return a.deepMap(e,m);if(u(e))return-e;throw new n.error.UnsupportedTypeError("unary",e)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],147:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t.number.toNumber,c=t.number.toBigNumber,f=t["boolean"].isBoolean,l=t.string.isString,m=i.isComplex,p=o.isUnit,h=a.isCollection;n.unequal=function g(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("unequal",arguments.length,2);if(s(e)){if(s(t))return e!=t;if(m(t))return e!=t.re||0!=t.im}if(m(e)){if(s(t))return e.re!=t||0!=e.im;if(m(t))return e.re!=t.re||e.im!=t.im}if(e instanceof r)return s(t)?t=c(t):f(t)&&(t=new r(t?1:0)),t instanceof r?!e.eq(t):g(u(e),t);if(t instanceof r)return s(e)?e=c(e):f(e)&&(e=new r(e?1:0)),e instanceof r?!e.eq(t):g(e,u(t));if(p(e)&&p(t)){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return e.value!=t.value}if(l(e)||l(t))return e!=t;if(h(e)||h(t))return a.deepMap2(e,t,g);if(f(e))return g(+e,t);if(f(t))return g(e,+t);throw new n.error.UnsupportedTypeError("unequal",e,t)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],148:[function(e,n){n.exports=function(n){function t(e,n){for(var t,r,i,o=0,a=1,s=1,u=0;n;)r=Math.floor(e/n),i=e%n,t=o,o=a-r*o,a=t,t=s,s=u-r*s,u=t,e=n,n=i;return 0>e?[-e,e?-a:0,-u]:[e,e?a:0,u]}var r=e("../../util/index"),i=e("bignumber.js"),o=r.number.toNumber,a=r.number.isNumber,s=r["boolean"].isBoolean,u=r.number.isInteger;n.xgcd=function c(e,r){if(2==arguments.length){if(a(e)&&a(r)){if(!u(e)||!u(r))throw new Error("Parameters in function xgcd must be integer numbers");return t(e,r)}if(e instanceof i)return c(o(e),r);if(r instanceof i)return c(e,o(r));if(s(e))return c(+e,r);if(s(r))return c(e,+r);throw new n.error.UnsupportedTypeError("xgcd",e,r)}throw new SyntaxError("Function xgcd expects two arguments")}}},{"../../util/index":213,"bignumber.js":218}],149:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=o.isCollection,c=i.isComplex;n.arg=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("arg",arguments.length,1);if(a(e))return Math.atan2(0,e);if(c(e))return Math.atan2(e.im,e.re);if(u(e))return o.deepMap(e,f);if(s(e))return f(+e);if(e instanceof r)return f(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("arg",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],150:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.object,s=t.number.isNumber,u=t["boolean"].isBoolean,c=o.isCollection,f=i.isComplex;n.conj=function l(e){if(1!=arguments.length)throw new n.error.ArgumentsError("conj",arguments.length,1);return s(e)?e:e instanceof r?new r(e):f(e)?new i(e.re,-e.im):c(e)?o.deepMap(e,l):u(e)?+e:a.clone(e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],151:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=o.isCollection,c=i.isComplex;n.im=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("im",arguments.length,1);return a(e)?0:e instanceof r?new r(0):c(e)?e.im:u(e)?o.deepMap(e,f):s(e)?0:0}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],152:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.object,s=t.number.isNumber,u=t["boolean"].isBoolean,c=o.isCollection,f=i.isComplex;n.re=function l(e){if(1!=arguments.length)throw new n.error.ArgumentsError("re",arguments.length,1);return s(e)?e:e instanceof r?new r(e):f(e)?e.re:c(e)?o.deepMap(e,l):u(e)?+e:a.clone(e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],153:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/collection"),o=i.isCollection,a=t.number.isNumber,s=t.string.isString,u=t["boolean"].isBoolean;"function"!=typeof r.prototype.clone&&(r.prototype.clone=function(){return new r(this)}),n.bignumber=function c(e){if(arguments.length>1)throw new n.error.ArgumentsError("bignumber",arguments.length,0,1);if(e instanceof r||a(e)||s(e))return new r(e);if(u(e))return new r(+e);if(o(e))return i.deepMap(e,c);if(0==arguments.length)return new r(0);throw new n.error.UnsupportedTypeError("bignumber",e)}}},{"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],154:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/collection"),o=i.isCollection,a=t.number.isNumber,s=t.string.isString;n["boolean"]=function u(e){if(1!=arguments.length)throw new n.error.ArgumentsError("boolean",arguments.length,0,1);if("true"===e||e===!0)return!0;if("false"===e||e===!1)return!1;if(e instanceof Boolean)return e?!0:!1;if(a(e))return 0!==e;if(e instanceof r)return!e.isZero();if(s(e)){var t=e.toLowerCase();if("true"===t)return!0;if("false"===t)return!1;var c=Number(e);if(""!=e&&!isNaN(c))return 0!==c}if(o(e))return i.deepMap(e,u);throw new SyntaxError(e.toString()+" is no valid boolean")}}},{"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],155:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=o.isCollection,s=t.number.isNumber,u=t.number.toNumber,c=t.string.isString,f=i.isComplex;n.complex=function l(){switch(arguments.length){case 0:return new i(0,0);case 1:var e=arguments[0];if(s(e))return new i(e,0);if(e instanceof r)return new i(u(e),0);if(f(e))return e.clone();if(c(e)){var t=i.parse(e);if(t)return t;throw new SyntaxError('String "'+e+'" is no valid complex number')}if(a(e))return o.deepMap(e,l);throw new TypeError("Two numbers or a single string expected in function complex");case 2:var m=arguments[0],p=arguments[1];if(m instanceof r&&(m=u(m)),p instanceof r&&(p=u(p)),s(m)&&s(p))return new i(m,p);throw new TypeError("Two numbers or a single string expected in function complex");default:throw new n.error.ArgumentsError("complex",arguments.length,0,2)}}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],156:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Index"),o=t.number.toNumber;n.index=function(){var e=new i,n=Array.prototype.slice.apply(arguments).map(function(e){return e instanceof r?o(e):Array.isArray(e)?e.map(function(e){return e instanceof r?o(e):e}):e});return i.apply(e,n),e}}},{"../../type/Index":205,"../../util/index":213,"bignumber.js":218}],157:[function(e,n){n.exports=function(n){var t=e("../../type/Matrix");n.matrix=function(e){if(arguments.length>1)throw new n.error.ArgumentsError("matrix",arguments.length,0,1);return new t(e)}}},{"../../type/Matrix":206}],158:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/collection"),o=i.isCollection,a=t.number.toNumber;n.number=function s(e){switch(arguments.length){case 0:return 0;case 1:if(o(e))return i.deepMap(e,s);if(e instanceof r)return a(e);var t=Number(e);if(isNaN(t)&&(t=Number(e.valueOf())),isNaN(t))throw new SyntaxError(e.toString()+" is no valid number");return t;default:throw new n.error.ArgumentsError("number",arguments.length,0,1)}}}},{"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],159:[function(e,n){n.exports=function(n){var t=e("../../expression/Parser");n.parser=function(){return new t(n)}}},{"../../expression/Parser":4}],160:[function(e,n){n.exports=function(e){e.select=function(n){return new e.chaining.Selector(n)}}},{}],161:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("../../type/collection"),i=t.number,o=t.number.isNumber,a=r.isCollection;n.string=function s(e){switch(arguments.length){case 0:return"";case 1:return o(e)?i.format(e):a(e)?r.deepMap(e,s):null===e?"null":e.toString();default:throw new n.error.ArgumentsError("string",arguments.length,0,1)}}}},{"../../type/collection":209,"../../util/index":213}],162:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Unit"),o=e("../../type/collection"),a=o.isCollection,s=t.number.toNumber,u=t.string.isString;n.unit=function c(e){switch(arguments.length){case 1:var t=arguments[0];if(t instanceof i)return t.clone();if(u(t)){if(i.isPlainUnit(t))return new i(null,t);var f=i.parse(t);if(f)return f;throw new SyntaxError('String "'+t+'" is no valid unit')}if(a(e))return o.deepMap(e,c);throw new TypeError("A string or a number and string expected in function unit");case 2:return arguments[0]instanceof r?new i(s(arguments[0]),arguments[1]):new i(arguments[0],arguments[1]);default:throw new n.error.ArgumentsError("unit",arguments.length,1,2)}}}},{"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],163:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("../../expression/Scope"),i=e("../../type/collection"),o=t.string.isString,a=i.isCollection;n.eval=function(e,t){if(1!=arguments.length&&2!=arguments.length)throw new n.error.ArgumentsError("eval",arguments.length,1,2);var s;if(s=t?t instanceof r?t:new r(n,t):new r(n),o(e)){var u=n.parse(e,s);return u.eval()}if(a(e))return i.deepMap(e,function(e){var t=n.parse(e,s);return t.eval()});throw new TypeError("String or matrix expected")}}},{"../../expression/Scope":5,"../../type/collection":209,"../../util/index":213}],164:[function(e,n){n.exports=function(n){var t=e("../../type/Help");n.help=function(e){if(1!=arguments.length)throw new SyntaxError("Wrong number of arguments in function help ("+arguments.length+" provided, 1 expected)");var r=null;if(e instanceof String||"string"==typeof e)r=e;else{var i;for(i in n)if(n.hasOwnProperty(i)&&e===n[i]){r=i;break}if(!r)for(i in n.type)if(n.type.hasOwnProperty(i)&&e===n.type[i]){r=i;break}}if(r){var o=n.expression.docs[r];if(!o)throw new Error('No documentation found on "'+r+'"');return new t(n,o)}throw new Error('Could not find search term "'+e+'"')}}},{"../../type/Help":204}],165:[function(e,n){n.exports=function(n,t){function r(){ln=0,mn=fn.charAt(0)}function i(){ln++,mn=fn.charAt(ln)}function o(){return fn.charAt(ln+1)}function a(){for(hn=sn.NULL,pn="";" "==mn||"	"==mn;)i();if("#"==mn)for(;"\n"!=mn&&""!=mn;)i();if(""==mn)return hn=sn.DELIMITER,void 0;var e=mn+o();if(un[e])return hn=sn.DELIMITER,pn=e,i(),i(),void 0;if(un[mn])return hn=sn.DELIMITER,pn=mn,i(),void 0;if(!u(mn)){if(s(mn)){for(;s(mn)||c(mn);)pn+=mn,i();return hn=cn[pn]?sn.DELIMITER:sn.SYMBOL,void 0}for(hn=sn.UNKNOWN;""!=mn;)pn+=mn,i();throw B('Syntax error in part "'+pn+'"')}if(hn=sn.NUMBER,"."==mn)pn+=mn,i(),c(mn)||(hn=sn.UNKNOWN);else{for(;c(mn);)pn+=mn,i();"."==mn&&(pn+=mn,i())}for(;c(mn);)pn+=mn,i();if("E"==mn||"e"==mn)for(pn+=mn,i(),("+"==mn||"-"==mn)&&(pn+=mn,i()),c(mn)||(hn=sn.UNKNOWN);c(mn);)pn+=mn,i()}function s(e){return e>="a"&&"z">=e||e>="A"&&"Z">=e||"_"==e}function u(e){return e>="0"&&"9">=e||"."==e}function c(e){return e>="0"&&"9">=e}function f(e){r(),a();var n;if(n=""==pn?new $(void 0):l(e),""!=pn)throw hn==sn.DELIMITER?_("Unknown operator "+pn):B('Unexpected part "'+pn+'"');return n}function l(e){var n,t,r;for("\n"!=pn&&";"!=pn&&""!=pn&&(n=m(e));"\n"==pn||";"==pn;)t||(t=new K,n&&(r=";"!=pn,t.add(n,r))),a(),"\n"!=pn&&";"!=pn&&""!=pn&&(n=m(e),r=";"!=pn,t.add(n,r));return t?t:(n||(n=m(e)),n)}function m(e){var n=p(e),t="ans";return new Z(t,n,e)}function p(e){if(hn==sn.SYMBOL&&"function"==pn){if(a(),hn!=sn.SYMBOL)throw B("Function name expected");var n=pn;if(a(),"("!=pn)throw B("Opening parenthesis ( expected");for(var t=e.createSubScope(),r=[];;)if(a(),hn==sn.SYMBOL&&(r.push(pn),a()),","!=pn){if(")"==pn)break;throw B('Comma , or closing parenthesis ) expected"')}if(a(),"="!=pn)throw B("Equal sign = expected");a();var i=h(t);return new X(n,r,i,t,e)}return h(e)}function h(e){var t,r,i,o,s=g(e);if("="==pn){if(s instanceof tn)return a(),t=s.name,r=null,o=h(e),new Z(t,o,e);if(s instanceof en&&s.object instanceof tn)return a(),t=s.object.name,r=s.params,i=s.paramScopes,o=h(e),new on(n,t,r,i,o,e);throw B("Symbol expected at the left hand side of assignment operator =")}return s}function g(e){var r,i=[];if(":"==pn){var o="bignumber"===t.number?new D(1):1;r=new $(o)}else r=x(e);if(":"==pn){for(i.push(r);":"==pn;)a(),")"==pn||","==pn||""==pn?i.push(new tn("end",e)):i.push(x(e));i.length&&(r=new nn(n,t,i))}return r}function x(e){var n=d(e);return n}function d(e){var t,r,i,o,s;for(t=y(e),r={"==":n.equal,"!=":n.unequal,"<":n.smaller,">":n.larger,"<=":n.smallereq,">=":n.largereq};pn in r;)i=pn,o=r[i],a(),s=[t,y(e)],t=new J(i,o,s);return t}function y(e){var t,r,i,o,s;for(t=b(e),r={"in":n["in"]};pn in r;)i=pn,o=r[i],a(),s=[t,b(e)],t=new J(i,o,s);return t}function b(e){var t,r,i,o,s;for(t=v(e),r={"+":n.add,"-":n.subtract};pn in r;)i=pn,o=r[i],a(),s=[t,v(e)],t=new J(i,o,s);return t}function v(e){var t,r,i,o,s;for(t=w(e),r={"*":n.multiply,".*":n.emultiply,"/":n.divide,"./":n.edivide,"%":n.mod,mod:n.mod};pn in r;)i=pn,o=r[i],a(),s=[t,w(e)],t=new J(i,o,s);return t}function w(e){var n,t;for(n=E(e);hn==sn.SYMBOL;)t=pn,a(),n=new rn(n,t);return n}function E(e){var t,r,i;return"-"==pn?(t=pn,r=n.unary,a(),i=[E(e)],new J(t,r,i)):N(e)}function N(e){var t,r,i,o,s,u,c;for(i=[M(e)],o=[];"^"==pn||".^"==pn;)o.push(pn),a(),i.push(M(e));for(t=i.pop();i.length;)r=i.pop(),s=o.pop(),u="^"==s?n.pow:n.epow,c=[r,t],t=new J(s,u,c);return t}function M(e){var t,r,i,o,s;for(t=j(e),r={"!":n.factorial,"'":n.transpose};pn in r;)i=pn,o=r[i],a(),s=[t],t=new J(i,o,s);return t}function j(e){var n,t,r,i;if(hn==sn.SYMBOL&&an[pn]){if(i=an[pn],a(),"("==pn){if(n=[],t=[],a(),")"!=pn)for(r=e.createSubScope(),t.push(r),n.push(g(r));","==pn;)a(),r=e.createSubScope(),t.push(r),n.push(g(r));if(")"!=pn)throw B("Parenthesis ) expected");a()}return new i(n,t)}return C(e)}function C(e){var n,t;return hn==sn.SYMBOL||hn==sn.DELIMITER&&pn in cn?(t=pn,a(),n=new tn(t,e),A(e,n)):O(e)}function A(e,t){for(var r,i,o,s;"("==pn;){if(r=pn,i=[],o=[],a(),")"!=pn)for(s=e.createSubScope(),o.push(s),i.push(g(s));","==pn;)a(),s=e.createSubScope(),o.push(s),i.push(g(s));if("("==r&&")"!=pn)throw B("Parenthesis ) expected");a(),t=new en(n,t,i,o)}return t}function O(e){var n,t,r;if('"'==pn){for(t="",r="";""!=mn&&('"'!=mn||"\\"==r);)t+=mn,r=mn,i();if(a(),'"'!=pn)throw B('End of string " expected');return a(),n=new $(t),n=A(e,n)}return S(e)}function S(e){var n,r,i,o;if("["==pn){for(a();"\n"==pn;)a();if("]"!=pn){var s=T(e);if(";"==pn){for(i=1,r=[s];";"==pn;){for(a();"\n"==pn;)a();for(r[i]=T(e),i++;"\n"==pn;)a()}if("]"!=pn)throw B("End of matrix ] expected");a(),o=r.length>0?r[0].length:0;for(var u=1;i>u;u++)if(r[u].length!=o)throw _("Number of columns must match ("+r[u].length+" != "+o+")");n=new Q(t,r)}else{if("]"!=pn)throw B("End of matrix ] expected");a(),n=s}}else a(),n=new Q(t,[]);return n=A(e,n)}return U(e)}function T(e){for(var n=[h(e)],r=1;","==pn;){for(a();"\n"==pn;)a();for(n[r]=h(e),r++;"\n"==pn;)a()}return new Q(t,n)}function U(e){var n,r,i;return hn==sn.NUMBER?(i="bignumber"==t.number?new D("."==pn?0:pn):"."==pn?0:Number(pn),a(),"i"==pn||"I"==pn?(i=i instanceof D?k(i):i,r=new H(0,i),a(),n=new $(r)):n=new $(i),n=A(e,n)):q(e)}function q(e){var n;if("("==pn){if(a(),n=h(e),")"!=pn)throw B("Parenthesis ) expected");return a(),n=A(e,n)}return z(e)}function z(){throw""==pn?B("Unexpected end of expression"):B("Value expected")}function R(){return void 0}function I(){return ln-pn.length+1}function L(e){var n=R(),t=I();return void 0===n?void 0===t?e:e+" (char "+t+")":e+" (line "+n+", char "+t+")"}function B(e){return new SyntaxError(L(e))}function _(e){return new Error(L(e))}var P=e("../../util/index"),k=P.number.toNumber,F=P.string.isString,G=Array.isArray,D=e("bignumber.js"),H=e("./../../type/Complex"),V=e("./../../type/Matrix"),Y=(e("./../../type/Unit"),e("../../type/collection")),W=e("./../../expression/Scope"),Q=e("../../expression/node/ArrayNode"),Z=e("../../expression/node/AssignmentNode"),K=e("../../expression/node/BlockNode"),$=e("../../expression/node/ConstantNode"),X=e("../../expression/node/FunctionNode"),J=e("../../expression/node/OperatorNode"),en=e("../../expression/node/ParamsNode"),nn=e("../../expression/node/RangeNode"),tn=e("../../expression/node/SymbolNode"),rn=e("../../expression/node/UnitNode"),on=e("../../expression/node/UpdateNode"),an=e("../../expression/node/handlers");n.parse=function(e,t){if(1!=arguments.length&&2!=arguments.length)throw new n.error.ArgumentsError("parse",arguments.length,1,2);var r;if(r=t?t instanceof W?t:new W(n,t):new W(n),F(e))return fn=e||"",f(r);if(G(e)||e instanceof V)return Y.deepMap(e,function(e){return fn=e||"",f(r)});throw new TypeError("String or matrix expected")};var sn={NULL:0,DELIMITER:1,NUMBER:2,SYMBOL:3,UNKNOWN:4},un={",":!0,"(":!0,")":!0,"[":!0,"]":!0,'"':!0,"\n":!0,";":!0,"+":!0,"-":!0,"*":!0,".*":!0,"/":!0,"./":!0,"%":!0,"^":!0,".^":!0,"!":!0,"'":!0,"=":!0,":":!0,"==":!0,"!=":!0,"<":!0,">":!0,"<=":!0,">=":!0},cn={mod:!0,"in":!0},fn="",ln=0,mn="",pn="",hn=sn.NULL}},{"../../expression/node/ArrayNode":104,"../../expression/node/AssignmentNode":105,"../../expression/node/BlockNode":106,"../../expression/node/ConstantNode":107,"../../expression/node/FunctionNode":108,"../../expression/node/OperatorNode":110,"../../expression/node/ParamsNode":111,"../../expression/node/RangeNode":112,"../../expression/node/SymbolNode":113,"../../expression/node/UnitNode":114,"../../expression/node/UpdateNode":115,"../../expression/node/handlers":116,"../../type/collection":209,"../../util/index":213,"./../../expression/Scope":5,"./../../type/Complex":203,"./../../type/Matrix":206,"./../../type/Unit":208,"bignumber.js":218}],166:[function(e,n){n.exports=function(n){function t(e,n,r,i){if(r>i){if(e.length!=n.length)throw new Error("Dimensions mismatch ("+e.length+" != "+n.length+")");for(var o=[],a=0;a<e.length;a++)o[a]=t(e[a],n[a],r,i+1);return o}return e.concat(n)}var r=e("../../util/index"),i=e("../../type/Matrix"),o=e("../../type/collection"),a=r.object,s=r.array,u=r.number.isNumber,c=r.number.isInteger,f=o.isCollection;n.concat=function(){var e,r,o=arguments.length,l=-1,m=!1,p=[];for(e=0;o>e;e++){var h=arguments[e];if(h instanceof i&&(m=!0),e==o-1&&u(h)){if(r=l,l=h,!c(l)||0>l)throw new TypeError("Dimension number must be a positive integer (dim = "+l+")");if(e>0&&l>r)throw new RangeError("Dimension out of range ("+l+" > "+r+")")}else{if(!f(h))throw new n.error.UnsupportedTypeError("concat",h);var g=a.clone(h).valueOf(),x=s.size(h.valueOf());if(p[e]=g,r=l,l=x.length-1,e>0&&l!=r)throw new RangeError("Dimension mismatch ("+r+" != "+l+")")}}if(0==p.length)throw new SyntaxError("At least one matrix expected");for(var d=p.shift();p.length;)d=t(d,p.shift(),l,0);return m?new i(d):d}}},{"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213}],167:[function(e,n){n.exports=function(n){function t(e,t,r){if(1==t)return e[0][0];if(2==t)return n.subtract(n.multiply(e[0][0],e[1][1]),n.multiply(e[1][0],e[0][1]));for(var o=1,a=0,s=0;t>s&&!(a>=r);s++){for(var u=s;0==e[u][a];)if(u++,u==t&&(u=s,a++,a==r))return i.deepEqual(e,eye(t).valueOf())?n.round(o,6):0;if(u!=s){for(var c=0;r>c;c++){var f=e[u][c];e[u][c]=e[s][c],e[s][c]=f}o*=-1}for(var l=e[s][a],c=0;r>c;c++)e[s][c]=e[s][c]/l;o*=l;for(var m=0;t>m;m++)if(m!=s)for(var p=e[m][a],c=0;r>c;c++)e[m][c]=e[m][c]-e[s][c]*p;a++}return i.deepEqual(e,n.eye(t).valueOf())?n.round(o,6):0}var r=e("../../util/index"),i=(e("../../type/Matrix"),r.object),o=r.array,a=r.string;n.det=function(e){if(1!=arguments.length)throw new n.error.ArgumentsError("det",arguments.length,1);var r=o.size(e.valueOf());switch(r.length){case 0:return i.clone(e);case 1:if(1==r[0])return i.clone(e.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+a.format(r)+")");case 2:var s=r[0],u=r[1];if(s==u)return t(e.valueOf(),s,u);throw new RangeError("Matrix must be square (size: "+a.format(r)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+a.format(r)+")")}}}},{"../../type/Matrix":206,"../../util/index":213}],168:[function(e,n){n.exports=function(n,t){var r=e("../../util/index"),i=e("../../type/Matrix"),o=(e("../../type/collection"),r.object),a=r.array.isArray,s=r.number.isNumber,u=r.number.isInteger;n.diag=function(e,r){var c,f,l,m;if(1!=arguments.length&&2!=arguments.length)throw new n.error.ArgumentsError("diag",arguments.length,1,2);if(r){if(!s(r)||!u(r))throw new TypeError("Second parameter in function diag must be an integer")}else r=0;var p=r>0?r:0,h=0>r?-r:0;if(e instanceof i);else{if(!a(e))throw new TypeError("First parameter in function diag must be a Matrix or Array");e=new i(e)}var g=e.size();switch(g.length){case 1:f=e.valueOf();var x=new i,d=0;for(x.resize([f.length+h,f.length+p],d),c=x.valueOf(),m=f.length,l=0;m>l;l++)c[l+h][l+p]=o.clone(f[l]);return"array"===t.matrix?x.valueOf():x;case 2:for(f=[],c=e.valueOf(),m=Math.min(g[0]-h,g[1]-p),l=0;m>l;l++)f[l]=o.clone(c[l+h][l+p]);return"array"===t.matrix?f:new i(f);default:throw new RangeError("Matrix for function diag must be 2 dimensional")}}}},{"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213}],169:[function(e,n){n.exports=function(n,t){var r=e("../../util/index"),i=e("bignumber.js"),o=e("../../type/Matrix"),a=e("../../type/collection"),s=r.number.toNumber,u=r.number.isNumber,c=r.number.isInteger,f=Array.isArray;n.eye=function(e){var r=a.argsToArray(arguments),l=e instanceof o?!0:f(e)?!1:"matrix"===t.matrix;if(0==r.length)return l?new o:[];if(1==r.length)r[1]=r[0];else if(r.length>2)throw new n.error.ArgumentsError("eye",r.length,0,2);var m=r[0]instanceof i,p=r[0],h=r[1];if(p instanceof i&&(p=s(p)),h instanceof i&&(h=s(h)),!u(p)||!c(p)||1>p)throw new Error("Parameters in function eye must be positive integers");if(h&&(!u(h)||!c(h)||1>h))throw new Error("Parameters in function eye must be positive integers");var g=new o,x=m?new i(1):1,d=m?new i(0):0;g.resize(r.map(s),d);for(var y=n.min(r),b=g.valueOf(),v=0;y>v;v++)b[v][v]=x;return l?g:g.valueOf()
}}},{"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],170:[function(e,n){n.exports=function(n){function t(e,t,r){var i,o,a,s,u;if(1==t){if(s=e[0][0],0==s)throw Error("Cannot calculate inverse, determinant is zero");return[[n.divide(1,s)]]}if(2==t){var c=n.det(e);if(0==c)throw Error("Cannot calculate inverse, determinant is zero");return[[n.divide(e[1][1],c),n.divide(n.unary(e[0][1]),c)],[n.divide(n.unary(e[1][0]),c),n.divide(e[0][0],c)]]}var f=e.concat();for(i=0;t>i;i++)f[i]=f[i].concat();for(var l=n.eye(t).valueOf(),m=0;r>m;m++){for(i=m;t>i&&0==f[i][m];)i++;if(i==t||0==f[i][m])throw Error("Cannot calculate inverse, determinant is zero");i!=m&&(u=f[m],f[m]=f[i],f[i]=u,u=l[m],l[m]=l[i],l[i]=u);var p=f[m],h=l[m];for(i=0;t>i;i++){var g=f[i],x=l[i];if(i!=m){if(0!=g[m]){for(a=n.divide(n.unary(g[m]),p[m]),o=m;r>o;o++)g[o]=n.add(g[o],n.multiply(a,p[o]));for(o=0;r>o;o++)x[o]=n.add(x[o],n.multiply(a,h[o]))}}else{for(a=p[m],o=m;r>o;o++)g[o]=n.divide(g[o],a);for(o=0;r>o;o++)x[o]=n.divide(x[o],a)}}}return l}{var r=e("../../util/string"),i=e("../../type/Matrix");e("../../type/collection")}n.inv=function(e){if(1!=arguments.length)throw new n.error.ArgumentsError("inv",arguments.length,1);var o=n.size(e).valueOf();switch(o.length){case 0:return n.divide(1,e);case 1:if(1==o[0])return e instanceof i?new i([n.divide(1,e.valueOf()[0])]):[n.divide(1,e[0])];throw new RangeError("Matrix must be square (size: "+r.format(o)+")");case 2:var a=o[0],s=o[1];if(a==s)return e instanceof i?new i(t(e.valueOf(),a,s)):t(e,a,s);throw new RangeError("Matrix must be square (size: "+r.format(o)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+r.format(o)+")")}}}},{"../../type/Matrix":206,"../../type/collection":209,"../../util/string":216}],171:[function(e,n){n.exports=function(n,t){var r=e("../../util/index"),i=e("bignumber.js"),o=e("../../type/Matrix"),a=e("../../type/collection"),s=r.array,u=r.number.toNumber,c=Array.isArray;n.ones=function(e){var n=a.argsToArray(arguments),r=e instanceof o?!0:c(e)?!1:"matrix"===t.matrix;if(0==n.length)return r?new o:[];var f=[],l=n[0]instanceof i?new i(1):1;return f=s.resize(f,n.map(u),l),r?new o(f):f}}},{"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],172:[function(e,n){n.exports=function(n,t){function r(e,n,t){var r=[],i=e;if(t>0)for(;n>i;)r.push(i),i+=t;else if(0>t)for(;i>n;)r.push(i),i+=t;return r}function i(e,n,t){var r=[],i=e.clone(),o=new s(0);if(t.gt(o))for(;i.lt(n);)r.push(i),i=i.plus(t);else if(t.lt(o))for(;i.gt(n);)r.push(i),i=i.plus(t);return r}function o(e){var n=e.split(":"),r=null;if("bignumber"===t.number)try{r=n.map(function(e){return new s(e)})}catch(i){return null}else{r=n.map(function(e){return parseFloat(e)});var o=r.some(function(e){return isNaN(e)});if(o)return null}switch(r.length){case 2:return{start:r[0],end:r[1],step:1};case 3:return{start:r[0],end:r[2],step:r[1]};default:return null}}var a=e("../../util/index"),s=e("bignumber.js"),u=e("../../type/Matrix"),c=(e("../../type/collection"),a.string.isString),f=a.number.isNumber,l=a.number.toNumber,m=a.number.toBigNumber;n.range=function(e){var a,p,h;switch(arguments.length){case 1:if(!c(e))throw new TypeError("Two or three numbers or a single string expected in function range");var g=o(e);if(!g)throw new SyntaxError('String "'+g+'" is no valid range');a=g.start,p=g.end,h=g.step;break;case 2:a=arguments[0],p=arguments[1],h=1;break;case 3:a=arguments[0],p=arguments[1],h=arguments[2];break;default:throw new n.error.ArgumentsError("range",arguments.length,2,3)}if(!(f(a)||a instanceof s))throw new TypeError("Parameter start must be a number");if(!(f(p)||p instanceof s))throw new TypeError("Parameter end must be a number");if(!(f(h)||h instanceof s))throw new TypeError("Parameter step must be a number");if(a instanceof s||p instanceof s||h instanceof s){var x=!0;a instanceof s||(a=m(a)),p instanceof s||(p=m(p)),h instanceof s||(h=m(h)),a instanceof s&&p instanceof s&&h instanceof s||(x=!1,a=l(a),p=l(p),h=l(h))}var d=x?i(a,p,h):r(a,p,h);return"array"===t.matrix?d:new u(d)}}},{"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],173:[function(e,n){n.exports=function(n,t){function r(e,n,t){if(void 0!==t){if(!c(t)||1!==t.length)throw new TypeError("Single character expected as defaultValue")}else t=" ";if(1!==n.length)throw new Error("Dimension mismatch: ("+n.length+" != 1)");var r=n[0];if(!l(r)||!m(r))throw new TypeError("Size must contain numbers");if(e.length>r)return e.substring(0,r);if(e.length<r){for(var i=e,o=0,a=r-e.length;a>o;o++)i+=t;return i}return e}var i=e("../../util/index"),o=e("bignumber.js"),a=e("../../type/Matrix"),s=i.array,u=i.object.clone,c=i.string.isString,f=i.number.toNumber,l=i.number.isNumber,m=i.number.isInteger,p=s.isArray;n.resize=function(e,i,l){if(2!=arguments.length&&3!=arguments.length)throw new n.error.ArgumentsError("resize",arguments.length,2,3);var m=e instanceof a?!0:p(e)?!1:"array"!==t.matrix;if(e instanceof a&&(e=e.valueOf()),i instanceof a&&(i=i.valueOf()),i.length&&i[0]instanceof o&&(i=i.map(f)),c(e))return r(e,i,l);if(0==i.length){for(;p(e);)e=e[0];return u(e)}p(e)||(e=[e]),e=u(e);var h=s.resize(e,i,l);return m?new a(h):h}}},{"../../type/Matrix":206,"../../util/index":213,"bignumber.js":218}],174:[function(e,n){n.exports=function(n,t){var r=e("../../util/index"),i=e("bignumber.js"),o=e("../../type/Complex"),a=e("../../type/Unit"),s=e("../../type/Matrix"),u=r.array,c=r.number.isNumber,f=r["boolean"].isBoolean,l=r.string.isString,m=o.isComplex,p=a.isUnit;n.size=function(e){if(1!=arguments.length)throw new n.error.ArgumentsError("size",arguments.length,1);var r="array"===t.matrix;if(c(e)||m(e)||p(e)||f(e)||null==e||e instanceof i)return r?[]:new s([]);if(l(e))return r?[e.length]:new s([e.length]);if(Array.isArray(e))return u.size(e);if(e instanceof s)return new s(e.size());throw new n.error.UnsupportedTypeError("size",e)}}},{"../../type/Complex":203,"../../type/Matrix":206,"../../type/Unit":208,"../../util/index":213,"bignumber.js":218}],175:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("../../type/Matrix"),i=t.object,o=t.array,a=Array.isArray;n.squeeze=function(e){if(1!=arguments.length)throw new n.error.ArgumentsError("squeeze",arguments.length,1);if(a(e))return o.squeeze(i.clone(e));if(e instanceof r){var t=o.squeeze(e.toArray());return a(t)?new r(t):t}return i.clone(e)}}},{"../../type/Matrix":206,"../../util/index":213}],176:[function(e,n){n.exports=function(n){function t(e,t){var i,o;if(l(e))return i=new s(e),o=i.subset(t),o.valueOf();if(e instanceof s)return e.subset(t);if(f(e))return r(e,t);throw new n.error.UnsupportedTypeError("subset",e)}function r(e,n){if(!(n instanceof u))throw new TypeError("Index expected");if(1!=n.size().length)throw new RangeError("Dimension mismatch ("+n.size().length+" != 1)");var t=n.range(0),r="",i=e.length;return t.forEach(function(n){c.validateIndex(n,i),r+=e.charAt(n)}),r}function i(e,t,r,i){var a;if(l(e))return a=new s(n.clone(e)),a.subset(t,r,i),a.valueOf();if(e instanceof s)return e.clone().subset(t,r,i);if(f(e))return o(e,t,r,i);throw new n.error.UnsupportedTypeError("subset",e)}function o(e,n,t,r){if(!(n instanceof u))throw new TypeError("Index expected");if(1!=n.size().length)throw new RangeError("Dimension mismatch ("+n.size().length+" != 1)");if(void 0!==r){if(!f(r)||1!==r.length)throw new TypeError("Single character expected as defaultValue")}else r=" ";var i=n.range(0),o=i.size()[0];if(o!=t.length)throw new RangeError("Dimension mismatch ("+i.size()[0]+" != "+t.length+")");for(var a=e.length,s=[],l=0;a>l;l++)s[l]=e.charAt(l);if(i.forEach(function(e,n){c.validateIndex(e),s[e]=t.charAt(n)}),s.length>a)for(l=a-1,o=s.length;o>l;l++)s[l]||(s[l]=r);return s.join("")}var a=e("../../util/index"),s=e("../../type/Matrix"),u=e("../../type/Index"),c=a.array,f=a.string.isString,l=Array.isArray;n.subset=function(){switch(arguments.length){case 2:return t(arguments[0],arguments[1]);case 3:case 4:return i(arguments[0],arguments[1],arguments[2],arguments[3]);default:throw new n.error.ArgumentsError("subset",arguments.length,2,4)}}}},{"../../type/Index":205,"../../type/Matrix":206,"../../util/index":213}],177:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("../../type/Matrix"),i=(e("../../type/collection"),t.object),o=t.string;n.transpose=function(e){if(1!=arguments.length)throw new n.error.ArgumentsError("transpose",arguments.length,1);var t=n.size(e).valueOf();switch(t.length){case 0:return i.clone(e);case 1:return i.clone(e);case 2:var a,s=t[1],u=t[0],c=e instanceof r,f=e.valueOf(),l=[],m=i.clone;if(0===s)throw new RangeError("Cannot transpose a 2D matrix with no rows(size: "+o.format(t)+")");for(var p=0;s>p;p++){a=l[p]=[];for(var h=0;u>h;h++)a[h]=m(f[h][p])}return 0==u&&(l[0]=[]),c?new r(l):l;default:throw new RangeError("Matrix must be two dimensional (size: "+o.format(t)+")")}}}},{"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213}],178:[function(e,n){n.exports=function(n,t){var r=e("../../util/index"),i=e("bignumber.js"),o=e("../../type/Matrix"),a=e("../../type/collection"),s=r.array,u=r.number.toNumber,c=Array.isArray;n.zeros=function(e){var n=a.argsToArray(arguments),r=e instanceof o?!0:c(e)?!1:"matrix"===t.matrix;if(0==n.length)return r?new o:[];var f=[],l=n[0]instanceof i?new i(0):0;return f=s.resize(f,n.map(u),l),r?new o(f):f}}},{"../../type/Matrix":206,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],179:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/collection"),o=t.number.isNumber,a=t["boolean"].isBoolean,s=t.number.isInteger,u=i.isCollection;n.factorial=function c(e){var t,f;if(1!=arguments.length)throw new n.error.ArgumentsError("factorial",arguments.length,1);if(o(e)){if(!s(e)||0>e)throw new TypeError("Positive integer value expected in function factorial");for(t=e-1,f=e;t>1;)f*=t,t--;return 0==f&&(f=1),f}if(e instanceof r){if(!e.round().equals(e)||e.lt(0))throw new TypeError("Positive integer value expected in function factorial");var l=new r(1);for(t=e.minus(l),f=e;t.gt(l);)f=f.times(t),t=t.minus(l);return f.equals(0)&&(f=l),f}if(a(e))return 1;if(u(e))return i.deepMap(e,c);throw new n.error.UnsupportedTypeError("factorial",e)}}},{"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],180:[function(e,n){n.exports=function(n,t){var r=e("../../type/Matrix"),i=(e("../../type/collection"),{uniform:function(){return Math.random},normal:function(){return function(){for(var e,n,t=-1;0>t||t>1;)e=Math.random(),n=Math.random(),t=1/6*Math.pow(-2*Math.log(e),.5)*Math.cos(2*Math.PI*n)+.5;return t}}});n.distribution=function(e){if(!i.hasOwnProperty(e))throw new Error("unknown distribution "+e);var o=Array.prototype.slice.call(arguments,1),a=i[e].apply(this,o);return function(e){var i={random:function(e,i,a){var u,c,f;if(arguments.length>3)throw new n.error.ArgumentsError("random",arguments.length,0,3);if(1===arguments.length?Array.isArray(e)?u=e:f=e:2===arguments.length?Array.isArray(e)?u=e:(c=e,f=i):(u=e,c=i,f=a),void 0===f&&(f=1),void 0===c&&(c=0),void 0!==u){var l=s(u,c,f,o);return"array"===t.matrix?l:new r(l)}return o(c,f)},randomInt:function(e,i,o){var u,c,f;if(arguments.length>3||arguments.length<1)throw new n.error.ArgumentsError("randomInt",arguments.length,1,3);if(1===arguments.length?f=e:2===arguments.length?"[object Array]"===Object.prototype.toString.call(e)?u=e:(c=e,f=i):(u=e,c=i,f=o),void 0===c&&(c=0),void 0!==u){var l=s(u,c,f,a);return"array"===t.matrix?l:new r(l)}return a(c,f)},pickRandom:function(e){if(1!==arguments.length)throw new n.error.ArgumentsError("pickRandom",arguments.length,1);if(!Array.isArray(e))throw new n.error.UnsupportedTypeError("pickRandom",e);return e[Math.floor(Math.random()*e.length)]}},o=function(n,t){return n+e()*(t-n)},a=function(n,t){return Math.floor(n+e()*(t-n))},s=function(e,n,t,r){var i,o,a=[];if(e=e.slice(0),e.length>1)for(o=0,i=e.shift();i>o;o++)a.push(s(e,n,t,r));else for(o=0,i=e.shift();i>o;o++)a.push(r(n,t));return a};return i}(a)};var o=n.distribution("uniform");n.random=o.random,n.randomInt=o.randomInt,n.pickRandom=o.pickRandom}},{"../../type/Matrix":206,"../../type/collection":209}],181:[function(e,n){n.exports=function(n){function t(e,t){return n.larger(e,t)?e:t}function r(e){var t=null;if(i.deepForEach(e,function(e){(null===t||n.larger(e,t))&&(t=e)}),null===t)throw new Error("Cannot calculate max of an empty array");return t}var i=(e("../../type/Matrix"),e("../../type/collection")),o=i.isCollection;n.max=function(e){if(0==arguments.length)throw new SyntaxError("Function max requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return r(e);if(2==arguments.length)return i.reduce(arguments[0],arguments[1],t);throw new SyntaxError("Wrong number of parameters")}return r(arguments)}}},{"../../type/Matrix":206,"../../type/collection":209}],182:[function(e,n){n.exports=function(n){function t(e,t){var r;return r=i.reduce(e,t,n.add),n.divide(r,size(e)[t])}function r(e){var t=0,r=0;if(i.deepForEach(e,function(e){t=n.add(t,e),r++}),0===r)throw new Error("Cannot calculate mean of an empty array");return n.divide(t,r)}var i=(e("../../type/Matrix"),e("../../type/collection")),o=i.isCollection;n.mean=function(e){if(0==arguments.length)throw new SyntaxError("Function mean requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return r(e);if(2==arguments.length)return t(arguments[0],arguments[1]);throw new SyntaxError("Wrong number of parameters")}return r(arguments)}}},{"../../type/Matrix":206,"../../type/collection":209}],183:[function(e,n){n.exports=function(n){function t(e,t){return n.smaller(e,t)?e:t}function r(e){var t=null;if(i.deepForEach(e,function(e){(null===t||n.smaller(e,t))&&(t=e)}),null===t)throw new Error("Cannot calculate min of an empty array");return t}var i=(e("../../type/Matrix"),e("../../type/collection")),o=i.isCollection;n.min=function(e){if(0==arguments.length)throw new SyntaxError("Function min requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return r(e);if(2==arguments.length)return i.reduce(arguments[0],arguments[1],t);throw new SyntaxError("Wrong number of parameters")}return r(arguments)}}},{"../../type/Matrix":206,"../../type/collection":209}],184:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.acos=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("acos",arguments.length,1);if(a(e))return e>=-1&&1>=e?Math.acos(e):f(new i(e,0));if(u(e)){var l,m=new i(e.im*e.im-e.re*e.re+1,-2*e.re*e.im),p=n.sqrt(m);l=p instanceof i?new i(p.re-e.im,p.im+e.re):new i(p-e.im,e.re);var h=n.log(l);return h instanceof i?new i(1.5707963267948966-h.im,h.re):new i(1.5707963267948966,h)}if(c(e))return o.deepMap(e,f);if(s(e))return Math.acos(e);if(e instanceof r)return f(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("acos",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],185:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.asin=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("asin",arguments.length,1);if(a(e))return e>=-1&&1>=e?Math.asin(e):f(new i(e,0));if(u(e)){var l,m=e.re,p=e.im,h=new i(p*p-m*m+1,-2*m*p),g=n.sqrt(h);l=g instanceof i?new i(g.re-p,g.im+m):new i(g-p,m);var x=n.log(l);return x instanceof i?new i(x.im,-x.re):new i(0,-x)}if(c(e))return o.deepMap(e,f);if(s(e))return Math.asin(e);if(e instanceof r)return f(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("asin",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],186:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.isNumber,s=t["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;n.atan=function f(e){if(1!=arguments.length)throw new n.error.ArgumentsError("atan",arguments.length,1);if(a(e))return Math.atan(e);if(u(e)){var l=e.re,m=e.im,p=l*l+(1-m)*(1-m),h=new i((1-m*m-l*l)/p,-2*l/p),g=n.log(h);return g instanceof i?new i(-.5*g.im,.5*g.re):new i(0,.5*g)}if(c(e))return o.deepMap(e,f);if(s(e))return Math.atan(e);if(e instanceof r)return f(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("atan",e)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],187:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/collection"),a=t.number.toNumber,s=t.number.isNumber,u=t["boolean"].isBoolean,c=i.isComplex,f=o.isCollection;n.atan2=function l(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("atan2",arguments.length,2);if(s(e)){if(s(t))return Math.atan2(e,t)}else if(c(e)&&s(t))return Math.atan2(e.re,t);if(f(e)||f(t))return o.deepMap2(e,t,l);if(u(e))return l(+e,t);if(u(t))return l(e,+t);if(e instanceof r)return l(a(e),t);if(t instanceof r)return l(e,a(t));throw new n.error.UnsupportedTypeError("atan2",e,t)}}},{"../../type/Complex":203,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],188:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;n.cos=function m(e){if(1!=arguments.length)throw new n.error.ArgumentsError("cos",arguments.length,1);if(s(e))return Math.cos(e);if(c(e))return new i(.5*Math.cos(e.re)*(Math.exp(-e.im)+Math.exp(e.im)),.5*Math.sin(e.re)*(Math.exp(-e.im)-Math.exp(e.im)));if(f(e)){if(!e.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return Math.cos(e.value)}if(l(e))return a.deepMap(e,m);if(u(e))return Math.cos(e);if(e instanceof r)return m(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("cos",e)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],189:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;n.cot=function m(e){if(1!=arguments.length)throw new n.error.ArgumentsError("cot",arguments.length,1);if(s(e))return 1/Math.tan(e);if(c(e)){var p=Math.exp(-4*e.im)-2*Math.exp(-2*e.im)*Math.cos(2*e.re)+1;return new i(2*Math.exp(-2*e.im)*Math.sin(2*e.re)/p,(Math.exp(-4*e.im)-1)/p)}if(f(e)){if(!e.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cot is no angle");return 1/Math.tan(e.value)}if(l(e))return a.deepMap(e,m);if(u(e))return m(+e);if(e instanceof r)return m(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("cot",e)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],190:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;n.csc=function m(e){if(1!=arguments.length)throw new n.error.ArgumentsError("csc",arguments.length,1);if(s(e))return 1/Math.sin(e);if(c(e)){var p=.25*(Math.exp(-2*e.im)+Math.exp(2*e.im))-.5*Math.cos(2*e.re);return new i(.5*Math.sin(e.re)*(Math.exp(-e.im)+Math.exp(e.im))/p,.5*Math.cos(e.re)*(Math.exp(-e.im)-Math.exp(e.im))/p)}if(f(e)){if(!e.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csc is no angle");return 1/Math.sin(e.value)}if(l(e))return a.deepMap(e,m);if(u(e))return m(+e);if(e instanceof r)return m(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("csc",e)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],191:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;n.sec=function m(e){if(1!=arguments.length)throw new n.error.ArgumentsError("sec",arguments.length,1);if(s(e))return 1/Math.cos(e);if(c(e)){var p=.25*(Math.exp(-2*e.im)+Math.exp(2*e.im))+.5*Math.cos(2*e.re);return new i(.5*Math.cos(e.re)*(Math.exp(-e.im)+Math.exp(e.im))/p,.5*Math.sin(e.re)*(Math.exp(e.im)-Math.exp(-e.im))/p)}if(f(e)){if(!e.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sec is no angle");return 1/Math.cos(e.value)}if(l(e))return a.deepMap(e,m);if(u(e))return m(+e);if(e instanceof r)return m(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("sec",e)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],192:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;n.sin=function m(e){if(1!=arguments.length)throw new n.error.ArgumentsError("sin",arguments.length,1);if(s(e))return Math.sin(e);if(c(e))return new i(.5*Math.sin(e.re)*(Math.exp(-e.im)+Math.exp(e.im)),.5*Math.cos(e.re)*(Math.exp(e.im)-Math.exp(-e.im)));if(f(e)){if(!e.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sin is no angle");return Math.sin(e.value)}if(l(e))return a.deepMap(e,m);if(u(e))return Math.sin(e);if(e instanceof r)return m(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("sin",e)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],193:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Unit"),a=e("../../type/collection"),s=t.number.isNumber,u=t["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;n.tan=function m(e){if(1!=arguments.length)throw new n.error.ArgumentsError("tan",arguments.length,1);if(s(e))return Math.tan(e);if(c(e)){var p=Math.exp(-4*e.im)+2*Math.exp(-2*e.im)*Math.cos(2*e.re)+1;return new i(2*Math.exp(-2*e.im)*Math.sin(2*e.re)/p,(1-Math.exp(-4*e.im))/p)}if(f(e)){if(!e.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tan is no angle");return Math.tan(e.value)}if(l(e))return a.deepMap(e,m);if(u(e))return Math.tan(e);if(e instanceof r)return m(t.number.toNumber(e));throw new n.error.UnsupportedTypeError("tan",e)}}},{"../../type/Complex":203,"../../type/Unit":208,"../../type/collection":209,"../../util/index":213,"bignumber.js":218}],194:[function(e,n){n.exports=function(n){var t=e("../../util/index"),r=e("../../type/Unit"),i=e("../../type/collection"),o=t.string.isString,a=r.isUnit,s=i.isCollection;n["in"]=function u(e,t){if(2!=arguments.length)throw new n.error.ArgumentsError("in",arguments.length,2);if(a(e)&&(a(t)||o(t)))return e["in"](t);if(s(e)||s(t))return i.deepMap2(e,t,u);throw new n.error.UnsupportedTypeError("in",e,t)}}},{"../../type/Unit":208,"../../type/collection":209,"../../util/index":213}],195:[function(e,n){n.exports=function(n){var t=e("../../util/object");n.clone=function(e){if(1!=arguments.length)throw new n.error.ArgumentsError("clone",arguments.length,1);return t.clone(e)}}},{"../../util/object":215}],196:[function(e,n){n.exports=function(n){function t(e,n){var t=[],r=function(i,o){Array.isArray(i)?i.forEach(function(e,n){t[o]=n,r(e,o+1)}):n(i,t,e)};r(e,0)}var r=e("../../type/Matrix").isMatrix;n.forEach=function(e,i){if(2!=arguments.length)throw new n.error.ArgumentsError("forEach",arguments.length,2);if(Array.isArray(e))return t(e,i);if(r(e))return e.forEach(i);throw new n.error.UnsupportedTypeError("forEach",e)}}},{"../../type/Matrix":206}],197:[function(e,n){n.exports=function(n){var t=e("../../util/string");n.format=function(e,r){var i=arguments.length;if(1!==i&&2!==i)throw new n.error.ArgumentsError("format",i,1,2);return t.format(e,r)}}},{"../../util/string":216}],198:[function(e,n){n.exports=function(n){function t(e,t,r){(r.override||void 0===n[e])&&(n[e]=r.wrap&&"function"==typeof t?function(){for(var e=[],r=0,i=arguments.length;i>r;r++)e[r]=arguments[r].valueOf();return t.apply(n,e)}:t,n.chaining.Selector.createProxy(e,t))}function r(e){return"function"==typeof e||s(e)||u(e)||c(e)||f(e)}var i=e("../../util/index"),o=e("../../type/Complex"),a=e("../../type/Unit"),s=i.number.isNumber,u=i.string.isString,c=o.isComplex,f=a.isUnit;n["import"]=function l(o,a){var s,c={override:!1,wrap:!0};if(a&&a instanceof Object&&i.object.extend(c,a),u(o)){if("undefined"==typeof e)throw new Error("Cannot load file: require not available.");var f=e(o);l(f)}else if(r(o)){if(s=o.name,!s)throw new Error("Cannot import an unnamed function or object");(c.override||void 0===n[s])&&t(s,o,c)}else if(o instanceof Object)for(s in o)if(o.hasOwnProperty(s)){var m=o[s];r(m)?t(s,m,c):l(m)}}}},{"../../type/Complex":203,"../../type/Unit":208,"../../util/index":213}],199:[function(e,n){n.exports=function(n){function t(e,n){var t=[],r=function(i,o){return Array.isArray(i)?i.map(function(e,n){return t[o]=n,r(e,o+1)}):n(i,t,e)};return r(e,0)}var r=e("../../type/Matrix").isMatrix;n.map=function(e,i){if(2!=arguments.length)throw new n.error.ArgumentsError("map",arguments.length,2);if(Array.isArray(e))return t(e,i);if(r(e))return e.map(i);throw new n.error.UnsupportedTypeError("map",e)}}},{"../../type/Matrix":206}],200:[function(e,n){n.exports=function(n){var t=e("../../util/string"),r=t.isString;n.print=function(e,t,i){var o=arguments.length;if(2!=o&&3!=o)throw new n.error.ArgumentsError("print",o,2,3);if(!r(e))throw new TypeError("String expected as first parameter in function format");if(!(t instanceof Object))throw new TypeError("Object expected as second parameter in function format");return e.replace(/\$([\w\.]+)/g,function(e,o){for(var a=o.split("."),s=t[a.shift()];a.length&&void 0!==s;){var u=a.shift();s=u?s[u]:s+"."}return void 0!==s?r(s)?s:n.format(s,i):e})}}},{"../../util/string":216}],201:[function(e,n){n.exports=function(n){var t=e("../../util/types"),r=e("bignumber.js"),i=e("../../type/Complex"),o=e("../../type/Matrix"),a=e("../../type/Unit"),s=e("../../type/Index"),u=e("../../type/Range"),c=e("../../type/Help");n["typeof"]=function(e){if(1!=arguments.length)throw new n.error.ArgumentsError("typeof",arguments.length,1);var f=t.type(e);if("object"===f){if(e instanceof i)return"complex";if(e instanceof r)return"bignumber";if(e instanceof o)return"matrix";if(e instanceof a)return"unit";if(e instanceof s)return"index";if(e instanceof u)return"range";if(e instanceof c)return"matrix";if(e instanceof n.chaining.Selector)return"selector"}return f}}},{"../../type/Complex":203,"../../type/Help":204,"../../type/Index":205,"../../type/Matrix":206,"../../type/Range":207,"../../type/Unit":208,"../../util/types":217,"bignumber.js":218}],202:[function(e,n){function t(n){if("function"!=typeof Array.prototype.map)throw new Error("ES5 not supported by this JavaScript engine. Please load the es5-shim library for compatibility.");var t={},i={matrix:"matrix",number:"number"};return t.config=function(n){var t=e("bignumber.js");if(n){if(r.deepExtend(i,n),n.decimals&&t.config({DECIMAL_PLACES:n.decimals}),n.number&&n.number.defaultType)throw new Error("setting `number.defaultType` is deprecated. Use `number` instead.");if(n.number&&n.number.precision)throw new Error("setting `number.precision` is deprecated. Use `decimals` instead.");if(n.matrix&&n.matrix.defaultType)throw new Error("setting `matrix.defaultType` is deprecated. Use `matrix` instead.");if(n.matrix&&n.matrix["default"])throw new Error("setting `matrix.default` is deprecated. Use `matrix` instead.")}var o=r.clone(i);return o.decimals=t.config().DECIMAL_PLACES,o},t.config(n),t.expression={},t.expression.node=e("./expression/node/index.js"),t.expression.Scope=e("./expression/Scope.js"),t.expression.Parser=e("./expression/Parser.js"),t.expression.docs=e("./expression/docs/index.js"),t.type={},t.type.BigNumber=e("bignumber.js"),t.type.Complex=e("./type/Complex"),t.type.Range=e("./type/Range"),t.type.Index=e("./type/Index"),t.type.Matrix=e("./type/Matrix"),t.type.Unit=e("./type/Unit"),t.type.Help=e("./type/Help"),t.collection=e("./type/collection"),e("./type/error")(t),e("./function/expression/eval.js")(t,i),e("./function/expression/help.js")(t,i),e("./function/expression/parse.js")(t,i),e("./function/arithmetic/abs.js")(t,i),e("./function/arithmetic/add.js")(t,i),e("./function/arithmetic/add.js")(t,i),e("./function/arithmetic/ceil.js")(t,i),e("./function/arithmetic/cube.js")(t,i),e("./function/arithmetic/divide.js")(t,i),e("./function/arithmetic/edivide.js")(t,i),e("./function/arithmetic/emultiply.js")(t,i),e("./function/arithmetic/epow.js")(t,i),e("./function/arithmetic/equal.js")(t,i),e("./function/arithmetic/exp.js")(t,i),e("./function/arithmetic/fix.js")(t,i),e("./function/arithmetic/floor.js")(t,i),e("./function/arithmetic/gcd.js")(t,i),e("./function/arithmetic/larger.js")(t,i),e("./function/arithmetic/largereq.js")(t,i),e("./function/arithmetic/lcm.js")(t,i),e("./function/arithmetic/log.js")(t,i),e("./function/arithmetic/log10.js")(t,i),e("./function/arithmetic/mod.js")(t,i),e("./function/arithmetic/multiply.js")(t,i),e("./function/arithmetic/pow.js")(t,i),e("./function/arithmetic/round.js")(t,i),e("./function/arithmetic/sign.js")(t,i),e("./function/arithmetic/smaller.js")(t,i),e("./function/arithmetic/smallereq.js")(t,i),e("./function/arithmetic/sqrt.js")(t,i),e("./function/arithmetic/square.js")(t,i),e("./function/arithmetic/subtract.js")(t,i),e("./function/arithmetic/unary.js")(t,i),e("./function/arithmetic/unequal.js")(t,i),e("./function/arithmetic/xgcd.js")(t,i),e("./function/complex/arg.js")(t,i),e("./function/complex/conj.js")(t,i),e("./function/complex/re.js")(t,i),e("./function/complex/im.js")(t,i),e("./function/construction/bignumber")(t,i),e("./function/construction/boolean.js")(t,i),e("./function/construction/complex.js")(t,i),e("./function/construction/index.js")(t,i),e("./function/construction/matrix.js")(t,i),e("./function/construction/number.js")(t,i),e("./function/construction/parser.js")(t,i),e("./function/construction/select.js")(t,i),e("./function/construction/string.js")(t,i),e("./function/construction/unit.js")(t,i),e("./function/matrix/concat.js")(t,i),e("./function/matrix/det.js")(t,i),e("./function/matrix/diag.js")(t,i),e("./function/matrix/eye.js")(t,i),e("./function/matrix/inv.js")(t,i),e("./function/matrix/ones.js")(t,i),e("./function/matrix/range.js")(t,i),e("./function/matrix/resize.js")(t,i),e("./function/matrix/size.js")(t,i),e("./function/matrix/squeeze.js")(t,i),e("./function/matrix/subset.js")(t,i),e("./function/matrix/transpose.js")(t,i),e("./function/matrix/zeros.js")(t,i),e("./function/probability/factorial.js")(t,i),e("./function/probability/random.js")(t,i),e("./function/statistics/min.js")(t,i),e("./function/statistics/max.js")(t,i),e("./function/statistics/mean.js")(t,i),e("./function/trigonometry/acos.js")(t,i),e("./function/trigonometry/asin.js")(t,i),e("./function/trigonometry/atan.js")(t,i),e("./function/trigonometry/atan2.js")(t,i),e("./function/trigonometry/cos.js")(t,i),e("./function/trigonometry/cot.js")(t,i),e("./function/trigonometry/csc.js")(t,i),e("./function/trigonometry/sec.js")(t,i),e("./function/trigonometry/sin.js")(t,i),e("./function/trigonometry/tan.js")(t,i),e("./function/units/in.js")(t,i),e("./function/utils/clone.js")(t,i),e("./function/utils/format.js")(t,i),e("./function/utils/import.js")(t,i),e("./function/utils/map.js")(t,i),e("./function/utils/print.js")(t,i),e("./function/utils/typeof.js")(t,i),e("./function/utils/forEach.js")(t,i),e("./constants.js")(t,i),t.chaining={},t.chaining.Selector=e("./chaining/Selector.js")(t,i),t
}var r=e("./util/object");n.exports=t},{"./chaining/Selector.js":2,"./constants.js":3,"./expression/Parser.js":4,"./expression/Scope.js":5,"./expression/docs/index.js":103,"./expression/node/index.js":117,"./function/arithmetic/abs.js":118,"./function/arithmetic/add.js":119,"./function/arithmetic/ceil.js":120,"./function/arithmetic/cube.js":121,"./function/arithmetic/divide.js":122,"./function/arithmetic/edivide.js":123,"./function/arithmetic/emultiply.js":124,"./function/arithmetic/epow.js":125,"./function/arithmetic/equal.js":126,"./function/arithmetic/exp.js":127,"./function/arithmetic/fix.js":128,"./function/arithmetic/floor.js":129,"./function/arithmetic/gcd.js":130,"./function/arithmetic/larger.js":131,"./function/arithmetic/largereq.js":132,"./function/arithmetic/lcm.js":133,"./function/arithmetic/log.js":134,"./function/arithmetic/log10.js":135,"./function/arithmetic/mod.js":136,"./function/arithmetic/multiply.js":137,"./function/arithmetic/pow.js":138,"./function/arithmetic/round.js":139,"./function/arithmetic/sign.js":140,"./function/arithmetic/smaller.js":141,"./function/arithmetic/smallereq.js":142,"./function/arithmetic/sqrt.js":143,"./function/arithmetic/square.js":144,"./function/arithmetic/subtract.js":145,"./function/arithmetic/unary.js":146,"./function/arithmetic/unequal.js":147,"./function/arithmetic/xgcd.js":148,"./function/complex/arg.js":149,"./function/complex/conj.js":150,"./function/complex/im.js":151,"./function/complex/re.js":152,"./function/construction/bignumber":153,"./function/construction/boolean.js":154,"./function/construction/complex.js":155,"./function/construction/index.js":156,"./function/construction/matrix.js":157,"./function/construction/number.js":158,"./function/construction/parser.js":159,"./function/construction/select.js":160,"./function/construction/string.js":161,"./function/construction/unit.js":162,"./function/expression/eval.js":163,"./function/expression/help.js":164,"./function/expression/parse.js":165,"./function/matrix/concat.js":166,"./function/matrix/det.js":167,"./function/matrix/diag.js":168,"./function/matrix/eye.js":169,"./function/matrix/inv.js":170,"./function/matrix/ones.js":171,"./function/matrix/range.js":172,"./function/matrix/resize.js":173,"./function/matrix/size.js":174,"./function/matrix/squeeze.js":175,"./function/matrix/subset.js":176,"./function/matrix/transpose.js":177,"./function/matrix/zeros.js":178,"./function/probability/factorial.js":179,"./function/probability/random.js":180,"./function/statistics/max.js":181,"./function/statistics/mean.js":182,"./function/statistics/min.js":183,"./function/trigonometry/acos.js":184,"./function/trigonometry/asin.js":185,"./function/trigonometry/atan.js":186,"./function/trigonometry/atan2.js":187,"./function/trigonometry/cos.js":188,"./function/trigonometry/cot.js":189,"./function/trigonometry/csc.js":190,"./function/trigonometry/sec.js":191,"./function/trigonometry/sin.js":192,"./function/trigonometry/tan.js":193,"./function/units/in.js":194,"./function/utils/clone.js":195,"./function/utils/forEach.js":196,"./function/utils/format.js":197,"./function/utils/import.js":198,"./function/utils/map.js":199,"./function/utils/print.js":200,"./function/utils/typeof.js":201,"./type/Complex":203,"./type/Help":204,"./type/Index":205,"./type/Matrix":206,"./type/Range":207,"./type/Unit":208,"./type/collection":209,"./type/error":210,"./util/object":215,"bignumber.js":218}],203:[function(e,n,t){function r(e,n){if(!(this instanceof r))throw new SyntaxError("Complex constructor must be called with the new operator");switch(arguments.length){case 0:this.re=0,this.im=0;break;case 2:if(!p(e)||!p(n))throw new TypeError("Two numbers expected in Complex constructor");this.re=e,this.im=n;break;default:if(0!=arguments.length&&2!=arguments.length)throw new SyntaxError("Two or zero arguments expected in Complex constructor")}}function i(){for(;" "==d||"	"==d;)s()}function o(e){return e>="0"&&"9">=e||"."==e}function a(e){return e>="0"&&"9">=e}function s(){x++,d=g.charAt(x)}function u(e){x=e,d=g.charAt(x)}function c(){var e,n="";if(e=x,"+"==d?s():"-"==d&&(n+=d,s()),!o(d))return u(e),null;if("."==d){if(n+=d,s(),!a(d))return u(e),null}else{for(;a(d);)n+=d,s();"."==d&&(n+=d,s())}for(;a(d);)n+=d,s();if("E"==d||"e"==d){if(n+=d,s(),("+"==d||"-"==d)&&(n+=d,s()),!a(d))return u(e),null;for(;a(d);)n+=d,s()}return n}function f(){var e=g.charAt(x+1);if("I"==d||"i"==d)return s(),"1";if(!("+"!=d&&"-"!=d||"I"!=e&&"i"!=e)){var n="+"==d?"1":"-1";return s(),s(),n}return null}var l=e("../util/index"),m=l.number,p=l.number.isNumber,h=l.string.isString;r.isComplex=function(e){return e instanceof r};var g,x,d;r.parse=function(e){if(g=e,x=-1,d="",!h(g))return null;s(),i();var n=c();if(n){if("I"==d||"i"==d)return s(),i(),d?null:new r(0,Number(n));i();var t=d;if("+"!=t&&"-"!=t)return i(),d?null:new r(Number(n),0);s(),i();var o=c();if(o){if("I"!=d&&"i"!=d)return null;s()}else if(o=f(),!o)return null;return"-"==t&&(o="-"==o[0]?"+"+o.substring(1):"-"+o),s(),i(),d?null:new r(Number(n),Number(o))}return(n=f())?(i(),d?null:new r(0,Number(n))):null},r.prototype.clone=function(){return new r(this.re,this.im)},r.prototype.equals=function(e){return this.re===e.re&&this.im===e.im},r.prototype.format=function(e){var n="",t=m.format(this.re,e),r=m.format(this.im,e);return n=0==this.im?t:0==this.re?1==this.im?"i":-1==this.im?"-i":r+"i":this.im>0?1==this.im?t+" + i":t+" + "+r+"i":-1==this.im?t+" - i":t+" - "+r.substring(1)+"i"},r.prototype.toString=function(){return this.format()},n.exports=r,t.isComplex=r.isComplex,t.parse=r.parse},{"../util/index":213}],204:[function(e,n,t){function r(e,n){this.math=e,this.doc=n}var i=e("../util/index"),o=i.object,a=i.string;r.isHelp=function(e){return e instanceof r},r.prototype.toString=function(){var e=this.doc||{},n="\n";if(e.name&&(n+="Name: "+e.name+"\n\n"),e.category&&(n+="Category: "+e.category+"\n\n"),e.description&&(n+="Description:\n    "+e.description+"\n\n"),e.syntax&&(n+="Syntax:\n    "+e.syntax.join("\n    ")+"\n\n"),e.examples){var t=this.math.parser();n+="Examples:\n";for(var i=0;i<e.examples.length;i++){var o,s=e.examples[i];try{o=t.eval(s)}catch(u){o=u}n+="    "+s+"\n",!o||o instanceof r||(n+="        "+a.format(o)+"\n")}n+="\n"}return e.seealso&&(n+="See also: "+e.seealso.join(", ")+"\n"),n},r.prototype.toJSON=function(){return o.extend({},this.doc)},n.exports=r,t.isHelp=r.isHelp},{"../util/index":213}],205:[function(e,n,t){function r(){if(!(this instanceof r))throw new SyntaxError("Index constructor must be called with the new operator");this._ranges=[];for(var e=0,n=arguments.length;n>e;e++){var t=arguments[e];if(t instanceof a)this._ranges.push(t);else if(t&&(t=t.valueOf()),f(t))this._ranges.push(i(t));else{if(!u(t))throw new TypeError("Range expected as Array, Number, or String");this._ranges.push(i([t,t+1]))}}}function i(e){for(var n=e.length,t=0;n>t;t++)if(!u(e[t])||!c(e[t]))throw new TypeError("Index parameters must be integer numbers");switch(e.length){case 2:return new a(e[0],e[1]);case 3:return new a(e[0],e[1],e[2]);default:throw new SyntaxError("Wrong number of arguments in Index (2 or 3 expected)")}}{var o=e("../util/index"),a=e("./Range"),s=o.number,u=s.isNumber,c=s.isInteger,f=Array.isArray;o.array.validateIndex}r.prototype.clone=function(){var e=new r;return e._ranges=o.object.clone(this._ranges),e},r.isIndex=function(e){return e instanceof r},r.create=function(e){var n=new r;return r.apply(n,e),n},r.prototype.size=function l(){for(var l=[],e=0,n=this._ranges.length;n>e;e++){var t=this._ranges[e];l[e]=t.size()[0]}return l},r.prototype.max=function(){for(var e=[],n=0,t=this._ranges.length;t>n;n++){var r=this._ranges[n];e[n]=r.max()}return e},r.prototype.min=function(){for(var e=[],n=0,t=this._ranges.length;t>n;n++){var r=this._ranges[n];e[n]=r.min()}return e},r.prototype.forEach=function(e){for(var n=0,t=this._ranges.length;t>n;n++)e(this._ranges[n],n,this)},r.prototype.range=function(e){return this._ranges[e]},r.prototype.isScalar=function(){for(var e=this.size(),n=0,t=e.length;t>n;n++)if(1!==e[n])return!1;return!0},r.prototype.toArray=function(){for(var e=[],n=0,t=this._ranges.length;t>n;n++){var r=this._ranges[n],i=[],o=r.start,a=r.end,s=r.step;if(s>0)for(;a>o;)i.push(o),o+=s;else if(0>s)for(;o>a;)i.push(o),o+=s;e.push(i)}return e},r.prototype.valueOf=r.prototype.toArray,r.prototype.toString=function(){for(var e=[],n=0,t=this._ranges.length;t>n;n++){var r=this._ranges[n],i=s.format(r.start);1!=r.step&&(i+=":"+s.format(r.step)),i+=":"+s.format(r.end),e.push(i)}return"["+e.join(",")+"]"},n.exports=r,t.isIndex=r.isIndex,t.create=r.create},{"../util/index":213,"./Range":207}],206:[function(e,n,t){function r(e){if(!(this instanceof r))throw new SyntaxError("Matrix constructor must be called with the new operator");if(e instanceof r)this._data=e.clone()._data;else if(h(e))this._data=e;else{if(null!=e)throw new TypeError("Unsupported type of data ("+c.types.type(e)+")");this._data=[]}this._size=m.size(this._data)}function i(e,n){if(!(n instanceof f))throw new TypeError("Invalid index");var t=n.isScalar();if(t)return e.get(n.min());var i=n.size();if(i.length!=e._size.length)throw new RangeError("Dimension mismatch ("+i.length+" != "+e._size.length+")");for(var a=new r(o(e._data,n,i.length,0));h(a._data)&&1==a._data.length;)a._data=a._data[0],a._size.shift();return a}function o(e,n,t,r){var i=r==t-1,a=n.range(r);return i?a.map(function(n){return g(n,e.length),e[n]}):a.map(function(i){g(i,e.length);var a=e[i];return o(a,n,t,r+1)})}function a(e,n,t,i){if(!(n instanceof f))throw new TypeError("Invalid index");var o,a=n.size(),c=n.isScalar();if(t instanceof r?(o=t.size(),t=t.valueOf()):o=m.size(t),c){if(0!=o.length)throw new TypeError("Scalar value expected");e.set(n.min(),t,i)}else{if(a.length<e._size.length)throw new RangeError("Dimension mismatch ("+a.length+" < "+e._size.length+")");for(var h=0,g=a.length-o.length;g>h;h++)t=[t],o.unshift(1);if(!p.deepEqual(a,o))throw new RangeError("Dimensions mismatch ("+l.format(a)+" != "+l.format(o)+")");var x=n.max().map(function(e){return e+1});u(e,x,i);var d=a.length,y=0;s(e._data,n,t,d,y)}return e}function s(e,n,t,r,i){var o=i==r-1,a=n.range(i);o?a.forEach(function(n,r){g(n),e[n]=t[r]}):a.forEach(function(o,a){g(o),s(e[o],n,t[a],r,i+1)})}function u(e,n,t){if(!h(n))throw new Error("Array expected");for(var r=p.clone(e._size),i=!1;r.length<n.length;)r.unshift(0),i=!0;for(var o=0,a=n.length;a>o;o++)n[o]>r[o]&&(r[o]=n[o],i=!0);i&&e.resize(r,t)}var c=e("../util/index"),f=e("./Index"),l=(c.number,c.string),m=c.array,p=c.object,h=Array.isArray,g=m.validateIndex;r.isMatrix=function(e){return e instanceof r},r.prototype.subset=function(e,n,t){switch(arguments.length){case 1:return i(this,e);case 2:case 3:return a(this,e,n,t);default:throw new SyntaxError("Wrong number of arguments")}},r.prototype.get=function(e){if(!h(e))throw new Error("Array expected");if(e.length!=this._size.length)throw new RangeError("Dimension mismatch ("+e.length+" != "+this._size.length+")");for(var n=this._data,t=0,r=e.length;r>t;t++){var i=e[t];g(i,n.length),n=n[i]}return p.clone(n)},r.prototype.set=function(e,n,t){var r,i;if(!h(e))throw new Error("Array expected");if(e.length<this._size.length)throw new RangeError("Dimension mismatch ("+e.length+" < "+this._size.length+")");var o=e.map(function(e){return e+1});u(this,o,t);var a=this._data;for(r=0,i=e.length-1;i>r;r++){var s=e[r];g(s,a.length),a=a[s]}return s=e[e.length-1],g(s,a.length),a[s]=n,this},r.prototype.resize=function(e,n){return this._size=p.clone(e),this._data=m.resize(this._data,this._size,n),this},r.prototype.clone=function(){var e=new r;return e._data=p.clone(this._data),e._size=p.clone(this._size),e},r.prototype.size=function(){return this._size},r.prototype.map=function(e){var n=this,t=new r,i=[],o=function(t,r){return h(t)?t.map(function(e,n){return i[r]=n,o(e,r+1)}):e(t,i,n)};return t._data=o(this._data,0),t._size=p.clone(this._size),t},r.prototype.forEach=function(e){var n=this,t=[],r=function(i,o){h(i)?i.forEach(function(e,n){t[o]=n,r(e,o+1)}):e(i,t,n)};r(this._data,0)},r.prototype.toArray=function(){return p.clone(this._data)},r.prototype.valueOf=function(){return this._data},r.prototype.format=function(e){return l.format(this._data,e)},r.prototype.toString=function(){return l.format(this._data)},n.exports=r,t.isMatrix=r.isMatrix},{"../util/index":213,"./Index":205}],207:[function(e,n,t){function r(e,n,t){if(!(this instanceof r))throw new SyntaxError("Range constructor must be called with the new operator");if(null!=e&&!o.isNumber(e))throw new TypeError("Parameter start must be a number");if(null!=n&&!o.isNumber(n))throw new TypeError("Parameter end must be a number");if(null!=t&&!o.isNumber(t))throw new TypeError("Parameter step must be a number");this.start=null!=e?parseFloat(e):0,this.end=null!=n?parseFloat(n):0,this.step=null!=t?parseFloat(t):1}{var i=e("../util/index"),o=i.number,a=i.string;i.array}r.parse=function(e){if(!a.isString(e))return null;var n=e.split(":"),t=n.map(function(e){return parseFloat(e)}),i=t.some(function(e){return isNaN(e)});if(i)return null;switch(t.length){case 2:return new r(t[0],t[1]);case 3:return new r(t[0],t[2],t[1]);default:return null}},r.prototype.clone=function(){return new r(this.start,this.end,this.step)},r.isRange=function(e){return e instanceof r},r.prototype.size=function(){var e=0,n=this.start,t=this.step,r=this.end,i=r-n;return o.sign(t)==o.sign(i)?e=Math.ceil(i/t):0==i&&(e=0),isNaN(e)&&(e=0),[e]},r.prototype.min=function(){var e=this.size()[0];return e>0?this.step>0?this.start:this.start+(e-1)*this.step:void 0},r.prototype.max=function(){var e=this.size()[0];return e>0?this.step>0?this.start+(e-1)*this.step:this.start:void 0},r.prototype.forEach=function(e){var n=this.start,t=this.step,r=this.end,i=0;if(t>0)for(;r>n;)e(n,i,this),n+=t,i++;else if(0>t)for(;n>r;)e(n,i,this),n+=t,i++},r.prototype.map=function(e){var n=[];return this.forEach(function(t,r,i){n[r]=e(t,r,i)}),n},r.prototype.toArray=function(){var e=[];return this.forEach(function(n,t){e[t]=n}),e},r.prototype.valueOf=function(){return this.toArray()},r.prototype.format=function(e){var n=o.format(this.start,e);return 1!=this.step&&(n+=":"+o.format(this.step,e)),n+=":"+o.format(this.end,e)},r.prototype.toString=function(){return this.format()},n.exports=r,t.isRange=r.isRange,t.parse=r.parse},{"../util/index":213}],208:[function(e,n,t){function r(e,n){if(!(this instanceof r))throw new Error("Unit constructor must be called with the new operator");if(null!=e&&!y(e))throw new TypeError("First parameter in Unit constructor must be a number");if(null!=n&&!b(n))throw new TypeError("Second parameter in Unit constructor must be a string");if(null!=n){var t=l(n);if(!t)throw new SyntaxError('String "'+n+'" is no unit');this.unit=t.unit,this.prefix=t.prefix}else this.unit=UNIT_NONE,this.prefix=w;null!=e?(this.value=this._normalize(e),this.fixPrefix=!1):(this.value=null,this.fixPrefix=!0)}function i(){for(;" "==h||"	"==h;)s()}function o(e){return e>="0"&&"9">=e||"."==e}function a(e){return e>="0"&&"9">=e}function s(){p++,h=m.charAt(p)}function u(e){p=e,h=m.charAt(p)}function c(){var e,n="";if(e=p,"+"==h?s():"-"==h&&(n+=h,s()),!o(h))return u(e),null;if("."==h){if(n+=h,s(),!a(h))return u(e),null}else{for(;a(h);)n+=h,s();"."==h&&(n+=h,s())}for(;a(h);)n+=h,s();if("E"==h||"e"==h){if(n+=h,s(),("+"==h||"-"==h)&&(n+=h,s()),!a(h))return u(e),null;for(;a(h);)n+=h,s()}return n}function f(){var e="";for(i();h&&" "!=h&&"	"!=h;)e+=h,s();return e||null}function l(e){for(var n=0,t=N.length;t>n;n++){var r=N[n];if(d.endsWith(e,r.name)){var i=e.length-r.name.length,o=e.substring(0,i),a=r.prefixes[o];if(void 0!==a)return{unit:r,prefix:a}}}return null}var m,p,h,g=e("../util/index"),x=g.number,d=g.string,y=g.number.isNumber,b=g.string.isString;r.parse=function(e){if(m=e,p=-1,h="",!b(m))return null;s(),i();var n,t=c();return t?(n=f(),s(),i(),h?null:t&&n?new r(Number(t),n):null):(n=f(),s(),i(),h?null:new r(null,n))},r.isUnit=function(e){return e instanceof r},r.prototype.clone=function(){var e=new r;for(var n in this)this.hasOwnProperty(n)&&(e[n]=this[n]);return e},r.prototype._normalize=function(e){return(e+this.unit.offset)*this.unit.value*this.prefix.value},r.prototype._unnormalize=function(e,n){return void 0==n?e/this.unit.value/this.prefix.value-this.unit.offset:e/this.unit.value/n-this.unit.offset},r.isPlainUnit=function(e){return null!=l(e)},r.prototype.hasBase=function(e){return void 0===this.unit.base?void 0===e:this.unit.base===e},r.prototype.equalBase=function(e){return this.unit.base===e.unit.base},r.prototype.equals=function(e){return this.equalBase(e)&&this.value==e.value},r.prototype["in"]=function(e){var n;if(b(e)){if(n=new r(null,e),!this.equalBase(n))throw new Error("Units do not match");return n.value=this.value,n}if(e instanceof r){if(!this.equalBase(e))throw new Error("Units do not match");if(null!=e.value)throw new Error("Cannot convert to a unit with a value");if(null==e.unit)throw new Error("Unit expected on the right hand side of function in");return n=e.clone(),n.value=this.value,n.fixPrefix=!0,n}throw new Error("String or Unit expected as parameter")},r.prototype.toNumber=function(e){var n=this["in"](e),t=this.fixPrefix?n._bestPrefix():n.prefix;return n._unnormalize(n.value,t.value)},r.prototype.toString=function(){return this.format()},r.prototype.format=function(e){var n,t;if(this.fixPrefix)n=this._unnormalize(this.value),t=null!=this.value?x.format(n,e)+" ":"",t+=this.prefix.name+this.unit.name;else{var r=this._bestPrefix();n=this._unnormalize(this.value,r.value),t=null!=this.value?x.format(n,e)+" ":"",t+=r.name+this.unit.name}return t},r.prototype._bestPrefix=function(){var e=Math.abs(this.value/this.unit.value),n=w,t=Math.abs(Math.log(e/n.value)/Math.LN10-1.2),r=this.unit.prefixes;for(var i in r)if(r.hasOwnProperty(i)){var o=r[i];if(o.scientific){var a=Math.abs(Math.log(e/o.value)/Math.LN10-1.2);t>a&&(n=o,t=a)}}return n};var v={NONE:{"":{name:"",value:1,scientific:!0}},SHORT:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:10,scientific:!1},h:{name:"h",value:100,scientific:!1},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},d:{name:"d",value:.1,scientific:!1},c:{name:"c",value:.01,scientific:!1},m:{name:"m",value:.001,scientific:!0},u:{name:"u",value:1e-6,scientific:!0},n:{name:"n",value:1e-9,scientific:!0},p:{name:"p",value:1e-12,scientific:!0},f:{name:"f",value:1e-15,scientific:!0},a:{name:"a",value:1e-18,scientific:!0},z:{name:"z",value:1e-21,scientific:!0},y:{name:"y",value:1e-24,scientific:!0}},LONG:{"":{name:"",value:1,scientific:!0},deca:{name:"deca",value:10,scientific:!1},hecto:{name:"hecto",value:100,scientific:!1},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},deci:{name:"deci",value:.1,scientific:!1},centi:{name:"centi",value:.01,scientific:!1},milli:{name:"milli",value:.001,scientific:!0},micro:{name:"micro",value:1e-6,scientific:!0},nano:{name:"nano",value:1e-9,scientific:!0},pico:{name:"pico",value:1e-12,scientific:!0},femto:{name:"femto",value:1e-15,scientific:!0},atto:{name:"atto",value:1e-18,scientific:!0},zepto:{name:"zepto",value:1e-21,scientific:!0},yocto:{name:"yocto",value:1e-24,scientific:!0}},SQUARED:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:100,scientific:!1},h:{name:"h",value:1e4,scientific:!1},k:{name:"k",value:1e6,scientific:!0},M:{name:"M",value:1e12,scientific:!0},G:{name:"G",value:1e18,scientific:!0},T:{name:"T",value:1e24,scientific:!0},P:{name:"P",value:1e30,scientific:!0},E:{name:"E",value:1e36,scientific:!0},Z:{name:"Z",value:1e42,scientific:!0},Y:{name:"Y",value:1e48,scientific:!0},d:{name:"d",value:.01,scientific:!1},c:{name:"c",value:1e-4,scientific:!1},m:{name:"m",value:1e-6,scientific:!0},u:{name:"u",value:1e-12,scientific:!0},n:{name:"n",value:1e-18,scientific:!0},p:{name:"p",value:1e-24,scientific:!0},f:{name:"f",value:1e-30,scientific:!0},a:{name:"a",value:1e-36,scientific:!0},z:{name:"z",value:1e-42,scientific:!0},y:{name:"y",value:1e-42,scientific:!0}},CUBIC:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:1e3,scientific:!1},h:{name:"h",value:1e6,scientific:!1},k:{name:"k",value:1e9,scientific:!0},M:{name:"M",value:1e18,scientific:!0},G:{name:"G",value:1e27,scientific:!0},T:{name:"T",value:1e36,scientific:!0},P:{name:"P",value:1e45,scientific:!0},E:{name:"E",value:1e54,scientific:!0},Z:{name:"Z",value:1e63,scientific:!0},Y:{name:"Y",value:1e72,scientific:!0},d:{name:"d",value:.001,scientific:!1},c:{name:"c",value:1e-6,scientific:!1},m:{name:"m",value:1e-9,scientific:!0},u:{name:"u",value:1e-18,scientific:!0},n:{name:"n",value:1e-27,scientific:!0},p:{name:"p",value:1e-36,scientific:!0},f:{name:"f",value:1e-45,scientific:!0},a:{name:"a",value:1e-54,scientific:!0},z:{name:"z",value:1e-63,scientific:!0},y:{name:"y",value:1e-72,scientific:!0}},BINARY_SHORT:{"":{name:"",value:1,scientific:!0},k:{name:"k",value:1024,scientific:!0},M:{name:"M",value:Math.pow(1024,2),scientific:!0},G:{name:"G",value:Math.pow(1024,3),scientific:!0},T:{name:"T",value:Math.pow(1024,4),scientific:!0},P:{name:"P",value:Math.pow(1024,5),scientific:!0},E:{name:"E",value:Math.pow(1024,6),scientific:!0},Z:{name:"Z",value:Math.pow(1024,7),scientific:!0},Y:{name:"Y",value:Math.pow(1024,8),scientific:!0},Ki:{name:"Ki",value:1024,scientific:!0},Mi:{name:"Mi",value:Math.pow(1024,2),scientific:!0},Gi:{name:"Gi",value:Math.pow(1024,3),scientific:!0},Ti:{name:"Ti",value:Math.pow(1024,4),scientific:!0},Pi:{name:"Pi",value:Math.pow(1024,5),scientific:!0},Ei:{name:"Ei",value:Math.pow(1024,6),scientific:!0},Zi:{name:"Zi",value:Math.pow(1024,7),scientific:!0},Yi:{name:"Yi",value:Math.pow(1024,8),scientific:!0}},BINARY_LONG:{"":{name:"",value:1,scientific:!0},kilo:{name:"kilo",value:1024,scientific:!0},mega:{name:"mega",value:Math.pow(1024,2),scientific:!0},giga:{name:"giga",value:Math.pow(1024,3),scientific:!0},tera:{name:"tera",value:Math.pow(1024,4),scientific:!0},peta:{name:"peta",value:Math.pow(1024,5),scientific:!0},exa:{name:"exa",value:Math.pow(1024,6),scientific:!0},zetta:{name:"zetta",value:Math.pow(1024,7),scientific:!0},yotta:{name:"yotta",value:Math.pow(1024,8),scientific:!0},kibi:{name:"kibi",value:1024,scientific:!0},mebi:{name:"mebi",value:Math.pow(1024,2),scientific:!0},gibi:{name:"gibi",value:Math.pow(1024,3),scientific:!0},tebi:{name:"tebi",value:Math.pow(1024,4),scientific:!0},pebi:{name:"pebi",value:Math.pow(1024,5),scientific:!0},exi:{name:"exi",value:Math.pow(1024,6),scientific:!0},zebi:{name:"zebi",value:Math.pow(1024,7),scientific:!0},yobi:{name:"yobi",value:Math.pow(1024,8),scientific:!0}}},w={name:"",value:1,scientific:!0},E={NONE:{},LENGTH:{},MASS:{},TIME:{},CURRENT:{},TEMPERATURE:{},LUMINOUS_INTENSITY:{},AMOUNT_OF_SUBSTANCE:{},FORCE:{},SURFACE:{},VOLUME:{},ANGLE:{},BIT:{}};BASE_UNIT_NONE={},UNIT_NONE={name:"",base:BASE_UNIT_NONE,value:1,offset:0};var N=[{name:"meter",base:E.LENGTH,prefixes:v.LONG,value:1,offset:0},{name:"inch",base:E.LENGTH,prefixes:v.NONE,value:.0254,offset:0},{name:"foot",base:E.LENGTH,prefixes:v.NONE,value:.3048,offset:0},{name:"yard",base:E.LENGTH,prefixes:v.NONE,value:.9144,offset:0},{name:"mile",base:E.LENGTH,prefixes:v.NONE,value:1609.344,offset:0},{name:"link",base:E.LENGTH,prefixes:v.NONE,value:.201168,offset:0},{name:"rod",base:E.LENGTH,prefixes:v.NONE,value:5.02921,offset:0},{name:"chain",base:E.LENGTH,prefixes:v.NONE,value:20.1168,offset:0},{name:"angstrom",base:E.LENGTH,prefixes:v.NONE,value:1e-10,offset:0},{name:"m",base:E.LENGTH,prefixes:v.SHORT,value:1,offset:0},{name:"ft",base:E.LENGTH,prefixes:v.NONE,value:.3048,offset:0},{name:"yd",base:E.LENGTH,prefixes:v.NONE,value:.9144,offset:0},{name:"mi",base:E.LENGTH,prefixes:v.NONE,value:1609.344,offset:0},{name:"li",base:E.LENGTH,prefixes:v.NONE,value:.201168,offset:0},{name:"rd",base:E.LENGTH,prefixes:v.NONE,value:5.02921,offset:0},{name:"ch",base:E.LENGTH,prefixes:v.NONE,value:20.1168,offset:0},{name:"mil",base:E.LENGTH,prefixes:v.NONE,value:254e-7,offset:0},{name:"m2",base:E.SURFACE,prefixes:v.SQUARED,value:1,offset:0},{name:"sqin",base:E.SURFACE,prefixes:v.NONE,value:64516e-8,offset:0},{name:"sqft",base:E.SURFACE,prefixes:v.NONE,value:.09290304,offset:0},{name:"sqyd",base:E.SURFACE,prefixes:v.NONE,value:.83612736,offset:0},{name:"sqmi",base:E.SURFACE,prefixes:v.NONE,value:2589988.110336,offset:0},{name:"sqrd",base:E.SURFACE,prefixes:v.NONE,value:25.29295,offset:0},{name:"sqch",base:E.SURFACE,prefixes:v.NONE,value:404.6873,offset:0},{name:"sqmil",base:E.SURFACE,prefixes:v.NONE,value:6.4516e-10,offset:0},{name:"m3",base:E.VOLUME,prefixes:v.CUBIC,value:1,offset:0},{name:"L",base:E.VOLUME,prefixes:v.SHORT,value:.001,offset:0},{name:"litre",base:E.VOLUME,prefixes:v.LONG,value:.001,offset:0},{name:"cuin",base:E.VOLUME,prefixes:v.NONE,value:16387064e-12,offset:0},{name:"cuft",base:E.VOLUME,prefixes:v.NONE,value:.028316846592,offset:0},{name:"cuyd",base:E.VOLUME,prefixes:v.NONE,value:.764554857984,offset:0},{name:"teaspoon",base:E.VOLUME,prefixes:v.NONE,value:5e-6,offset:0},{name:"tablespoon",base:E.VOLUME,prefixes:v.NONE,value:15e-6,offset:0},{name:"minim",base:E.VOLUME,prefixes:v.NONE,value:6.161152e-8,offset:0},{name:"fluiddram",base:E.VOLUME,prefixes:v.NONE,value:36966911e-13,offset:0},{name:"fluidounce",base:E.VOLUME,prefixes:v.NONE,value:2957353e-11,offset:0},{name:"gill",base:E.VOLUME,prefixes:v.NONE,value:.0001182941,offset:0},{name:"cup",base:E.VOLUME,prefixes:v.NONE,value:.0002365882,offset:0},{name:"pint",base:E.VOLUME,prefixes:v.NONE,value:.0004731765,offset:0},{name:"quart",base:E.VOLUME,prefixes:v.NONE,value:.0009463529,offset:0},{name:"gallon",base:E.VOLUME,prefixes:v.NONE,value:.003785412,offset:0},{name:"beerbarrel",base:E.VOLUME,prefixes:v.NONE,value:.1173478,offset:0},{name:"oilbarrel",base:E.VOLUME,prefixes:v.NONE,value:.1589873,offset:0},{name:"hogshead",base:E.VOLUME,prefixes:v.NONE,value:.238481,offset:0},{name:"fldr",base:E.VOLUME,prefixes:v.NONE,value:36966911e-13,offset:0},{name:"floz",base:E.VOLUME,prefixes:v.NONE,value:2957353e-11,offset:0},{name:"gi",base:E.VOLUME,prefixes:v.NONE,value:.0001182941,offset:0},{name:"cp",base:E.VOLUME,prefixes:v.NONE,value:.0002365882,offset:0},{name:"pt",base:E.VOLUME,prefixes:v.NONE,value:.0004731765,offset:0},{name:"qt",base:E.VOLUME,prefixes:v.NONE,value:.0009463529,offset:0},{name:"gal",base:E.VOLUME,prefixes:v.NONE,value:.003785412,offset:0},{name:"bbl",base:E.VOLUME,prefixes:v.NONE,value:.1173478,offset:0},{name:"obl",base:E.VOLUME,prefixes:v.NONE,value:.1589873,offset:0},{name:"g",base:E.MASS,prefixes:v.SHORT,value:.001,offset:0},{name:"gram",base:E.MASS,prefixes:v.LONG,value:.001,offset:0},{name:"ton",base:E.MASS,prefixes:v.SHORT,value:907.18474,offset:0},{name:"tonne",base:E.MASS,prefixes:v.SHORT,value:1e3,offset:0},{name:"grain",base:E.MASS,prefixes:v.NONE,value:6479891e-11,offset:0},{name:"dram",base:E.MASS,prefixes:v.NONE,value:.0017718451953125,offset:0},{name:"ounce",base:E.MASS,prefixes:v.NONE,value:.028349523125,offset:0},{name:"poundmass",base:E.MASS,prefixes:v.NONE,value:.45359237,offset:0},{name:"hundredweight",base:E.MASS,prefixes:v.NONE,value:45.359237,offset:0},{name:"stick",base:E.MASS,prefixes:v.NONE,value:.115,offset:0},{name:"gr",base:E.MASS,prefixes:v.NONE,value:6479891e-11,offset:0},{name:"dr",base:E.MASS,prefixes:v.NONE,value:.0017718451953125,offset:0},{name:"oz",base:E.MASS,prefixes:v.NONE,value:.028349523125,offset:0},{name:"lbm",base:E.MASS,prefixes:v.NONE,value:.45359237,offset:0},{name:"cwt",base:E.MASS,prefixes:v.NONE,value:45.359237,offset:0},{name:"s",base:E.TIME,prefixes:v.SHORT,value:1,offset:0},{name:"min",base:E.TIME,prefixes:v.NONE,value:60,offset:0},{name:"h",base:E.TIME,prefixes:v.NONE,value:3600,offset:0},{name:"seconds",base:E.TIME,prefixes:v.LONG,value:1,offset:0},{name:"second",base:E.TIME,prefixes:v.LONG,value:1,offset:0},{name:"sec",base:E.TIME,prefixes:v.LONG,value:1,offset:0},{name:"minutes",base:E.TIME,prefixes:v.NONE,value:60,offset:0},{name:"minute",base:E.TIME,prefixes:v.NONE,value:60,offset:0},{name:"hours",base:E.TIME,prefixes:v.NONE,value:3600,offset:0},{name:"hour",base:E.TIME,prefixes:v.NONE,value:3600,offset:0},{name:"day",base:E.TIME,prefixes:v.NONE,value:86400,offset:0},{name:"days",base:E.TIME,prefixes:v.NONE,value:86400,offset:0},{name:"rad",base:E.ANGLE,prefixes:v.NONE,value:1,offset:0},{name:"deg",base:E.ANGLE,prefixes:v.NONE,value:.017453292519943295,offset:0},{name:"grad",base:E.ANGLE,prefixes:v.NONE,value:.015707963267948967,offset:0},{name:"cycle",base:E.ANGLE,prefixes:v.NONE,value:6.283185307179586,offset:0},{name:"A",base:E.CURRENT,prefixes:v.SHORT,value:1,offset:0},{name:"ampere",base:E.CURRENT,prefixes:v.LONG,value:1,offset:0},{name:"K",base:E.TEMPERATURE,prefixes:v.NONE,value:1,offset:0},{name:"degC",base:E.TEMPERATURE,prefixes:v.NONE,value:1,offset:273.15},{name:"degF",base:E.TEMPERATURE,prefixes:v.NONE,value:1/1.8,offset:459.67},{name:"degR",base:E.TEMPERATURE,prefixes:v.NONE,value:1/1.8,offset:0},{name:"kelvin",base:E.TEMPERATURE,prefixes:v.NONE,value:1,offset:0},{name:"celsius",base:E.TEMPERATURE,prefixes:v.NONE,value:1,offset:273.15},{name:"fahrenheit",base:E.TEMPERATURE,prefixes:v.NONE,value:1/1.8,offset:459.67},{name:"rankine",base:E.TEMPERATURE,prefixes:v.NONE,value:1/1.8,offset:0},{name:"mol",base:E.AMOUNT_OF_SUBSTANCE,prefixes:v.NONE,value:1,offset:0},{name:"mole",base:E.AMOUNT_OF_SUBSTANCE,prefixes:v.NONE,value:1,offset:0},{name:"cd",base:E.LUMINOUS_INTENSITY,prefixes:v.NONE,value:1,offset:0},{name:"candela",base:E.LUMINOUS_INTENSITY,prefixes:v.NONE,value:1,offset:0},{name:"N",base:E.FORCE,prefixes:v.SHORT,value:1,offset:0},{name:"newton",base:E.FORCE,prefixes:v.LONG,value:1,offset:0},{name:"lbf",base:E.FORCE,prefixes:v.NONE,value:4.4482216152605,offset:0},{name:"poundforce",base:E.FORCE,prefixes:v.NONE,value:4.4482216152605,offset:0},{name:"b",base:E.BIT,prefixes:v.BINARY_SHORT,value:1,offset:0},{name:"bits",base:E.BIT,prefixes:v.BINARY_LONG,value:1,offset:0},{name:"B",base:E.BIT,prefixes:v.BINARY_SHORT,value:8,offset:0},{name:"bytes",base:E.BIT,prefixes:v.BINARY_LONG,value:8,offset:0}];r.PREFIXES=v,r.BASE_UNITS=E,r.UNITS=N,n.exports=r,t.isUnit=r.isUnit,t.isPlainUnit=r.isPlainUnit,t.parse=r.parse},{"../util/index":213}],209:[function(e,n,t){function r(e,n,t){var o,a,u,c;if(0>=n){if(s(e[0])){for(c=i(e),a=[],o=0;o<c.length;o++)a[o]=r(c[o],n-1,t);return a}for(u=e[0],o=1;o<e.length;o++)u=t(u,e[o]);return u}for(a=[],o=0;o<e.length;o++)a[o]=r(e[o],n-1,t);return a}function i(e){var n,t,r=e.length,i=e[0].length,o=[];for(t=0;i>t;t++){var a=[];for(n=0;r>n;n++)a.push(e[n][t]);o.push(a)}return o}{var o=e("../util/index"),a=e("./Matrix"),s=o.array.isArray;o.string.isString}t.argsToArray=function(e){var n;return 0==e.length?n=[]:1==e.length?(n=e[0],n instanceof a&&(n=n.valueOf()),s(n)||(n=[n])):n=Array.prototype.slice.apply(e),n},t.isCollection=function(e){return s(e)||e instanceof a},t.deepMap=function u(e,n){return e&&"function"==typeof e.map?e.map(function(e){return u(e,n)}):n(e)},t.deepMap2=function c(e,n,t){var r,i,o;if(s(e))if(s(n)){if(e.length!=n.length)throw new RangeError("Dimension mismatch ("+e.length+" != "+n.length+")");for(r=[],i=e.length,o=0;i>o;o++)r[o]=c(e[o],n[o],t)}else{if(n instanceof a)return r=c(e,n.valueOf(),t),new a(r);for(r=[],i=e.length,o=0;i>o;o++)r[o]=c(e[o],n,t)}else{if(e instanceof a)return n instanceof a?(r=c(e.valueOf(),n.valueOf(),t),new a(r)):(r=c(e.valueOf(),n,t),new a(r));if(s(n))for(r=[],i=n.length,o=0;i>o;o++)r[o]=c(e,n[o],t);else{if(n instanceof a)return r=c(e,n.valueOf(),t),new a(r);
r=t(e,n)}}return r},t.reduce=function(e,n,t){return e instanceof a?new a(r(e.valueOf(),n,t)):r(e,n,t)},t.deepForEach=function f(e,n){e instanceof a&&(e=e.valueOf());for(var t=0,r=e.length;r>t;t++){var i=e[t];s(i)?f(i,n):n(i)}}},{"../util/index":213,"./Matrix":206}],210:[function(e,n){n.exports=function(n){var t=(e("./../util/types"),{});n.error=t,t.UnsupportedTypeError=function(e,t){if(2==arguments.length){var r=n["typeof"](t);this.message="Function "+e+"("+r+") not supported"}else if(arguments.length>2){var i=Array.prototype.splice.call(arguments,1),o=i.map(function(e){return n["typeof"](e)});this.message="Function "+e+"("+o.join(", ")+") not supported"}else this.message="Unsupported type of argument in function "+e},t.UnsupportedTypeError.prototype=new TypeError,t.UnsupportedTypeError.prototype.name="UnsupportedTypeError",t.ArgumentsError=function(e,n,t,r){this.message="Wrong number of arguments in function "+e+" ("+n+" provided, "+t+(void 0!=r?"-"+r:"")+" expected)"},t.ArgumentsError.prototype=new SyntaxError,t.ArgumentsError.prototype.name="ArgumentError"}},{"./../util/types":217}],211:[function(e,n,t){function r(e){for(var n=[];c(e);)n.push(e.length),e=e[0];return n}function i(e,n,t){var r,o=e.length;if(o!=n[t])throw new RangeError("Dimension mismatch ("+o+" != "+n[t]+")");if(t<n.length-1){var a=t+1;for(r=0;o>r;r++){var s=e[r];if(!c(s))throw new RangeError("Dimension mismatch ("+(n.length-1)+" < "+n.length+")");i(e[r],n,a)}}else for(r=0;o>r;r++)if(c(e[r]))throw new RangeError("Dimension mismatch ("+(n.length+1)+" > "+n.length+")")}function o(e,n,t,r){if(!c(e))throw Error("Array expected");var i,a,s=e.length,f=n[t],l=Math.min(s,f);if(e.length=f,t<n.length-1){var m=t+1;for(i=0;l>i;i++)a=e[i],o(a,n,m,r);for(i=l;f>i;i++)a=[],e[i]=a,o(a,n,m,r)}else if(void 0!==r)for(i=s;f>i;i++)e[i]=u.clone(r)}var a=e("./number"),s=e("./string"),u=e("./object"),c=(e("./types"),Array.isArray);t.size=function(e){var n=r(e);return t.validate(e,n),n},t.validate=function(e,n){var t=0==n.length;if(t){if(c(e))throw new RangeError("Dimension mismatch ("+e.length+" != 0)")}else i(e,n,0)},t.validateIndex=function(e,n){if(!a.isNumber(e)||!a.isInteger(e))throw new TypeError("Index must be an integer (value: "+e+")");if(0>e)throw new RangeError("Index out of range ("+e+" < 0)");if(void 0!==n&&e>=n)throw new RangeError("Index out of range ("+e+" > "+(n-1)+")")},t.resize=function(e,n,t){if(!c(e)||!c(n))throw new TypeError("Array expected");if(0===n.length)throw new Error("Resizing to scalar is not supported");n.forEach(function(e){if(!a.isNumber(e)||!a.isInteger(e)||0>e)throw new TypeError("Invalid size, must contain positive integers (size: "+s.format(n)+")")});for(var r=1,i=e[0];c(i);)r++,i=i[0];for(;r<n.length;)e=[e],r++;for(;r>n.length;)e=e[0],r--;return o(e,n,0,t),e},t.squeeze=function(e){for(;c(e)&&1===e.length;)e=e[0];return e},t.unsqueeze=function(e,n){for(var r=t.size(e),i=0,o=n-r.length;o>i;i++)e=[e];return e},t.isArray=c},{"./number":214,"./object":215,"./string":216,"./types":217}],212:[function(e,n,t){t.isBoolean=function(e){return e instanceof Boolean||"boolean"==typeof e}},{}],213:[function(e,n,t){t.array=e("./array"),t["boolean"]=e("./boolean"),t.number=e("./number"),t.object=e("./object"),t.string=e("./string"),t.types=e("./types")},{"./array":211,"./boolean":212,"./number":214,"./object":215,"./string":216,"./types":217}],214:[function(e,n,t){function r(e){return e instanceof o?e.isZero():0===e}function i(e,n,t){var r;return e instanceof o?(r=e.abs(),r.gte(n)&&r.lt(t)):(r=Math.abs(e),r>=n&&t>r)}var o=e("bignumber.js");t.isNumber=function(e){return e instanceof Number||"number"==typeof e},t.isInteger=function(e){return e==Math.round(e)},t.sign=function(e){return e>0?1:0>e?-1:0},t.format=function(e,n){if("function"==typeof n)return n(e);if(1/0===e)return"Infinity";if(e===-1/0)return"-Infinity";if(isNaN(e))return"NaN";var a="auto",s=void 0;switch(void 0!==n&&(n.notation&&(a=n.notation),n&&(t.isNumber(n)?s=n:n.precision&&(s=n.precision))),a){case"fixed":return t.toFixed(e,s);case"scientific":throw new Error('Format notation "scientific" is deprecated. Use "exponential" instead.');case"exponential":return t.toExponential(e,s);case"auto":var u=.001,c=1e5;if(n&&n.exponential)void 0!==n.exponential.lower&&(u=n.exponential.lower),void 0!==n.exponential.upper&&(c=n.exponential.upper);else if(n&&n.scientific)throw new Error("options.scientific is deprecated, use options.exponential instead.");var f=e instanceof o;if(f){var l=o.config().EXPONENTIAL_AT;o.config({EXPONENTIAL_AT:[Math.round(Math.log(u)/Math.LN10),Math.round(Math.log(c)/Math.LN10)]})}if(r(e))return"0";var m;if(i(e,u,c))if(f)m=new o(e.toPrecision(s)).toString();else{var p=s?e.toPrecision(Math.min(s,21)):e.toPrecision();m=parseFloat(p)+""}else m=t.toExponential(e,s);return f&&o.config({EXPONENTIAL_AT:l}),m.replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],n=arguments[4];return"."!==e?e+n:n});default:throw new Error('Unknown notation "'+a+'". Choose "auto", "exponential", or "fixed".')}},t.toExponential=function(e,n){return void 0!==n?e instanceof o?e.toExponential(n-1):e.toExponential(Math.min(n-1,20)):e.toExponential()},t.toFixed=function(e,n){return e instanceof o?e.toFixed(n||0):e.toFixed(Math.min(n,20))},t.digits=function(e){return e.toExponential().replace(/e[\+\-0-9]*$/,"").replace(/^0\.0*|\./,"").length},t.toBigNumber=function(e){return t.digits(e)>15?e:new o(e)},t.toNumber=function(e){return parseFloat(e.valueOf())}},{"bignumber.js":218}],215:[function(e,n,t){t.clone=function r(e){var n=typeof e;if("number"===n||"string"===n||"boolean"===n||null===e||void 0===e)return e;if("function"==typeof e.clone)return e.clone();if(Array.isArray(e))return e.map(function(e){return r(e)});if(e instanceof Object){var t={};for(var i in e)e.hasOwnProperty(i)&&(t[i]=r(e[i]));return e}throw new TypeError("Cannot clone "+e)},t.extend=function(e,n){for(var t in n)n.hasOwnProperty(t)&&(e[t]=n[t]);return e},t.deepExtend=function i(e,n){for(var t in n)n.hasOwnProperty(t)&&(n[t]&&n[t].constructor===Object?(void 0===e[t]&&(e[t]={}),e[t].constructor===Object?i(e[t],n[t]):e[t]=n[t]):e[t]=n[t]);return e},t.deepEqual=function(e,n){var r,i,o;if(Array.isArray(e)){if(!Array.isArray(n))return!1;if(e.length!=n.length)return!1;for(i=0,o=e.length;o>i;i++)if(!t.deepEqual(e[i],n[i]))return!1;return!0}if(e instanceof Object){if(Array.isArray(n)||!(n instanceof Object))return!1;for(r in e)if(e.hasOwnProperty(r)&&!t.deepEqual(e[r],n[r]))return!1;for(r in n)if(n.hasOwnProperty(r)&&!t.deepEqual(e[r],n[r]))return!1;return!0}return e==n}},{}],216:[function(e,n,t){function r(e,n){if(Array.isArray(e)){for(var i="[",o=e.length,a=0;o>a;a++)0!=a&&(i+=", "),i+=r(e[a],n);return i+="]"}return t.format(e,n)}var i=e("./number"),o=e("bignumber.js");t.isString=function(e){return e instanceof String||"string"==typeof e},t.endsWith=function(e,n){var t=e.length-n.length,r=e.length;return e.substring(t,r)===n},t.format=function(e,n){return i.isNumber(e)||e instanceof o?i.format(e,n):Array.isArray(e)?r(e,n):t.isString(e)?'"'+e+'"':"function"==typeof e?e.syntax?e.syntax+"":"function":e instanceof Object?"function"==typeof e.format?e.format(n):e.toString():String(e)}},{"./number":214,"bignumber.js":218}],217:[function(e,n,t){t.type=function r(e){var r=typeof e;if("object"===r){if(null===e)return"null";if(e instanceof Boolean)return"boolean";if(e instanceof Number)return"number";if(e instanceof String)return"string";if(Array.isArray(e))return"array";if(e instanceof Date)return"date"}return r}},{}],218:[function(n,t){!function(n){"use strict";function r(e,n){var t,a,s,u,l,m,g=this;if(!(g instanceof r))return new r(e,n);if(e instanceof r){if(N=0,n===t)return g.s=e.s,g.e=e.e,g.c=(e=e.c)?e.slice():e,void 0;e+=""}if("string"!=typeof e&&(e=(s="number"==typeof e||"[object Number]"==Object.prototype.toString.call(e))&&0===e&&0>1/e?"-0":e+""),m=e,n===t&&M.test(e))g.s="-"==e.charAt(0)?(e=e.slice(1),-1):1;else{if(10==n)return c(e,p,h);if(e=j.call(e).replace(/^\+(?!-)/,""),g.s="-"==e.charAt(0)?(e=e.replace(/^-(?!-)/,""),-1):1,null!=n?n!=(0|n)&&b||(f=!(n>=2&&65>n))?(i(n,2),l=M.test(e)):(u="["+E.slice(0,n=0|n)+"]+",e=e.replace(/\.$/,"").replace(/^\./,"0."),(l=new RegExp("^"+u+"(?:\\."+u+")?$",37>n?"i":"").test(e))?(s&&(e.replace(/^0\.0*|\./,"").length>15&&i(m,0),s=!s),e=o(e,10,n,g.s)):"Infinity"!=e&&"NaN"!=e&&(i(m,1,n),e="NaN")):l=M.test(e),!l)return g.c=g.e=null,"Infinity"!=e&&("NaN"!=e&&i(m,3),g.s=null),N=0,void 0}for((t=e.indexOf("."))>-1&&(e=e.replace(".","")),(a=e.search(/e/i))>0?(0>t&&(t=a),t+=+e.slice(a+1),e=e.substring(0,a)):0>t&&(t=e.length),a=0;"0"==e.charAt(a);a++);if(n=e.length,s&&n>15&&e.slice(a).length>15&&i(m,0),N=0,(t-=a+1)>y)g.c=g.e=null;else if(a==n||d>t)g.c=[g.e=0];else{for(;"0"==e.charAt(--n););for(g.e=t,g.c=[],t=0;n>=a;g.c[t++]=+e.charAt(a++));}}function i(e,n,t,r,i,o){if(b){var a,s=["new BigNumber","cmp","div","eq","gt","gte","lt","lte","minus","mod","plus","times","toFr"][N?0>N?-N:N:0>1/N?1:0]+"()",u=f?" out of range":" not a"+(i?" non-zero":"n")+" integer";throw u=([s+" number type has more than 15 significant digits",s+" not a base "+t+" number",s+" base"+u,s+" not a number"][n]||t+"() "+n+(o?" not a boolean or binary digit":u+(r?" or not ["+(f?" negative, positive":" integer, integer")+" ]":"")))+": "+e,f=N=0,a=new Error(u),a.name="BigNumber Error",a}}function o(e,n,t,i){function o(e,r){var i,o,a=0,s=e.length,u=[0];for(r=r||t;s>a;a++){for(o=u.length,i=0;o>i;u[i]*=r,i++);for(u[0]+=E.indexOf(e.charAt(a)),i=0;i<u.length;i++)u[i]>n-1&&(null==u[i+1]&&(u[i+1]=0),u[i+1]+=u[i]/n^0,u[i]%=n)}return u.reverse()}function s(e){for(var n=0,t=e.length,r="";t>n;r+=E.charAt(e[n++]));return r}var u,c,f,l,m,p;if(37>t&&(e=e.toLowerCase()),(u=e.indexOf("."))>-1)if(u=e.length-u-1,c=o(new r(t).pow(u).toF(),10),l=e.split("."),f=o(l[1]),l=o(l[0]),p=a(f,c,f.length-c.length,i,n,1&l[l.length-1]),m=p.c,u=p.e){for(;++u;m.unshift(0));e=s(l)+"."+s(m)}else m[0]?l[u=l.length-1]<n-1?(++l[u],e=s(l)):e=new r(s(l),n).plus(C).toS(n):e=s(l);else e=s(o(e));return e}function a(e,n,t,i,o,a){var s,c,f,l,m,h=n.slice(),g=s=n.length,x=e.length,b=e.slice(0,s),v=b.length,w=new r(C),E=w.c=[],N=0,M=p+(w.e=t)+1;for(w.s=i,i=0>M?0:M;v++<s;b.push(0));h.unshift(0);do{for(f=0;o>f;f++){if(s!=(v=b.length))l=s>v?1:-1;else for(m=-1,l=0;++m<s;)if(n[m]!=b[m]){l=n[m]>b[m]?1:-1;break}if(!(0>l))break;for(c=v==s?n:h;v;){if(b[--v]<c[v]){for(m=v;m&&!b[--m];b[m]=o-1);--b[m],b[v]+=o}b[v]-=c[v]}for(;!b[0];b.shift());}E[N++]=l?f:++f,b[0]&&l?b[v]=e[g]||0:b=[e[g]]}while((g++<x||null!=b[0])&&i--);return E[0]||1==N||(--w.e,E.shift()),N>M&&u(w,p,o,a,null!=b[0]),w.e>y?w.c=w.e=null:w.e<d&&(w.c=[w.e=0]),w}function s(e,n,t){var i=n-(e=new r(e)).e,o=e.c;if(!o)return e.toS();for(o.length>++n&&u(e,i,10),i=0==o[0]?i+1:t?n:e.e+i+1;o.length<i;o.push(0));return i=e.e,1==t||2==t&&(--n<i||g>=i)?(e.s<0&&o[0]?"-":"")+(o.length>1?(o.splice(1,0,"."),o.join("")):o[0])+(0>i?"e":"e+")+i:e.toS()}function u(e,n,t,r,i){var o=e.c,a=e.s<0,s=t/2,u=e.e+n+1,c=o[u],f=i||0>u||null!=o[u+1];if(i=4>h?(null!=c||f)&&(0==h||2==h&&!a||3==h&&a):c>s||c==s&&(4==h||f||6==h&&(1&o[u-1]||!n&&r)||7==h&&!a||8==h&&a),1>u||!o[0])return o.length=0,o.push(0),i?(o[0]=1,e.e=-n):e.e=0,e;if(o.length=u--,i)for(--t;++o[u]>t;)o[u]=0,u--||(++e.e,o.unshift(1));for(u=o.length;!o[--u];o.pop());return e}function c(e,n,t){var i=h;return h=t,e=new r(e),e.c&&u(e,n,10),h=i,e}var f,l=1e9,m=1e6,p=20,h=4,g=-7,x=21,d=-l,y=l,b=!0,v=parseInt,w=r.prototype,E="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_",N=0,M=/^-?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,j=String.prototype.trim||function(){return this.replace(/^\s+|\s+$/g,"")},C=r(1);r.ROUND_UP=0,r.ROUND_DOWN=1,r.ROUND_CEIL=2,r.ROUND_FLOOR=3,r.ROUND_HALF_UP=4,r.ROUND_HALF_DOWN=5,r.ROUND_HALF_EVEN=6,r.ROUND_HALF_CEIL=7,r.ROUND_HALF_FLOOR=8,r.config=function(){var e,n,t=0,r={},o=arguments,a=o[0],s="config",u=function(e,n,t){return!((f=n>e||e>t)||v(e)!=e&&0!==e)},c=a&&"object"==typeof a?function(){return a.hasOwnProperty(n)?null!=(e=a[n]):void 0}:function(){return o.length>t?null!=(e=o[t++]):void 0};return c(n="DECIMAL_PLACES")&&(u(e,0,l)?p=0|e:i(e,n,s)),r[n]=p,c(n="ROUNDING_MODE")&&(u(e,0,8)?h=0|e:i(e,n,s)),r[n]=h,c(n="EXPONENTIAL_AT")&&(u(e,-l,l)?g=-(x=~~(0>e?-e:+e)):!f&&e&&u(e[0],-l,0)&&u(e[1],0,l)?(g=~~e[0],x=~~e[1]):i(e,n,s,1)),r[n]=[g,x],c(n="RANGE")&&(u(e,-l,l)&&~~e?d=-(y=~~(0>e?-e:+e)):!f&&e&&u(e[0],-l,-1)&&u(e[1],1,l)?(d=~~e[0],y=~~e[1]):i(e,n,s,1,1)),r[n]=[d,y],c(n="ERRORS")&&(e===!!e||1===e||0===e?(f=N=0,v=(b=!!e)?parseInt:parseFloat):i(e,n,s,0,0,1)),r[n]=b,r},w.abs=w.absoluteValue=function(){var e=new r(this);return e.s<0&&(e.s=1),e},w.ceil=function(){return c(this,0,2)},w.comparedTo=w.cmp=function(e,n){var t,i=this,o=i.c,a=(N=-N,e=new r(e,n)).c,s=i.s,u=e.s,c=i.e,f=e.e;if(!s||!u)return null;if(t=o&&!o[0],n=a&&!a[0],t||n)return t?n?0:-u:s;if(s!=u)return s;if(t=0>s,n=c==f,!o||!a)return n?0:!o^t?1:-1;if(!n)return c>f^t?1:-1;for(s=-1,u=(c=o.length)<(f=a.length)?c:f;++s<u;)if(o[s]!=a[s])return o[s]>a[s]^t?1:-1;return c==f?0:c>f^t?1:-1},w.dividedBy=w.div=function(e,n){var t=this.c,i=this.e,o=this.s,s=(N=2,e=new r(e,n)).c,u=e.e,c=e.s,f=o==c?1:-1;return(i||t&&t[0])&&(u||s&&s[0])?a(t,s,i-u,f,10):new r(o&&c&&(t?!s||t[0]!=s[0]:s)?t&&0==t[0]||!s?0*f:f/0:0/0)},w.equals=w.eq=function(e,n){return N=3,0===this.cmp(e,n)},w.floor=function(){return c(this,0,3)},w.greaterThan=w.gt=function(e,n){return N=4,this.cmp(e,n)>0},w.greaterThanOrEqualTo=w.gte=function(e,n){return N=5,1==(n=this.cmp(e,n))||0===n},w.isFinite=w.isF=function(){return!!this.c},w.isNaN=function(){return!this.s},w.isNegative=w.isNeg=function(){return this.s<0},w.isZero=w.isZ=function(){return!!this.c&&0==this.c[0]},w.lessThan=w.lt=function(e,n){return N=6,this.cmp(e,n)<0},w.lessThanOrEqualTo=w.lte=function(e,n){return N=7,-1==(n=this.cmp(e,n))||0===n},w.minus=function(e,n){var t,i,o,a,s=this,u=s.s;if(n=(N=8,e=new r(e,n)).s,!u||!n)return new r(0/0);if(u!=n)return e.s=-n,s.plus(e);var c=s.c,f=s.e,l=e.c,m=e.e;if(!f||!m){if(!c||!l)return c?(e.s=-n,e):new r(l?s:0/0);if(!c[0]||!l[0])return l[0]?(e.s=-n,e):new r(c[0]?s:3==h?-0:0)}if(c=c.slice(),u=f-m){for(t=(a=0>u)?(u=-u,c):(m=f,l),t.reverse(),n=u;n--;t.push(0));t.reverse()}else for(o=((a=c.length<l.length)?c:l).length,u=n=0;o>n;n++)if(c[n]!=l[n]){a=c[n]<l[n];break}if(a&&(t=c,c=l,l=t,e.s=-e.s),(n=-((o=c.length)-l.length))>0)for(;n--;c[o++]=0);for(n=l.length;n>u;){if(c[--n]<l[n]){for(i=n;i&&!c[--i];c[i]=9);--c[i],c[n]+=10}c[n]-=l[n]}for(;0==c[--o];c.pop());for(;0==c[0];c.shift(),--m);return(d>m||!c[0])&&(c[0]||(e.s=3==h?-1:1),c=[m=0]),e.c=c,e.e=m,e},w.modulo=w.mod=function(e,n){var t=this,i=t.c,o=(N=9,e=new r(e,n)).c,a=t.s,s=e.s;return n=!a||!s||o&&!o[0],n||i&&!i[0]?new r(n?0/0:t):(t.s=e.s=1,n=1==e.cmp(t),t.s=a,e.s=s,n?new r(t):(a=p,s=h,p=0,h=1,t=t.div(e),p=a,h=s,this.minus(t.times(e))))},w.negated=w.neg=function(){var e=new r(this);return e.s=-e.s||null,e},w.plus=function(e,n){var t,i=this,o=i.s;if(n=(N=10,e=new r(e,n)).s,!o||!n)return new r(0/0);if(o!=n)return e.s=-n,i.minus(e);var a=i.e,s=i.c,u=e.e,c=e.c;if(!a||!u){if(!s||!c)return new r(o/0);if(!s[0]||!c[0])return c[0]?e:new r(s[0]?i:0*o)}if(s=s.slice(),o=a-u){for(t=o>0?(u=a,c):(o=-o,s),t.reverse();o--;t.push(0));t.reverse()}for(s.length-c.length<0&&(t=c,c=s,s=t),o=c.length,n=0;o;n=(s[--o]=s[o]+c[o]+n)/10^0,s[o]%=10);for(n&&(s.unshift(n),++u>y&&(s=u=null)),o=s.length;0==s[--o];s.pop());return e.c=s,e.e=u,e},w.toPower=w.pow=function(e){var n=0*e==0?0|e:e,t=new r(this),o=new r(C);if(((f=-m>e||e>m)&&(n=1*e/0)||v(e)!=e&&0!==e&&!(n=0/0))&&!i(e,"exponent","pow")||!n)return new r(Math.pow(t.toS(),n));for(n=0>n?-n:n;1&n&&(o=o.times(t)),n>>=1,n;)t=t.times(t);return 0>e?C.div(o):o},w.round=function(e,n){return e=null==e||((f=0>e||e>l)||v(e)!=e)&&!i(e,"decimal places","round")?0:0|e,n=null==n||((f=0>n||n>8)||v(n)!=n&&0!==n)&&!i(n,"mode","round")?h:0|n,c(this,e,n)},w.squareRoot=w.sqrt=function(){var e,n,t,i,o=this,a=o.c,s=o.s,c=o.e,f=p,l=h,m=new r("0.5");if(1!==s||!a||!a[0])return new r(!s||0>s&&(!a||a[0])?0/0:a?o:1/0);for(s=Math.sqrt(o.toS()),h=1,0==s||s==1/0?(e=a.join(""),e.length+c&1||(e+="0"),n=new r(Math.sqrt(e)+""),n.c||(n.c=[1]),n.e=((c+1)/2|0)-(0>c||1&c)):n=new r(e=s.toString()),t=n.e,s=t+(p+=4),3>s&&(s=0),c=s;;)if(i=n,n=m.times(i.plus(o.div(i))),i.c.slice(0,s).join("")===n.c.slice(0,s).join("")){if(a=n.c,s-=e&&n.e<t,9!=a[s]||9!=a[s-1]||9!=a[s-2]||!(9==a[s-3]||e&&4==a[s-3])){if(!(a[c]||a[c-1]||a[c-2]||a[c-3]&&5!=a[c-3]||(a.length>c-2&&(a.length=c-2),n.times(n).eq(o)))){for(;a.length<c-3;)a.push(0);a[c-3]++}return h=l,u(n,p=f,10),n}if(e&&9==a[s-3]&&(i=n.round(f,0),i.times(i).eq(o)))return h=l,p=f,i;p+=4,s+=4,e=""}},w.times=function(e,n){var t,i=this,o=i.c,a=(N=11,e=new r(e,n)).c,s=i.e,u=e.e,c=i.s;if(e.s=c==(n=e.s)?1:-1,!((s||o&&o[0])&&(u||a&&a[0])))return new r(!c||!n||o&&!o[0]&&!a||a&&!a[0]&&!o?0/0:o&&a?0*e.s:e.s/0);for(e.e=s+u,(c=o.length)<(n=a.length)&&(t=o,o=a,a=t,u=c,c=n,n=u),u=c+n,t=[];u--;t.push(0));for(s=n-1;s>-1;s--){for(n=0,u=c+s;u>s;n=t[u]+a[s]*o[u-s-1]+n,t[u--]=n%10|0,n=n/10|0);n&&(t[u]=(t[u]+n)%10)}for(n&&++e.e,!t[0]&&t.shift(),u=t.length;!t[--u];t.pop());return e.c=e.e>y?e.e=null:e.e<d?[e.e=0]:t,e},w.toExponential=w.toE=function(e){return s(this,(null==e||((f=0>e||e>l)||v(e)!=e&&0!==e)&&!i(e,"decimal places","toE"))&&this.c?this.c.length-1:0|e,1)},w.toFixed=w.toF=function(e){var n,t,r,o=this;return null==e||((f=0>e||e>l)||v(e)!=e&&0!==e)&&!i(e,"decimal places","toF")||(r=o.e+(0|e)),n=g,e=x,g=-(x=1/0),r==t?t=o.toS():(t=s(o,r),o.s<0&&o.c&&(o.c[0]?t.indexOf("-")<0&&(t="-"+t):t=t.replace(/^-/,""))),g=n,x=e,t},w.toFraction=w.toFr=function(e){var n,t,o,a,s,u,c,l=a=new r(C),m=o=new r("0"),g=this,x=g.c,d=y,v=p,w=h,E=new r(C);if(!x)return g.toS();for(c=E.e=x.length-g.e-1,(null==e||(!(N=12,u=new r(e)).s||(f=u.cmp(l)<0||!u.c)||b&&u.e<u.c.length-1)&&!i(e,"max denominator","toFr")||(e=u).cmp(E)>0)&&(e=c>0?E:l),y=1/0,u=new r(x.join("")),p=0,h=1;n=u.div(E),s=a.plus(n.times(m)),1!=s.cmp(e);)a=m,m=s,l=o.plus(n.times(s=l)),o=s,E=u.minus(n.times(s=E)),u=s;return s=e.minus(a).div(m),o=o.plus(s.times(l)),a=a.plus(s.times(m)),o.s=l.s=g.s,p=2*c,h=w,t=l.div(m).minus(g).abs().cmp(o.div(a).minus(g).abs())<1?[l.toS(),m.toS()]:[o.toS(),a.toS()],y=d,p=v,t},w.toPrecision=w.toP=function(e){return null==e||((f=1>e||e>l)||v(e)!=e)&&!i(e,"precision","toP")?this.toS():s(this,0|--e,2)},w.toString=w.toS=function(e){var n,t,r,a=this,u=a.e;if(null===u)t=a.s?"Infinity":"NaN";else{if(e===n&&(g>=u||u>=x))return s(a,a.c.length-1,1);if(t=a.c.join(""),0>u){for(;++u;t="0"+t);t="0."+t}else if(r=t.length,u>0)if(++u>r)for(u-=r;u--;t+="0");else r>u&&(t=t.slice(0,u)+"."+t.slice(u));else if(n=t.charAt(0),r>1)t=n+"."+t.slice(1);else if("0"==n)return n;if(null!=e)if((f=!(e>=2&&65>e))||e!=(0|e)&&b)i(e,"base","toS");else if(t=o(t,0|e,10,a.s),"0"==t)return t}return a.s<0?"-"+t:t},w.valueOf=function(){return this.toS()},"undefined"!=typeof t&&t.exports?t.exports=r:"function"==typeof e&&e.amd?e(function(){return r}):n.BigNumber=r}(this)},{}]},{},[1])(1)});