<?php

/*******************************************************
  Class: length.php
  Author: Brian Rock (SlowWalkere@gmail.com)
  Website: www.earn-web-cash.com
  Version: 0.5
  
  Description:  Length is a class to help standardize measurements and convert
    from one system of measurement or one unit of measurement to another.
  
  The class stores the length in SI units (meters) and allows you to retrieve
    the value converted to other units.  The units are defined in an xml data file.
    Some basic units are defined already (mm, cm, dm, m, d, in, ft, yds).  You can
    easily add new units by adding new entries to the length.xml file.
  
 *******************************************************/

/*******************************************************************
Copyright Info:

Copyright 2008, Brian Rock.

    This php script is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*******************************************************************/

class length {
	private $value;					//  Value of the length, in SI (meters)
	private static $conversions;	//  SimpleXML with unit info
	
	//  Uses the simpleXML object and finds the conversion ratio for a given $unit
	//  Returns null if there was an error and no ratio was retrieved
	public function getRatio ($unit) {
		//  Use xpath to get the relevant <unit> tag
		if ($result = $this->conversions->xpath("/length/unit[abbrev='$unit']")) {
			return (float) $result[0]->ratio;
		} else {
			return null;
		}
	}
	
	//  Uses the simpleXML object and finds the readable name for a given $unit
	//  Returns null if nothing was retrieved by the xpath search
	public function getName ($unit) {
		if ($result = $this->conversions->xpath("/length/unit[abbrev='$unit']")) {
			return $result[0]->fullName;
		} else {
			return null;
		}		
	}
	
	//  If $value is null, convert $this->value to $units
	//  Else convert $value from $units to meters
	public function getConversion($unit, $value = null) {
		//  Retrieve the conversion ratio from the xml object	
		$ratio = $this->getRatio($unit);
		
		if ($value === null) {
			return $this->value * $ratio;
		} else {
			return $value * (1 / $ratio);
		}
	}
	
	//  Make sure the 'length.xml' is in an accessibly location
	//  Otherwise, pass the path/filename to the class when creating a new instance
	public function __construct ($value, $unit = 'm', $filename = 'length.xml') {
		$this->conversions = simplexml_load_file($filename);	//  Build convert list
		$this->value = $this->getConversion($unit, $value);		//  Convert to si (m)
	}
}

?>