<?php
	//  Either autoload the class or be sure to include it in your common includes
	function __autoload($classname) {
		require_once($classname . ".php");
	}
	
	//  This is a simple example of how to use the length class.
	//  The information required to do the conversions is located in the
	//    length.xml file.  If you want to add new conversions to the script,
	//    all you have to do is edit length.xml.
	//
	//  For each new unit of measurement, add a <unit></unit> element.
	//    Within that element, create an <abbrev></abbrev> child element, with
	//    the standard abbreviation for your unit.  Create a <ratio></ratio>
	//    element for the # of your unit per one meter (i.e. 100 for cm).
	//    Lastly, a full name for the unit - i.e. yards, meters, etc.
	
	//  Create a new length instance
	//  First parameter - the value/length
	//  Second parameter - the units you're using (as defined in the xml file)
	//    If nothing is passed, the default unit is meters (m)
	//  Third parameter - the path/filename of the xml data file
	$len = new length(50, 'cm', 'length.xml');
	
	//  getConversion returns the converted value of the length you created.
	//  You can pass to it any unit type defined in the xml data file.
	//  You can also use $len->getName to get the readable name defined in the
	//    data file
	echo $len->getConversion('d') . 'd<br />';
	echo $len->getConversion('m') . 'm<br />';
	echo $len->getConversion('dm') . 'dm<br />';
	echo $len->getConversion('cm') . 'cm<br />';
	echo $len->getConversion('mm') . 'mm<br />';
	echo $len->getConversion('ft') . 'ft<br />';
	echo $len->getConversion('in') . 'in<br />';
	echo $len->getConversion('yd') . 'yd<br />';
?>