﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Mvc_Controls.Models
{
    public class Person
    {
        public int ID { get; set; }
        [Required]
        [Display(Name = "Full Name")]
        public string FullName { get; set; }
        [Required]
        public string Gender { get; set; }
        [Display(Name = "Date of Birth")]
        [DisplayFormat(DataFormatString = "{0:d}")]
        public DateTime DateOfBirth { get; set; }
        [Display(Name = "Is Married")]
        public bool IsMarried { get; set; }
        public string SpouseName { get; set; }
        [Required]
        [Display(Name = "Country")]
        public int Country { get; set; }
        [Required]
        [Display(Name = "State")]
        public int State { get; set; }
        [Required]
        [Display(Name = "City")]
        public int City { get; set; }
        [Required]
        public byte[] Photo { get; set; }
        public string Interest { get; set; }   
        public string Hobbies { get; set; }   
        //FOREIGN KEY constraint "FK_dbo.People_dbo.States_State_ID". 
        public virtual Country CountryV { get; set; }
        public virtual State StateV { get; set; }
        public virtual City CityV { get; set; }
    }
    public class PersonEntities : DbContext
    {
        public DbSet<Person> Persons { get; set; }
        public DbSet<Country> Countries { get; set; }
        public DbSet<State> States { get; set; }
        public DbSet<City> Cities { get; set; }
    }
    public class Country
    {
        public int ID { get; set; }
        [Required]
        [StringLength(30)]
        public string CountryName { get; set; }
    }
    public class State
    {
        public int ID { get; set; }
        [Required]
        public int CountryID { get; set; }
        [Required]
        public string StateName { get; set; }
    }
    public class City
    {
        public int ID { get; set; }
        [Required]
        public int StateID { get; set; }
        [Required]
        public string CityName { get; set; }
    }
}