﻿using Mvc_Controls.Models;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Helpers;
using System.Web.Mvc;

namespace Mvc_Controls.Controllers
{
    public class Controls_Controller : Controller
    {
        PersonEntities db = new PersonEntities();
        public ActionResult Index()
        {
            ViewBag.Header = "Welcome to MVC Cotrols! We are going to use Textbox, Dropdownlist, RadioButtonList, DateTime Calender, FileUpload," +
            "Cascading dropdownlist, Checkbox, Checkboxlist, Listbox, Image and Modalpopup in this demo application";
            var persons = db.Persons.ToList();
            ViewBag.Country = new SelectList(db.Countries, "ID", "CountryName");
            return View(persons);
        }

        public ActionResult Details(int id)
        {
            var person = db.Persons.Find(id);
            return View(person);
        }
        public FileContentResult getImg(int id)
        {
            byte[] byteArray = db.Persons.Find(id).Photo;
            if (byteArray != null)
            {
                return new FileContentResult(byteArray, "image/jpeg");
            }
            else
            {
                return null;
            }
        }

        public ActionResult Create()
        {
            //Make List of Gender 
            ViewBag.Gender = new SelectList(new List<SelectListItem> { 
            new SelectListItem{Text="Male",Value="Male"},
            new SelectListItem{Text="Female",Value="Female"}
            }, "Value", "Text");

            //Get list of Coutries to load on dropdownlist
            ViewBag.Country = new SelectList(db.Countries.ToList(), "ID", "CountryName", "ID");

            //Make list for Hobbies
            ViewBag.Hobbies = new List<string> { "Reading", "Singing", "Dancing", "Joking", "Cricket" };

            //Make list of Intrest
            ViewBag.Interest = new List<SelectListItem> { 
                new SelectListItem{Text="Pop-music",Value="Pop-music"},
                new SelectListItem{Text="Cinema",Value="Cinema"},
                new SelectListItem{Text="Swimming",Value="Swimming"},
                new SelectListItem{Text="Game",Value="Game"},
                new SelectListItem{Text="Cooking",Value="Cooking"}
            };
            return View();
        }
        [HttpPost]
        public ActionResult Create(FormCollection collection)
        {
            try
            {
                Person person = new Person();
                person.FullName = collection["FullName"].Replace(",", " ");
                person.Gender = collection["Gender"];
                person.DateOfBirth = Convert.ToDateTime(collection["DateOfBirth"]);
                person.IsMarried = Convert.ToBoolean(collection["IsMarried"].Split(',')[0]);
                person.SpouseName = collection["SpouseName"];
                person.Country = Convert.ToInt32(collection["Country"]);
                person.State = Convert.ToInt32(collection["State"]);
                person.City = Convert.ToInt32(collection["City"]);
                person.Photo = imageToByteArray(collection["Photo"]);
                person.Interest = collection["Interest"];
                person.Hobbies = collection["Hobbies"];
                //FOREIGN KEY constraint value set to Person Entities
                person.CountryV = db.Countries.Find(person.Country);
                person.StateV = db.States.Find(person.State);
                person.CityV = db.Cities.Find(person.City);
                //End of key settings
                db.Persons.Add(person);
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }
        public static byte[] imageToByteArray(string sPath)
        {
            try
            {
                System.Net.WebClient client = new System.Net.WebClient();
                byte[] imageData = client.DownloadData(sPath);
                System.IO.MemoryStream stream = new System.IO.MemoryStream(imageData);
                System.Drawing.Image img = System.Drawing.Image.FromStream(stream);
                MemoryStream ms = new MemoryStream();
                img.Save(ms, System.Drawing.Imaging.ImageFormat.Jpeg);
                return ms.ToArray();
            }
            catch (Exception) { return null; }
        }

        public ActionResult Edit(int id)
        {
            Person person = db.Persons.Find(id);
            //Make List of Gender 
            ViewBag.Gender = new SelectList(new List<SelectListItem> { 
            new SelectListItem{Text="Male",Value="Male"},
            new SelectListItem{Text="Female",Value="Female"}
            }, "Value", "Text");

            //Get list of Coutries to load on dropdownlist
            ViewBag.Country = new SelectList(db.Countries.ToList(), "ID", "CountryName", "ID");

            //Make list for Hobbies
            ViewBag.Hobbies = new List<string> { "Reading", "Singing", "Dancing", "Joking", "Cricket" };

            //Make list of Intrest
            ViewBag.Interest = new List<SelectListItem> { 
                new SelectListItem{Text="Pop-music",Value="Pop-music",Selected = person.Interest.Contains("Pop-music")},
                new SelectListItem{Text="Cinema",Value="Cinema",Selected = person.Interest.Contains("Cinema")},
                new SelectListItem{Text="Swimming",Value="Swimming",Selected=person.Interest.Contains("Swimming")},
                new SelectListItem{Text="Game",Value="Game",Selected=person.Interest.Contains("Game")},
                new SelectListItem{Text="Cooking",Value="Cooking",Selected=person.Interest.Contains("Cooking")}
            } as IEnumerable<SelectListItem>;
            return View(person);
        }
        [HttpPost]
        public ActionResult Edit(int id, FormCollection collection)
        {
            try
            {
                Person person = db.Persons.Find(id);
                person.FullName = collection["FullName"].Replace(",", " ");
                person.Gender = collection["Gender"];
                person.DateOfBirth = Convert.ToDateTime(collection["DateOfBirth"]);
                person.IsMarried = Convert.ToBoolean(collection["IsMarried"].Split(',')[0]);
                person.SpouseName = collection["SpouseName"];
                if (collection["Photo"] != "") person.Photo = imageToByteArray(collection["Photo"]);
                person.Hobbies = collection["Hobbies"];
                db.Entry(person).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }

        public ActionResult Delete(int id)
        {
            var person = db.Persons.Find(id);
            return View(person);
        }
        [HttpPost]
        public ActionResult Delete(int id, FormCollection collection)
        {
            try
            {
                Person person = db.Persons.Find(id);
                db.Persons.Remove(person);
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }



        #region Country, State, City ---> GET and POST Methods
        public ActionResult _Country()
        {
            return View();
        }
        [HttpPost]
        public ActionResult _Country(Country country)
        {
            if (ModelState.IsValid)
            {
                db.Countries.Add(country);
                db.SaveChanges();
            } return RedirectToAction("Create", "Controls_");
        }
        public ActionResult _State()
        {
            ViewBag.Country = new SelectList(db.Countries.ToList(), "ID", "CountryName", "ID");
            return View();
        }
        [HttpPost]
        public ActionResult _State(State state)
        {
            if (ModelState.IsValid)
            {
                db.States.Add(state);
                db.SaveChanges();
            }
            return RedirectToAction("Create", "Controls_");
        }
        public ActionResult _City()
        {
            ViewBag.States = new SelectList(db.States.ToList(), "ID", "StateName");
            return View();
        }
        [HttpPost]
        public ActionResult _City(City city)
        {
            if (ModelState.IsValid)
            {
                db.Cities.Add(city);
                db.SaveChanges();
            } return RedirectToAction("Create", "Controls_");
        }
        #endregion
        #region JQUERY METHODS
        public JsonResult GetCountry()
        {
            return Json(db.Countries.ToList(), JsonRequestBehavior.AllowGet);
        }
        public JsonResult GetStates(int id)
        {
            var states = db.States.Where(x => x.CountryID == id).ToList();
            return Json(states, JsonRequestBehavior.AllowGet);
        }
        public JsonResult GetCities(int id)
        {
            var city = db.Cities.Where(x => x.StateID == id).ToList();
            return Json(city, JsonRequestBehavior.AllowGet);
        }
        #endregion
    }
}
