﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.IO;
using System.Net;

/// <summary>
/// Recaptcha validation demo.
/// You must supply your own public/private recaptcha keys in the web.config
/// (you can get them at https://www.google.com/recaptcha/admin/create )
/// </summary>
public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        
    }

    // return your language code - used to localize recaptcha
    public string LanguageCode
    {
        get
        {
            return System.Threading.Thread.CurrentThread.CurrentUICulture.TwoLetterISOLanguageName;
        }
    }

    // submit button clicked
    protected void OnSubmit(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            Outcome.Text = "Success!";
        }
        else
        {
            Outcome.Text = "";
        }
    }

    // our custom server validator's validation method
    protected void OnRecaptchaValidate(object sender, ServerValidateEventArgs e)
    {
        string challenge = Request.Form["recaptcha_challenge_field"];
        string clientResponse = Request.Form["recaptcha_response_field"];

        reCaptchaValidation validator = 
            new reCaptchaValidation(
                        Config.Proxy,   // if you don't require a proxy to access the internet, just comment out this line.
                        Request.UserHostAddress, 
                        Config.PrivateKey, 
                        challenge, 
                        clientResponse);

        e.IsValid = validator.Validate();

        if (!e.IsValid)
        {
            if (validator.IsErrored)
            {
                // oh dear, something not right

                if (validator.Exception != null)    // an exception occured while trying to validate
                    Outcome.Text = validator.Exception.ToString();
                else if (validator.ValidationResult != null)  // the validation web service returned an error code (other than an invalid captcha solution)
                    Outcome.Text = "web service error: " + validator.ValidationResult;
            }
        }
    }
}
