﻿using System;
using System.Net;
using System.Collections.Generic;
using System.Web;
using System.Configuration;

/// <summary>
/// Get config file values
/// </summary>
public class Config
{
    public static string PublicKey
    {
        get {
            string pub = ConfigurationManager.AppSettings["recaptcha_public"];
            if(pub == null || pub.Trim().Length == 0)
                throw new ConfigurationException("Missing reCaptcha Public Key");

            return pub; 
        }
    }

    public static string PrivateKey
    {
        get {
            string priv = ConfigurationManager.AppSettings["recaptcha_private"];
            if (priv == null || priv.Trim().Length == 0)
                throw new ConfigurationException("Missing reCaptcha Private Key");


            return priv; 
        }
    }

    public static IWebProxy Proxy
    {
        get
        {
            string proxy = System.Configuration.ConfigurationManager.AppSettings["proxy"];
            if (proxy != null && proxy.Trim().Length > 0)
            {
                int port = int.Parse(System.Configuration.ConfigurationManager.AppSettings["proxyport"]);
                return new WebProxy(proxy, port);
            }
            return WebRequest.DefaultWebProxy;
        }
    }
}
