﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace MenusWithSitemap
{
    public partial class leftmenu : System.Web.UI.UserControl
    {
        public CustomerMain Customer { get; set; }
        public Admin Administrator { get; set; }

        protected void Page_Load(object sender, EventArgs e)
        {
Customer = Session["Customer"] as CustomerMain;
Administrator = Session["Admin"] as Admin;

if (Customer != null || Administrator != null)
{
    if (Customer != null)
        SiteMapDataSource1.SiteMapProvider = "sideProviderCustomer";
    else
        SiteMapDataSource1.SiteMapProvider = "sideProviderAdmin";
}
else
{
    SiteMapDataSource1.SiteMapProvider = "topProvider";

    //Find the node in web.sitemap file that corresponds to current page request
    SiteMapNode node = SiteMapDataSource1.Provider.FindSiteMapNodeFromKey(Page.Request.Path);

    //if the found node is a child node, set the StartingNodeOffset to 1 in order to bind menu from 1st node and not the node 0 i.e. parent
    if (node != null && !node.HasChildNodes && node.RootNode != node.ParentNode)
        SiteMapDataSource1.StartingNodeOffset = 1;
}

        }
    }
}