﻿#region Copyright (c) 2013 Raul Iloc
/*
{***************************************************************************}
{                                                                           }
{       Copyright (c) 2010  RAUL ILOC (rauliloc@yahoo.com)                  }
{       ALL RIGHTS RESERVED                                                 }
{                                                                           }
{   THE WORK IS PROVIDED UNDER THE TERMS OF THIS CODE PROJECT OPEN LICENSE. }
{   THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW.         }
{   ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE         }
{   OR COPYRIGHT LAW IS PROHIBITED.                                         }
{                                                                           }
{                                                                           }
{  BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HEREIN, YOU ACCEPT AND     }
{  AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. THE AUTHOR GRANTS YOU    }
{  THE RIGHTS CONTAINED HEREIN IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH  }
{  TERMS AND CONDITIONS. IF YOU DO NOT AGREE TO ACCEPT AND BE BOUND BY THE  }
{  TERMS OF THIS LICENSE, YOU CANNOT MAKE ANY USE OF THE WORK.              }
{                                                                           }
{***************************************************************************}
*/
#endregion Copyright (c) 2013 Raul Iloc
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.DataAnnotations;
using System.Collections;
using System.Web.Mvc;

namespace MvcBasic.Logic
{
    /// <summary>
    /// Defines the address entity.
    /// </summary>
    [MetadataType(typeof(AddressValidation))]
    public partial class Address
    {
        /// <summary>
        /// Gets the full name.
        /// </summary>
        /// <remarks>
        /// The full names means the first name and the last name.
        /// </remarks>
        public string FullName
        {
            get
            {
                return string.Format("{0} {1}", this.FirstName, this.LastName);
            }
        }

        /// <summary>
        /// Initializes a new instance of the Address class.
        /// </summary>
        public Address()
        {
            this.ID = 0;
        }
    }

    /// <summary>
    /// Defines the validation rules and messages for address entity.
    /// </summary>
    public class AddressValidation
    {
        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [DataType(DataType.Text)]
        [StringLength(50)]
        public string FirstName { get; set; }

        [DataType(DataType.Text)]
        [StringLength(50)]
        public string LastName { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [RegularExpression(@"([A-Za-zäöüÄÖÜßăîâșțĂÎÂȘȚ\.\\/ ])+", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationNumbersNotAllowed")]
        [DataType(DataType.Text)]
        [StringLength(100)]
        public string Town { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [DataType(DataType.Text)]
        [StringLength(200)]
        public string Street { get; set; }

        [RegularExpression(@"([0-9 \.\(\)/\\\-\+])+", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationLettersNotAllowed")]
        [DataType(DataType.PhoneNumber)]        
        [StringLength(25)]
        public string Phone { get; set; }

        [RegularExpression(@"([0-9 \.\(\)/\\\-\+])+", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationLettersNotAllowed")]
        [DataType(DataType.PhoneNumber)]
        [StringLength(25)]
        public string Fax { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [RegularExpression(@"(\d)+", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationLettersNotAllowed")]
        [DataType(DataType.Text)]
        [StringLength(25)]
        public string ZipCode { get; set; }
    }

    
}
