<?php
//
// +----------------------------------------------------------------------+
// | PHP Version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2003 The PHP Group                                |
// +----------------------------------------------------------------------+
// | This source file is subject to version 2.02 of the PHP license,      |
// | that is bundled with this package in the file LICENSE, and is        |
// | available at through the world-wide-web at                           |
// | http://www.php.net/license/2_02.txt.                                 |
// | If you did not receive a copy of the PHP license and are unable to   |
// | obtain it through the world-wide-web, please send a note to          |
// | license@php.net so we can mail you a copy immediately.               |
// +----------------------------------------------------------------------+
// | Author: Hatem Ben Yacoub <info@phptunisie.net>                       |
// +----------------------------------------------------------------------+
//
// $Id: DBConv.php,v 1.0.0 Sun Dec 05 2004 05:23:24 CET by hatem EXP $

/**
* DBConv class.  Convert SQL from oracle,mysql,mssql,sqlite and odbc to SQL compatible.
*
* @author  Ben Yacoub Hatem <info@phptunisie.net>
* @todo    
*          - testing
*          - documentations
*          - modules
*
*/
class DBConv
{
    // {{{ properties

    /**
     * @var  string  SQL data to convert
     */
    var $_data;
    
    /**
     * @var  string  Converted SQL data.
     */
    var $_newdata;
    

    /**
     * @var  string  SQL data type : Oracle,MySQL,MsSQL,SQLite,ODBC ...
     */
    var $_type;
    

    /**
     * @var  array  Replacments for each supported database.
     */
    var $_subst = array();
    
    // }}}
    // {{{ constructor
    
    /**
     * DBConv constructor
     *
     * @param mixed $type        Data source type
     *
     * @param mixed $source       Source data
     *
     * @access protected
     */
    function DBConv($type, $source )
    {
    	$this->init();
    	if (!array_key_exists($type,$this->_subst)) {
    		return false;
    	}
    	$this->_type = $type;
    	
    	clearstatcache();
    	if (is_file($source) or ereg("^http://",$source)) {
    		
    		$this->_data = implode('',@file($source));
    		
    	} elseif(trim($source)!="") {
    		$this->_data = $source;
    	}
    }
    
    // }}}
    // {{{ init()
    
    /**
     * Initialize the substitution array
     *
     * @access protected
     */
    function init(){
 		$this->_subst['mysql'] = array("int"=>"INTEGER","dec"=>"DECIMAL");
 		
 		$this->_subst['oracle'] = array(
 				"BFILE"=>"BLOB",
 				"CLOB"=>"TEXT",
 				"DATE"=>"DATETIME",
 				"LONG"=>"BIGINT",
 				"LONG RAW"=>"BIGINT",
 				"NCHAR"=>"CHAR",
 				"NCLOB"=>"TEXT",
 				"NUMBER"=>"DECIMAL",
 				"NVARCHAR2"=>"VARCHAR",
 				"RAW"=>"BLOB",
 				"VARCHAR2"=>"VARCHAR",
 				"DOUBLE PRECISION"=>"DECIMAL",
 				"\r\nLOGGING"=>"",
 				"\r\nNOCACHE"=>"",
 				"\r\nNOPARALLEL"=>"",
 				" BYTE"=>""
 			   );
		$this->_subst['odbc'] = array("LONGCHAR"=>"BLOB");
		
		$this->_subst['sqlite'] = array("INTEGER(10)"=>"INTEGER");
		
		$this->_subst['mssql'] = array(
				"nvarchar"=>"VARCHAR",
				"nchar"=>"CHAR",
				"int identity"=>"INTEGER",
				"ntext"=>"TEXT",
				"int"=>"INTEGER",
				"image"=>"LONGBLOB",
				"money"=>"FLOAT"
			    );
		return;
    }
    
    // }}}
    // {{{ convert()
    
    /**
     * Convert data to compatible SQL
     *
     * @param mixed $save_to       File name to save conversion results.
     *
     * @access public
     */
    function convert($save_to = ''){
    	
    	
		$replacements = $this->_subst[$this->_type];		   
		$rep = array_keys($replacements);
		$with = array_values($replacements);
		 			    
		$this->_newdata = str_replace($rep,$with, $this->_data);
		

		
		if (trim($save_to)!='') {
			
			// Try to create file if not exist
			if (!is_file($save_to)) {
				@touch($save_to);
			}
			
			// Try to save results
			if (is_writable($save_to)) {
				$handle = fopen($save_to, 'a');
				fwrite($handle, $this->_newdata);
				fclose($handle);
			} else {
    			Echo "Error : $save_to isn't writeable.<br>\n";
			}
		}
		
		return $this->_newdata;
    }
    // }}}    
}
?>