<?php
/*
this class will return the INFO for each SET
and all the emotioicons for each SET
and it will return the picture folder for the web and the server location

this class support the GAIM emoticons and soon also the phpBB set

v.1.0	- 2005-07-28
v.1.1	- 2005-07-29 - added the possibility to retrieve ONLY one set
					 - added the possibility to create an index.dat file with the lists of sets
v.1.1.1	- 2005-07-30 - added a function to retrieve only the headers of the sets
					 - minor fixing on the description for phpBB emoticons
v.1.2	- 2005-08-01 - added the possibility to have Yahoo! messenger emoticons
						just add the folder under 'sets', and add a file called 'yahoo' to that folder
v.1.2.1	- 2005-08-04 - corrected an error in the yahoo smiles creation
v.1.3	- 2005-08-04 - implemented the GET_SET function to return the pictures groupped
v.1.3.1 - 2005-08-04 - corrected a bug if the class is called more than once
						changed require_once to require
v.1.3.2 - 2005-08-04 - fixed the function that substitute the smiles
v.1.4	- 2005-08-08 - it will replace the icons form the "longests" to the "short" ones
v.1.4.1	- 2005-08-10 - added a function to retrieve the setn passing the code of the smiles
					   the code is: YAHOO: folder, gaim: folder_section, phpBB: pak_file_name
v.1.4.2 - 2005-08-10 - fixed a bug in the gaim import with the emoticons that contain [ and ]
v.1.4.3 - 2005-10-31 - create a parameter to set if the smiles are searched as text or as HTML
v.1.4.4 - 2005-12-27 - adapted to PHP 4 and PHP 5 to avoid E_STRICT errors.
v.1.4.5 - 2006-02-15 - added a new parameter to the set_smiles_html function
v.1.4.6 - 2006-03-18 - creation of a W3C links
v.1.4.7 - 2006-04-21 - removed description emotioicons in the tag ALT and TITLE
*/

if(phpversion()>=5){
	require_once realpath(dirname(__FILE__).'/php5x/'.basename(__FILE__));
}else{
	require_once realpath(dirname(__FILE__).'/php4x/'.basename(__FILE__));
}
class bib_smiles extends bib_smiles_vars{
	function bib_smiles(){
		$this->_set_folders();
	}

	function _set_folders(){
		$this->folder_set = 'sets/';
		$this->file_index = dirname(__FILE__).'/index.dat';
		$this->folder = dirname(__FILE__).'/'.$this->folder_set;
		$this->folder_web = str_replace($_SERVER['DOCUMENT_ROOT'],'',dirname(__FILE__).'/'.$this->folder_set);
	}

	function get_folder(){
		return $this->folder;
	}

	function get_folder_web(){
		return $this->folder_web;
	}

	function get_header_sets($setn = -1){
		if($setn!= -1){
			if(isset($this->sets[$setn])){
				$ret = array();
				foreach ($this->sets[$setn] AS $key=>$value){
					if($key!='sets')	$ret[$key] = $value;
				}
				return $ret;
			} else {
				return false;
			}
		} else {
			//return all the sets headers
			$ret = array();
			foreach($this->sets as $setn =>$v1){
				foreach ($this->sets[$setn] AS $key=>$value){
					if($key!='sets')	$ret[$setn][$key] = $value;
				}
			}
			return $ret;
		}
	}
	
	function set_smiles_html($html, $htmlspecialchars=true){
		//if $htmlspecialchars=='' means that I'll substitue with the htmlspecialchars, else I'll strip out only certain type of chars
		$this->smiles_html = (bool)$html;
		$this->smiles_html_htmlspecialchars = (bool)$htmlspecialchars;
//		var_dump($this->smiles_html, $this->smiles_html_htmlspecialchars);
	}

	function _strip_string($string){
		$search		= array('//','//','/</','/>/','//','//','//','//','//','//');
		$replace	= array('\'','\'','&lt;','&gt;','&aacute;','&ugrave;','&ograve;','&egrave;','&eacute;','&igrave;');
		$string		= preg_replace($search,$replace,$string);
//		$string		= (get_magic_quotes_gpc() == 0)	? addslashes($string) : $string;
		return $string;
	}
	
	function set_file_index($file_index){
		if(file_exists($file_index) && is_file($file_index) && is_writable($file_index)){
			$this->file_index = $file_index;
			return true;
		} elseif(is_writable(dirname($file_index))){
			$this->file_index = $file_index;
			return true;
		} else {
			return false;
		}
	}

	function create_index(){
		if(!isset($this->sets) || empty($this->sets)){
			$this->get_all_sets(true);
		}
		if(!$fp = @fopen($this->file_index,'wb')){
			die("please, create and set as writable the file ".$this->file_index);
		}
		$body = '<?php'."\n".'$sets = '.var_export($this->sets,true)."\n".'?>';
		fwrite($fp,$body);
		fclose($fp);
	}

	function get_set($setn, $group_pic=false){
		//this returns ONLY one set
		if(!isset($this->sets) || empty($this->sets)){
			$this->get_all_sets();
		}
		if(!is_numeric($setn)){
			$setn = $this->get_setn($setn);
		}
		if(isset($this->sets[$setn])){
			if(!$group_pic){
				return $this->sets[$setn];
			} else {
				return $this->_group_for_pic($this->sets[$setn]);
			}
		} else {
			return false;
		}
	}
	function _group_for_pic($set){
		$pic = array();
		foreach($set['smiles'] as $key=>$value){
			if(!isset($pic[$set['smiles'][$key]['pic']])){
				$pic[$set['smiles'][$key]['pic']]['key'] = $key;
				$pic[$set['smiles'][$key]['pic']]['desc'] = $set['smiles'][$key]['desc'];
			}
		}
		$new_set = $set;
		$new_set['smiles'] = array();
		foreach($pic as $key=>$value){
			$new_set['smiles'][$pic[$key]['key']]['pic'] = $key;
			$new_set['smiles'][$pic[$key]['key']]['desc'] = $pic[$key]['desc'];
		}
		return $new_set;
	}

	function get_all_sets($force = false){
		//I need to create an INDEX, and store everything there
		//this will save time with some kind of emoticons
		//and a function that force the creation
		if($force == false && file_exists($this->file_index) && is_readable($this->file_index)){
			require $this->file_index;	//this file create a variable called $sets
			$this->sets = $sets;
		} else {
			$path = $this->get_folder();
			// Open the folder
			$dir_handle = opendir($path);
			$ret = array();
			if($dir_handle){
				// Loop through the files
				while ($file = readdir($dir_handle)) {
					if($file != "." && $file != ".." && is_dir($path.$file)){
						$this->_add_set($path.$file);
					}
				}
				closedir($dir_handle);						
			}
		}
		return $this->sets;
	}

	function get_list_sets($force = false){
		//this is an alias of get_all_sets();
		return $this->get_all_sets($force);
	}
	
	function _add_set($folder){
		//check for GAIM type of sets
		if(file_exists($folder.'/theme')){
			//the file exist, I need to parse it to add the sets to the list of sets
			$this->_parse_gaim($folder.'/theme', str_replace($this->get_folder(),'',$folder));
		}elseif(file_exists($folder.'/yahoo')){
			//the file exist, I need to parse it to add the sets to the list of sets
			$this->_parse_yahoo($folder, str_replace($this->get_folder(),'',$folder));
		}else{
			//check for other type of smiles
			//phpBB has a file with extension .pak
			//to find it I have to parse te WHOLE folder, crazy but is the only way
			$dir_handle = opendir($folder);
			$ret = array();
			if($dir_handle){
				// Loop through the files
				while ($file = readdir($dir_handle)) {
					if(strtolower(substr($file,-4))=='.pak'){
						$this->_parse_phpBB($folder.'/'.$file, str_replace($this->get_folder(),'',$folder));
						//I don't stop here, there can be more than one
					}
				}
				closedir($dir_handle);						
			}
		}
	}
	function _parse_yahoo($folder_smiles, $folder){
		//here I parse the icons for yahoo
		//and I set for each set the necessary info
		$count = count($this->sets);
		$ret = pathinfo($file);
		$this->sets[$count]['code']			= $folder;
		$this->sets[$count]['folder']		= $folder;
		$this->sets[$count]['name']			= substr($ret['basename'],0,-4);
		$this->sets[$count]['description']	= $ret['basename'];
		$this->sets[$count]['icon']			= '';
		$this->sets[$count]['author']		= '';
		$this->sets[$count]['smiles']		= array();
		$this->sets[$count]['type']			= 'Yahoo!';
		$dir_handle = opendir($folder);
		$ret = array();
		if($dir_handle){
			// Loop through the files
			while ($file = readdir($dir_handle)) {
				$key = array();
				switch(strtolower($file)){
					case '1.gif':	$key = array(':)'=>'smile',':-)'=>'smile');						break;
					case '2.gif':	$key = array(':('=>'sad',':-('=>'sad');							break;
					case '3.gif':	$key = array(';)'=>'winking',';-)'=>'winking');					break;
					case '4.gif':	$key = array(':D'=>'big grin',':-D'=>'big grin');				break;
					case '5.gif':	$key = array(';;)','batting eyelashes');						break;
					case '6.gif':	$key = array('>:D<','big hug');									break;
					case '7.gif':	$key = array(':-/'=>'confused');								break;
					case '8.gif':	$key = array(':x'=>'love struck',':-x'=>'love struck');			break;
					case '9.gif':	$key = array(':">'=>'blushing');								break;
					case '10.gif':	$key = array(':P'=>'tongue',':-P'=>'tongue');					break;
					case '11.gif':	$key = array(':*'=>'kiss',':-*'=>'kiss');						break;
					case '12.gif':	$key = array('=(('=>'broken heart');							break;
					case '13.gif':	$key = array(':o'=>'surprise',':-o'=>'surprise');				break;
					case '14.gif':	$key = array(':X'=>'angry',':-X'=>'angry');						break;
					case '15.gif':	$key = array(':>'=>'smug',':->'=>'smug');						break;
					case '16.gif':	$key = array('B-)'=>'cool');									break;
					case '17.gif':	$key = array(':-S'=>'worried');									break;
					case '18.gif':	$key = array('#:-S'=>'whew!');									break;
					case '19.gif':	$key = array('>:)'=>'devil','>:-)'=>'devil');					break;
					case '20.gif':	$key = array(':(('=>'crying',':-(('=>'crying');					break;
					case '21.gif':	$key = array(':))'=>'laughing',':-))'=>'laughing');				break;
					case '22.gif':	$key = array(':|'=>'straight face',':-|'=>'straight face');		break;
					case '23.gif':	$key = array('/:)'=>'raised eyebrow','/:-)'=>'raised eyebrow');	break;
					case '24.gif':	$key = array('=))'=>'rolling on the floor');					break;
					case '25.gif':	$key = array('O:)'=>'angel','O:-)'=>'angel');					break;
					case '26.gif':	$key = array(':-B'=>'nerd');									break;
					case '27.gif':	$key = array('=;'=>'talk to the hand');							break;
					case '28.gif':	$key = array('l-|'=>'sleepy');									break;
					case '29.gif':	$key = array('8-|'=>'rolling eyes');							break;
					case '30.gif':	$key = array('L-)'=>'loser');									break;
					case '31.gif':	$key = array(':-&'=>'sick');									break;
					case '32.gif':	$key = array(':-$'=>'don\'t tell anyone');						break;
					case '33.gif':	$key = array('[-)'=>'not talking');								break;
					case '34.gif':	$key = array(':o)'=>'clown');									break;
					case '35.gif':	$key = array('8-}'=>'silly');									break;
					case '36.gif':	$key = array('<:-P'=>'party');									break;
					case '37.gif':	$key = array('(:|'=>'yawn');									break;
					case '38.gif':	$key = array('=P~'=>'drooling');								break;
					case '39.gif':	$key = array(':-?'=>'thinking');								break;
					case '40.gif':	$key = array('#-o'=>'d\'oh');									break;
					case '41.gif':	$key = array('=D>'=>'applause');								break;
					case '42.gif':	$key = array(':-SS'=>'nailbiting');								break;
					case '43.gif':	$key = array('@-)'=>'hypnotized');								break;
					case '44.gif':	$key = array(':^)'=>'liar');									break;
					case '45.gif':	$key = array(':-w'=>'waiting');									break;
					case '46.gif':	$key = array(':-<'=>'sigh');									break;
					case '47.gif':	$key = array('>:p'=>'phbbbbt','>:-P'=>'phbbbbt');				break;
					case '48.gif':	$key = array('<):)'=>'cowboy','<):-)'=>'cowboy');				break;

					case '49.gif':	$key = array(':@)'=>'pig');										break;
					case '50.gif':	$key = array('3:-o'=>'cow');									break;
					case '51.gif':	$key = array(':(|)'=>'monkey');									break;
					case '52.gif':	$key = array('!:>'=>'chicken');									break;
					case '53.gif':	$key = array('@};-'=>'rose');									break;
					case '54.gif':	$key = array('%%-'=>'good luck');								break;
					case '55.gif':	$key = array('**=='=>'flag');									break;
					case '56.gif':	$key = array('(~~)'=>'pumpking');								break;
					case '57.gif':	$key = array('~o)'=>'coffee');									break;
					case '58.gif':	$key = array('*-:)'=>'idea');									break;
					case '59.gif':	$key = array('8-X'=>'skull');									break;
					case '60.gif':	$key = array('=:)'=>'bug');										break;
					case '61.gif':	$key = array('>-)'=>'alien');									break;
					case '62.gif':	$key = array(':-L'=>'frustrated');								break;
					case '63.gif':	$key = array('[-o<'=>'praying');								break;
					case '64.gif':	$key = array('$-)'=>'money');									break;
					case '65.gif':	$key = array(':-"'=>'whistling');								break;
					case '66.gif':	$key = array('B-('=>'feeling beat up');							break;
					case '67.gif':	$key = array(':)>-'=>'peace sign');								break;
					case '68.gif':	$key = array('[-X'=>'shame on you');							break;
					case '69.gif':	$key = array('\:D/'=>'dancing');								break;
					case '70.gif':	$key = array('>:/'=>'bring it on');								break;
					case '71.gif':	$key = array(';))'=>'hee hee');									break;
					case '72.gif':	$key = array('o->'=>'Hiro'); 									break;
					case '73.gif':	$key = array('o+>'=>'Billy'); 									break;
					case '74.gif':	$key = array('o-+'=>'April'); 									break;
					case '75.gif':	$key = array('(%)'=>'Ying Yang'); 								break;
					case '76.gif':	$key = array(':-@'=>'chatterbox');								break;
					case '77.gif':	$key = array('^:)^'=>'not worthy');								break;
					case '78.gif':	$key = array(':-j'=>'oh go on');								break;
					case '79.gif':	$key = array('(*)'=>'star');									break;
				}
				if(!empty($key)){
					foreach($key as $k1 => $value){
						$this->sets[$count]['smiles'][strtolower($k1)]['pic']	= $folder.'/'.$file;
						$this->sets[$count]['smiles'][strtolower($k1)]['desc']	= ($value=='' || $k1==$value)?$k1:$value.' - '.$key;
					}
				}
			}
			closedir($dir_handle);						
		}
	}
	function _parse_phpBB($file, $folder){
		//here I parse the '.pak' file from the phpBB set
		//and I set for each set the necessary info
		$set = file($file);
		$count = count($this->sets);
		$ret = pathinfo($file);
		$this->sets[$count]['code']			= substr($ret['basename'],0,-4);
		$this->sets[$count]['folder']		= $folder;
		$this->sets[$count]['name']			= substr($ret['basename'],0,-4);
		$this->sets[$count]['description']	= $ret['basename'];
		$this->sets[$count]['icon']			= '';
		$this->sets[$count]['author']		= '';
		$this->sets[$count]['smiles']		= array();
		$this->sets[$count]['type']			= 'phpBB';
		foreach($set as $key=>$line){
			$m = explode('=+:',$line,3);
			$m1 = explode(' ',$m[2]);
			foreach($m1 as $key1=>$value){
				$value = trim($value);
				if($value!=''){
					$this->sets[$count]['smiles'][strtolower($value)]['pic']	= $folder.'/'.$m[0];
					$this->sets[$count]['smiles'][strtolower($value)]['desc']	= ($m[1]=='' || $m[1]==$value)?$value:$m[1].' - '.$value;
				}
			}
		}		
	}
	function _parse_gaim($file, $folder){
		//here I parse the 'theme' file from the GAIM set
		//and I set for each messenger the necessary info
		$set = file($file);
		foreach($set as $key=>$line){
			if(strtolower(substr($line,0,5))=='name=')				$name = trim(substr($line,5));
			elseif(strtolower(substr($line,0,12))=='description=')	$description = trim(substr($line,12));
			elseif(strtolower(substr($line,0,5))=='icon=')			$icon = trim(substr($line,5));
			elseif(strtolower(substr($line,0,7))=='author=')		$author = trim(substr($line,7));
			elseif(preg_match('/^\[(.*?)\]/', $line, $m)){
				//found a SET
				$count = count($this->sets);
				$this->sets[$count]['code']			= $folder.(strtolower($m[1])!='default'?'_'.strtolower($m[1]):'');
				$this->sets[$count]['folder']		= $folder;
				$this->sets[$count]['name']			= $name.' ['.$m[1].']';
				$this->sets[$count]['description']	= $description;
				$this->sets[$count]['icon']			= $icon;
				$this->sets[$count]['author']		= $author;
				$this->sets[$count]['smiles']		= array();
				$this->sets[$count]['type']			= 'gaim';
			}elseif(trim($line)!='' && substr($line,0,1)!='#'){
				$hidden = false;
				if(substr($line,0,1)=='!'){
					//hidden icons
					$hidden = true;
					$line = trim(substr($line,1));
				}
				if(preg_match('/([\w\.\w]+)\W(.*)/',$line,$m)){
					$pic = $m[1];
					if(file_exists($this->get_folder().$folder.'/'.$pic)){
						$m[2] = str_replace(array("\t",'  '),' ',trim($m[2]));
						$m1 = explode(' ',$m[2]);
						foreach($m1 as $key=>$value){
							$value = trim($value);
							if($value!=''){
								$this->sets[$count]['smiles'][strtolower($value)]['pic']	= $folder.'/'.$pic;
								$this->sets[$count]['smiles'][strtolower($value)]['desc']	= strtolower($value);
							}
						}
					}
				}
			}			
		}		
	}
	
	function get_setn($code){
		if(!isset($this->sets) || empty($this->sets)){
			$this->get_all_sets();
		}
		foreach($this->sets as $setn =>$v1){
			if(strtolower($this->sets[$setn]['code']) == strtolower($code)){
				return $setn;
			}
		}
		return false;
	}
	
	//	Use Smiles (replace :), :P, et.c with images)
	//	@public
	//	return string
	function smiles($string, $setn=NULL){
		$string = ' '.$string.' ';
		$set = $this->get_set($setn);
		uksort($set['smiles'],array($this,'_order_by_length'));
		if($set!==false){
			foreach($set['smiles'] as $key=>$value){
				$theSmile	= $key;
				if($this->smiles_html){
					if($this->smiles_html_htmlspecialchars){
						$theSmile = htmlspecialchars($theSmile,ENT_QUOTES);
					} else {
						$theSmile = $this->_strip_string($theSmile);
					}
				}
//				$theSmile	= str_replace('"', '\"', $theSmile);
				$theSmile	= preg_quote($theSmile,'/');
				$orig[] = '/'.$theSmile.'/si';
//				$repl[] = '\1<img src="'.$this->get_folder_web().$set['smiles'][$key]['pic'].'" alt="'.htmlspecialchars($set['smiles'][$key]['desc']).'" title="'.htmlspecialchars($set['smiles'][$key]['desc']).'" border="0" />\2';
				$repl[] = '<img src="'.$this->get_folder_web().$set['smiles'][$key]['pic'].'" alt="" title="" border="0" />';
			}
			$message	= preg_replace($orig, $repl, $string);
		}
		return $message;
	}
	
	function _order_by_length($a, $b){
		if(strlen($a) == strlen($b)){
			return 0;
		}
		return (strlen($a) > strlen($b)) ? -1 : 1;
	}
}
?>