﻿using System;
using System.Drawing;
using System.Globalization;
using MapAround.Geometry;

namespace WebExample.Map
{
    public class QueryStringDataExtractor
    {
        public static BoundingRectangle GetBBox(string bboxStr)
        {
            if (string.IsNullOrEmpty(bboxStr))
                throw new Exception("Empty bbox");

            double x1 = 0;
            double y1 = 0;
            double x2 = 0;
            double y2 = 0;
            string[] points = bboxStr.Split(',');
            if (
                points.Length < 4
                ||
                !double.TryParse(points[0], NumberStyles.Any, CultureInfo.InvariantCulture, out x1)
                ||
                !double.TryParse(points[1], NumberStyles.Any, CultureInfo.InvariantCulture, out y1)
                ||
                !double.TryParse(points[2], NumberStyles.Any, CultureInfo.InvariantCulture, out x2)
                ||
                !double.TryParse(points[3], NumberStyles.Any, CultureInfo.InvariantCulture, out y2)
                )
                throw new Exception("bbox = \"" + bboxStr + "\"");

            return new BoundingRectangle(Math.Min(x1, x2), Math.Min(y1, y2), Math.Max(x1, x2), Math.Max(y1, y2));
        }

        public static Size GetDisplaySize(string wStr, string hStr)
        {
            if (string.IsNullOrEmpty(wStr))
                throw new Exception("Empty display map width");

            if (string.IsNullOrEmpty(hStr))
                throw new Exception("Empty display map height");

            int w = 0;
            int h = 0;

            if (
                !int.TryParse(wStr, out w)
                ||
                !int.TryParse(hStr, out h)
                )
                throw new NotImplementedException();

            return new Size(w, h);
        }
    }
}