/*
 *  jQuery Github - v0.3.2
 *  A jQuery plugin to display your Github Repositories.
 *  https://github.com/zenorocha/jquery-github/
 *
 *  Copyright (c) 2013
 *  MIT License
 */
function GithubRepo(s){this.description=s.description,this.forks=s.forks,this.name=s.name,this.open_issues=s.open_issues,this.pushed_at=s.pushed_at,this.url=s.url,this.watchers=s.watchers}function Github(s,t){var e=this,o={iconStars:!0,iconForks:!0,iconIssues:!1};e.element=s,e.$container=$(s),e.repo=e.$container.attr("data-repo"),e.options=$.extend({},o,t),e._defaults=o,e.init(),e.displayIcons()}GithubRepo.prototype.toHTML=function(){var s=this;return s.pushed_at=s._parsePushedDate(s.pushed_at),s.url=s._parseURL(s.url),$("<div class='github-box'><div class='github-box-header'><h3><a href='"+s.url+"'>"+s.name+"</a>"+"</h3>"+"<div class='github-stats'>"+"<a class='repo-stars' title='Stars' data-icon='7' href='"+s.url+"/watchers'>"+s.watchers+"</a>"+"<a class='repo-forks' title='Forks' data-icon='f' href='"+s.url+"/network'>"+s.forks+"</a>"+"<a class='repo-issues' title='Issues' data-icon='i' href='"+s.url+"/issues'>"+s.open_issues+"</a>"+"</div>"+"</div>"+"<div class='github-box-content'>"+"<p>"+s.description+" &mdash; <a href='"+s.url+"#readme'>Read More</a></p>"+"</div>"+"<div class='github-box-download'>"+"<p class='repo-update'>Latest commit to <strong>master</strong> on "+s.pushed_at+"</p>"+"<a class='repo-download' title='Download as zip' data-icon='w' href='"+s.url+"/zipball/master'></a>"+"</div>"+"</div>")},GithubRepo.prototype._parsePushedDate=function(s){var t=new Date(s);return t.getDate()+"/"+(t.getMonth()+1)+"/"+t.getFullYear()},GithubRepo.prototype._parseURL=function(s){return s.replace("api.","").replace("repos/","")},Github.prototype.init=function(){var s=this,t=s.getCache();null!==t?s.applyTemplate(JSON.parse(t)):s.requestData(s.repo)},Github.prototype.displayIcons=function(){$iconStars=$(".repo-stars"),$iconForks=$(".repo-forks"),$iconIssues=$(".repo-issues"),this.options.iconStars?$iconStars.css("display","inline-block"):$iconStars.css("display","none"),this.options.iconForks?$iconForks.css("display","inline-block"):$iconForks.css("display","none"),this.options.iconIssues?$iconIssues.css("display","inline-block"):$iconIssues.css("display","none")},Github.prototype.requestData=function(s){var t=this;$.ajax({url:"https://api.github.com/repos/"+s,dataType:"jsonp",success:function(s){var e=s.data;s.meta.status>=400&&e.message?t.handleErrorRequest(e):t.handleSuccessfulRequest(e)}})},Github.prototype.handleErrorRequest=function(s){console.warn(s.message)},Github.prototype.handleSuccessfulRequest=function(s){var t=this;t.applyTemplate(s),t.setCache(s)},Github.prototype.setCache=function(s){var t=this;window.sessionStorage&&window.sessionStorage.setItem("gh-repos:"+t.repo,JSON.stringify(s))},Github.prototype.getCache=function(){var s=this;return window.sessionStorage?window.sessionStorage.getItem("gh-repos:"+s.repo):!1},Github.prototype.applyTemplate=function(s){var t=this,e=new GithubRepo(s),o=e.toHTML();o.appendTo(t.$container)},function(s){s.fn.github=function(t){return this.each(function(){s(this).data("plugin_github")||s(this).data("plugin_github",new Github(this,t))})}}(window.jQuery||window.Zepto,window);