﻿using MvcSchedule.Data;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

namespace MvcSchedule.Objects
{

    /// <summary>
    /// Represents a cell in a ScheduleTable.
    /// </summary>
    internal class ScheduleTableCell
    {

        private string _text;
        public string Text
        {
            get { return _text; }
            set { _text = value; }
        }

        private bool _isHeader = false;
        public bool IsHeader
        {
            get { return _isHeader; }
            set { _isHeader = value; }
        }

        private string _cssClass;
        public string CssClass
        {
            get { return _cssClass; }
            set { _cssClass = value; }
        }

        private bool? _borderLeft;
        public bool? BorderLeft
        {
            get { return _borderLeft; }
            set { _borderLeft = value; }
        }

        private bool? _borderRight;
        public bool? BorderRight
        {
            get { return _borderRight; }
            set { _borderRight = value; }
        }

        private bool? _borderTop;
        public bool? BorderTop
        {
            get { return _borderTop; }
            set { _borderTop = value; }
        }

        private bool? _borderBottom;
        public bool? BorderBottom
        {
            get { return _borderBottom; }
            set { _borderBottom = value; }
        }

        private int _rowSpan = 1;
        public int RowSpan
        {
            get { return _rowSpan; }
            set { _rowSpan = value; }
        }

        private int _columnSpan = 1;
        public int ColumnSpan
        {
            get { return _columnSpan; }
            set { _columnSpan = value; }
        }

        private bool _visible = true;
        public bool Visible
        {
            get { return _visible; }
            set { _visible = value; }
        }

        private int _titleIndex = -1;
        public int TitleIndex
        {
            get { return _titleIndex; }
            set { _titleIndex = value; }
        }

        private int _valueIndex = -1;
        public int ValueIndex
        {
            get { return _valueIndex; }
            set { _valueIndex = value; }
        }

        private object _data;
        public object Data
        {
            get { return _data; }
            set { _data = value; }
        }

        private Nullable<ScheduleItemType> _itemType;
        public Nullable<ScheduleItemType> ItemType
        {
            get { return _itemType; }
            set { _itemType = value; }
        }

    }

}

