﻿using MvcSchedule.Data;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.ComponentModel;

namespace MvcSchedule.Objects
{

	/// <summary>
	/// Comparer class for the ScheduleGeneral control.
	/// </summary>
    class ScheduleGeneralComparer<TItem> : IComparer<ScheduleItemData<TItem>>
	{

		public ScheduleGeneralComparer()
		{
		}

        public int Compare(ScheduleItemData<TItem> x, ScheduleItemData<TItem> y)
		{
			IComparable xTitleValue = x.TitleValue as IComparable;
			if (xTitleValue == null)
				return 0;
			// when titles are not comparable, they're considered all equal
			IComparable yTitleValue = y.TitleValue as IComparable;
			if (yTitleValue == null)
				return 0;
			if (!xTitleValue.Equals(yTitleValue)) {
				return xTitleValue.CompareTo(yTitleValue);
			}
			IComparable xStartValue = x.StartValue as IComparable;
			IComparable yStartValue = y.StartValue as IComparable;
			if (ShouldCompareNulls(xStartValue, yStartValue)) {
				return CompareNulls(xStartValue, yStartValue);
			}
			if (!xStartValue.Equals(yStartValue)) {
				return xStartValue.CompareTo(yStartValue);
			}
			if (ShouldCompareNulls(x.EndValue, y.EndValue)) {
				return CompareNulls(x.EndValue, y.EndValue);
			}
			return ((IComparable)x.EndValue).CompareTo((IComparable)y.EndValue);
		}

		private int CompareNulls(object x, object y)
		{
			if (x == null && y != null)	return -1;
			if (x != null && y == null)	return 1;
			if (x == null && y == null)	return 0;
			if ((x is DBNull) && !(y is DBNull)) return -1;
			if (!(x is DBNull) && (y is DBNull)) return 1;
			if ((x is DBNull) && (y is DBNull))	return 0;
            return 0; // shouldn't happen
		}

		private bool ShouldCompareNulls(object x, object y)
		{
			if (x == null) return true;
			if (y == null) return true;
			if (x is DBNull) return true;
			if (y is DBNull) return true;
			return false;
		}

	}

}
