﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MvcSchedule.Objects
{

    /// <summary>
    /// Options for the MvcScheduleGeneral component
    /// </summary>
    public class MvcScheduleGeneralOptions : MvcScheduleOptions 
    {

        private bool _separateDateHeader = false;
        private string _titleDataFormatString = string.Empty;
        private string _rangeDataFormatString = string.Empty;
        private string _dateHeaderDataFormatString = string.Empty;
        private bool _autoSortTitles = true;

        /// -----------------------------------------------------------------------------
        /// <summary>
        /// When true, a separate header will be added for the date. 
        /// This requires DataRangeStartField and DataRangeEndField to be of type DateTime.
        /// </summary>
        /// -----------------------------------------------------------------------------
        [Description("When true, a separate header will be added for the date. This requires DataRangeStartField and DataRangeEndField to be of type DateTime.")]
        [DefaultValue(false)]
        [Category("Behavior")]
        public bool SeparateDateHeader
        {
            get { return _separateDateHeader; }
            set { _separateDateHeader = value; }
        }

        /// -----------------------------------------------------------------------------
        /// <summary>
        /// The format used for the title if the TitleTemplate is missing, e.g. {0:ddd d}
        /// </summary>
        /// -----------------------------------------------------------------------------
        [Description("The format used for the title if the TitleTemplate is missing, e.g. {0:ddd d}")]
        [DefaultValue("")]
        [Category("Data")]
        public string TitleDataFormatString
        {
            get { return _titleDataFormatString; }
            set { _titleDataFormatString = value; }
        }

        /// -----------------------------------------------------------------------------
        /// <summary>
        /// The format used for the ranges if the RangeHeaderTemplate is missing, e.g. {0:hh:mm}
        /// </summary>
        /// -----------------------------------------------------------------------------
        [Description("The format used for the ranges if the RangeHeaderTemplate is missing, e.g. {0:hh:mm}")]
        [DefaultValue("")]
        [Category("Data")]
        public string RangeDataFormatString
        {
            get { return _rangeDataFormatString; }
            set { _rangeDataFormatString = value; }
        }

        /// -----------------------------------------------------------------------------
        /// <summary>
        /// The format used for the date header if SeparateDateHeader=True and the DateHeaderTemplate is missing, e.g. {0:dd/MM}
        /// </summary>
        /// -----------------------------------------------------------------------------
        [Description("The format used for the date header if SeparateDateHeader=true and the DateHeaderTemplate is missing, e.g. {0:dd/MM}")]
        [DefaultValue("")]
        [Category("Data")]
        public string DateHeaderDataFormatString
        {
            get { return _dateHeaderDataFormatString; }
            set { _dateHeaderDataFormatString = value; }
        }

        /// -----------------------------------------------------------------------------
        /// <summary>
        /// When true, titles will automatically be sorted alphabetically. 
        /// When false, you may provide your own sorting order for the titles, but make sure 
        /// that the items with the same titles are grouped together, and that for each title, 
        /// the items are sorted on DataRangeStartField first and on DataRangeEndField next. 
        /// (for example: if you want to sort on a field called "SortOrder", the 
        /// DataRangeStartField is "StartTime", and the DataRangeEndField is "EndTime", 
        /// use the sorting expression "ORDER BY SortOrder ASC, StartTime ASC, EndTime ASC") 
        /// The default value for AutoSortTitles is true. 
        /// </summary>
        /// -----------------------------------------------------------------------------
        [Description("When true, titles will automatically be sorted alphabetically. When false, the data source should be sorted properly before binding.")]
        [DefaultValue(true)]
        [Category("Behavior")]
        public bool AutoSortTitles
        {
            get { return _autoSortTitles; }
            set { _autoSortTitles = value; }
        }

    }

}
