﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MvcSchedule.Objects
{

    /// <summary>
    /// Options for the MvcScheduleCalendar component
    /// </summary>
    public class MvcScheduleCalendarOptions : MvcScheduleOptions
    {

        private DateTime _startDate = DateTime.Today;
        private DayOfWeek _startDay = DayOfWeek.Monday;
        private int _numberOfDays = 7;
        private int _numberOfRepetitions = 1;
        private string _dateFormatString = string.Empty;
        private string _timeFormatString = string.Empty;
        private bool _timeExpressionsContainDate = false;

	    /// -----------------------------------------------------------------------------
	    /// <summary>
	    /// The first date to display. 
	    /// The calendar will start on this date, if not overridden by the 
	    /// StartDay and NumberOfDays settings.
	    /// The default value is the date at the time of display.
	    /// </summary>
	    /// -----------------------------------------------------------------------------
	    [Description("The first date to display. The calendar will start on this date, if not overridden by the StartDay and NumberOfDays settings.")]
        [Category("Behavior")]
        public DateTime StartDate
        {
            get { return _startDate; }
            set { _startDate = value; }
        }


        /// -----------------------------------------------------------------------------
        /// <summary>
        /// The first day of the week to display. 
        /// The calendar will start on this day of the week.
        /// This value is used only when NumberOfDays equals 7.
        /// The default is Monday.
        /// </summary>
        /// -----------------------------------------------------------------------------
        [Description("The first day of the week to display. The calendar will start on this day of the week. This value is used only when NumberOfDays equals 7.")]
        [DefaultValue(DayOfWeek.Monday)]
        [Category("Behavior")]
        public DayOfWeek StartDay
        {
            get { return _startDay; }
            set { _startDay = value; }
        }

	    /// -----------------------------------------------------------------------------
	    /// <summary>
	    /// The number of days to display. 
	    /// This number may be repeated multiple times in Vertical layout when the NumberOfRepetitions 
	    /// property is greater than 1.
	    /// De default value is 7 (weekly calendar).
	    /// </summary>
	    /// -----------------------------------------------------------------------------
	    [Description("The number of days to display. This number may be repeated multiple times in Vertical layout when the NumberOfRepetitions property is greater than 1.")]
        [DefaultValue(7)]
        [Category("Behavior")]
        public int NumberOfDays
        {
            get { return _numberOfDays; }
            set { _numberOfDays = value; }
        }


	    /// -----------------------------------------------------------------------------
	    /// <summary>
	    /// The number of repetitions to show at a time.
	    /// Especially useful if you want to show several weeks in the calendar, one
	    /// below the other.
	    /// This property replaces the Weeks property starting from version 1.6.1.
	    /// </summary>
	    /// -----------------------------------------------------------------------------
	    [Description("The number of repetitions to show at a time.")]
        [DefaultValue(1)]
        [Category("Behavior")]
        public int NumberOfRepetitions
        {
            get { return _numberOfRepetitions; }
            set { _numberOfRepetitions = value; }
        }


	    /// -----------------------------------------------------------------------------
	    /// <summary>
        /// The format used for the date if the DateDisplayExpression is missing, e.g. {0:ddd d}
	    /// </summary>
	    /// -----------------------------------------------------------------------------
	    [Description("The format used for the date if the DateExpression is missing, e.g. {0:ddd d}")]
        [DefaultValue("")]
        [Category("Data")]
        public string DateFormatString
        {
            get { return _dateFormatString; }
            set { _dateFormatString = value; }
        }

	    /// -----------------------------------------------------------------------------
	    /// <summary>
        /// The format used for the time if the TimeDisplayExpression is missing, e.g. {0:hh:mm}
	    /// </summary>
	    /// -----------------------------------------------------------------------------
	    [Description("The format used for the times if the TimeExpression is missing, e.g. {0:hh:mm}")]
        [DefaultValue("")]
        [Category("Data")]
        public string TimeFormatString
        {
            get { return _timeFormatString; }
            set { _timeFormatString = value; }
        }

	    /// -----------------------------------------------------------------------------
	    /// <summary>
        /// Indicates whether the time expressions (StartTimeExpression and EndTimeExpression) contain the date as well. Whe true, this allows midnight spanning for calendar events. When false, the DateExpression contains the date.
	    /// </summary>
	    /// -----------------------------------------------------------------------------
        [Description("Indicates whether the time expressions (StartTimeExpression and EndTimeExpression) contain the date as well. When true, this allows midnight spanning for calendar events. When false, the DateExpression contains the date.")]
        [DefaultValue(false)]
        [Category("Data")]
        public bool TimeExpressionsContainDate
        {
            get { return _timeExpressionsContainDate; }
            set { _timeExpressionsContainDate = value; }        
        }

        #region Styles

        /// -----------------------------------------------------------------------------
        /// <summary>
        /// The style applied to time header items.
        /// </summary>
        /// <remarks>
        /// TimeStyle replaces RangeHeaderCss for ScheduleCalendar
        /// </remarks>
        /// -----------------------------------------------------------------------------
        [Description("The style applied to time header items. ")]
        [Category("Style")]
        public virtual string TimeCss
        {
            get { return base.RangeHeaderCss; }
            set { base.RangeHeaderCss = value; }
        }

        // Hide RangeHeaderStyle. For ScheduleCalendar, it's replaced with TimeStyle
        [Browsable(false)]
        [Obsolete("The RangeHeaderCss property is obsolete. Use TimeCss instead")]
        public new string RangeHeaderCss
        {
            get { return base.RangeHeaderCss; }
            set { base.RangeHeaderCss = value; }
        }

        /// -----------------------------------------------------------------------------
        /// <summary>
        /// The style applied to date header items.
        /// </summary>
        /// <remarks>
        /// DateStyle replaces TitleCss for ScheduleCalendar
        /// </remarks>
        /// -----------------------------------------------------------------------------
        [Description("The style applied to date header items. ")]
        [Category("Style")]
        public virtual string DateCss
        {
            get { return base.TitleCss; }
            set { base.TitleCss = value; }
        }

        // Hide TitleCss. For ScheduleCalendar, it's replaced with DateCss
        [Browsable(false)]
        [Obsolete("The TitleCss property is obsolete. Use DateCss instead.")]
        public new string TitleCss
        {
            get { return base.TitleCss; }
            set { base.TitleCss = value; }
        }

        #endregion


    }
}
