﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

namespace MvcSchedule.Objects
{

    /// <summary>
    /// Enumeration for the different types of schedule items
    /// </summary>
    public enum ScheduleItemType
    {
        /// -----------------------------------------------------------------------------
        /// <summary>
        /// Standard item in a schedule
        /// </summary>
        /// -----------------------------------------------------------------------------
        Item = 0,
        /// -----------------------------------------------------------------------------
        /// <summary>
        /// Alternating standard item in a schedule
        /// </summary>
        /// -----------------------------------------------------------------------------
        AlternatingItem,
        /// -----------------------------------------------------------------------------
        /// <summary>
        /// Item in the range header column or row. In the derived ScheduleCalendar,
        /// this is an item in the time header.
        /// </summary>
        /// -----------------------------------------------------------------------------
        RangeHeader,
        /// -----------------------------------------------------------------------------
        /// <summary>
        /// Item in the title header column or row. In the derived ScheduleCalendar,
        /// this is an item in the date header.
        /// </summary>
        /// -----------------------------------------------------------------------------
        TitleHeader,
        /// -----------------------------------------------------------------------------
        /// <summary>
        /// Item in the optional date header column or row.
        /// Only used in the derived ScheduleGeneral control.
        /// </summary>
        /// -----------------------------------------------------------------------------
        DateHeader
    }

    /// <summary>
    /// Enumeration for the different types of layouts
    /// </summary>
    public enum LayoutEnum
    {
        /// -----------------------------------------------------------------------------
        /// <summary>
        /// In Horizontal layout, the range values (times in ScheduleCalendar) are shown horizontally
        /// in the first row, and the titles (dates in ScheduleCalendar) are shown vertically in the first column.
        /// </summary>
        /// -----------------------------------------------------------------------------
        Horizontal = 0,
        /// -----------------------------------------------------------------------------
        /// <summary>
        /// In Vertical layout, the range values (times in ScheduleCalendar) are shown vertically
        /// in the first column, and the titles (dates in ScheduleCalendar) are shown horizontally in the first row.
        /// </summary>
        /// -----------------------------------------------------------------------------
        Vertical
    }

}
