﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Linq.Expressions;
using System.Text;

namespace MvcSchedule.Data
{

	/// <summary>
	/// Wrapper list for the data.
	/// With this list, we can add extra items if necessary without touching the data itself.
	/// </summary>
    internal class ScheduleItemDataList<TItem> : List<ScheduleItemData<TItem>>
	{
        private Expression<Func<TItem, object>> _dataRangeStartExpression;
        private Expression<Func<TItem, object>> _dataRangeEndExpression;
        private Expression<Func<TItem, object>> _titleExpression;

        public ScheduleItemDataList(Expression<Func<TItem, object>> dataRangeStartExpression,
                                    Expression<Func<TItem, object>> dataRangeEndExpression,
                                    Expression<Func<TItem, object>> titleExpression)
		{
            _dataRangeStartExpression = dataRangeStartExpression;
            _dataRangeEndExpression = dataRangeEndExpression;
            _titleExpression = titleExpression;
		}

		public void AddItem(TItem dataItem)
		{
            object startValue = _dataRangeStartExpression.Compile().Invoke(dataItem);
            object endValue = _dataRangeEndExpression.Compile().Invoke(dataItem);
            object titleValue = null;
            if(_titleExpression != null)
                titleValue = _titleExpression.Compile().Invoke(dataItem);
            ScheduleItemData<TItem> sid = new ScheduleItemData<TItem>(dataItem, startValue, endValue, titleValue);
			base.Add(sid);
		}

	}

}
