﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MvcSchedule.Data
{

	/// <summary>
	/// Wrapper for the actual data.
	/// </summary>
    internal class ScheduleItemData<TItem>
	{

        private TItem _dataObject;
        public TItem DataObject
        {
			get { return _dataObject; }
			set { _dataObject = value; }
		}

		private object _startValue;
		public object StartValue {
			get { return _startValue; }
			set { _startValue = value; }
		}

		private object _endValue;
		public object EndValue {
			get { return _endValue; }
			set { _endValue = value; }
		}

		private object _titleValue;
		public object TitleValue {
			get { return _titleValue; }
			set { _titleValue = value; }
		}

        public ScheduleItemData(TItem data, object startValue, object endValue, object titleValue)
		{
			_dataObject = data;
			_startValue = startValue;
			_endValue = endValue;
			_titleValue = titleValue;
		}

        public ScheduleItemData(ScheduleItemData<TItem> original)
		{
			_dataObject = original.DataObject;
			_startValue = original.StartValue;
			_endValue = original.EndValue;
			_titleValue = original.TitleValue;
		}

	}

}
